/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class GptPropertiesUtils {
    public static final String GPT_CALL_URL = "/kapi/v2/gai/prompt/syncCall";
    private static final String GPT_PROPERTIES_PATH = "server" + File.separator + "properties" + File.separator + "gpt.properties";
    private static Map<String, String> PROPERTIESMAP = null;

    public static String getGptProperties(String propertyName) {
        if (PROPERTIESMAP == null) {
            PROPERTIESMAP = GptPropertiesUtils.getPropertiesMap();
        }
        return PROPERTIESMAP == null ? null : PROPERTIESMAP.get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getPropertiesMap() {
        HashMap<String, String> propMap = new HashMap<String, String>();
        String resource = System.getProperty("EAS_HOME") + File.separator + GPT_PROPERTIES_PATH;
        Properties gptProperties = new Properties();
        InputStream in = null;
        try {
            File f = new File(resource);
            if (!(f.exists() && f.length() != 0L || f.exists())) {
                f.createNewFile();
            }
            in = new BufferedInputStream(new FileInputStream(resource));
            gptProperties.load(in);
            for (Object key : gptProperties.keySet()) {
                if (key == null) continue;
                propMap.put(key.toString(), gptProperties.getProperty(key.toString()));
            }
            if (gptProperties.keySet().size() == 0) {
                Iterator<Object> iterator = null;
                return iterator;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return propMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean setGptProperties(Map<String, String> gtpProperties) {
        String resource = System.getProperty("EAS_HOME") + File.separator + GPT_PROPERTIES_PATH;
        Properties prop = new Properties();
        FileInputStream fis = null;
        OutputStream fos = null;
        try {
            fis = new FileInputStream(resource);
            prop.load(fis);
            fos = new FileOutputStream(resource);
            for (String propertyName : gtpProperties.keySet()) {
                prop.setProperty(propertyName, gtpProperties.get(propertyName));
                if (PROPERTIESMAP == null) continue;
                PROPERTIESMAP.put(propertyName, gtpProperties.get(propertyName));
            }
            prop.store(fos, "Update value");
        }
        catch (IOException e) {
            System.err.println("Visit " + resource + " for updating value error");
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

