/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.service.formula.builder.hr.HREnumListener;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.FormulaCmpItemData;
import com.kingdee.eas.hr.compensation.client.AbstractAccountFormula;
import com.kingdee.eas.hr.compensation.client.CmpFormulaEditUI;
import com.kingdee.eas.hr.compensation.util.AccountFormulaUtils;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AccountFormula
extends AbstractAccountFormula {
    private boolean isCanceled = true;
    private AccountFormulaUtils.FormulaEditResult returnMapData = null;
    private Map itemFormulaMap = null;
    private List itemNums = null;
    static String currFormula = "";
    public boolean flagGol = true;
    private static final Logger logger = Logger.getLogger(AccountFormula.class);
    private CmpFormulaEditUI cmpfUI = null;

    public AccountFormula() throws Exception {
        this.jbInit();
    }

    public AccountFormula(boolean flag) throws Exception {
        this.flagGol = flag;
        if (this.flagGol) {
            this.jbInit();
        }
    }

    private void jbInit() throws Exception {
        Window dialog = ComponentUtil.getOwnerWindow(null);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
        Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom - 50);
        this.setPreferredSize(new Dimension(desktopBounds.width, desktopBounds.height));
    }

    private void initCmpFormulaEditUI() throws Exception {
        try {
            this.cmpfUI = new CmpFormulaEditUI(false, (String)this.getUIContext().get("cmpSchemeStrID"));
            this.cmpfUI.initSelf();
            this.kdFormulaPanel.add((Component)((Object)this.cmpfUI), (Object)"Center");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.itemFormulaMap = (HashMap)this.getUIContext().get("SCHMITEMFORMULAMAP");
        if (this.itemFormulaMap == null) {
            return;
        }
        this.initCmpFormulaEditUI();
        this.itemNums = Arrays.asList(this.itemFormulaMap.keySet().toArray());
        this.cmpfUI.setRefObejct((Object)this);
        String item = (String)this.getUIContext().get("ITEMNUM");
        if (item == null) {
            return;
        }
        this.cmpfUI.selectRow(item, currFormula);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.cleanCache();
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (String)"cmpScheme_funcselect");
        if (!this.cmpfUI.checkInput()) {
            return;
        }
        if (this.cmpfUI.isChangFlag()) {
            this.cmpfUI.actionSave_actionPerformed(null);
        } else {
            this.checkFormula();
        }
        this.isCanceled = false;
        this.setReturnData(AccountFormulaUtils.getFormula(this.cmpfUI.cfInfo));
        this.getUIWindow().close();
    }

    @Override
    protected void btnCheckFormula_actionPerformed(ActionEvent e) throws Exception {
        this.checkFormula();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FormulaResource", (String)"CHECK_PASS"));
    }

    public void checkFormula() throws Exception {
        String formulaStr = this.cmpfUI.formulaBuilderPanelBean.getFormulaStr();
        String itemNum = (String)this.getUIContext().get("ITEMNUM");
        String itemName = (String)this.getUIContext().get("ITEMNAME");
        ItemRegex regex = this.toRegex(this.itemNums);
        HashSet formulaItems = (HashSet)this.cmpfUI.formulaBuilderPanelBean.getHRObjectsName(formulaStr);
        AccountFormulaUtils.checkFormula(itemNum, itemName, formulaStr, formulaItems, this.itemFormulaMap, regex.cmpItemNumRegex, regex.personNumRegex);
    }

    public ItemRegex toRegex(List itemNums) {
        StringBuffer buff = new StringBuffer();
        StringBuffer personBuff = new StringBuffer();
        String num = null;
        if (itemNums == null) {
            return null;
        }
        int size = itemNums.size();
        for (int i = 0; i < size; ++i) {
            num = (String)itemNums.get(i);
            buff.append(num);
            if (i != size - 1) {
                buff.append("|");
            }
            if (num.indexOf("FPER") != 0) continue;
            personBuff.append(num);
            personBuff.append("|");
        }
        if (personBuff.length() > 0 && personBuff.lastIndexOf("|") == personBuff.length() - 1) {
            personBuff.deleteCharAt(personBuff.length() - 1);
        }
        ItemRegex regex = new ItemRegex();
        regex.cmpItemNumRegex = buff.toString();
        regex.personNumRegex = personBuff.toString();
        return regex;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean b) {
        this.isCanceled = b;
    }

    public AccountFormulaUtils.FormulaEditResult getReturnMapData() {
        return this.returnMapData;
    }

    public void setReturnData(AccountFormulaUtils.FormulaEditResult result) {
        this.returnMapData = result;
    }

    static class MyHREnumListener
    implements HREnumListener {
        MyHREnumListener() {
        }

        public IHRObject[] getEnumObjs(TreePath path) {
            FormulaCmpItemData itemData;
            Object obj;
            if (path != null && path.getPathCount() >= 3 && (obj = path.getLastPathComponent()) != null && obj instanceof FormulaCmpItemData && (itemData = (FormulaCmpItemData)obj).getCmpItemInstList() != null) {
                IHRObject[] rst = itemData.getCmpItemInstList();
                return rst;
            }
            return null;
        }
    }

    static class ItemRegex {
        public String cmpItemNumRegex = "";
        public String personNumRegex = "";

        ItemRegex() {
        }
    }
}

