/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.CmpAdjSchReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.ICmpAdjSchReportFacade;
import com.kingdee.eas.hr.compensation.client.AbstractAdjNameListReportUI;
import com.kingdee.eas.hr.compensation.client.CmpAdjustiveReportFilter;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjNameListReportUI
extends AbstractAdjNameListReportUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjNameListReportUI.class);
    private DynamicTableInfo infoDynamicTable = new DynamicTableInfo();
    private CommonQueryDialog commonQueryDialog = null;
    private Map AdjParams = new HashMap();
    private List lstColumns = new ArrayList();
    private Map mapData = new HashMap();
    private List adjSchNumList = new ArrayList();
    Map numberMap = new HashMap();
    private static final String BEFORE = "BEFORE_";
    private static final String AFTER = "AFTER_";
    private static final String DIFF = "DIFF_";
    IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpAdjustiveNameListQuery");
    private final BigDecimal ZERO = new BigDecimal("0");
    private String btnSelected = "radiobtn2";
    private int level = 1;
    private ICmpAdjSchReportFacade iAdjSchFacade = null;
    public static final String CELL_OLD_ADMINORGUNIT_NAME = "OLDDEPT.NAME";
    public static final String CELL_NEW_ADMINORGUNIT_NAME = "NEWDEPT.NAME";
    public static final String CELL_PERSON_NUMBER = "PERSON.number";
    public static final String CELL_PERSON_NAME = "PERSON.name";
    public static final String CELL_PERSON_SEX = "PERSON.gender";
    public static final String CELL_PERSON_BIRTHDAY = "PERSON.birthday";
    public static final String CELL_EMPPOSITON_JOINDATE = "PERSONEXTEND.enterDate";
    public static final String CELL_OLD_POSITION_NAME = "OLDPOSITION.NAME";
    public static final String CELL_NEW_POSITION_NAME = "NEWPOSITION.NAME";
    public static final String CELL_CMPPOINT_OLDVALUE = "OLDSALP.NAME";
    public static final String CELL_CMPPOINT_NEWVALUE = "NEWSALP.NAME";
    public static final int CELL_CMPITEM_NAME = 5;
    public static final int CELL_CMPITEM_OLDVALUE = 6;
    public static final int CELL_CMPITEM_NEWVALUE = 7;
    public static final int CELL_CMPITEM_DIFFENT = 8;
    public static final String CELL_CMPADJSCHEME_BIZDATE = "CMPADJSCHEME.effectDate";
    public static final String CELL_CMPADJSCHEME_EFFECTDAT = "effectDate";
    public static final String CELL_CMPADJSCHEME_ADJCAUSE = "CMPAC.NAME";
    public static final String CELL_CMPADJSCHEME_ADJREMARK = "remark";
    private String cmpAdjustiveSchBasicURL = "com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.";
    private String strSubTotal = EASResource.getString((String)(this.cmpAdjustiveSchBasicURL + "TOTALLAB"));
    private EntityViewInfo filterEntityAll = new EntityViewInfo();
    private List selectItemList = null;
    private List selectItemSet = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
        this.loadAdjSchNumData();
        this.doQueryResult();
        CmpDateUtils.setColumnDateFormat(this.tblMain, new String[]{CELL_PERSON_BIRTHDAY, CELL_EMPPOSITON_JOINDATE, CELL_CMPADJSCHEME_BIZDATE, CELL_CMPADJSCHEME_EFFECTDAT});
    }

    private void loadAdjSchNumData() {
        Map ctx = this.getUIContext();
        this.adjSchNumList = (List)ctx.get("adjSchNum");
        this.AdjParams.put("adjSchNum", this.adjSchNumList);
    }

    protected void doQueryResult() throws Exception {
        this.crateTable();
        if (this.tHelper != null) {
            this.tHelper.init();
        }
        this.fillData();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showFilterDialog(e);
    }

    protected void showFilterDialog(ActionEvent e) throws Exception {
        CmpAdjustiveReportFilter cmpAdjustiveReportFilterUITmp = new CmpAdjustiveReportFilter();
        cmpAdjustiveReportFilterUITmp.chkShowSealUp.setVisible(false);
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.addUserPanel((KDPanel)cmpAdjustiveReportFilterUITmp);
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BankAgentIssueResource.LABADJNAMELIST_QRY"));
            this.commonQueryDialog.setUiObject((IUIObject)this);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.commonQueryDialog.setShowDefaultSolution(false);
            this.commonQueryDialog.setDisVisiableDefaultView(true);
            this.commonQueryDialog.setDynQueryVisible(false);
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(450);
        }
        if (this.commonQueryDialog.show()) {
            this.tHelper.setDialog(this.commonQueryDialog);
            this.tHelper.setUiQueryName(this.getMetaDataPK().getFullName(), this.getQueryName());
            CmpAdjustiveReportFilter cmpAdjustiveReportFilterUI = (CmpAdjustiveReportFilter)this.commonQueryDialog.getUserPanel(0);
            boolean dateFlag = false;
            if (cmpAdjustiveReportFilterUI.btnCmpDate.isSelected()) {
                dateFlag = true;
            }
            cmpAdjustiveReportFilterUI.pkBeginDate.setTimeEnabled(false);
            cmpAdjustiveReportFilterUI.pkEndDate.setTimeEnabled(false);
            Date beginDate = cmpAdjustiveReportFilterUI.pkBeginDate.getSqlDate();
            Date endDate = cmpAdjustiveReportFilterUI.pkEndDate.getSqlDate();
            this.selectItemList = cmpAdjustiveReportFilterUI.getListSelectItem();
            if (cmpAdjustiveReportFilterUI.radiobtn0.isSelected()) {
                this.btnSelected = "radiobtn0";
            } else if (cmpAdjustiveReportFilterUI.radiobtn2.isSelected()) {
                this.btnSelected = "radiobtn2";
            }
            this.level = cmpAdjustiveReportFilterUI.levelComboBox.getSelectedIndex() + 1;
            EntityViewInfo filterEntityInfo = this.commonQueryDialog.getEntityViewInfoResult();
            this.filterEntityAll = this.setFilter(beginDate, endDate, filterEntityInfo, dateFlag);
            this.doQueryResult();
        } else {
            SysUtil.abort();
        }
    }

    private EntityViewInfo setFilter(Date beginDate, Date endDate, EntityViewInfo entityViewInfoCommQuery, boolean flag) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        String beginDateStr = beginDate.toString() + " 00:00:00";
        String endDateStr = endDate.toString() + " 23:59:59";
        if (flag) {
            filterInfo.getFilterItems().add(new FilterItemInfo(CELL_CMPADJSCHEME_BIZDATE, (Object)beginDateStr, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo(CELL_CMPADJSCHEME_BIZDATE, (Object)endDateStr, CompareType.LESS_EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo(CELL_CMPADJSCHEME_EFFECTDAT, (Object)beginDateStr, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo(CELL_CMPADJSCHEME_EFFECTDAT, (Object)endDateStr, CompareType.LESS_EQUALS));
        }
        if (this.adjSchNumList == null || this.adjSchNumList.size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        }
        if (entityViewInfoCommQuery == null) {
            entityViewInfoCommQuery = new EntityViewInfo();
        }
        if (entityViewInfoCommQuery.getFilter() == null || entityViewInfoCommQuery.getFilter().getFilterItems().size() == 0) {
            entityViewInfoCommQuery.setFilter(filterInfo);
        } else {
            entityViewInfoCommQuery.getFilter().mergeFilter(filterInfo, "AND");
        }
        return entityViewInfoCommQuery;
    }

    protected String getQueryName() {
        return "com.kingdee.eas.hr.compensation.app.CmpAdjustiveNameListQuery";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.enableExportExcel(this.tblMain);
    }

    private void crateTable() throws Exception {
        this.infoDynamicTable.setCountHeadLine(2);
        this.infoDynamicTable.setHeadMergeMode(4);
        DynamicTableInfo.ColumnInfo[] infosColumn = this.getDynamicColumnInfos();
        if (infosColumn == null || infosColumn.length <= 0) {
            return;
        }
        this.infoDynamicTable.setInfosColumn(infosColumn);
        HRDynamicTableUtils.createTableHead(this.tblMain, this.infoDynamicTable);
        this.setHeadMerge();
    }

    private DynamicTableInfo.ColumnInfo[] getDynamicColumnInfos() throws Exception {
        if (this.lstColumns != null) {
            this.lstColumns.clear();
        }
        ArrayList lstTemp = new ArrayList();
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumn = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setKey(CELL_OLD_ADMINORGUNIT_NAME);
        infoColumn.setColumnNumber(CELL_OLD_ADMINORGUNIT_NAME);
        infoColumn.setColumnName(CELL_OLD_ADMINORGUNIT_NAME);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"93_AdjNameListReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(CELL_OLD_ADMINORGUNIT_NAME);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"93_AdjNameListReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue(CELL_OLD_ADMINORGUNIT_NAME);
        lstColumn.add(infoColumn);
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setKey(CELL_NEW_ADMINORGUNIT_NAME);
        infoColumn.setColumnNumber(CELL_NEW_ADMINORGUNIT_NAME);
        infoColumn.setColumnName(CELL_NEW_ADMINORGUNIT_NAME);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"94_AdjNameListReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(CELL_NEW_ADMINORGUNIT_NAME);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"94_AdjNameListReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue(CELL_NEW_ADMINORGUNIT_NAME);
        lstColumn.add(infoColumn);
        lstColumn.add(this.getDynamicStringColumnInfo("PERSON_NUMBER", CELL_PERSON_NUMBER));
        lstColumn.add(this.getDynamicStringColumnInfo("PERSON_NAME", CELL_PERSON_NAME));
        lstColumn.add(this.getDynamicStringColumnInfo("sex", CELL_PERSON_SEX));
        lstColumn.add(this.getDynamicStringColumnInfo("birthday", CELL_PERSON_BIRTHDAY));
        lstColumn.add(this.getDynamicStringColumnInfo("enterDate", CELL_EMPPOSITON_JOINDATE));
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setKey(CELL_OLD_POSITION_NAME);
        infoColumn.setColumnNumber(CELL_OLD_POSITION_NAME);
        infoColumn.setColumnName(CELL_OLD_POSITION_NAME);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"95_AdjNameListReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(CELL_OLD_POSITION_NAME);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"95_AdjNameListReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue(CELL_OLD_POSITION_NAME);
        lstColumn.add(infoColumn);
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setKey(CELL_NEW_POSITION_NAME);
        infoColumn.setColumnNumber(CELL_NEW_POSITION_NAME);
        infoColumn.setColumnName(CELL_NEW_POSITION_NAME);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"96_AdjNameListReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(CELL_NEW_POSITION_NAME);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"96_AdjNameListReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue(CELL_NEW_POSITION_NAME);
        lstColumn.add(infoColumn);
        List columnList = this.getAdjItems(this.adjSchNumList);
        lstColumn.addAll(columnList);
        lstColumn.add(this.getDynamicStringColumnInfo("adjDate", CELL_CMPADJSCHEME_BIZDATE));
        lstColumn.add(this.getDynamicStringColumnInfo(CELL_CMPADJSCHEME_EFFECTDAT, CELL_CMPADJSCHEME_EFFECTDAT));
        lstColumn.add(this.getDynamicStringColumnInfo("adjReson", CELL_CMPADJSCHEME_ADJCAUSE));
        lstColumn.add(this.getDynamicStringColumnInfo(CELL_CMPADJSCHEME_ADJREMARK, CELL_CMPADJSCHEME_ADJREMARK));
        this.lstColumns = lstColumn;
        this.AdjParams.put("tableColumn", lstTemp);
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[lstColumn.size()];
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infosColumn[i] = (DynamicTableInfo.ColumnInfo)lstColumn.get(i);
        }
        return infosColumn;
    }

    private void setHeadMerge() throws Exception {
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        int iBeginMergeRow = 0;
        mm.mergeBlock(0, iBeginMergeRow, 1, iBeginMergeRow, 4);
        mm.mergeBlock(0, iBeginMergeRow + 1, 1, iBeginMergeRow + 1, 4);
        mm.mergeBlock(0, iBeginMergeRow + 2, 1, iBeginMergeRow + 2, 4);
        mm.mergeBlock(0, iBeginMergeRow + 3, 1, iBeginMergeRow + 3, 4);
        mm.mergeBlock(0, iBeginMergeRow + 4, 1, iBeginMergeRow + 4, 4);
        mm.mergeBlock(0, iBeginMergeRow + 5, 1, iBeginMergeRow + 5, 4);
        mm.mergeBlock(0, iBeginMergeRow + 6, 1, iBeginMergeRow + 6, 4);
        mm.mergeBlock(0, iBeginMergeRow + 7, 1, iBeginMergeRow + 7, 4);
        mm.mergeBlock(0, iBeginMergeRow + 8, 1, iBeginMergeRow + 8, 4);
        iBeginMergeRow += 8;
        if (this.selectItemList == null || this.selectItemList.size() == 0) {
            this.selectItemSet = new ArrayList();
            this.selectItemSet.addAll(this.numberMap.keySet());
        }
        for (String number : this.selectItemSet) {
            if ("FSAL000".equals(number)) {
                mm.mergeBlock(0, iBeginMergeRow + 1, 0, iBeginMergeRow + 2, 4);
                iBeginMergeRow += 2;
                continue;
            }
            mm.mergeBlock(0, iBeginMergeRow + 1, 0, iBeginMergeRow + 3, 4);
            iBeginMergeRow += 3;
        }
        mm.mergeBlock(0, ++iBeginMergeRow, 1, iBeginMergeRow, 4);
        mm.mergeBlock(0, ++iBeginMergeRow, 1, iBeginMergeRow, 4);
        mm.mergeBlock(0, ++iBeginMergeRow, 1, iBeginMergeRow, 4);
        mm.mergeBlock(0, ++iBeginMergeRow, 1, iBeginMergeRow, 4);
    }

    private void fillData() throws Exception {
        this.tblMain.removeRows();
        this.AdjParams.put("filterEntityAll", this.filterEntityAll);
        this.mapData = this.getBizAdjSchRepFacInterface().getAdjNameListData(this.AdjParams);
        this.setTableData();
    }

    private ICmpAdjSchReportFacade getBizAdjSchRepFacInterface() throws BOSException {
        if (this.iAdjSchFacade == null) {
            this.iAdjSchFacade = CmpAdjSchReportFacadeFactory.getRemoteInstance();
        }
        return this.iAdjSchFacade;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    private void setTableData() throws Exception {
        this.tblMain.removeRows();
        String currPersonId = null;
        String currPersonIdTemp = null;
        String initValue = "0";
        BigDecimal totalDiffentValue = new BigDecimal(initValue);
        int totalScale = 0;
        boolean showPesonFlag = true;
        IRowSet empDataRowSet = (IRowSet)this.mapData.get("rowSetPerson");
        if (empDataRowSet == null) {
            return;
        }
        empDataRowSet.beforeFirst();
        HashMap<String, BigDecimal> totalValMap = new HashMap<String, BigDecimal>();
        IRow currRow = null;
        while (empDataRowSet.next()) {
            currPersonIdTemp = empDataRowSet.getString("PERSON.id").toString();
            if (currPersonId == null) {
                currPersonId = currPersonIdTemp;
            }
            if (!currPersonId.equals(currPersonIdTemp)) {
                totalDiffentValue = HRCmpItemUtils.convertPrecisionForBigDecimal(totalDiffentValue, totalScale, CmpItemPrecisionTypeEnum.SISHEWURU);
                this.addTotalRow(totalValMap);
                currPersonId = currPersonIdTemp;
                totalScale = 0;
                totalDiffentValue = new BigDecimal(initValue);
                showPesonFlag = true;
                totalValMap = new HashMap();
                currRow = this.tblMain.addRow();
            } else {
                String curPerson = empDataRowSet.getString("PERSON.id").toString();
                String curAdjNum = empDataRowSet.getString("CMPADJSCHEME.number").toString();
                boolean mvPrevious = empDataRowSet.previous();
                if (mvPrevious) {
                    String priousPerson = empDataRowSet.getString("PERSON.id").toString();
                    String priousAdjNum = empDataRowSet.getString("CMPADJSCHEME.number").toString();
                    if (!curPerson.equals(priousPerson) || !curAdjNum.equals(priousAdjNum)) {
                        currRow = this.tblMain.addRow();
                    }
                    empDataRowSet.next();
                } else {
                    currRow = this.tblMain.addRow();
                    empDataRowSet.next();
                }
            }
            if (empDataRowSet.getString("OLDDEPT.displayName") != null) {
                currRow.getCell(CELL_OLD_ADMINORGUNIT_NAME).setValue((Object)empDataRowSet.getString("OLDDEPT.displayName"));
            }
            if (empDataRowSet.getString("newDept.displayName") != null) {
                currRow.getCell(CELL_NEW_ADMINORGUNIT_NAME).setValue((Object)empDataRowSet.getString("newDept.displayName"));
            }
            if (empDataRowSet.getString(CELL_PERSON_NUMBER) != null) {
                currRow.getCell(CELL_PERSON_NUMBER).setValue((Object)empDataRowSet.getString(CELL_PERSON_NUMBER));
            }
            if (empDataRowSet.getString(CELL_PERSON_NAME) != null) {
                currRow.getCell(CELL_PERSON_NAME).setValue((Object)empDataRowSet.getString(CELL_PERSON_NAME));
            }
            if (empDataRowSet.getString(CELL_PERSON_SEX) != null) {
                if (empDataRowSet.getInt(CELL_PERSON_SEX) == 1) {
                    currRow.getCell(CELL_PERSON_SEX).setValue((Object)HRReportUtils.getResource("MALE"));
                } else if (empDataRowSet.getInt(CELL_PERSON_SEX) == 2) {
                    currRow.getCell(CELL_PERSON_SEX).setValue((Object)HRReportUtils.getResource("FAMALE"));
                }
            }
            if (empDataRowSet.getString(CELL_PERSON_BIRTHDAY) != null) {
                currRow.getCell(CELL_PERSON_BIRTHDAY).setValue((Object)empDataRowSet.getString(CELL_PERSON_BIRTHDAY));
            }
            if (empDataRowSet.getString(CELL_OLD_POSITION_NAME) != null) {
                currRow.getCell(CELL_OLD_POSITION_NAME).setValue((Object)empDataRowSet.getString(CELL_OLD_POSITION_NAME));
            }
            if (empDataRowSet.getString(CELL_EMPPOSITON_JOINDATE) != null) {
                currRow.getCell(CELL_EMPPOSITON_JOINDATE).setValue((Object)empDataRowSet.getString(CELL_EMPPOSITON_JOINDATE));
            }
            if (empDataRowSet.getString(CELL_NEW_POSITION_NAME) != null) {
                currRow.getCell(CELL_NEW_POSITION_NAME).setValue((Object)empDataRowSet.getString(CELL_NEW_POSITION_NAME));
            }
            showPesonFlag = false;
            for (String number : this.selectItemSet) {
                BigDecimal totalVal;
                if ("FSAL000".equals(number) && number.equals(empDataRowSet.getString("CMPITEM.NUMBER"))) {
                    currRow.getCell("BEFORE_FSAL000").setValue((Object)empDataRowSet.getString(CELL_CMPPOINT_OLDVALUE));
                    currRow.getCell("AFTER_FSAL000").setValue((Object)empDataRowSet.getString(CELL_CMPPOINT_NEWVALUE));
                    continue;
                }
                if (!number.equals(empDataRowSet.getString("CMPITEM.NUMBER"))) continue;
                BigDecimal oldVal = empDataRowSet.getBigDecimal("oldValue");
                BigDecimal newVal = empDataRowSet.getBigDecimal("newValue");
                currRow.getCell(BEFORE + number).setValue((Object)oldVal);
                currRow.getCell(AFTER + number).setValue((Object)newVal);
                if (oldVal == null) {
                    oldVal = new BigDecimal("0");
                }
                if (newVal == null) {
                    newVal = new BigDecimal("0");
                }
                currRow.getCell(DIFF + number).setValue((Object)newVal.subtract(oldVal));
                if (totalValMap.get(number) == null) {
                    totalVal = new BigDecimal("0");
                    totalVal = totalVal.add(newVal.subtract(oldVal));
                    totalValMap.put(number, totalVal);
                    continue;
                }
                totalVal = (BigDecimal)totalValMap.get(number);
                totalVal = totalVal.add(newVal.subtract(oldVal));
                totalValMap.put(number, totalVal);
            }
            if (empDataRowSet.getString(CELL_CMPADJSCHEME_BIZDATE) != null) {
                currRow.getCell(CELL_CMPADJSCHEME_BIZDATE).setValue((Object)empDataRowSet.getString(CELL_CMPADJSCHEME_BIZDATE));
            }
            if (empDataRowSet.getString(CELL_CMPADJSCHEME_EFFECTDAT) != null) {
                currRow.getCell(CELL_CMPADJSCHEME_EFFECTDAT).setValue((Object)empDataRowSet.getString(CELL_CMPADJSCHEME_EFFECTDAT));
            }
            if (empDataRowSet.getString(CELL_CMPADJSCHEME_ADJCAUSE) != null) {
                currRow.getCell(CELL_CMPADJSCHEME_ADJCAUSE).setValue((Object)empDataRowSet.getString(CELL_CMPADJSCHEME_ADJCAUSE));
            }
            if (empDataRowSet.getString(CELL_CMPADJSCHEME_ADJREMARK) != null) {
                currRow.getCell(CELL_CMPADJSCHEME_ADJREMARK).setValue((Object)empDataRowSet.getString(CELL_CMPADJSCHEME_ADJREMARK));
            }
            this.setAdminAndHROName(currRow);
        }
        if (empDataRowSet.size() > 0) {
            totalDiffentValue = HRCmpItemUtils.convertPrecisionForBigDecimal(totalDiffentValue, totalScale, CmpItemPrecisionTypeEnum.SISHEWURU);
            this.addTotalRow(totalValMap);
        }
    }

    private void addTotalRow(Map totalValMap) throws Exception {
        IRow totalRow = this.tblMain.addRow();
        totalRow.getCell(CELL_OLD_ADMINORGUNIT_NAME).setValue((Object)this.strSubTotal);
        if (this.selectItemList == null || this.selectItemList.size() == 0) {
            this.selectItemSet = new ArrayList();
            this.selectItemSet.addAll(this.numberMap.keySet());
        }
        for (String number : this.selectItemSet) {
            CmpItemInfo itemInfo = (CmpItemInfo)this.numberMap.get(number);
            if (itemInfo == null || "FSAL000".equals(number)) continue;
            BigDecimal val = (BigDecimal)totalValMap.get(number);
            totalRow.getCell(DIFF + number).setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal(val, itemInfo.getDecDigital(), itemInfo.getPrecisionType()));
        }
        totalRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
    }

    private void addColId() {
        int i;
        int colCount = this.tblMain.getColumnCount();
        IColumn colID = this.tblMain.addColumn(colCount);
        colID.setKey("id");
        colID.getStyleAttributes().setHided(true);
        int rowCount = this.tblMain.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            ICell cell = this.tblMain.getCell(i, "id");
            cell.setValue((Object)"0");
        }
        rowCount = this.tblMain.getHeadRowCount();
        for (i = 0; i < rowCount; ++i) {
            IRow iRow = this.tblMain.getHeadRow(i);
            iRow.getCell("id").setValue((Object)"1");
        }
    }

    private DynamicTableInfo.ColumnInfo getDynamicStringColumnInfo(String displayName, String columnName) {
        displayName = HRReportUtils.getResource(displayName);
        DynamicTableInfo.ColumnInfo infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setKey(columnName);
        infoColumn.setColumnNumber(columnName);
        infoColumn.setColumnName(columnName);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(displayName);
        infoColumn.getInfosHead()[0].setHeadValue(columnName);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(displayName);
        infoColumn.getInfosHead()[1].setHeadValue(columnName);
        return infoColumn;
    }

    private DynamicTableInfo.ColumnInfo getDynamicAdjItemColumnInfo(String headName, String displayName, String columnName, CmpItemInfo itemInfo) {
        displayName = HRReportUtils.getResource(displayName);
        DynamicTableInfo.ColumnInfo infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setKey(columnName);
        infoColumn.setColumnNumber(columnName);
        infoColumn.setColumnName(columnName);
        infoColumn.setFormat(HRCmpItemUtils.getColumnFormatStr(itemInfo.getDecDigital()));
        infoColumn.setScale(itemInfo.getDecDigital());
        infoColumn.setPrecisionType(itemInfo.getPrecisionType());
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(headName);
        infoColumn.getInfosHead()[0].setHeadValue(headName);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(displayName);
        infoColumn.getInfosHead()[1].setHeadValue(columnName);
        return infoColumn;
    }

    private List getAdjItems(List adjParams) throws Exception {
        ArrayList<DynamicTableInfo.ColumnInfo> itemList = new ArrayList<DynamicTableInfo.ColumnInfo>();
        this.numberMap = this.getBizAdjSchRepFacInterface().getAdjItemList(adjParams);
        CmpItemInfo itemInfo = null;
        DynamicTableInfo.ColumnInfo columnInfo = null;
        this.selectItemSet = new ArrayList();
        if (this.selectItemList != null && this.selectItemList.size() > 0) {
            CmpItemInfo cmpItemInfo = null;
            String number = null;
            for (int i = 0; i < this.selectItemList.size(); ++i) {
                cmpItemInfo = (CmpItemInfo)this.selectItemList.get(i);
                number = cmpItemInfo.getNumber();
                if (!this.numberMap.containsKey(number)) continue;
                if ("FSAL000".equals(number)) {
                    itemInfo = (CmpItemInfo)this.numberMap.get(number);
                    columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "beforeAdjVal", BEFORE + itemInfo.getNumber(), itemInfo);
                    itemList.add(columnInfo);
                    columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "afterAdjVal", AFTER + itemInfo.getNumber(), itemInfo);
                    itemList.add(columnInfo);
                } else {
                    itemInfo = (CmpItemInfo)this.numberMap.get(number);
                    columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "beforeAdjVal", BEFORE + itemInfo.getNumber(), itemInfo);
                    itemList.add(columnInfo);
                    columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "afterAdjVal", AFTER + itemInfo.getNumber(), itemInfo);
                    itemList.add(columnInfo);
                    columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "difference", DIFF + itemInfo.getNumber(), itemInfo);
                    itemList.add(columnInfo);
                }
                this.selectItemSet.add(number);
            }
        } else {
            this.selectItemSet = new ArrayList();
            this.selectItemSet.addAll(this.numberMap.keySet());
            for (String number : this.selectItemSet) {
                if ("FSAL000".equals(number)) {
                    itemInfo = (CmpItemInfo)this.numberMap.get(number);
                    columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "beforeAdjVal", BEFORE + itemInfo.getNumber(), itemInfo);
                    itemList.add(columnInfo);
                    columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "afterAdjVal", AFTER + itemInfo.getNumber(), itemInfo);
                    itemList.add(columnInfo);
                    continue;
                }
                itemInfo = (CmpItemInfo)this.numberMap.get(number);
                columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "beforeAdjVal", BEFORE + itemInfo.getNumber(), itemInfo);
                itemList.add(columnInfo);
                columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "afterAdjVal", AFTER + itemInfo.getNumber(), itemInfo);
                itemList.add(columnInfo);
                columnInfo = this.getDynamicAdjItemColumnInfo(itemInfo.getName(), "difference", DIFF + itemInfo.getNumber(), itemInfo);
                itemList.add(columnInfo);
            }
        }
        return itemList;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    private void setAdminAndHROName(IRow row) {
        String newAdminName = null;
        String displayName = null;
        if (row.getCell(CELL_OLD_ADMINORGUNIT_NAME).getValue() != null) {
            displayName = row.getCell(CELL_OLD_ADMINORGUNIT_NAME).getValue().toString();
            newAdminName = this.btnSelected.equals("radiobtn2") ? this.setAdminNameByLevel(this.level, displayName) : displayName;
            row.getCell(CELL_OLD_ADMINORGUNIT_NAME).setValue((Object)newAdminName);
        }
        newAdminName = null;
        displayName = null;
        if (row.getCell(CELL_NEW_ADMINORGUNIT_NAME).getValue() != null) {
            displayName = row.getCell(CELL_NEW_ADMINORGUNIT_NAME).getValue().toString();
            newAdminName = this.btnSelected.equals("radiobtn2") ? this.setAdminNameByLevel(this.level, displayName) : displayName;
            row.getCell(CELL_NEW_ADMINORGUNIT_NAME).setValue((Object)newAdminName);
        }
    }

    private String setAdminNameByLevel(int levelNum, String oldAdminName) {
        String newAdminName = null;
        String[] names = oldAdminName.split("_");
        int num = names.length - levelNum;
        if (num <= 0) {
            return oldAdminName;
        }
        StringBuffer sb = new StringBuffer(names[num]);
        for (int i = num + 1; i < names.length; ++i) {
            sb.append("_").append(names[i]);
        }
        newAdminName = sb.toString();
        return newAdminName;
    }
}

