/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.hr.compensation.CmpCommonFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.client.AbstractBICmpStructReportFilterUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BICmpStructReportFilterUI
extends AbstractBICmpStructReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BICmpStructReportFilterUI.class);
    protected List singleAdminOrgChangeListener = null;
    protected List singleOrgChangeListener = null;
    private final String RADIOBTN = "radiobtn";

    public BICmpStructReportFilterUI() throws Exception {
    }

    public BICmpStructReportFilterUI(boolean dataTypeFilter, boolean perItemFilter) throws Exception {
        this.dataTypeFilter = dataTypeFilter;
        this.perItemFilter = perItemFilter;
        this.init();
    }

    @Override
    protected void initAllEditor() throws Exception {
        super.initAllEditor();
        this.chkZeroItemDisplayNull.setVisible(false);
        CompUtils.initF7SelectorNoHR((CustomerQueryPanel)this, this.prmtSingleOrgSelect);
        this.prmtSingleOrgSelect.setEditable(false);
        this.prmtSingleOrgSelect.setRequired(true);
        this.kDMulSelect.setSelected(true);
        this.kDSingelSelect.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (BICmpStructReportFilterUI.this.kDSingelSelect.isSelected()) {
                    BICmpStructReportFilterUI.this.setAdminPrmtState(true);
                } else {
                    BICmpStructReportFilterUI.this.setAdminPrmtState(false);
                }
            }
        });
        this.kDMulSelect.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (BICmpStructReportFilterUI.this.kDMulSelect.isSelected()) {
                    BICmpStructReportFilterUI.this.setAdminPrmtState(false);
                } else {
                    BICmpStructReportFilterUI.this.setAdminPrmtState(true);
                }
            }
        });
        this.prmtSingleOrgSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    Object[] objs = new Object[]{BICmpStructReportFilterUI.this.prmtSingleOrgSelect.getData()};
                    BICmpStructReportFilterUI.this.setCurrentHRO(objs);
                }
                catch (Exception e) {
                    BICmpStructReportFilterUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowSealUp_itemStateChanged(e);
        CompUtils.initF7SelectorNoHR(this.prmtSingleOrgSelect, this.chkShowSealUp.isSelected());
    }

    @Override
    public HashMap getCustomFilterMap() {
        HashMap map = super.getCustomFilterMap();
        map.put("radiobtn0", this.radiobtn0.isSelected());
        map.put("radiobtn1", this.radiobtn1.isSelected());
        map.put("radiobtn2", this.radiobtn2.isSelected());
        map.put("level", this.levelComboBox.getSelectedIndex() + 1);
        map.put("isShowLongName", true);
        if (this.kDMulSelect.isSelected()) {
            return map;
        }
        AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)this.prmtSingleOrgSelect.getData();
        HashMap<String, AdminOrgUnitInfo> paramsMap = new HashMap<String, AdminOrgUnitInfo>();
        paramsMap.put("AdminOrgUnitInfo", unitInfo);
        try {
            AdminOrgUnitCollection colDept = CmpCommonFacadeFactory.getRemoteInstance().getSubAdminOrgCollection(paramsMap);
            map.put("AdminOrgUnitColl", colDept);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        map.put("isSingeOrglSelect", true);
        map.put("adminOrgUnit", unitInfo);
        return map;
    }

    private void setAdminPrmtState(boolean isSingleSelect) {
        if (isSingleSelect) {
            this.prmtSingleOrgSelect.setEnabled(true);
            this.prmtAdminUnitOrg.setEnabled(false);
            this.prmtAdminUnitOrg.setData(null);
            this.kDSingelSelect.setSelected(true);
            this.kDMulSelect.setSelected(false);
        } else {
            this.prmtSingleOrgSelect.setEnabled(false);
            this.prmtSingleOrgSelect.setData(null);
            this.prmtAdminUnitOrg.setEnabled(true);
            this.kDSingelSelect.setSelected(false);
            this.kDMulSelect.setSelected(true);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.radiobtn0.setSelected(true);
        this.setAdminPrmtState(false);
        this.setOrgCommentEnabled();
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (this.kDSingelSelect.isSelected()) {
            cp.addCustomerParam("kDSingelSelect", "true");
            if (this.prmtSingleOrgSelect.getData() != null) {
                cp.addCustomerParam("prmtSingleOrgSelect", ((AdminOrgUnitInfo)this.prmtSingleOrgSelect.getData()).getId().toString());
            }
        }
        if (this.kDMulSelect.isSelected()) {
            cp.addCustomerParam("kDMulSelect", "true");
        }
        if (this.radiobtn0.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn0");
        } else if (this.radiobtn1.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn1");
        } else if (this.radiobtn2.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn2");
            cp.addCustomerParam("level", this.levelComboBox.getSelectedItem().toString());
        }
        return cp;
    }

    @Override
    public boolean verify() {
        if (this.kDSingelSelect.isSelected()) {
            int i;
            if (this.prmtSingleOrgSelect.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_ADMIN")));
                this.prmtSingleOrgSelect.requestFocusInWindow();
                return false;
            }
            if (this.prmtCmpPeriod.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
                this.prmtCmpPeriod.requestFocusInWindow();
                return false;
            }
            if (this.prmtCmpScheme.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPSCH")));
                this.prmtCmpScheme.requestFocusInWindow();
                return false;
            }
            this.lstSelectItemData = new ArrayList();
            int size = this.lstSelectItem.getElementCount();
            for (i = 0; i < size; ++i) {
                this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
            }
            this.lstSelectItemNotSortData = new ArrayList();
            size = this.lstSelectItemNotSort.getElementCount();
            for (i = 0; i < size; ++i) {
                this.lstSelectItemNotSortData.add(this.lstSelectItemNotSort.getElement(i));
            }
            if (this.lstSelectItemData.size() <= 0 && this.lstSelectItemNotSortData.size() <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"126_BICmpStructReportFilterUI"));
                return false;
            }
            return true;
        }
        boolean valid = super.verify();
        return valid;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        CmpPeriodInfo periodInfo;
        String kDMulSelect;
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("radiobtn") == null || cp.getCustomerParam("radiobtn").equals("radiobtn0")) {
            this.radiobtn0.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn1")) {
            this.radiobtn1.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn2")) {
            this.radiobtn2.setSelected(true);
            String level = cp.getCustomerParam("level");
            this.levelComboBox.setSelectedIndex(Integer.parseInt(level) - 1);
        }
        String kDSingelSelect = cp.getCustomerParam("kDSingelSelect");
        if (!StringUtils.isEmpty((String)kDSingelSelect)) {
            this.kDSingelSelect.setSelected(Boolean.valueOf(kDSingelSelect).booleanValue());
        }
        if (!StringUtils.isEmpty((String)(kDMulSelect = cp.getCustomerParam("kDMulSelect")))) {
            this.kDMulSelect.setSelected(Boolean.valueOf(kDMulSelect).booleanValue());
        }
        if (Boolean.valueOf(kDSingelSelect).booleanValue()) {
            AdminOrgUnitInfo infoDept = this.f7Info.getAdminInfo();
            this.prmtSingleOrgSelect.setData((Object)infoDept);
        }
        if ((periodInfo = this.f7Info.getPeriodInfo()) != null) {
            this.prmtCmpPeriod.setData((Object)periodInfo);
        }
        this.setOrgCommentEnabled();
    }

    protected void setCurrentHRO(Object[] objs) throws Exception {
        if (objs == null) {
            return;
        }
        if (objs[0] == null) {
            return;
        }
        String newRootHroId = "";
        ArrayList newHroList = null;
        ArrayList<Object> adminList = new ArrayList<Object>();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            if (!(objs[i] instanceof AdminOrgUnitInfo)) continue;
            adminList.add(objs[i]);
        }
        newHroList = this.getSelectHROS(adminList);
        newRootHroId = this.getRootHROID(newHroList);
        this.setPeriodAndSchemeF7(newRootHroId, newHroList);
    }

    @Override
    public void addAdminOrgDataChangeListener(DataChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.adminOrgChangeListener == null) {
            this.adminOrgChangeListener = new ArrayList();
        }
        this.adminOrgChangeListener.add(listener);
        this.prmtAdminUnitOrg.addDataChangeListener(listener);
        this.prmtSingleOrgSelect.addDataChangeListener(listener);
    }

    @Override
    protected void kDSingelSelect_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.kDSingelSelect_actionPerformed(e);
    }

    @Override
    protected void kDMulSelect_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.kDMulSelect_actionPerformed(e);
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgMultSelected = this.kDMulSelect.isSelected();
        if (this.radiobtn1.isSelected() && isRdOrgMultSelected) {
            this.radiobtn1.setSelected(false);
            this.radiobtn0.setSelected(true);
        }
        this.radiobtn1.setEnabled(!isRdOrgMultSelected);
    }

    @Override
    protected Map getF7ParamMap(CustomerParams cp) {
        Map paramMap = super.getF7ParamMap(cp);
        String value = cp.getCustomerParam("prmtSingleOrgSelect");
        if (!StringUtils.isEmpty((String)value)) {
            paramMap.put("cmpreport_admin_single", value);
        }
        return paramMap;
    }

    @Override
    public AdminOrgUnitCollection getDeptCol(boolean isShowSealUp) {
        isShowSealUp = false;
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        Object[] value = (Object[])this.prmtAdminUnitOrg.getData();
        HashSet<String> set = new HashSet<String>();
        if (value != null && value.length > 0) {
            for (int i = 0; i < value.length; ++i) {
                if (isShowSealUp) {
                    colDept.add((AdminOrgUnitInfo)value[i]);
                    continue;
                }
                set.add(((AdminOrgUnitInfo)value[i]).getId().toString());
            }
        }
        if (!isShowSealUp && set.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            try {
                IAdminOrgUnit iadmin = AdminOrgUnitFactory.getRemoteInstance();
                AdminOrgUnitCollection adminColl = iadmin.getAdminOrgUnitCollection(viewInfo);
                AdminOrgUnitInfo adminInfo = null;
                int size = adminColl.size();
                for (int i = 0; i < size; ++i) {
                    adminInfo = adminColl.get(i);
                    colDept.add(adminInfo);
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return colDept;
    }
}

