/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.compensation.CmpItemCatalogCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpReportException;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractBankAgentIssueFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUtil;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankAgentIssueFilterUI
extends AbstractBankAgentIssueFilterUI {
    protected static final Logger logger = CoreUIObject.getLogger(BankAgentIssueFilterUI.class);
    protected String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    protected String bankAgentIssueResourceURL = "com.kingdee.eas.hr.compensation.client.BankAgentIssueResource.";
    protected String currCmpSchemeId = null;
    protected ICmpScheme iCmpSchemeIts = null;
    protected ICmpSchemeItem iCmpSchemeItemIts = null;
    protected ICmpItem iCmpItemIts = null;
    protected CmpSchemeCollection cmpSchemeCollection = new CmpSchemeCollection();
    protected CmpItemCollection colCmpItem = null;
    protected CmpItemCollection colNecessaryCmpItem = new CmpItemCollection();
    public boolean isIncludeAll = false;
    protected CmpItemFilterUI cmpItemFilterUI = null;

    public BankAgentIssueFilterUI() throws Exception {
        this.init();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        if (this.prmtCmpScheme.getData() != null) {
            this.prmtCmpScheme.setData(null);
        }
        this.cmbItemCatalog.removeAllItems();
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    public CustomerParams getCustomerParams() {
        FilterInfo filter;
        int i;
        CustomerParams cp = new CustomerParams();
        if (this.prmtCmpScheme.getData() != null) {
            CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
            CmpSchemeInfo infoTem = null;
            StringBuffer cmpSchemeStr = new StringBuffer();
            int size = info.length;
            for (i = 0; i < size; ++i) {
                infoTem = info[i];
                if (i == 0) {
                    cmpSchemeStr.append(infoTem.getId().toString());
                    continue;
                }
                cmpSchemeStr.append("~" + infoTem.getId().toString());
            }
            cp.addCustomerParam("prmtCmpScheme", cmpSchemeStr.toString());
        }
        cp.addCustomerParam("isIncludeAll", String.valueOf(this.chkShowALL.isSelected()));
        int controlInt = 0;
        StringBuffer cmbStrArrayStr = new StringBuffer();
        int cmbSize = this.cmbItemCatalog.getItemCount();
        controlInt = cmbSize - 1;
        for (i = 0; i < cmbSize; ++i) {
            CmpItemCatalogInfo cmpcatalogInfo = (CmpItemCatalogInfo)this.cmbItemCatalog.getItemAt(i);
            cmbStrArrayStr.append(cmpcatalogInfo.getId().toString());
            if (i == controlInt) continue;
            cmbStrArrayStr.append("~");
        }
        cp.addCustomerParam("cmbCatalog", cmbStrArrayStr.toString());
        ArrayList<Object> lstSelectItemData = new ArrayList<Object>();
        int size = this.lstSelectItem.getElementCount();
        for (int i2 = 0; i2 < size; ++i2) {
            lstSelectItemData.add(this.lstSelectItem.getElement(i2));
        }
        cp.addCustomerParam("lstSelectItem", HRCommonQueryUtils.getSelectedItemIDS(lstSelectItemData));
        if (this.cmpItemFilterUI != null && (filter = this.cmpItemFilterUI.getCondition()) != null) {
            cp.addCustomerParam("CmpItemFilter", filter.toString());
        }
        return cp;
    }

    private String getSplitStr(String itemStr) {
        if (itemStr.indexOf("-") >= 0) {
            return "-";
        }
        return "~";
    }

    public void setCustomerParams(CustomerParams cp) {
        boolean isQuerySolutionUseAble = true;
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("isIncludeAll") != null) {
            this.isIncludeAll = Boolean.valueOf(cp.getCustomerParam("isIncludeAll"));
            this.chkShowALL.setSelected(this.isIncludeAll);
        }
        if (cp.getCustomerParam("prmtCmpScheme") != null) {
            String[] idArr = cp.getCustomerParam("prmtCmpScheme").split("~");
            try {
                HashSet<String> set = new HashSet<String>();
                int size = idArr.length;
                for (int i = 0; i < size; ++i) {
                    set.add(idArr[i]);
                }
                this.loadCmpScheme(set);
            }
            catch (Exception e) {
                this.lstSelectItem.removeAllElements();
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            if (this.prmtCmpScheme.getData() == null || this.getCmpSchemeIDs() == null) {
                this.cmbItemCatalog.removeAllItems();
                this.lstSelectItem.removeAllElements();
                isQuerySolutionUseAble = false;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"641_CmpReportFilterBaseUI"));
            } else if (this.getCmpSchemeIDs().size() != idArr.length) {
                isQuerySolutionUseAble = false;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"641_CmpReportFilterBaseUI"));
            }
        }
        if (cp.getCustomerParam("lstSelectItem") != null && isQuerySolutionUseAble) {
            String ids = cp.getCustomerParam("lstSelectItem");
            try {
                String filterStr;
                List lstSelectItemData = HRCommonQueryUtils.getSelectedItemList(ids, this.getSplitStr(ids));
                HRCommonQueryUtils.fillSelectItemList(lstSelectItemData, this.lstSelectItem, this.lstAllItem);
                CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
                if (this.cmpItemFilterUI != null && !StringUtils.isEmpty((String)(filterStr = cp.getCustomerParam("CmpItemFilter")))) {
                    this.cmpItemFilterUI.loadFilterInfo(new FilterInfo(filterStr));
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.lstAllItem.setSelectionMode(0);
        this.lstSelectItem.setSelectionMode(0);
    }

    protected void initAllEditor() throws ParserException, BOSException {
        this.prmtCmpScheme.setQueryInfo(this.cmpSchemeF7URL);
        this.prmtCmpScheme.setHasCUDefaultFilter(false);
        this.prmtCmpScheme.setEditable(false);
        this.prmtCmpScheme.setEditFormat("$name$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
        this.prmtCmpScheme.setEnabledMultiSelection(true);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)"1"));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("audit", (Object)"40"));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        filterInfoCmpSch.setMaskString("#0 and #1 and #2 and #3");
        FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, "adminUser.id");
        if (adminRangeFilter != null) {
            filterInfoCmpSch.mergeFilter(adminRangeFilter, "and");
        }
        evi.setFilter(filterInfoCmpSch);
        this.prmtCmpScheme.setEntityViewInfo(evi);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    protected void initLstSelectItem() {
        Iterator itr = this.colNecessaryCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpSchemeItemInfo info = null;
        while (itr.hasNext()) {
            infoCmpItem = (CmpItemInfo)itr.next();
            info = new CmpSchemeItemInfo();
            info.setCmpItem(infoCmpItem);
            this.lstSelectItem.addElement((Object)infoCmpItem);
        }
    }

    protected void init() throws Exception {
        this.cmbItemCatalog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    try {
                        BankAgentIssueFilterUI.this.onLoadAllList();
                        BankAgentIssueFilterUI.this.lstAllItem.requestFocus();
                    }
                    catch (BOSException e) {
                        BankAgentIssueFilterUI.this.handUIException(e);
                    }
                }
            }
        });
        this.prmtCmpScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    Object[] obj = (Object[])BankAgentIssueFilterUI.this.prmtCmpScheme.getData();
                    BankAgentIssueFilterUI.this.lstAllItem.removeAllElements();
                    BankAgentIssueFilterUI.this.lstSelectItem.removeAllElements();
                    if (obj == null || obj.length == 0) {
                        BankAgentIssueFilterUI.this.cmbItemCatalog.removeAllItems();
                        return;
                    }
                    if (obj.length == 1 && obj[0] == null) {
                        BankAgentIssueFilterUI.this.cmbItemCatalog.removeAllItems();
                        return;
                    }
                    BankAgentIssueFilterUI.this.getCmpItemCollection(BankAgentIssueFilterUI.this.getCmpSchemeInfoArrayByObject(obj));
                    BankAgentIssueFilterUI.this.fillCmpItemCatalogData();
                }
                catch (Exception exc) {
                    BankAgentIssueFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void onLoadAllList() throws BOSException {
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        if (infoCmpItemCatalog == null || this.colCmpItem == null) {
            return;
        }
        this.lstAllItem.removeAllElements();
        Iterator itrCmpItem = this.colCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpItemCatalogInfo infoTemp = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            infoTemp = infoCmpItem.getCmpItemCatalog();
            if (infoTemp == null || !infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) continue;
            boolean isSame = false;
            CmpItemInfo infoTempCmpItem = null;
            int count = this.lstSelectItem.getElementCount();
            for (int i = 0; i < count; ++i) {
                infoTempCmpItem = (CmpItemInfo)this.lstSelectItem.getElement(i);
                if (!infoTempCmpItem.getId().toString().equals(infoCmpItem.getId().toString())) continue;
                isSame = true;
            }
            if (isSame || infoCmpItem.getNumber().equals("FSAL000")) continue;
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    protected void fillCmpItemCatalogData() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        evi.setFilter(filterInfo);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longnumber"));
        evi.setSorter(sort);
        CmpItemCatalogCollection colCmpItemCatalog = CmpItemCatalogFactory.getRemoteInstance().getCmpItemCatalogCollection(evi);
        if (colCmpItemCatalog == null || colCmpItemCatalog.size() <= 0) {
            return;
        }
        Iterator itr = colCmpItemCatalog.iterator();
        CmpItemCatalogInfo cmpItemCatalogInfo = null;
        this.cmbItemCatalog.removeAllItems();
        while (itr.hasNext()) {
            cmpItemCatalogInfo = (CmpItemCatalogInfo)itr.next();
            this.cmbItemCatalog.addItem((Object)cmpItemCatalogInfo);
        }
    }

    protected ICmpScheme getSchemeBizInteface() throws BOSException {
        if (this.iCmpSchemeIts == null) {
            return CmpSchemeFactory.getRemoteInstance();
        }
        return this.iCmpSchemeIts;
    }

    protected ICmpSchemeItem getSchemeItemBizInteface() throws BOSException {
        if (this.iCmpSchemeIts == null) {
            return CmpSchemeItemFactory.getRemoteInstance();
        }
        return this.iCmpSchemeItemIts;
    }

    protected ICmpItem getItemBizInteface() throws BOSException {
        if (this.iCmpSchemeIts == null) {
            return CmpItemFactory.getRemoteInstance();
        }
        return this.iCmpItemIts;
    }

    protected EntityViewInfo getCmpItemEntityViewInfo(Set schemeIDSet) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("cmpItem.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("cmpItem.cmpItemCatalog.number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CMPSCHEME.ID", (Object)schemeIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FPER%", CompareType.NOTLIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.enable", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        entityViewInfo.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("cmpItem.cmpItemCatalog.number");
        sorterOrderItem.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterOrderItem);
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("cmpItem.number");
        sorterOrderItem1.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterOrderItem1);
        return entityViewInfo;
    }

    protected CmpItemCollection getRefPersonItem() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("CmpItemCatalog.number", (Object)"FPER"));
        filterInfo.setMaskString("#0 and #1 ");
        evi.setFilter(filterInfo);
        CmpItemCollection listCmpPersonItem = this.getItemBizInteface().getCmpItemCollection();
        return listCmpPersonItem;
    }

    protected CmpItemCollection getCmpItemCollection(CmpSchemeInfo[] schemeInfos) throws Exception {
        if (schemeInfos == null || schemeInfos.length == 0) {
            this.colCmpItem = null;
            return null;
        }
        HashSet<String> schemeIDSet = new HashSet<String>();
        for (int i = 0; i < schemeInfos.length; ++i) {
            schemeIDSet.add(schemeInfos[i].getId().toString());
        }
        EntityViewInfo entityViewInfo = this.getCmpItemEntityViewInfo(schemeIDSet);
        String cmpItemids = HRUtils.getCmpItemIds(null);
        if (cmpItemids != null && cmpItemids.length() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("cmpItem.id", (Object)cmpItemids, CompareType.INNER));
            entityViewInfo.getFilter().mergeFilter(fi, "and");
        }
        this.colCmpItem = this.getSchemeItemBizInteface().getUnionSchemeItemColl(null, entityViewInfo, true);
        this.getColNecessaryCmpItem();
        return this.colCmpItem;
    }

    private void loadCmpScheme(Set cmpSchemeIdSet) throws CmpReportException {
        CmpSchemeCollection cmpColl = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)cmpSchemeIdSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("enable", (Object)"1"));
        fi.getFilterItems().add(new FilterItemInfo("audit", (Object)"40"));
        fi.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        fi.setMaskString("#0 and #1 and #2 and #3");
        viewInfo.setFilter(fi);
        try {
            cmpColl = CmpSchemeFactory.getRemoteInstance().getCmpSchemeCollection(viewInfo);
            CmpSchemeInfo[] cmpSchemeArr = new CmpSchemeInfo[cmpColl.size()];
            int size = cmpColl.size();
            for (int i = 0; i < size; ++i) {
                cmpSchemeArr[i] = cmpColl.get(i);
            }
            this.prmtCmpScheme.setData((Object)cmpSchemeArr);
            this.colCmpItem = this.getCmpItemCollection(cmpSchemeArr);
            this.fillCmpItemCatalogData();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void getColNecessaryCmpItem() {
        if (this.colCmpItem == null) {
            return;
        }
        this.colNecessaryCmpItem = new CmpItemCollection();
        Iterator itr = this.colCmpItem.iterator();
        CmpItemInfo info = null;
        while (itr.hasNext()) {
            info = (CmpItemInfo)itr.next();
            if (!this.isNecessaryCmpItem(info)) continue;
            this.colNecessaryCmpItem.add(info);
        }
        this.lstSelectItem.removeAllElements();
        this.initLstSelectItem();
    }

    protected boolean isNecessaryCmpItem(CmpItemInfo info) {
        return HRSchemeUtils.isNecessaryBankAgentCmpItem(info);
    }

    public List getListSelectItem() {
        ArrayList<CmpItemInfo> listSelectList = new ArrayList<CmpItemInfo>();
        int countListSelectItem = this.lstSelectItem.getElementCount();
        if (countListSelectItem > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < countListSelectItem; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(i);
                listSelectList.add(i, info);
            }
        }
        return listSelectList;
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        this.allRightToLeftItem();
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        this.rightToLeft();
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        this.leftToRight();
    }

    protected void leftToRight() {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            if (indexSelect <= 1) {
                indexSelect = 2;
            }
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            if (indexSelect <= 1) {
                indexSelect = 2;
            }
            if (this.lstSelectItem.getSelectedIndex() == -1) {
                indexSelect = 1;
            }
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.insertElement((Object)info, indexSelect);
                this.lstAllItem.removeElement((Object)info);
                ++indexSelect;
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    protected void rightToLeft() {
        CmpItemInfo info;
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0 && !this.isNecessaryCmpItem(info = (CmpItemInfo)this.lstSelectItem.getElement(index))) {
            this.lstSelectItem.removeElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
            CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
            CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
            if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                this.lstAllItem.addElement((Object)info);
                this.lstAllItem.setSelectedIndex(this.lstAllItem.getElementCount() - 1);
            }
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    protected void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                if (!this.isNecessaryCmpItem(info)) {
                    CmpItemCatalogInfo cmpItemCatalogInfo = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                    CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                    CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
                    if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                        this.lstAllItem.addElement((Object)info);
                    }
                }
                this.lstSelectItem.removeElement((Object)info);
            }
            this.initLstSelectItem();
            this.lstAllItem.setSelectedIndex(0);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        this.allLeftToRightItem();
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    public boolean verify() {
        if (this.getCmpSchemeIDs() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.bankAgentIssueResourceURL + "MISS_CMPSHCEME")));
            this.prmtCmpScheme.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstAllItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstSelectItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    protected CmpSchemeInfo[] getCmpSchemeInfoArrayByObject(Object[] objA) {
        if (objA == null || objA.length == 0) {
            return null;
        }
        CmpSchemeInfo[] info = new CmpSchemeInfo[objA.length];
        int size = objA.length;
        for (int i = 0; i < size; ++i) {
            info[i] = (CmpSchemeInfo)objA[i];
        }
        return info;
    }

    public CmpSchemeCollection getCmpSchemeColl() {
        Object[] objs = (Object[])this.prmtCmpScheme.getData();
        if (objs == null || objs.length == 0) {
            return null;
        }
        CmpSchemeCollection schemeColl = new CmpSchemeCollection();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            schemeColl.add((CmpSchemeInfo)objs[i]);
        }
        return schemeColl;
    }

    public List getCmpSchemeIDs() {
        Object[] objs = (Object[])this.prmtCmpScheme.getData();
        if (objs == null || objs.length == 0) {
            return null;
        }
        ArrayList<String> cmpSchemeIDs = new ArrayList<String>();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            if (objs[i] == null) continue;
            cmpSchemeIDs.add(((CmpSchemeInfo)objs[i]).getId().toString());
        }
        return cmpSchemeIDs;
    }

    public List getSelectCmpItem() {
        ArrayList<Object> selectCmpItemList = new ArrayList<Object>();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            selectCmpItemList.add(this.lstSelectItem.getElement(i));
        }
        return selectCmpItemList;
    }

    public CmpItemFilterUI getCmpItemFilterUI() {
        return this.cmpItemFilterUI;
    }

    public void setCmpItemFilterUI(CmpItemFilterUI cmpItemFilterUI) {
        this.cmpItemFilterUI = cmpItemFilterUI;
    }

    private KDList getCmpItemFilterItem(KDList items) {
        KDList kdList = new KDList();
        CmpItemInfo info = null;
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            info = (CmpItemInfo)this.lstSelectItem.getElement(i);
            if ("FSAL000".equals(info.getNumber())) continue;
            kdList.addElement((Object)info);
        }
        return kdList;
    }
}

