/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.BankAgentIssueFacadeFactory;
import com.kingdee.eas.hr.compensation.IBankAgentIssueFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCashPaymentIssueListUI;
import com.kingdee.eas.hr.compensation.client.CashPaymentIssueFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class CashPaymentIssueListUI
extends AbstractCashPaymentIssueListUI {
    private static final Logger logger = CoreUIObject.getLogger(CashPaymentIssueListUI.class);
    private CommonQueryDialog commonQueryDialog = null;
    private boolean isFirstDefaultQuery = true;
    private EntityViewInfo filterEntityInfo = new EntityViewInfo();
    private IBankAgentIssueFacade iBankAgentIssueFacade = null;
    private KDTSortManager sm = null;
    private DecimalFormat df = new DecimalFormat("##.##");

    private IBankAgentIssueFacade getBankAgentIssueFacInterface() throws BOSException {
        if (this.iBankAgentIssueFacade == null) {
            this.iBankAgentIssueFacade = BankAgentIssueFacadeFactory.getRemoteInstance();
        }
        return this.iBankAgentIssueFacade;
    }

    private KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.tblMain);
        }
        return this.sm;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initAllEditor() {
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintView);
        this.setButtonDefaultStyl(this.btnQuery);
        this.tblMain.checkParsed();
        this.enableExportExcel(this.tblMain);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getColumn("empName").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("empNumber").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("adminOrgUnit").setUserObject((Object)"Total");
        this.tblMain.getColumn("cashValue").setUserObject((Object)"cashData");
        this.tblMain.getColumn("byNumber").setUserObject((Object)"Data");
        this.tblMain.getColumn("wsNumber").setUserObject((Object)"Data");
        this.tblMain.getColumn("syNumber").setUserObject((Object)"Data");
        this.tblMain.getColumn("wyNumber").setUserObject((Object)"Data");
        this.tblMain.getColumn("yyNumber").setUserObject((Object)"Data");
        this.tblMain.getColumn("wjNumber").setUserObject((Object)"Data");
        this.tblMain.getColumn("yjNumber").setUserObject((Object)"Data");
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        HRUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        this.showFilterDialog();
    }

    private List calNumberOfCash(BigDecimal valueTemp) {
        ArrayList<Integer> calResultList = new ArrayList<Integer>();
        Integer rmb100 = this.getCashNumber(0.0, new BigDecimal("100"), valueTemp);
        calResultList.add(rmb100);
        Integer rmb50 = this.getCashNumber(100.0, new BigDecimal("50"), valueTemp);
        calResultList.add(rmb50);
        Integer rmb10 = this.getCashNumber(50.0, new BigDecimal("10"), valueTemp);
        calResultList.add(rmb10);
        Integer rmb5 = this.getCashNumber(10.0, new BigDecimal("5"), valueTemp);
        calResultList.add(rmb5);
        Integer rmb1 = this.getCashNumber(5.0, new BigDecimal("1"), valueTemp);
        calResultList.add(rmb1);
        Integer rmb05 = this.getCashNumber(1.0, new BigDecimal("0.5"), valueTemp);
        calResultList.add(rmb05);
        Integer rmb01 = this.getCashNumber(0.5, new BigDecimal("0.1"), valueTemp);
        calResultList.add(rmb01);
        return calResultList;
    }

    private Integer getCashNumber(double modValue, BigDecimal divValue, BigDecimal totalCash) {
        BigDecimal temp = HRSchemeUtils.BD_ZERO;
        temp = modValue == 0.0 ? new BigDecimal(this.df.format(totalCash.doubleValue())).setScale(1, 4) : new BigDecimal(this.df.format(totalCash.doubleValue() % modValue)).setScale(1, 4);
        Integer rmbX = Integer.valueOf(temp.divide(divValue, 0, 1).toString());
        return rmbX;
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    private void fillDataToTable(IRowSet rowSetTemp) {
        this.tblMain.removeRows();
        if (rowSetTemp.size() == 0) {
            return;
        }
        try {
            while (rowSetTemp.next()) {
                IRow iRow = this.tblMain.addRow();
                if (rowSetTemp.getString("ADMINNAME") != null) {
                    String[] adminName = rowSetTemp.getString("ADMINNAME").split("_");
                    String name = "";
                    int size = adminName.length;
                    for (int i = 1; i < size; ++i) {
                        name = !name.equals("") ? name + "_" + adminName[i] : adminName[i];
                    }
                    iRow.getCell("adminOrgUnit").setValue((Object)name);
                }
                if (rowSetTemp.getBigDecimal("FFSAL230") == null) continue;
                iRow.getCell("cashValue").setValue((Object)rowSetTemp.getBigDecimal("FFSAL230").setScale(1, 4).toString());
                BigDecimal valueTemp = rowSetTemp.getBigDecimal("FFSAL230").setScale(1, 4);
                this.fillNumber(iRow, valueTemp);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.tblMain, 0, this.tblMain.getRowCount() - 1, this.getKDSortManger());
        this.addTotalRow();
    }

    private void fillNumber(IRow iRow, BigDecimal valueTemp) {
        List numberList = this.calNumberOfCash(valueTemp);
        if (!"0.0".equals(valueTemp.toString())) {
            iRow.getCell("byNumber").setValue((Object)numberList.get(0).toString());
            iRow.getCell("wsNumber").setValue((Object)numberList.get(1).toString());
            iRow.getCell("syNumber").setValue((Object)numberList.get(2).toString());
            iRow.getCell("wyNumber").setValue((Object)numberList.get(3).toString());
            iRow.getCell("yyNumber").setValue((Object)numberList.get(4).toString());
            iRow.getCell("wjNumber").setValue((Object)numberList.get(5).toString());
            iRow.getCell("yjNumber").setValue((Object)numberList.get(6).toString());
        } else {
            iRow.getCell("byNumber").setValue((Object)"0");
            iRow.getCell("wsNumber").setValue((Object)"0");
            iRow.getCell("syNumber").setValue((Object)"0");
            iRow.getCell("wyNumber").setValue((Object)"0");
            iRow.getCell("yyNumber").setValue((Object)"0");
            iRow.getCell("wjNumber").setValue((Object)"0");
            iRow.getCell("yjNumber").setValue((Object)"0");
        }
    }

    private void addTotalRow() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        IRow iRow = this.tblMain.addRow();
        iRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        BigDecimal sumBigDecimal = HRSchemeUtils.BD_ZERO;
        int sizeCol = this.tblMain.getColumnCount();
        for (int j = 0; j < sizeCol; ++j) {
            if (this.tblMain.getColumn(j).getUserObject() != null && (this.tblMain.getColumn(j).getUserObject().toString().equals("Data") || this.tblMain.getColumn(j).getUserObject().toString().equals("cashData"))) {
                int sizeRow = this.tblMain.getRowCount() - 1;
                for (int i = 0; i < sizeRow; ++i) {
                    sumBigDecimal = sumBigDecimal.add(new BigDecimal(this.tblMain.getCell(i, j).getValue().toString()));
                }
                if (this.tblMain.getColumn(j).getUserObject().toString().equals("cashData")) {
                    iRow.getCell(j).setValue((Object)sumBigDecimal.setScale(1, 4));
                } else {
                    iRow.getCell(j).setValue((Object)sumBigDecimal.setScale(0));
                }
                sumBigDecimal = HRSchemeUtils.BD_ZERO;
                continue;
            }
            if (this.tblMain.getColumn(j).getUserObject() == null || !this.tblMain.getColumn(j).getUserObject().toString().equals("Total")) continue;
            iRow.getCell(j).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"4_BIEmpCmpDiffFacadeControllerBean"));
        }
    }

    protected void showFilterDialog() throws Exception {
        int dialogHight = 380;
        int dialogWidth = 460;
        CashPaymentIssueFilterUI cashPaymentIssueFilterTmp = new CashPaymentIssueFilterUI();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = CashPaymentIssueListUI.getQueryInfo(this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getQueryPanelInfo().size() > 0 && solution.getQueryPanelInfo().get(0).getCustomerParams() != null && CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams()) != null) {
                CustomerParams cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
                cashPaymentIssueFilterTmp.setCustomerParams(cp);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("adminList", cashPaymentIssueFilterTmp.getAdminList());
                paramMap.put("cmpSchemeTable", cashPaymentIssueFilterTmp.getSchemeTableName());
                paramMap.put("employeeType", cashPaymentIssueFilterTmp.getEmpTypeList());
                IRowSet rowSetTemp = this.getBankAgentIssueFacInterface().getCmpCashRMB(paramMap);
                this.fillDataToTable(rowSetTemp);
                this.isFirstDefaultQuery = false;
                return;
            }
            this.isFirstDefaultQuery = false;
            this.showFilterDialog();
            return;
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(dialogHight);
            this.commonQueryDialog.setWidth(dialogWidth);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.addUserPanel((KDPanel)cashPaymentIssueFilterTmp);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
        }
        if (this.commonQueryDialog.show()) {
            CashPaymentIssueFilterUI cashPaymentIssueFilter = (CashPaymentIssueFilterUI)this.commonQueryDialog.getUserPanel(0);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("adminList", cashPaymentIssueFilter.getAdminList());
            paramMap.put("cmpSchemeTable", cashPaymentIssueFilter.getSchemeTableName());
            paramMap.put("employeeType", cashPaymentIssueFilter.getEmpTypeList());
            this.filterEntityInfo = this.commonQueryDialog.getEntityViewInfoResult();
            IRowSet rowSetTemp = this.getBankAgentIssueFacInterface().getCmpCashRMB(paramMap);
            this.fillDataToTable(rowSetTemp);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initAllEditor();
        this.showFilterDialog();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
        super.actionPrintView_actionPerformed(e);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }
}

