/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.BusinessTypeEnum;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRMarkFactory;
import com.kingdee.eas.hr.base.HRMarkInfo;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeFactory;
import com.kingdee.eas.hr.compensation.FillFillException;
import com.kingdee.eas.hr.compensation.ICmpAdjustScheme;
import com.kingdee.eas.hr.compensation.client.AbstractCmpAffairBizHistoryUI;
import com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI;
import com.kingdee.eas.hr.compensation.client.CmpAffairFilterUI;
import com.kingdee.eas.hr.compensation.client.PartJobFixedAdjustEditUI;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CmpAffairBizHistoryUI
extends AbstractCmpAffairBizHistoryUI {
    private static final Logger log = Logger.getLogger(CmpAffairBizHistoryUI.class);
    private static final String ID_COL_NAME = "id";
    private static final String EMPNAME_COL_NAME = "person.name";
    private static final String EMPNAME_COL_NUMBER = "person.number";
    private static final String EMPNAME_COL_ID = "person.id";
    private static final String EFFECT_DATE = "affairDate";
    public boolean REFRESH = true;
    public boolean isForPartJob = false;

    protected void beforeOnLoad() throws Exception {
        HRSchemeUtils.checkInit();
        if (!this.isBillUpdate()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"639_CmpAffairBizHistoryUI"));
            SysUtil.abort();
        }
        super.beforeOnLoad();
    }

    protected void afterOnLoad() throws Exception {
        CmpDateUtils.setColumnDateFormat(this.tblMain, new String[]{EFFECT_DATE});
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        super.handleQueryDialog(dialog);
        dialog.addUserPanel((KDPanel)new CmpAffairFilterUI());
    }

    protected FilterInfo getDefaultFilter() throws Exception {
        FilterInfo filter = new FilterInfo();
        CompUtils.addPermissionFilter(filter, EMPNAME_COL_ID);
        String adminSql = HRSchemeUtils.getAdminByUserRange(null);
        FilterItemInfo item = new FilterItemInfo("adminOrg.id", (Object)adminSql, CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionDispose_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks.size() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.EmpTransformResource.SELECT_ONEDISPOSEEMP"));
            return;
        }
        List disposeEmpIDList = this.getDisposeList(blocks);
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.EmpTransformResource.COMFIRM_DELETE")))) {
            this.saveMark(disposeEmpIDList);
            this.actionRefresh_actionPerformed(e);
        }
    }

    private void saveMark(List disposeEmpIDList) throws BOSException, EASBizException {
        if (disposeEmpIDList == null || disposeEmpIDList.size() < 1) {
            return;
        }
        HRMarkInfo info = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        int size = disposeEmpIDList.size();
        for (int i = 0; i < size; ++i) {
            info = new HRMarkInfo();
            info.setBusinessType(BusinessTypeEnum.compensation);
            info.setTuned(true);
            info.setEmpFlowInOut(BOSUuid.read((String)disposeEmpIDList.get(i).toString()));
            colls.add((CoreBaseInfo)info);
        }
        HRMarkFactory.getRemoteInstance().addnewBatchData(colls);
    }

    private List getDisposeList(List blocks) throws FillFillException {
        int size = blocks.size();
        ArrayList<Object> lst = new ArrayList<Object>(size);
        ArrayList<Object> lst1 = new ArrayList<Object>(size);
        int k = 0;
        int rowCount = 0;
        for (int i = 0; i < size; ++i) {
            KDTBlock block = (KDTBlock)blocks.get(i);
            int jsize = block.getBottom();
            for (int j = block.getTop(); j <= jsize; ++j) {
                if (j == -1) continue;
                if (((Boolean)this.tblMain.getRow(j).getCell("tuned").getValue()).booleanValue()) {
                    throw new FillFillException(FillFillException.HAS_DEAL);
                }
                lst.add(this.tblMain.getRow(j).getCell(ID_COL_NAME).getValue());
                ++rowCount;
                if (this.tblMain.getRow(j).getCell("assignType").getValue() != null && 0 == ((BizEnumValueDTO)this.tblMain.getRow(j).getCell("assignType").getValue()).getInt()) {
                    ++k;
                    continue;
                }
                lst1.add(this.tblMain.getRow(j).getCell(ID_COL_NAME).getValue());
            }
        }
        this.isForPartJob = false;
        if (k > 0 && rowCount != k) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchEditUIResource.SELECT_PERSON_ERROR")) != 0) {
                SysUtil.abort();
            }
        } else if (k > 0 && rowCount == k) {
            this.isForPartJob = true;
        }
        if (!this.isForPartJob) {
            return lst1;
        }
        return lst;
    }

    @Override
    public void actionProcess_actionPerformed(ActionEvent e) throws Exception {
        ArrayList selBlks = this.tblMain.getSelectManager().getBlocks();
        if (selBlks == null || selBlks.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.EmpTransformResource", (String)"SELECT_EMP"));
            return;
        }
        if (this.tblMain.getSelectManager().getActiveRowIndex() == -1) {
            return;
        }
        List lstDispose = this.getDisposeList(selBlks);
        Map mapPerson = this.getSelectedPerson(selBlks);
        Map ctx = this.getUIContext();
        ctx.put("ADJUSTSCHEMEEDITUIPARM", mapPerson);
        ctx.put("FromEmpTransformListUI", "true");
        ctx.put("isUpgrade", "true");
        if (this.isForPartJob) {
            IUIWindow adjEditUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.hr.compensation.client.PartJobFixedAdjustEditUI", ctx, null, OprtState.ADDNEW);
            adjEditUI.show();
            if (PartJobFixedAdjustEditUI.isSubmited) {
                this.saveMark(lstDispose);
                PartJobFixedAdjustEditUI.isSubmited = false;
            }
        } else {
            IUIWindow adjEditUI = UIFactory.createUIFactory((String)this.getEditUIModal()).create("com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI", ctx, null, OprtState.ADDNEW);
            adjEditUI.show();
            if (AdjustSchemeEditUI.isSubmited) {
                this.removeLstDispose(mapPerson, lstDispose, AdjustSchemeEditUI.personList);
                this.saveMark(lstDispose);
                AdjustSchemeEditUI.isSubmited = false;
            }
        }
        this.actionRefresh_actionPerformed(e);
    }

    private void removeLstDispose(Map mapPerson, List lstDispose, List personList) {
        ArrayList personAllList = new ArrayList(mapPerson.keySet());
        if (personList == null) {
            return;
        }
        personAllList.removeAll(personList);
        Iterator it = personAllList.iterator();
        String personId = null;
        while (it.hasNext()) {
            personId = it.next().toString();
            Object affairHisID = null;
            if (!mapPerson.containsKey(personId) || (affairHisID = ((Map)mapPerson.get(personId)).get("affairHisID")) == null) continue;
            lstDispose.remove(affairHisID);
        }
    }

    private Map getSelectedPerson(List selBlks) throws Exception {
        HashMap<String, HashMap> mapPerson = new HashMap<String, HashMap>(32);
        String personId = null;
        String name = null;
        String number = null;
        HashMap<String, Object> tmp = null;
        String affairHisID = null;
        HashSet<String> personIDSet = new HashSet<String>();
        int size = selBlks.size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)selBlks.get(i);
            int end = block.getEndRow();
            for (int begin = block.getBeginRow(); begin <= end; ++begin) {
                Object entryID;
                IRow row = this.tblMain.getRow(begin);
                if (!this.isForPartJob && row.getCell("assignType").getValue() != null && 0 == ((BizEnumValueDTO)row.getCell("assignType").getValue()).getInt()) continue;
                personId = row.getCell(EMPNAME_COL_ID).getValue().toString();
                personIDSet.add(personId);
                if (row.getCell(EMPNAME_COL_NAME).getValue() != null) {
                    name = row.getCell(EMPNAME_COL_NAME).getValue().toString();
                }
                if (row.getCell(EMPNAME_COL_NUMBER).getValue() != null) {
                    number = row.getCell(EMPNAME_COL_NUMBER).getValue().toString();
                }
                if (row.getCell(ID_COL_NAME).getValue() != null) {
                    affairHisID = row.getCell(ID_COL_NAME).getValue().toString();
                }
                tmp = new HashMap<String, Object>();
                tmp.put("name", name);
                tmp.put("number", number);
                tmp.put("affairHisID", affairHisID);
                tmp.put("effectDate", row.getCell(EFFECT_DATE).getValue());
                AdminOrgUnitInfo oldAdmin = null;
                Object v = row.getCell("adminOrg1.id").getValue();
                if (v != null) {
                    oldAdmin = new AdminOrgUnitInfo();
                    oldAdmin.setId(BOSUuid.read((String)v.toString()));
                    v = row.getCell("adminOrg1.name").getValue();
                    if (v != null) {
                        oldAdmin.setName(v.toString());
                    }
                    if ((v = row.getCell("adminOrg1.displayName").getValue()) != null) {
                        oldAdmin.setDisplayName(v.toString());
                    }
                    tmp.put("oldAdmin", oldAdmin);
                }
                if ((v = row.getCell("position1.id").getValue()) != null) {
                    PositionInfo position = new PositionInfo();
                    position.setId(BOSUuid.read((String)v.toString()));
                    v = row.getCell("position1.name").getValue();
                    if (v != null) {
                        position.setName(v.toString());
                    }
                    position.setAdminOrgUnit(oldAdmin);
                    tmp.put("oldPosition", position);
                }
                AdminOrgUnitInfo newAdmin = null;
                v = row.getCell("adminOrg.id").getValue();
                if (v != null) {
                    newAdmin = new AdminOrgUnitInfo();
                    newAdmin.setId(BOSUuid.read((String)v.toString()));
                    v = row.getCell("adminOrg.name").getValue();
                    if (v != null) {
                        newAdmin.setName(v.toString());
                        v = row.getCell("adminOrg.displayName").getValue();
                        newAdmin.setDisplayName(v.toString());
                    }
                    tmp.put("newAdmin", newAdmin);
                }
                if ((v = row.getCell("position.id").getValue()) != null) {
                    PositionInfo position = new PositionInfo();
                    position.setId(BOSUuid.read((String)v.toString()));
                    v = row.getCell("position.name").getValue();
                    if (v != null) {
                        position.setName(v.toString());
                    }
                    position.setAdminOrgUnit(newAdmin);
                    tmp.put("newPosition", position);
                }
                if ((entryID = row.getCell(ID_COL_NAME).getValue()) != null) {
                    tmp.put("entryID", entryID);
                }
                mapPerson.put(personId, tmp);
            }
        }
        ICmpAdjustScheme ica = CmpAdjustSchemeFactory.getRemoteInstance();
        HashMap effDateMap = ica.getPersonLastAdjDate(personIDSet);
        mapPerson.put("effDateMap", effDateMap);
        return mapPerson;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
            return;
        }
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            ActionEvent event = null;
            event = new ActionEvent(this.btnProcess, 0, "Double Clicked");
            ItemAction act = this.getActionFromActionEvent(event);
            act.actionPerformed(event);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.tblMain.getActionMap().put("enter", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CmpAffairBizHistoryUI.this.enterKey();
            }
        });
    }

    private void enterKey() {
        ActionEvent evt = new ActionEvent(this.btnProcess, 0, "Enter");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    private boolean isBillUpdate() throws BOSException {
        HRInitCollection upgrade = HRInitFactory.getRemoteInstance().getHRInitCollection("where key = 'BILL_UPGRADE'");
        return upgrade != null && upgrade.size() > 0;
    }

    protected boolean isUseStandardPermission() {
        return true;
    }
}

