/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.client.HrTextAreaRender;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.org.IOrgHRCommon;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpCalculateBaseHelper {
    private static Logger logger = Logger.getLogger(CmpCalculateBaseHelper.class);
    private KDTable tblBaseInfo;
    private static final String resPath = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";
    private String formatString = "yyyy-m-d";
    private Map mapRes = new HashMap(48);
    private Map mapValue = new HashMap(48);
    private String cmpSchemeId;
    private boolean error = false;

    public CmpCalculateBaseHelper(KDTable table, String cmpSchemeId) {
        this.tblBaseInfo = table;
        this.cmpSchemeId = cmpSchemeId;
        this.loadRes();
    }

    private void loadRes() {
        this.mapRes.put("CMPSCHEME", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.CMPSCHEME"));
        this.mapRes.put("STANDRAD_DYAS", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.STANDRAD_DYAS"));
        this.mapRes.put("ACCOUNTANT_PERIOD", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.ACCOUNTANT_PERIOD"));
        this.mapRes.put("SALARY_PERIOD", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.SALARY_PERIOD"));
        this.mapRes.put("COMPUTER_TIME", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.COMPUTER_TIME"));
        this.mapRes.put("COMPANY_TOTAL_PEOPLE", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.COMPANY_TOTAL_PEOPLE"));
        this.mapRes.put("COMPUTER_TOTAL_PEOPLE", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.COMPUTER_TOTAL_PEOPLE"));
        this.mapRes.put("CURRENT_PEOPLE", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.CURRENT_PEOPLE"));
        this.mapRes.put("SALARY_ITEM", EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.SALARY_ITEM"));
        this.mapRes.put("1.", "1.");
        this.mapRes.put("2.", "2.");
    }

    private void getBaseInfoData() {
        this.getPersonCount();
        this.getDays();
        this.getCmpItems();
        this.getCmpSchemeInfo();
        this.mapValue.put("COMPUTER_TIME", new Date());
        this.mapValue.put("1.", "");
        this.mapValue.put("2.", "");
    }

    private void fillDataToCol(int col, Map mapColValue) {
        int index = 0;
        this.tblBaseInfo.getRow(index++).getCell(col).setValue(mapColValue.get("1."));
        this.tblBaseInfo.getRow(index++).getCell(col).setValue(mapColValue.get("CMPSCHEME"));
        ICell cell = this.tblBaseInfo.getRow(index++).getCell(col);
        cell.setValue(mapColValue.get("SALARY_PERIOD"));
        this.tblBaseInfo.getRow(index++).getCell(col).setValue(mapColValue.get("STANDRAD_DYAS"));
        cell = this.tblBaseInfo.getRow(index++).getCell(col);
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
        cell.getStyleAttributes().setNumberFormat(sdf.toString());
        cell.setValue(mapColValue.get("ACCOUNTANT_PERIOD"));
        int n = ++index;
        cell = this.tblBaseInfo.getRow(n).getCell(col);
        String dateFormat = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        cell.getStyleAttributes().setNumberFormat(format.toString());
        cell.setValue(mapColValue.get("COMPUTER_TIME"));
        int n2 = ++index;
        ++index;
        this.tblBaseInfo.getRow(n2).getCell(col).setValue(mapColValue.get("CURRENT_PEOPLE"));
        int n3 = ++index;
        this.tblBaseInfo.getRow(n3).getCell(col).setValue(mapColValue.get("2."));
        HrTextAreaRender info = new HrTextAreaRender();
        this.tblBaseInfo.getRow(++index).getCell(col).setRenderer((IBasicRender)info);
        this.tblBaseInfo.getRow(index).setResizeable(true);
        this.tblBaseInfo.getRow(index).setHeight(info.getPerfHeight(this.tblBaseInfo.getColumn(col).getWidth(), (String)mapColValue.get("SALARY_ITEM")));
        this.tblBaseInfo.getRow(index++).getCell(col).setValue(mapColValue.get("SALARY_ITEM"));
    }

    public boolean fillTable() {
        int size = this.mapRes.size() + 2;
        for (int i = 0; i < size; ++i) {
            this.tblBaseInfo.addRow();
        }
        this.fillDataToCol(0, this.mapRes);
        this.getBaseInfoData();
        this.fillDataToCol(1, this.mapValue);
        return this.error;
    }

    private void getPersonCount() {
        int companys = 0;
        int computers = 0;
        try {
            IOrgHRCommon iOrg = OrgHRCommonFactory.getRemoteInstance();
            companys = iOrg.getSumPersonByOrg(null, 3);
            computers = iOrg.getSumPersonByOrg(null, 1);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        this.mapValue.put("COMPANY_TOTAL_PEOPLE", companys);
        this.mapValue.put("COMPUTER_TOTAL_PEOPLE", computers);
        this.mapValue.put("CURRENT_PEOPLE", this.getCurrentPersonCount());
    }

    private void getDays() {
        BigDecimal bigV = null;
        try {
            bigV = HRUtils.getSysConfigInfo().getMonStaWorkDays();
        }
        catch (Exception e) {
            bigV = new BigDecimal(21.5);
        }
        this.mapValue.put("STANDRAD_DYAS", bigV.setScale(2));
    }

    private int getCurrentPersonCount() {
        int person = 0;
        String sql = "select count(*) as Fnumber from t_hr_cmpschemeperson a where a.fcmpschemeid='" + this.cmpSchemeId + "' and a.fisdelete = 0 ";
        IRowSet rs = null;
        try {
            ISQLExecutor exector = SQLExecutorFactory.getRemoteInstance((String)sql);
            rs = exector.executeSQL();
            if (rs.next()) {
                person = rs.getInt(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (person == 0) {
            this.error = true;
        }
        return person;
    }

    private void getCmpItems() {
        String strItems = "";
        String language = SysContext.getSysContext().getLocale().getLanguage();
        String sql = "select b.fname_" + language + ",b.fnumber from t_hr_cmpschemeitem a,t_hr_cmpitem b where a.fcmpitemid=b.fid and a.fcmpschemeid='" + this.cmpSchemeId + "' and a.FisDelete = 0";
        IRowSet rs = null;
        try {
            ISQLExecutor exector = SQLExecutorFactory.getRemoteInstance((String)sql);
            rs = exector.executeSQL();
            strItems = this.formatCmpItems(rs);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            strItems = "...";
        }
        this.mapValue.put("SALARY_ITEM", strItems);
    }

    private String formatCmpItems(IRowSet rs) throws SQLException {
        StringBuffer buff = new StringBuffer(1024);
        while (rs.next()) {
            buff.append(rs.getString("fnumber") + " " + rs.getString(1) + ",");
        }
        return buff.substring(0, buff.length() - 1);
    }

    private void getCmpSchemeInfo() {
        CmpSchemeInfo info = null;
        try {
            ICmpScheme ics = CmpSchemeFactory.getRemoteInstance();
            info = ics.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(this.cmpSchemeId), this.getSelectors());
            PeriodInfo pinfo = info.getCmpPeriod().getFiscalPeriod();
            this.mapValue.put("CMPSCHEME", info.getName());
            this.mapValue.put("SALARY_PERIOD", info.getCmpPeriod().getNumber());
            this.mapValue.put("ACCOUNTANT_PERIOD", pinfo);
        }
        catch (Exception e) {
            this.mapValue.put("CMPSCHEME", "");
            this.mapValue.put("SALARY_PERIOD", "");
            this.mapValue.put("ACCOUNTANT_PERIOD", "");
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("cmpPeriod.number"));
        sic.add(new SelectorItemInfo("cmpPeriod.fiscalPeriod.*"));
        return sic;
    }
}

