/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.AffairUpgradeFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpCalFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpCalFacade;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.client.AbstractCmpCalculateCheckUI;
import com.kingdee.eas.hr.compensation.client.CmpCalculateBaseHelper;
import com.kingdee.eas.hr.compensation.util.CmpConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sql.RowSet;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CmpCalculateCheckUI
extends AbstractCmpCalculateCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpCalculateCheckUI.class);
    private boolean loadBase = false;
    private boolean loadEmpChange = false;
    private boolean loadSalaryChange = false;
    private String cmpSchemeId = null;
    private String cmpPeriodId = null;
    private ICmpCalFacade icmpCalFacde = null;
    private HashMap deletePersonMap = new HashMap();
    private String cmpCalCheckResBasicURL = "com.kingdee.eas.hr.compensation.client.CmpCalCheckResource.";
    private boolean isUpgrade = false;
    private CmpSchemeInfo cmpSchemeInfo = null;
    public static final int FIELDPERSONNNUMBER = 0;
    public static final int FIELDPERSONNAME = 1;
    public static final int FIELDUNIT = 2;
    public static final int FIELPOISTION = 3;
    public static final int FIELDEFFECTDATE = 4;
    public static final int FIELDAffirType = 5;
    public static final int FIELDREMOVESTATE = 6;
    public static final int FIELDPERSONID = 7;

    public CmpCalculateCheckUI() throws Exception {
    }

    public CmpCalculateCheckUI(String cmpSchemeId) throws Exception {
        this.cmpSchemeId = cmpSchemeId;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.cmpSchemeId = (String)this.getUIContext().get("ID");
        boolean error = this.loadBaseInfo();
        if (error) {
            return;
        }
        ICmpScheme ics = CmpSchemeFactory.getRemoteInstance();
        this.cmpSchemeInfo = ics.getCmpSchemeInfo("select id,name,number,cmpPeriod.id,cmpPeriod.beginDate,cmpPeriod.endDate where id ='" + this.cmpSchemeId + "'");
        this.cmpPeriodId = (String)this.getUIContext().get("cmpPeriodIDContext");
        this.isUpgrade = AffairUpgradeFacadeFactory.getRemoteInstance().isUpgrade();
        if (this.isUpgrade) {
            this.personTransformQueryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app", "PersonTransformNewQuery");
        }
        this.loadEmpChangeInfo();
        this.loadSalaryChangeInfo();
        this.initRemoveTable();
        this.tblAdjust.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblAdjust.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblAdjust.getColumn("colAdjustBefore").getStyleAttributes().setNumberFormat("#,###,##0.00");
        this.tblAdjust.getColumn("colAdjustAfter").getStyleAttributes().setNumberFormat("#,###,##0.00");
        this.tblChange.getColumn("colEffectDate").getStyleAttributes().setNumberFormat(CmpConstant.DATEFORMAT);
        this.tblRemovePerson.getColumn("effectDate").getStyleAttributes().setNumberFormat(CmpConstant.DATEFORMAT);
        this.tblAdjust.getColumn("colAdjustDate").getStyleAttributes().setNumberFormat(CmpConstant.DATEFORMAT);
        this.tblAdjust.getColumn("colEffectDate").getStyleAttributes().setNumberFormat(CmpConstant.DATEFORMAT);
    }

    private CmpPeriodInfo getCmpPeriodInfo() {
        return this.cmpSchemeInfo.getCmpPeriod();
    }

    private boolean loadBaseInfo() {
        if (this.loadBase) {
            return true;
        }
        this.loadBase = true;
        this.tblBaseInfo.checkParsed();
        this.tblBaseInfo.getStyleAttributes().setLocked(true);
        this.tblBaseInfo.getStyleAttributes().setWrapText(true);
        this.tblBaseInfo.getSelectManager().setSelectMode(2);
        this.tblBaseInfo.refresh();
        this.tblBaseInfo.getColumn(0).setWidth(150);
        this.tblBaseInfo.getColumn(1).setWidth(400);
        CmpCalculateBaseHelper baseHelper = new CmpCalculateBaseHelper(this.tblBaseInfo, this.cmpSchemeId);
        return baseHelper.fillTable();
    }

    private void loadEmpChangeInfo() {
        if (this.loadEmpChange) {
            return;
        }
        this.loadEmpChange = true;
        this.tblChange.checkParsed();
        this.tblChange.getStyleAttributes().setLocked(true);
        this.tblChange.getSelectManager().setSelectMode(2);
        this.personTransformQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpSchemeId", (Object)this.cmpSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.getPersonSql(), CompareType.INNER));
        if (this.isUpgrade) {
            filter.getFilterItems().add(new FilterItemInfo("billBOSType", (Object)"E41B9A4E", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billBOSType", (Object)"C0DAD00D", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billBOSType", (Object)"B65CCEF1", CompareType.EQUALS));
            filter.setMaskString(" #0 and #1 and (#2 or #3 or #4)");
        } else {
            filter.setMaskString(" #0 and #1 ");
        }
        this.personTransformQuery.setFilter(filter);
    }

    private void loadSalaryChangeInfo() {
        if (this.loadSalaryChange) {
            return;
        }
        this.loadSalaryChange = true;
        this.tblAdjust.checkParsed();
        this.tblAdjust.getColumn("colAdjustBefore").getStyleAttributes().setNumberFormat("%r{0.00}f");
        this.tblAdjust.getColumn("colAdjustAfter").getStyleAttributes().setNumberFormat("%r{0.00}f");
        this.tblAdjust.getColumn("colAdjustDate").getStyleAttributes().setNumberFormat(CmpConstant.DATEFORMAT);
        this.tblAdjust.getColumn("colEffectDate").getStyleAttributes().setNumberFormat(CmpConstant.DATEFORMAT);
        this.tblAdjust.getSelectManager().setSelectMode(2);
        this.tblAdjust.getStyleAttributes().setLocked(true);
        this.cmpAdjustQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.getPersonSql(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("isHistoryData", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isHistoryData", null, CompareType.EQUALS));
        CmpPeriodInfo periodInfo = this.getCmpPeriodInfo();
        if (periodInfo != null) {
            Date startDate = periodInfo.getBeginDate();
            Date endDate = periodInfo.getEndDate();
            filter.getFilterItems().add(new FilterItemInfo("effectDate", (Object)startDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("effectDate", (Object)endDate, CompareType.LESS_EQUALS));
            filter.setMaskString("#0 and (#1 or #2) and #3 and #4");
        } else {
            filter.setMaskString("#0 and (#1 or #2)");
        }
        this.cmpAdjustQuery.setFilter(filter);
        this.tblAdjust.getColumn("colAdjustDate").getStyleAttributes().setHided(true);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private void setAffairTypeName() {
        IRow row;
        ICell cell;
        Object obj;
        int size = this.tblChange.getRowCount();
        for (int i = 0; i < size && (obj = (cell = (row = this.tblChange.getRow(i)).getCell("colChangeType")).getValue()) instanceof Integer; ++i) {
            int type = (Integer)cell.getValue();
            cell.setValue((Object)AffairTypeEnum.getEnum((int)type));
        }
    }

    @Override
    protected void tabPanel_stateChanged(ChangeEvent e) throws Exception {
        super.tabPanel_stateChanged(e);
        this.setAffairTypeName();
    }

    private void initRemoveTable() throws Exception {
        this.tblRemovePerson.checkParsed();
        this.tblRemovePerson.getStyleAttributes().setLocked(true);
        this.tblRemovePerson.getColumn(6).getStyleAttributes().setLocked(false);
        this.tblRemovePerson.getColumn(7).getStyleAttributes().setHided(true);
        this.loadRemovePersonData();
        this.tblRemovePerson.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){
            boolean isException = false;

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 6) {
                    IRow iRow = CmpCalculateCheckUI.this.tblRemovePerson.getRow(e.getRowIndex());
                    ICell iCellState = iRow.getCell(6);
                    Boolean temp = (Boolean)iCellState.getValue();
                    ICell iCellPersonID = iRow.getCell(7);
                    if (iCellPersonID.getValue() == null) {
                        this.isException = true;
                        return;
                    }
                    String mapKey = null;
                    String personCurrentID = iCellPersonID.getValue().toString();
                    try {
                        if (temp.booleanValue()) {
                            if (!CmpCalculateCheckUI.this.deletePersonMap.isEmpty()) {
                                CmpCalculateCheckUI.this.deletePersonMap.remove(CmpCalculateCheckUI.this.cmpSchemeId);
                            }
                            iCellState.setValue((Object)Boolean.FALSE);
                        } else {
                            mapKey = CmpCalculateCheckUI.this.cmpSchemeId + "#" + personCurrentID;
                            CmpCalculateCheckUI.this.deletePersonMap.put(mapKey, personCurrentID);
                            iCellState.setValue((Object)Boolean.TRUE);
                        }
                    }
                    catch (Exception e1) {
                        this.editCanceled(null);
                        this.isException = true;
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }

            public void editStopped(KDTEditEvent e) {
                if (this.isException) {
                    IRow iRow = CmpCalculateCheckUI.this.tblRemovePerson.getRow(e.getRowIndex());
                    ICell iCellState = iRow.getCell(e.getColIndex());
                    iCellState.setValue((Object)Boolean.FALSE);
                    this.isException = false;
                }
            }
        });
    }

    private ICmpCalFacade getBizCmpCalFacadeIF() throws BOSException {
        if (this.icmpCalFacde == null) {
            this.icmpCalFacde = CmpCalFacadeFactory.getRemoteInstance();
        }
        return this.icmpCalFacde;
    }

    public void loadRemovePersonData() throws Exception {
        CmpPeriodInfo cmpPeriodInfo = this.getCmpPeriodInfo();
        if (cmpPeriodInfo == null) {
            return;
        }
        EntityViewInfo entityViewInfo = null;
        entityViewInfo = this.isUpgrade ? this.getEntityViewInfoForRemoveNew(cmpPeriodInfo) : this.getEntityViewInfoForRemoveOld(cmpPeriodInfo);
        IRowSet rowSetTemp = this.getBizCmpCalFacadeIF().getRemovePersonDataIF(entityViewInfo);
        this.loadTableRow((RowSet)rowSetTemp);
    }

    private EntityViewInfo getEntityViewInfoForRemoveOld(CmpPeriodInfo cmpPeriodInfo) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CMPSCH.id", (Object)this.cmpSchemeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectDate", (Object)cmpPeriodInfo.getEndDate(), CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("affairType", (Object)"3", CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.getPersonSql(), CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.inService", (Object)"1", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.inService", (Object)"4", CompareType.NOTEQUALS));
        filterInfo.setMaskString("(#0) and (#1) and (#2) and #3 and #4 and #5");
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    private EntityViewInfo getEntityViewInfoForRemoveNew(CmpPeriodInfo cmpPeriodInfo) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CMPSCH.id", (Object)this.cmpSchemeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectDate", (Object)cmpPeriodInfo.getEndDate(), CompareType.LESS_EQUALS));
        HashSet<String> bosTypeSet = new HashSet<String>();
        bosTypeSet.add("CC58A617");
        bosTypeSet.add("19438A0C");
        filterInfo.getFilterItems().add(new FilterItemInfo("billBOSType", bosTypeSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.getPersonSql(), CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.inService", (Object)"1", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.inService", (Object)"4", CompareType.NOTEQUALS));
        filterInfo.setMaskString("(#0) and (#1) and (#2) and #3 and #4 and #5");
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadTableRow(RowSet rowSetTemp) throws Exception {
        this.tblRemovePerson.removeRows();
        HashMap<String, String> mapPerson = new HashMap<String, String>();
        while (rowSetTemp.next()) {
            String number = rowSetTemp.getString("PERSON.NUMBER");
            if (mapPerson.get(number) != null) continue;
            mapPerson.put(number, number);
            if (!this.isUpgrade && rowSetTemp.getInt("AFFAIRTYPE") == 6) continue;
            IRow row = this.tblRemovePerson.addRow();
            ICell cellPersonNumber = row.getCell(0);
            cellPersonNumber.setValue((Object)rowSetTemp.getString("PERSON.NUMBER"));
            ICell cellPersonName = row.getCell(1);
            cellPersonName.setValue((Object)rowSetTemp.getString("PERSON.NAME"));
            ICell cellPersonUnit = row.getCell(2);
            cellPersonUnit.setValue((Object)rowSetTemp.getString("OLDDEPT.NAME"));
            ICell cellPersonPosition = row.getCell(3);
            cellPersonPosition.setValue((Object)rowSetTemp.getString("OLDPOSITION.NAME"));
            ICell cellEffectDate = row.getCell(4);
            cellEffectDate.setValue((Object)rowSetTemp.getDate("EFFECTDATE").toString());
            ICell cellAffirType = row.getCell(5);
            if (this.isUpgrade) {
                if ("CC58A617".equals(rowSetTemp.getString("billBOSType"))) {
                    cellAffirType.setValue((Object)EASResource.getString((String)(this.cmpCalCheckResBasicURL + "RESIGN")));
                } else {
                    if (!"19438A0C".equals(rowSetTemp.getString("billBOSType"))) return;
                    cellAffirType.setValue((Object)EASResource.getString((String)(this.cmpCalCheckResBasicURL + "RETIRE")));
                }
            } else if (rowSetTemp.getInt("AFFAIRTYPE") == 3) {
                cellAffirType.setValue((Object)EASResource.getString((String)(this.cmpCalCheckResBasicURL + "RESIGN")));
            } else if (rowSetTemp.getInt("AFFAIRTYPE") == 4) {
                cellAffirType.setValue((Object)EASResource.getString((String)(this.cmpCalCheckResBasicURL + "FIRETITLE")));
            } else {
                if (rowSetTemp.getInt("AFFAIRTYPE") != 5) return;
                cellAffirType.setValue((Object)EASResource.getString((String)(this.cmpCalCheckResBasicURL + "RETIRE")));
            }
            ICell cellRemoveSate = row.getCell(6);
            cellRemoveSate.setValue((Object)Boolean.FALSE);
            ICell cellPersonID = row.getCell(7);
            cellPersonID.setValue((Object)rowSetTemp.getString("PERSON.ID"));
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        this.disposeUIWindow();
    }

    public void doProcess() {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)(this.cmpCalCheckResBasicURL + "ISEFFECTPERSON")));
        if (result == 0) {
            try {
                this.getBizCmpCalFacadeIF().removeCmpSchPersonIF(this.deletePersonMap);
                MsgBox.showInfo((String)EASResource.getString((String)(this.cmpCalCheckResBasicURL + "EFFECTSUCC")));
                this.deletePersonMap.clear();
            }
            catch (Exception exc) {
                this.handUIException(exc);
            }
        } else if (result == 2) {
            SysUtil.abort();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        if (!this.deletePersonMap.isEmpty()) {
            this.doProcess();
        }
        this.disposeUIWindow();
    }

    public boolean checkBeforeWindowClosing() {
        if (!this.deletePersonMap.isEmpty()) {
            this.doProcess();
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    protected void tblChange_doRequestRowSet(RequestRowSetEvent e) {
        if (this.personTransformQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.personTransformQueryPK, this.personTransformQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                if (this.isUpgrade) {
                    this.onGetRowSetUpGrade(rowSet);
                }
                e.setRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    private void onGetRowSetUpGrade(IRowSet rowSet) {
        try {
            HashMap<String, String> entryids = new HashMap<String, String>();
            Map PosiLevels = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getString("entryID") == null || rowSet.getString("billBOSType") == null) continue;
                entryids.put(rowSet.getString("entryID"), rowSet.getString("billBOSType"));
            }
            if (entryids != null && entryids.size() > 0) {
                PosiLevels = CmpCalFacadeFactory.getRemoteInstance().getPosiLevel(entryids);
            }
            if (PosiLevels == null || PosiLevels.size() == 0) {
                return;
            }
            String[] PosiLevelAndBoSType = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getString("entryID") == null || (PosiLevelAndBoSType = (String[])PosiLevels.get(rowSet.getString("entryID"))) == null) continue;
                rowSet.updateString("affairType", PosiLevelAndBoSType[0]);
                rowSet.updateString("oldJobLevel.name", PosiLevelAndBoSType[1]);
                rowSet.updateString("newJobLevel.name", PosiLevelAndBoSType[2]);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    private String getPersonSql() {
        String sql = "select fpersonid from t_hr_cmpschemeperson where fisDelete = 0 and fcmpschemeid = '" + this.cmpSchemeId + "'";
        return sql;
    }
}

