/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.compensation.ISchemeFacade;
import com.kingdee.eas.hr.compensation.SchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractCmpCloseListUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CmpCloseListUI
extends AbstractCmpCloseListUI {
    private static Logger logger = Logger.getLogger(CmpCloseListUI.class);
    String resClass = "com.kingdee.eas.hr.compensation.client.EmpCmpSchmResource.";

    public CmpCloseListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.tblMain == null) {
            return;
        }
        KDTSortManager sm = new KDTSortManager(this.tblMain);
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
    }

    @Override
    public void actionCloseCmpScheme_actionPerformed(ActionEvent e) throws Exception {
        if (!LicenseHelper.keyPointLicenseCheck()) {
            SysUtil.abort();
        }
        this.checkSelected();
        final Object objID = HRTableTools.getTableSelectCellValue(this.tblMain, "id");
        HRSchemeUtils.requestDataLock(objID.toString(), EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"205_CmpCloseListUI"));
        Map ctx = this.getUIContext();
        ctx.put("closedType", null);
        String closeAccountUI = "com.kingdee.eas.hr.compensation.client.CloseAccountConfirmUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(closeAccountUI, ctx, null, OprtState.ADDNEW);
        uiWindow.show();
        Map uiMap = uiWindow.getUIObject().getUIContext();
        final String closedType = (String)uiMap.get("closedType");
        String action = (String)uiMap.get("action");
        if (action != null && action.equals("do")) {
            if ("period".equals(closedType)) {
                ObjectUuidPK pk = new ObjectUuidPK(objID.toString());
                String getCurPeriodTime = SchemeFacadeFactory.getRemoteInstance().checkDateOfFuTble((IObjectPK)pk, closedType);
                if (getCurPeriodTime != null && getCurPeriodTime.length() > 0 && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((CoreUI)null), (String)(getCurPeriodTime = EASResource.getString((String)(this.resClass + "PERIOD_CLOSE")).replaceAll("#1", getCurPeriodTime))))) {
                    MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(objID.toString());
                    return;
                }
            }
            if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
                GetDataDialog dlg = new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
                dlg.setGetDataTask(new GetDataTaskAdapter(){

                    public Object exec() throws Exception {
                        ObjectUuidPK pk = new ObjectUuidPK(objID.toString());
                        ISchemeFacade iSchemeFacade = SchemeFacadeFactory.getRemoteInstance();
                        iSchemeFacade.closeCmpScheme((IObjectPK)pk, closedType);
                        CmpCloseListUI.this.setMessageText(EASResource.getString((String)(CmpCloseListUI.this.resClass + "CLOSE_OVER")));
                        CmpCloseListUI.this.showMessage();
                        MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(objID.toString());
                        return null;
                    }
                });
                dlg.show();
                this.refresh(e);
            }
        } else {
            MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(objID.toString());
            return;
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected boolean initDefaultFilter() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("audit", (Object)40));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1 and #2");
        FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, "adminUser.id");
        if (adminRangeFilter != null) {
            try {
                filterInfo.mergeFilter(adminRangeFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.mainQuery.setFilter(filterInfo);
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCloseCmpScheme.setIcon(EASResource.getIcon((String)"imgTbtn_post"));
        this.menuItemCheckOut.setIcon(EASResource.getIcon((String)"imgTbtn_post"));
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
        this.tblMain.setColumnMoveable(true);
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        logger.info((Object)(">>>>>>>>>>HRO_ID:" + HRO_ID));
        try {
            logger.info((Object)(">>>>>>>>>>hr_cmp_017:" + HRParamUtil.getParamOfHR(null, (String)"hr_cmp_017", (String)HRO_ID)));
            if (HRParamUtil.getParamOfHR(null, (String)"hr_cmp_017", (String)HRO_ID)) {
                this.synBtn.setIcon(EASResource.getIcon((String)"imgTbtn_post"));
                this.synBtn.setVisible(true);
            } else {
                this.synBtn.setVisible(false);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, "adminUser.id");
        if (adminRangeFilter != null) {
            try {
                filter.mergeFilter(adminRangeFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return filter;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    public void actionSyn_actionPerformed_actionPerformed(ActionEvent e) throws Exception {
        try {
            logger.info((Object)">>>>>>>>>>begin CmpCloseListUI:actionSyn_actionPerformed");
            SchemeFacadeFactory.getRemoteInstance().synData();
            this.synBtn.setEnabled(false);
            logger.info((Object)">>>>>>>>>>end actionSyn_actionPerformed");
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)e1.getMessage());
            SysUtil.abort();
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.EasHrMultilanResourse", (String)"synSuccess");
        MsgBox.showInfo((String)msg);
    }
}

