/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.client.AbstractCmpDetailReportFilterUI;
import com.kingdee.eas.hr.compensation.client.HRF7CmpSchemePromptBox;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CmpDetailReportFilterUI
extends AbstractCmpDetailReportFilterUI {
    private AdminOrgUnitCollection colDept = null;
    private AdminOrgUnitInfo infoDept = null;
    private int level = 0;
    private boolean isDisplayAllName = false;
    private boolean isShowAllDept = false;
    private boolean isLoaded = true;
    private final String RADIOBTN = "radiobtn";

    public CmpDetailReportFilterUI() throws Exception {
    }

    public CmpDetailReportFilterUI(CmpSchemeInfo[] schemeInfo, AdminOrgUnitInfo adminInfo) throws Exception {
        this.dataTypeFilter = true;
        this.perItemFilter = true;
        if (schemeInfo != null && schemeInfo.length > 0 && schemeInfo[0] != null) {
            this.labBeginPeriod.setVisible(false);
            this.labEndPeriod.setVisible(false);
            this.labCmpScheme.setVisible(false);
            this.chkShowDelete.setVisible(false);
            this.kdlAdminOrg.setVisible(false);
            this.chkHasSubAdminOrg.setSelected(false);
            this.prmtBeginCmpPeriod.setRequired(false);
            this.prmtEndCmpPeriod.setRequired(false);
            this.prmtAdminUnitOrg.setRequired(false);
            this.pnlProp.setVisible(false);
            this.btnSingleOrg.setVisible(false);
            this.btnMulOrg.setVisible(false);
            this.kDSeparator1.setVisible(false);
        }
    }

    @Override
    public CmpSchemeInfo[] getCmpSchemeColl() {
        return super.getCmpSchemeColl();
    }

    @Override
    public void clear() {
        super.clear();
        this.btnSingleOrg.setSelected(true);
        this.prmtSingleAdminOrg.setData(null);
        this.prmtSingleAdminOrg.setEnabled(true);
        this.prmtSingleAdminOrg.setRequired(true);
        this.chkHasSubAdminOrg.setEnabled(true);
        this.chkHasSubAdminOrg.setSelected(false);
        this.cmbLevel.setEnabled(false);
        this.cmbLevel.removeAllItems();
        this.prmtBeginCmpPeriod.setData(null);
        this.prmtEndCmpPeriod.setData(null);
        this.prmtAdminUnitOrg.setData(null);
        this.prmtAdminUnitOrg.setEnabled(false);
        this.prmtAdminUnitOrg.setRequired(false);
        this.chkShowLongName.setSelected(false);
        this.chkShowAllDept.setSelected(false);
        this.chkZeroItemDisplayNull.setSelected(false);
        this.chkCollectItemEndFlag.setSelected(false);
        this.chkIncDelItem.setSelected(false);
        this.chkIsShowDetail.setSelected(false);
        this.chkIsShowTimeDetail.setSelected(false);
        this.txtFromTime.setText(null);
        this.txtToTime.setText(null);
        this.chkShowDelete.setSelected(false);
        this.radiobtn0.setSelected(true);
        try {
            this.rootHroId = null;
            this.hroList = new ArrayList();
            this.setPeriodAndSchemeF7(this.rootHroId, this.hroList);
            this.isLoaded = true;
            this.setOrgCommentEnabled();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (this.prmtBeginCmpPeriod.getData() != null) {
            cp.addCustomerParam("cmpBeginPeriod", ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getId().toString());
        }
        if (this.prmtEndCmpPeriod.getData() != null) {
            cp.addCustomerParam("cmpEndPeriod", ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getId().toString());
        }
        if (this.btnSingleOrg.isSelected()) {
            if (this.prmtSingleAdminOrg.getData() != null) {
                cp.addCustomerParam("adminOrgUnit", ((AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData()).getId().toString());
            }
            cp.addCustomerParam("hasSubDept", String.valueOf(this.chkHasSubAdminOrg.isSelected()));
            if (this.cmbLevel.getSelectedItem() != null) {
                cp.addCustomerParam("level", ((Integer)this.cmbLevel.getSelectedItem()).toString());
            }
        }
        cp.putBoolean("chkCollectItemEndFlag", this.chkCollectItemEndFlag.isSelected());
        cp.putBoolean("chkIsShowDetail", this.chkIsShowDetail.isSelected());
        cp.putBoolean("chkIsShowTimeDetail", this.chkIsShowTimeDetail.isSelected());
        if (!StringUtils.isEmpty((String)this.txtFromTime.getText())) {
            cp.addCustomerParam("fromTime", Integer.toString(this.txtFromTime.getNumberValue().intValue()));
        }
        if (!StringUtils.isEmpty((String)this.txtToTime.getText())) {
            cp.addCustomerParam("toTime", Integer.toString(this.txtToTime.getNumberValue().intValue()));
        }
        if (this.radiobtn0.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn0");
        } else if (this.radiobtn1.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn1");
        } else if (this.radiobtn2.isSelected()) {
            cp.addCustomerParam("levelComboBox", this.levelComboBox.getSelectedItem().toString());
        }
        cp.addCustomerParam("isDisplayAllName", String.valueOf(this.chkShowLongName.isSelected()));
        cp.addCustomerParam("isShowAllDept", String.valueOf(this.chkShowAllDept.isSelected()));
        cp.addCustomerParam("isIncludeDelCmpSch", String.valueOf(this.chkShowDelete.isSelected()));
        cp.putBoolean("chkIncDelItem", this.chkIncDelItem.isSelected());
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        CmpPeriodInfo endPeriodInfo;
        this.isLoaded = false;
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("cmpScheme") != null) {
            cp.addCustomerParam("prmtCmpScheme", cp.getCustomerParam("cmpScheme"));
        }
        super.setCustomerParams(cp);
        CmpPeriodInfo beginPeriodInfo = this.f7Info.getPeriodInfo();
        if (beginPeriodInfo != null) {
            this.prmtBeginCmpPeriod.setData((Object)beginPeriodInfo);
        }
        if ((endPeriodInfo = this.f7Info.getEndPeriodInfo()) != null) {
            this.prmtEndCmpPeriod.setData((Object)endPeriodInfo);
        }
        try {
            this.infoDept = this.f7Info.getAdminInfo();
            if (this.infoDept != null) {
                this.btnSingleOrg.setSelected(true);
                this.btnMulOrg.setSelected(false);
                this.prmtSingleAdminOrg.setData((Object)this.infoDept);
                try {
                    this.doChangedAdmin(this.infoDept, this.f7Info.getLevel());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                this.btnSingleOrg.setSelected(false);
                this.btnMulOrg.setSelected(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (cp.getCustomerParam("radiobtn") == null || cp.getCustomerParam("radiobtn").equals("radiobtn0")) {
            this.radiobtn0.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn1")) {
            this.radiobtn1.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn2")) {
            this.radiobtn2.setSelected(true);
            String level = cp.getCustomerParam("levelComboBox");
            if (StringUtils.isEmpty((String)level)) {
                level = cp.getCustomerParam("level");
            }
            this.levelComboBox.setSelectedIndex(Integer.parseInt(level) - 1);
        }
        if (this.infoDept != null) {
            int oldLevel;
            if (cp.getCustomerParam("level") != null && this.cmbLevel.getItemCount() > 0 && (oldLevel = Integer.valueOf(cp.getCustomerParam("level")).intValue()) <= this.cmbLevel.getItemCount()) {
                this.cmbLevel.setSelectedIndex(oldLevel - 1);
            }
        } else {
            this.cmbLevel.removeAllItems();
        }
        if (cp.getCustomerParam("isDisplayAllName") != null) {
            this.isDisplayAllName = Boolean.valueOf(cp.getCustomerParam("isDisplayAllName"));
            this.chkShowLongName.setSelected(this.isDisplayAllName);
        }
        if (cp.getCustomerParam("isShowAllDept") != null) {
            this.isShowAllDept = Boolean.valueOf(cp.getCustomerParam("isShowAllDept"));
            this.chkShowAllDept.setSelected(this.isShowAllDept);
        }
        if (cp.getCustomerParam("hasSubDept") != null) {
            this.chkHasSubAdminOrg.setSelected(Boolean.valueOf(cp.getCustomerParam("hasSubDept")).booleanValue());
        }
        if (cp.getCustomerParam("isIncludeDelCmpSch") != null) {
            this.chkShowDelete.setSelected(Boolean.valueOf(cp.getCustomerParam("isIncludeDelCmpSch")).booleanValue());
        }
        if (!this.chkHasSubAdminOrg.isSelected()) {
            this.cmbLevel.setEnabled(false);
        } else {
            this.cmbLevel.setEnabled(true);
        }
        this.chkCollectItemEndFlag.setSelected(cp.getBoolean("chkCollectItemEndFlag"));
        this.chkIsShowDetail.setSelected(cp.getBoolean("chkIsShowDetail"));
        this.chkIsShowTimeDetail.setSelected(cp.getBoolean("chkIsShowTimeDetail"));
        this.txtFromTime.setText(cp.getCustomerParam("fromTime"));
        this.txtToTime.setText(cp.getCustomerParam("toTime"));
        this.chkIncDelItem.setSelected(cp.getBoolean("chkIncDelItem"));
        this.isLoaded = true;
        try {
            this.setCurrentHRO();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.setOrgCommentEnabled();
    }

    @Override
    protected void initAllEditor() throws Exception {
        super.initAllEditor();
        this.prmtBeginCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtBeginCmpPeriod.setEditable(false);
        this.prmtBeginCmpPeriod.setEditFormat("$name$");
        this.prmtBeginCmpPeriod.setDisplayFormat("$name$");
        this.prmtBeginCmpPeriod.setHasCUDefaultFilter(false);
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.rootHroId));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtBeginCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        this.prmtEndCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtEndCmpPeriod.setEditable(false);
        this.prmtEndCmpPeriod.setEditFormat("$name$");
        this.prmtEndCmpPeriod.setDisplayFormat("$name$");
        this.prmtEndCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        this.prmtEndCmpPeriod.setHasCUDefaultFilter(false);
        CompUtils.initF7SelectorNoHR((CustomerQueryPanel)this, this.prmtSingleAdminOrg);
        this.btnSingleOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CmpDetailReportFilterUI.this.btnSingleOrg.isSelected()) {
                    CmpDetailReportFilterUI.this.setAdminPrmtState(true);
                } else {
                    CmpDetailReportFilterUI.this.setAdminPrmtState(false);
                    CmpDetailReportFilterUI.this.infoDept = null;
                }
            }
        });
        this.btnSingleOrg.setSelected(true);
        this.prmtSingleAdminOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    CmpDetailReportFilterUI.this.doChangedAdmin((AdminOrgUnitInfo)CmpDetailReportFilterUI.this.prmtSingleAdminOrg.getData());
                }
                catch (Exception e) {
                    CmpDetailReportFilterUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowSealUp_itemStateChanged(e);
        CompUtils.initF7SelectorNoHR(this.prmtSingleAdminOrg, this.chkShowSealUp.isSelected());
    }

    @Override
    protected void cmbLevel_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbLevel_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            this.setCurrentHRO();
        }
    }

    @Override
    protected void setCurrentHRO() throws Exception {
        super.setCurrentHRO();
        if (!this.isLoaded) {
            return;
        }
        String newRootHroId = "";
        ArrayList newHroList = null;
        if (this.btnSingleOrg.isSelected()) {
            if (this.prmtSingleAdminOrg.getData() == null) {
                return;
            }
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
            Integer level = 0;
            if (this.chkHasSubAdminOrg.isSelected() && this.cmbLevel.getSelectedItem() != null) {
                Object obj = this.cmbLevel.getSelectedItem();
                level = (Integer)obj;
            }
            newHroList = this.getSelectHROS(adminInfo, level);
            newRootHroId = this.getRootHROID(newHroList);
            this.setPeriodAndSchemeF7(newRootHroId, newHroList);
        }
    }

    @Override
    protected void setPeriodAndSchemeF7(String newRootHroId, ArrayList newHroList) throws Exception {
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)newRootHroId));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtBeginCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        this.prmtEndCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        if (this.rootHroId != null && (newRootHroId != null && !this.rootHroId.equals(newRootHroId) || newRootHroId == null)) {
            this.prmtBeginCmpPeriod.setValue(null);
            this.prmtEndCmpPeriod.setValue(null);
        }
        HRF7CmpSchemePromptBox f7PromptBox = new HRF7CmpSchemePromptBox((IUIObject)this);
        f7PromptBox.setIsSingleSelect(false);
        f7PromptBox.setIsShowDelete(this.chkShowDelete.isSelected());
        f7PromptBox.setHROFilter(newHroList);
        this.prmtCmpScheme.setDefaultF7UIName(HRF7CmpSchemePromptBox.class.getName());
        this.prmtCmpScheme.setSelector((KDPromptSelector)f7PromptBox);
        this.rootHroId = newRootHroId;
        this.hroList = newHroList;
        if (this.prmtCmpScheme.getData() == null) {
            return;
        }
        Object[] objs = (Object[])this.prmtCmpScheme.getData();
        boolean flag = true;
        CmpSchemeInfo csInfo = null;
        HROrgUnitInfo hroInfo = null;
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            if (!(objs[i] instanceof CmpSchemeInfo)) continue;
            csInfo = (CmpSchemeInfo)objs[i];
            flag = true;
            for (int t = 0; t < this.hroList.size(); ++t) {
                hroInfo = (HROrgUnitInfo)this.hroList.get(t);
                if (!csInfo.getHrOrgUnit().getId().toString().equals(hroInfo.getId().toString())) continue;
                flag = false;
            }
            if (flag) break;
        }
        if (flag) {
            this.prmtCmpScheme.setValue(null);
            this.lstSelectItem.removeAllElements();
            this.lstSelectItemNotSort.removeAllElements();
            this.lstAllItem.removeAllElements();
        }
    }

    private ArrayList getSelectHROS(AdminOrgUnitInfo adminInfo, Integer level) throws Exception {
        ArrayList<HROrgUnitInfo> hros = new ArrayList<HROrgUnitInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT T_ORG_HRO.FID,T_ORG_HRO.FLongNumber ");
        sql.append("FROM T_ORG_UnitRelation ");
        sql.append("INNER JOIN T_ORG_HRO ");
        sql.append("ON T_ORG_UnitRelation.FToUnitID = T_ORG_HRO.FID ");
        sql.append("INNER JOIN T_ORG_Admin ");
        sql.append("ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
        sql.append("WHERE T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        sql.append("AND (T_ORG_Admin.FID='");
        sql.append(adminInfo.getId());
        sql.append("' OR T_ORG_Admin.FLongNumber LIKE '");
        sql.append(adminInfo.getLongNumber());
        sql.append("!%') AND T_ORG_Admin.FLevel <= ");
        sql.append(adminInfo.getLevel());
        sql.append("+");
        sql.append(level);
        sql.append(" and T_ORG_Admin.FID in ( select forgid from T_PM_OrgRange where FUserID = '");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        sql.append("' and ftype = 20 ) ");
        sql.append(" ORDER BY T_ORG_HRO.FLongNumber");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        HROrgUnitInfo hroInfo = null;
        while (rows.next()) {
            hroInfo = new HROrgUnitInfo();
            hroInfo.setId(BOSUuid.read((String)rows.getString(1)));
            hroInfo.setLongNumber(rows.getString(2));
            hros.add(hroInfo);
        }
        return hros;
    }

    @Override
    public boolean verify() {
        boolean flagOfDate;
        int fromTime;
        if (this.btnMulOrg.isSelected()) {
            if (this.prmtAdminUnitOrg.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_ADMIN")));
                this.prmtAdminUnitOrg.requestFocusInWindow();
                return false;
            }
            this.colDept = new AdminOrgUnitCollection();
            Object[] value = (Object[])this.prmtAdminUnitOrg.getData();
            if (value != null && value.length > 0) {
                for (int i = 0; i < value.length; ++i) {
                    this.colDept.add((AdminOrgUnitInfo)value[i]);
                }
            }
        } else {
            this.infoDept = (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
            if (this.prmtSingleAdminOrg.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_ADMIN")));
                this.btnSingleOrg.setSelected(true);
                this.prmtSingleAdminOrg.requestFocusInWindow();
                return false;
            }
        }
        if (this.prmtBeginCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmtBeginCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (this.prmtEndCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmtEndCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (!StringUtils.isEmpty((String)this.txtFromTime.getText()) && (fromTime = this.txtFromTime.getNumberValue().intValue()) < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "FROMTIME_NEED_GREATER_THAN_ZERO")));
            this.txtFromTime.requestFocusInWindow();
            return false;
        }
        if (!StringUtils.isEmpty((String)this.txtToTime.getText()) && (fromTime = this.txtToTime.getNumberValue().intValue()) < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "TOTIME_NEED_GREATER_THAN_ZERO")));
            this.txtToTime.requestFocusInWindow();
            return false;
        }
        if (!StringUtils.isEmpty((String)this.txtToTime.getText()) && !StringUtils.isEmpty((String)this.txtFromTime.getText())) {
            String endPeriodId;
            int toTime = this.txtToTime.getNumberValue().intValue();
            int fromTime2 = this.txtFromTime.getNumberValue().intValue();
            String beginPeriodId = ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getId().toString();
            if (beginPeriodId.equals(endPeriodId = ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getId().toString()) && fromTime2 > toTime) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"364_EmployeeToTalFilterUI"));
                this.txtFromTime.requestFocusInWindow();
                return false;
            }
        }
        CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndCmpPeriod.getData();
        if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
            this.prmtBeginCmpPeriod.requestFocusInWindow();
            return false;
        }
        Object scheme = this.prmtCmpScheme.getData();
        if (scheme == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"263_CmpSummaryReportFilterUI"));
            this.prmtCmpScheme.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void chkHasSubAdminOrg_itemStateChanged(ItemEvent e) throws Exception {
        super.chkHasSubAdminOrg_itemStateChanged(e);
        try {
            if (this.chkHasSubAdminOrg.isSelected()) {
                this.cmbLevel.setEnabled(true);
            } else {
                this.cmbLevel.setEnabled(false);
            }
            this.setCurrentHRO();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void doChangedAdmin(AdminOrgUnitInfo temp) throws Exception {
        this.cmbLevel.removeAllItems();
        if (temp == null) {
            this.chkHasSubAdminOrg.setSelected(false);
            return;
        }
        int level = HRCommonQueryUtils.getAdminOrgLevelCountNoHR(temp);
        HRCommonQueryUtils.initComBox(this.cmbLevel, level);
        this.setCurrentHRO();
    }

    private void doChangedAdmin(AdminOrgUnitInfo temp, int level) throws Exception {
        this.cmbLevel.removeAllItems();
        if (temp == null) {
            this.chkHasSubAdminOrg.setSelected(false);
            return;
        }
        HRCommonQueryUtils.initComBox(this.cmbLevel, level);
    }

    public CmpPeriodCollection getCmpPeriodCollection() throws Exception {
        CmpPeriodCollection col = null;
        Date beginDate = ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getBeginDate();
        Date endDate = ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getEndDate();
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.rootHroId));
        infoFilter.setMaskString("#0 and #1 and #2");
        evi.setFilter(infoFilter);
        evi.getSorter().add(new SorterItemInfo("beginDate"));
        col = iCmpPeriod.getCmpPeriodCollection(evi);
        return col;
    }

    @Override
    public AdminOrgUnitCollection getDeptCol(boolean isShowSealUp) {
        block9: {
            try {
                if (this.colDept == null) {
                    this.colDept = new AdminOrgUnitCollection();
                }
                if (this.isSelectSingleDept()) {
                    this.infoDept = (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
                    if (this.chkHasSubAdminOrg.isSelected() && this.cmbLevel.getSelectedItem() != null) {
                        this.level = (Integer)this.cmbLevel.getSelectedItem();
                        this.colDept = HRUtils.getSubDeptCollectionNew(this.infoDept, this.level, isShowSealUp);
                    } else {
                        this.colDept.add(this.infoDept);
                    }
                    break block9;
                }
                if (this.prmtAdminUnitOrg.getData() != null) {
                    this.colDept = new AdminOrgUnitCollection();
                    Object[] value = (Object[])this.prmtAdminUnitOrg.getData();
                    AdminOrgUnitInfo infoTmp = null;
                    if (value != null && value.length > 0) {
                        ArrayList<String> list = new ArrayList<String>();
                        for (int ii = 0; ii < value.length; ++ii) {
                            infoTmp = (AdminOrgUnitInfo)value[ii];
                            list.add(infoTmp.getId().toString());
                        }
                        String strAminIds = CompUtils.getStrFromList(list);
                        this.colDept = isShowSealUp ? AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection("where id in " + strAminIds) : AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection("where id in " + strAminIds + " and isSealUp != 1");
                    }
                    break block9;
                }
                return new AdminOrgUnitCollection();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.colDept;
    }

    public AdminOrgUnitInfo getDeptInfo() {
        return (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
    }

    public int getLevel() {
        Integer select = (Integer)this.cmbLevel.getSelectedItem();
        this.level = select != null ? (Integer)this.cmbLevel.getSelectedItem() : 0;
        return this.level;
    }

    public HashMap getAllSchemeItems() {
        HashMap allMap = new HashMap();
        CmpSchemeInfo[] info = null;
        info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
        if (info == null || info.length <= 0) {
            return allMap;
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(info[i].getId().toString());
        }
        ArrayList<String> privateItems = null;
        this.getAllSelectItem();
        if (this.lstSelectItemNotSortData != null && this.lstSelectItemNotSortData.size() > 0) {
            privateItems = new ArrayList<String>();
            int size2 = this.lstSelectItemNotSortData.size();
            for (int i = 0; i < size2; ++i) {
                privateItems.add(((CmpItemInfo)this.lstSelectItemNotSortData.get(i)).getNumber());
            }
            try {
                boolean notIncDelItem = this.chkIncDelItem.isSelected();
                allMap = CmpReportFacadeFactory.getRemoteInstance().getPrivateItemsByScheme(lstSchemeIds, privateItems, notIncDelItem);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.lstSelectItemData != null && this.lstSelectItemData.size() > 0) {
            allMap.put("publicItem", this.lstSelectItemData);
        }
        return allMap;
    }

    public List getCombinItem() {
        return this.lstSelectItemData;
    }

    public List getPrivateItem() {
        return this.lstSelectItemNotSortData;
    }

    private void setAdminPrmtState(boolean isSingleSelect) {
        this.prmtSingleAdminOrg.setEnabled(isSingleSelect);
        this.prmtSingleAdminOrg.setRequired(isSingleSelect);
        this.chkHasSubAdminOrg.setEnabled(isSingleSelect);
        this.chkHasSubAdminOrg.setSelected(false);
        this.cmbLevel.setEnabled(!isSingleSelect);
        this.prmtAdminUnitOrg.setEnabled(!isSingleSelect);
        this.prmtAdminUnitOrg.setRequired(!isSingleSelect);
        this.chkShowLongName.setSelected(false);
        this.chkShowAllDept.setSelected(false);
        if (isSingleSelect) {
            this.prmtAdminUnitOrg.setData(null);
        } else {
            this.prmtSingleAdminOrg.setData(null);
            this.chkHasSubAdminOrg.setSelected(false);
            this.cmbLevel.setEnabled(false);
        }
    }

    public boolean isZeroItemValueNull() {
        return this.chkZeroItemDisplayNull.isSelected();
    }

    public boolean isSelectSingleDept() {
        return this.btnSingleOrg.isSelected();
    }

    @Override
    public List getAllSelectItem() {
        return super.getAllSelectItem();
    }

    @Override
    protected void btnSingleOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.btnSingleOrg_actionPerformed(e);
    }

    @Override
    protected void btnMulOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.btnMulOrg_actionPerformed(e);
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgMultSelected = this.btnMulOrg.isSelected();
        if (this.radiobtn1.isSelected() && isRdOrgMultSelected) {
            this.radiobtn1.setSelected(false);
            this.radiobtn0.setSelected(true);
        }
        this.radiobtn1.setEnabled(!isRdOrgMultSelected);
    }

    @Override
    protected void chkIsShowDetail_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsShowDetail_itemStateChanged(e);
        if (this.chkIsShowDetail.isSelected()) {
            this.chkIsShowTimeDetail.setSelected(false);
        }
    }

    @Override
    protected void chkIsShowTimeDetail_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsShowTimeDetail_itemStateChanged(e);
        if (this.chkIsShowTimeDetail.isSelected()) {
            this.chkIsShowDetail.setSelected(false);
        }
    }

    @Override
    protected Map getF7ParamMap(CustomerParams cp) {
        Map paramMap = super.getF7ParamMap(cp);
        String value = cp.getCustomerParam("cmpBeginPeriod");
        if (!StringUtils.isEmpty((String)value)) {
            paramMap.put("cmpreport_period_start", value);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("cmpEndPeriod")))) {
            paramMap.put("cmpreport_period_end", value);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("adminOrgUnit")))) {
            paramMap.put("cmpreport_admin_single", value);
        }
        this.isLoaded = false;
        return paramMap;
    }

    @Override
    protected boolean isLoaded() {
        return this.isLoaded;
    }
}

