/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.CmpSystemConfigInfo;
import com.kingdee.eas.hr.compensation.CmpItemAccountCollection;
import com.kingdee.eas.hr.compensation.CmpItemAccountFactory;
import com.kingdee.eas.hr.compensation.CmpItemAccountInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.GrantTypeEnum;
import com.kingdee.eas.hr.compensation.ICmpItemAccount;
import com.kingdee.eas.hr.compensation.client.AbstractCmpItemAccountListUI;
import com.kingdee.eas.hr.compensation.client.CmpItemAccountEditUI;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class CmpItemAccountListUI
extends AbstractCmpItemAccountListUI {
    public static final String CMPITEMACCOUNTINFO = "CmpItemAccountInfo";
    private ICmpItemAccount iCmpItemAccount = null;
    private CmpItemAccountCollection col = null;
    private Hashtable hstChanged = new Hashtable();

    public CmpItemAccountListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return CmpItemAccountEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.iCmpItemAccount == null) {
            this.iCmpItemAccount = CmpItemAccountFactory.getRemoteInstance();
        }
        return this.iCmpItemAccount;
    }

    private void queryDataFillTable() throws Exception {
        int indexOldSelect = this.tblMain.getSelectManager().getActiveRowIndex();
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        this.col = ((ICmpItemAccount)this.getBizInterface()).getCompanyAndHRColl(comp, HRSchemeUtils.getClientHROrgUnitInfo());
        if (this.col == null || this.col.size() <= 0) {
            return;
        }
        CmpItemAccountInfo infoCmpItemAccount = null;
        CmpItemInfo infoCmpItem = null;
        AccountViewInfo infoAccountDebit = null;
        AccountViewInfo infoAccountCredit = null;
        AccountViewInfo infoCashDebit = null;
        AccountViewInfo infoCashCredit = null;
        this.tblMain.removeRows();
        IRow iRow = null;
        ICell iCell = null;
        int size = this.col.size();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.addRow();
            infoCmpItemAccount = this.col.get(i);
            iCell = iRow.getCell("id");
            iCell.setValue((Object)infoCmpItemAccount.getId());
            infoCmpItem = infoCmpItemAccount.getCmpItem();
            iCell = iRow.getCell("CmpItem");
            iCell.setValue((Object)infoCmpItem);
            infoAccountDebit = infoCmpItemAccount.getAccountDebit();
            if (infoAccountDebit != null) {
                iCell = iRow.getCell("AccountDebit");
                iCell.setValue((Object)infoAccountDebit);
            }
            if ((infoAccountCredit = infoCmpItemAccount.getAccountCredit()) != null) {
                iCell = iRow.getCell("AccountCredit");
                iCell.setValue((Object)infoAccountCredit);
            }
            if ((infoCashDebit = infoCmpItemAccount.getCashDebit()) != null) {
                iCell = iRow.getCell("CashDebit");
                iCell.setValue((Object)infoCashDebit);
            }
            if ((infoCashCredit = infoCmpItemAccount.getCashCredit()) == null) continue;
            iCell = iRow.getCell("CashCredit");
            iCell.setValue((Object)infoCashCredit);
        }
        if (indexOldSelect < 0) {
            indexOldSelect = 0;
        }
        if (this.tblMain.getRowCount() >= 0 && indexOldSelect >= 0) {
            this.tblMain.getSelectManager().select(indexOldSelect, 0);
        }
        this.tblMain.revalidate();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.enableExportExcel(this.tblMain);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(1);
        IColumn iColumn = this.tblMain.getColumn("CmpItem");
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setQueryInfo("com.kingdee.eas.hr.compensation.app.CmpItemQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1 ");
        evi.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.setSelectorCollection(sic);
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
        this.tblMain.getColumn("CashDebit").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("CashCredit").getStyleAttributes().setHided(true);
        this.queryDataFillTable();
        this.initListener();
        CmpSystemConfigInfo cmpSystemConfigInfo = HRUtils.getSysConfigInfo();
        if (cmpSystemConfigInfo.isGenLedgerIF()) {
            this.tblMain.getColumn("AccountDebit").getStyleAttributes().setLocked(false);
            this.tblMain.getColumn("AccountCredit").getStyleAttributes().setLocked(false);
        } else {
            this.tblMain.getColumn("AccountDebit").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("AccountCredit").getStyleAttributes().setLocked(true);
        }
        if (cmpSystemConfigInfo.isTellerManageIF()) {
            this.tblMain.getColumn("CashDebit").getStyleAttributes().setLocked(false);
            this.tblMain.getColumn("CashCredit").getStyleAttributes().setLocked(false);
        } else {
            this.tblMain.getColumn("CashDebit").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("CashCredit").getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.setButtonDefaultStyl(this.btnEdit);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSave);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.tblMain.setColumnMoveable(true);
        try {
            this.initCompanay();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initCompanay() throws Exception {
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtCompany.setDisplayFormat("$name$");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCurHRAdmin(), CompareType.INNER));
        entityViewInfo.setFilter(filterInfo);
        this.prmtCompany.setEntityViewInfo(entityViewInfo);
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (eventObj.getNewValue() == null) {
                        CmpItemAccountListUI.this.prmtCompany.setData(eventObj.getOldValue());
                    } else {
                        CmpItemAccountListUI.this.setAccountF7("AccountDebit");
                        CmpItemAccountListUI.this.setAccountF7("AccountCredit");
                        CmpItemAccountListUI.this.setAccountF7("CashDebit");
                        CmpItemAccountListUI.this.setAccountF7("CashCredit");
                        CmpItemAccountListUI.this.queryDataFillTable();
                    }
                }
                catch (Exception e) {
                    CmpItemAccountListUI.this.handUIException(e);
                }
            }
        });
        this.tblMain.checkParsed();
        GrantTypeEnum grantType = HRUtils.getGrantHRParamterValue(null);
        if (grantType == null || 0 == grantType.getValue()) {
            this.prmtCompany.setEnabled(false);
            this.prmtCompany.setData((Object)HRSchemeUtils.getHRToCompanyOrgUnitInfo(null, null));
        } else {
            this.prmtCompany.setEnabled(true);
            CompanyOrgUnitInfo comp = HRSchemeUtils.getHROfAdminToCompanyOrgUnitInfo(null);
            this.prmtCompany.setData((Object)comp);
        }
    }

    private String getCurHRAdmin() {
        String sqlAdmin = "SELECT r0.FFromUnitID  FROM T_ORG_UNITRELATION R0  INNER JOIN T_ORG_ADMIN A ON R0.FFROMUNITID = A.FID  INNER JOIN T_ORG_HRO H ON H.FID = R0.FTOUNITID  WHERE r0.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5'  AND  r0.FToUnitID in('" + HRSchemeUtils.getClientHROrgUnitInfo().getId().toString() + "')";
        return HRUtils.getCompSqlByAdmin(sqlAdmin);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.queryDataFillTable();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.saveData();
    }

    private void setAccountF7(String columnName) {
        IColumn iColumn = this.tblMain.getColumn(columnName);
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        AccountPromptBox accountPromptBox = new AccountPromptBox((IUIObject)this, comp, null, false, true);
        bizPromptBox.setSelector((KDPromptSelector)accountPromptBox);
        bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        bizPromptBox.setSelector((KDPromptSelector)accountPromptBox);
        bizPromptBox.setEditable(false);
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
    }

    protected void initListener() {
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){
            private int currentRow = -1;

            public void editValueChanged(KDTEditEvent e) {
                IRow iRow = CmpItemAccountListUI.this.tblMain.getRow(this.currentRow);
                if (iRow == null) {
                    return;
                }
                Integer temp = this.currentRow;
                CmpItemAccountListUI.this.hstChanged.put(temp, temp);
                HRDynamicTableUtils.setEditedCellColor(e);
            }

            public void editStopping(KDTEditEvent e) {
                this.currentRow = CmpItemAccountListUI.this.tblMain.getEditManager().getEditRowIndex();
                if (e.getOldValue() != e.getValue()) {
                    this.editValueChanged(e);
                }
            }
        });
    }

    public void saveData() throws Exception {
        if (this.hstChanged.isEmpty() || this.prmtCompany.getData() == null) {
            return;
        }
        IRow iRow = null;
        String compId = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString();
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)compId));
        CmpItemAccountCollection col = new CmpItemAccountCollection();
        Integer count = null;
        CmpItemAccountInfo info = null;
        Object id = null;
        Object infoAccountDebit = null;
        Object infoAccountCredit = null;
        Object infoCashDebit = null;
        Object infoCashCredit = null;
        Enumeration enum1 = this.hstChanged.keys();
        while (enum1.hasMoreElements()) {
            count = (Integer)enum1.nextElement();
            iRow = this.tblMain.getRow(count.intValue());
            info = new CmpItemAccountInfo();
            info.setCompany(companyOrgUnitInfo);
            id = iRow.getCell("id").getValue();
            if (id != null) {
                info.setId(BOSUuid.read((String)id.toString()));
            }
            info.setCmpItem((CmpItemInfo)iRow.getCell("CmpItem").getValue());
            infoAccountDebit = iRow.getCell("AccountDebit").getValue();
            if (infoAccountDebit != null) {
                info.setAccountDebit((AccountViewInfo)infoAccountDebit);
            } else {
                info.setAccountDebit(null);
            }
            infoAccountCredit = iRow.getCell("AccountCredit").getValue();
            if (infoAccountCredit != null) {
                info.setAccountCredit((AccountViewInfo)infoAccountCredit);
            } else {
                info.setAccountCredit(null);
            }
            infoCashDebit = iRow.getCell("CashDebit").getValue();
            if (infoCashDebit != null) {
                info.setCashDebit((AccountViewInfo)infoCashDebit);
            } else {
                info.setCashDebit(null);
            }
            infoCashCredit = iRow.getCell("CashCredit").getValue();
            if (infoCashCredit != null) {
                info.setCashCredit((AccountViewInfo)infoCashCredit);
            } else {
                info.setCashCredit(null);
            }
            col.add(info);
        }
        ICmpItemAccount iCmpItemAccount = CmpItemAccountFactory.getRemoteInstance();
        iCmpItemAccount.updateData(col);
        String res = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"Msg_Save_OK");
        this.setMessageText(res);
        this.showMessage();
        this.hstChanged.clear();
        this.queryDataFillTable();
    }

    protected boolean checkBeforeWindowClosing() {
        if (!this.hstChanged.isEmpty() && MsgBox.isYes((int)MsgBox.showConfirm3((Component)((CoreUI)null), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check")))) {
            try {
                this.saveData();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
            }
        }
        return true;
    }
}

