/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CommonPermissionFacadeFactory;
import com.kingdee.eas.hr.compensation.CompenException;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractCmpItemListUI;
import com.kingdee.eas.hr.compensation.client.CmpItemAssignItemUI;
import com.kingdee.eas.hr.compensation.client.CmpItemCatEditUI;
import com.kingdee.eas.hr.compensation.client.CmpItemEditUI;
import com.kingdee.eas.hr.compensation.client.CmpItemSortUI;
import com.kingdee.eas.hr.compensation.client.CmpItemUpdateDataUI;
import com.kingdee.eas.hr.compensation.client.FixedSchemeListUI;
import com.kingdee.eas.hr.compensation.client.HRDynQueryEditUI;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CmpItemListUI
extends AbstractCmpItemListUI {
    private static Logger logger = Logger.getLogger(CmpItemListUI.class);
    private String resClass = "com.kingdee.eas.hr.compensation.client.CmpItemResource.";
    private HROrgUnitInfo infoHR = null;
    private Map perItemMap = null;
    private EntityViewInfo entityViewInfo = null;
    private boolean isPerMappingHidden = false;
    private boolean isGroupControlHidden = false;
    private static final String PERMAPPING = "perMapping";
    private static final String ISGROUPCONTROL = "isGroupControl";
    private static final String AND = "and";
    private static final String ENABLE = "enable";
    private static final String SUBJECT = "subject";
    private static final String NUMBER = "number";
    private static final String PRECISIONTYPE = "precisionType";
    private static final String ID = "id";
    private Map itemMap = null;
    private List selectIDs = null;

    public CmpItemListUI() throws Exception {
        HRSchemeUtils.checkInit();
        this.infoHR = HRSchemeUtils.getClientHROrgUnitInfo();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getGroupEditUIName() {
        return CmpItemCatEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "cmpItemCatalog.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return CmpItemCatalogFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return CmpItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CmpItemFactory.getRemoteInstance();
    }

    protected String getRootName() {
        return EASResource.getString((String)(this.resClass + "CMPITEMCATA"));
    }

    @Override
    public void actionInputItem_actionPerformed(ActionEvent e) throws Exception {
        ICmpItem iCmpItem = (ICmpItem)this.getBizInterface();
        iCmpItem.syncPrintData();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpItemResource.SYNCDATA_SUCCESS"));
        this.showMessage();
    }

    @Override
    public void actionSortItem_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode == null) {
            throw new CmpItemException(CmpItemException.CMPITEMCATA_NOTSELECT);
        }
        if (treeNode != null && treeNode.getUserObject() != null) {
            if (treeNode.getUserObject() instanceof CmpItemCatalogInfo) {
                CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)treeNode.getUserObject();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)ID);
                uiContext.put((Object)"catalog", (Object)infoCmpItemCatalog);
                uiContext.put((Object)"Owner", (Object)this);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CmpItemSortUI.class.getName(), (Map)uiContext);
                uiWindow.show();
                this.refresh(e);
            } else {
                throw new CmpItemException(CmpItemException.CMPITEMCATA_ROOTNOTSELECT);
            }
        }
    }

    private void initTreeSelected() {
        DefaultKingdeeTreeNode nodeRoot = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        DefaultKingdeeTreeNode nodePerson = (DefaultKingdeeTreeNode)nodeRoot.getFirstChild();
        if (nodePerson != null) {
            this.treeMain.setSelectionNode(nodePerson);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.enableExportExcel(this.tblMain);
        this.actionGroupAddNew.setEnabled(false);
        this.actionGroupEdit.setEnabled(false);
        this.actionGroupRemove.setEnabled(false);
        this.actionGroupMoveTree.setEnabled(false);
        this.btnSyncData.setVisible(false);
        this.btnSyncData1.setVisible(false);
        this.menuItemGroupMoveTree.setVisible(false);
        if (this.infoHR.isIsBizUnit()) {
            this.btnAssign.setVisible(false);
            this.menuItemAssign.setVisible(false);
        } else {
            this.btnAssign.setVisible(true);
            this.menuItemAssign.setVisible(true);
        }
        if (this.infoHR.getId().toString().equalsIgnoreCase("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            this.tblMain.getColumn(ISGROUPCONTROL).getStyleAttributes().setHided(true);
        } else if (!this.isGroupControlHidden) {
            this.tblMain.getColumn(ISGROUPCONTROL).getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn(ISGROUPCONTROL).getStyleAttributes().setHided(true);
        }
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        this.generateTemplates.setVisible(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int index;
        if (this.tblMain.getRowCount() > 0 && (index = this.tblMain.getSelectManager().getActiveRowIndex()) >= 0) {
            IRow iRow = this.tblMain.getRow(index);
            ICell iCell = iRow.getCell(SUBJECT);
            BizEnumValueInfo infoEnum = (BizEnumValueInfo)iCell.getValue();
            if (infoEnum.getInt() == 10) {
                throw new CmpItemException(CmpItemException.CMPITEM_INIT_NOT_DELETE);
            }
            super.actionRemove_actionPerformed(e);
        }
    }

    protected boolean initDefaultFilter() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        if (!this.chkDisplayAll.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo(ENABLE, (Object)3, CompareType.NOTEQUALS));
            try {
                filter.mergeFilter(this.mainQuery.getFilter(), AND);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.mainQuery.setFilter(filter);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        this.mainQuery.getSorter().add(sorterOrderItem);
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo(ENABLE);
        sorterOrderItem1.setSortType(SortType.DESCEND);
        this.mainQuery.getSorter().add(sorterOrderItem1);
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInputItem.setIcon(EASResource.getIcon((String)"imgTbtn_autoarrange"));
        this.btnSortItem.setIcon(EASResource.getIcon((String)"imgTbtn_sortorder"));
        this.btnGroupMoveTree.setVisible(false);
        this.btnLocate.setVisible(true);
        this.btnQuery.setVisible(true);
        this.treeView.getControlPane().setVisible(false);
        this.treeView.getControlPane().remove((Component)this.btnGroupMoveTree);
        this.menuItemGroupAddNew.setVisible(false);
        this.menuItemGroupEdit.setVisible(false);
        this.menuItemGroupRemove.setVisible(false);
        this.menuItemGroupMoveTree.setVisible(false);
        this.menuItemMoveTree.setVisible(false);
        this.menuItemGroupView.setVisible(false);
        this.tblMain.setColumnMoveable(true);
        this.btnSyncData1.setIcon(EASResource.getIcon((String)"imgTbtn_autoarrange"));
        this.btnSyncData.setVisible(false);
        this.btnSyncData1.setVisible(false);
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_usercollocatemanage"));
        this.menuItemSyncDataPrint.setIcon(EASResource.getIcon((String)"imgTbtn_autoarrange"));
        this.menuItemSort.setIcon(EASResource.getIcon((String)"imgTbtn_sortorder"));
        this.menuItemAssign.setIcon(EASResource.getIcon((String)"imgTbtn_usercollocatemanage"));
        this.btnItemMapping.setIcon(EASResource.getIcon((String)"imgTbtn_uniterangemaintenance"));
        this.menuItemUpdateData.setIcon(EASResource.getIcon((String)"imgTbtn_reload"));
        this.btnCancel.setText(this.btnCancel.getToolTipText());
        this.btnCancel.setTextIconDisStyle((short)3);
        this.btnCancel.setIsControlByParent(true);
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            if (treeNode.getLevel() >= 1) {
                throw new CmpItemException(CmpItemException.CMPITEMCATA_OVER_LEVEL);
            }
            super.actionGroupAddNew_actionPerformed(e);
        }
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            if (treeNode.getUserObject() instanceof CmpItemCatalogInfo) {
                CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)treeNode.getUserObject();
                String number = infoCmpItemCatalog.getNumber();
                if (HRCmpItemUtils.isInitCmpItemCatalog(number)) {
                    throw new CmpItemException(CmpItemException.CMPITEMCATA_INIT_NOT_EDIT);
                }
                super.actionGroupEdit_actionPerformed(e);
            } else {
                throw new CmpItemException(CmpItemException.CMPITEMCATA_INIT_NOT_EDIT);
            }
        }
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            if (treeNode.getUserObject() instanceof CmpItemCatalogInfo) {
                CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)treeNode.getUserObject();
                String number = infoCmpItemCatalog.getNumber();
                if (HRCmpItemUtils.isInitCmpItemCatalog(number)) {
                    throw new CmpItemException(CmpItemException.CMPITEMCATA_INIT_NOT_DELETE);
                }
                super.actionGroupRemove_actionPerformed(e);
            } else {
                throw new CmpItemException(CmpItemException.CMPITEMCATA_INIT_NOT_DELETE);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    int indexRow = e.getSelectBlock().getTop();
                    CmpItemListUI.this.doButtonState(indexRow);
                }
                catch (Exception exc) {
                    CmpItemListUI.this.handUIException(exc);
                }
            }
        });
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.doButtonState(0);
        }
    }

    private void doButtonState(int indexRow) {
        if (indexRow < 0) {
            return;
        }
        BizEnumValueInfo subject = (BizEnumValueInfo)this.tblMain.getRow(indexRow).getCell(SUBJECT).getValue();
        if (subject.getInt() == 10) {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        }
        subject = (BizEnumValueInfo)this.tblMain.getRow(indexRow).getCell(ENABLE).getValue();
        if (subject.getInt() == 1) {
            this.btnCancel.setEnabled(true);
        } else {
            this.btnCancel.setEnabled(false);
        }
        this.itemMap = null;
    }

    protected void buildTreeFilter() {
        super.buildTreeFilter();
        this.mainQuery.getSorter().clear();
        this.mainQuery.getSorter().add(new SorterItemInfo("defaultOrder"));
        try {
            if (this.entityViewInfo != null) {
                this.mainQuery.getFilter().mergeFilter(this.entityViewInfo.getFilter(), AND);
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        ObjectUuidPK pk = null;
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof CmpItemCatalogInfo) {
            CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)treeNode.getUserObject();
            pk = new ObjectUuidPK(infoCmpItemCatalog.getId());
        }
        return pk;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            if (treeNode.getLevel() > 0) {
                super.actionAddNew_actionPerformed(e);
            } else {
                throw new CmpItemException(CmpItemException.CMPITEMCATA_NOT_ADDCMPITEM);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        return filter;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("creator.id", null));
        return filter;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.dealPercisionTypeCell();
        this.entityViewInfo = (EntityViewInfo)this.mainQuery.clone();
        if (this.getPreference() != null) {
            ColumnItemData colData = (ColumnItemData)this.getPreference().getTableCurrentSetting().getColumnData().get(PERMAPPING);
            this.isPerMappingHidden = colData.isHidden();
            colData = (ColumnItemData)this.getPreference().getTableCurrentSetting().getColumnData().get(ISGROUPCONTROL);
            this.isGroupControlHidden = colData.isHidden();
        }
        this.treeMain_valueChanged(null);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setShowSorter(false);
        return dialog;
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssign_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"HRORGUNIT", (Object)this.infoHR);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CmpItemAssignItemUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionItemMapping_actionPerformed(ActionEvent e) throws Exception {
        super.actionItemMapping_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"parentUIName", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"queryFullName", (Object)"com.kingdee.eas.hr.compensation.app.PersonInfoQuery");
        String hroId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        String dynQueryId = this.getDynQueryId();
        uiContext.put((Object)"DYNQUERY_HRO", (Object)hroId);
        if (dynQueryId != null) {
            uiContext.put((Object)"ID", (Object)dynQueryId);
        } else {
            uiContext.put((Object)"DYNQUERY_TYPE", (Object)1);
        }
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = null;
        curDialog = dynQueryId == null ? uiFactory.create(HRDynQueryEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW) : uiFactory.create(HRDynQueryEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        curDialog.show();
        this.perItemMap = HRCmpItemUtils.getPerItemMap(null, 1);
    }

    @Override
    protected void chkDisplayAll_itemStateChanged(ItemEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkNotDisableItem();
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    protected void cancel() throws Exception {
        if (this.selectIDs.size() <= 0) {
            return;
        }
        ((ICmpItem)this.getBizInterface()).disableItem(this.selectIDs, StateEnum.DISABLE);
        this.selectIDs.clear();
    }

    private boolean checkNotDisableItem() {
        this.initItemMap();
        ArrayList ids = this.getSelectedIdValues();
        this.selectIDs = new ArrayList();
        CmpItemInfo cmpItem = null;
        for (int i = 0; i < ids.size(); ++i) {
            cmpItem = (CmpItemInfo)this.itemMap.get(ids.get(i).toString());
            if (cmpItem.getEnable() != null && 3 == cmpItem.getEnable().getValue()) continue;
            String errorMsg = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.client.CmpItemResource", (String)"19_F7TITLE_NOT_DISABLE", (String[])new String[]{cmpItem.getName()});
            if (cmpItem.getNumber().startsWith("FPER") && 10 == cmpItem.getSubject().getValue()) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SYS_PER_CANCEL")));
                SysUtil.abort();
            }
            if (cmpItem.getNumber().equals("FSAL004") || cmpItem.getNumber().equals("FSAL005") || cmpItem.getNumber().equals("FSAL006") || cmpItem.getNumber().equals("FSAL006") || cmpItem.getNumber().equals("FSAL014") || cmpItem.getNumber().equals("FSAL027") || cmpItem.getNumber().equals("FSAL029") || cmpItem.getNumber().equals("FSAL000") || cmpItem.getNumber().equals("FSAL013") || cmpItem.getNumber().equals("FOTH001") || cmpItem.getNumber().equals("FSAL015") || cmpItem.getNumber().equals("FSAL012") || cmpItem.getNumber().equals("FSAL041")) {
                MsgBox.showInfo((String)(errorMsg + EASResource.getString((String)(this.resClass + "SPECIAL_ITEM"))));
                SysUtil.abort();
            }
            this.selectIDs.add(ids.get(i));
        }
        return true;
    }

    private void initItemMap() {
        if (this.itemMap != null) {
            return;
        }
        this.itemMap = new HashMap();
        IRow iRow = null;
        String id = null;
        CmpItemInfo cmpItem = null;
        ItemSubjectEnum subjectEnum = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            cmpItem = new CmpItemInfo();
            iRow = this.tblMain.getRow(i);
            id = (String)iRow.getCell(ID).getValue();
            cmpItem.setId(BOSUuid.read((String)id));
            cmpItem.setName((String)iRow.getCell("name").getValue());
            cmpItem.setNumber((String)iRow.getCell(NUMBER).getValue());
            subjectEnum = ItemSubjectEnum.getEnum(((BizEnumValueDTO)iRow.getCell(SUBJECT).getValue()).getInt());
            cmpItem.setSubject(subjectEnum);
            cmpItem.setEnable(StateEnum.getEnum(((BizEnumValueDTO)iRow.getCell(ENABLE).getValue()).getInt()));
            this.itemMap.put(id, cmpItem);
        }
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        EntityViewInfo viewInfo = null;
        viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!this.chkDisplayAll.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo(ENABLE, (Object)3, CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    protected void checkQueryPK() {
        super.checkQueryPK();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    private String getDynQueryId() throws Exception {
        String hroId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        ISQLExecutor iSQLExec = SQLExecutorFactory.getRemoteInstance((String)("SELECT FDynSolutionID FROM T_HR_CmpitemDynquery WHERE FType = 1 AND FHROrgUnitID='" + hroId + "'"));
        String dynQueryId = null;
        IRowSet rows = iSQLExec.executeSQL();
        while (rows.next()) {
            dynQueryId = rows.getString(1);
        }
        return dynQueryId;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        this.dealPercisionTypeCell();
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            if (this.getSelectedTreeNode().getUserObject() instanceof CmpItemCatalogInfo) {
                CmpItemCatalogInfo itemCat = (CmpItemCatalogInfo)this.getSelectedTreeNode().getUserObject();
                if (!itemCat.getNumber().equals("FPER")) {
                    this.tblMain.getColumn(PERMAPPING).getStyleAttributes().setHided(true);
                } else if (!this.isPerMappingHidden) {
                    this.tblMain.getColumn(PERMAPPING).getStyleAttributes().setHided(false);
                    this.initTablePerMapping();
                } else {
                    this.tblMain.getColumn(PERMAPPING).getStyleAttributes().setHided(true);
                }
            }
        } else if (!this.isPerMappingHidden) {
            this.tblMain.getColumn(PERMAPPING).getStyleAttributes().setHided(false);
            this.initTablePerMapping();
        } else {
            this.tblMain.getColumn(PERMAPPING).getStyleAttributes().setHided(true);
        }
    }

    private void dealPercisionTypeCell() {
        Object obj = null;
        IRow iRow = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            obj = iRow.getCell(PRECISIONTYPE).getValue();
            if (obj == null || !(obj instanceof Integer)) continue;
            iRow.getCell(PRECISIONTYPE).setValue((Object)CmpItemPrecisionTypeEnum.getEnum((Integer)obj));
        }
    }

    private void initTablePerMapping() throws Exception {
        this.getPerItemMap();
        IRow iRow = null;
        String number = null;
        if (this.perItemMap == null || this.perItemMap.size() == 0) {
            return;
        }
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            number = iRow.getCell(NUMBER).getValue().toString();
            iRow.getCell(PERMAPPING).setValue(this.perItemMap.get(number));
        }
    }

    private Map getPerItemMap() throws Exception {
        if (this.perItemMap != null) {
            return this.perItemMap;
        }
        this.perItemMap = HRCmpItemUtils.getPerItemMap(null, 1);
        return this.perItemMap;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        if (!this.tblMain.getColumn(PERMAPPING).getStyleAttributes().isHided()) {
            this.initTablePerMapping();
        }
        this.dealPercisionTypeCell();
    }

    protected void execQuery() {
        super.execQuery();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CmpItemListUI.this.initTablePerMapping();
                    CmpItemListUI.this.dealPercisionTypeCell();
                }
                catch (Exception e) {
                    CmpItemListUI.this.handleException(e);
                }
            }
        });
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.refresh(null);
    }

    @Override
    public void actionUpdateData_actionPerformed(ActionEvent e) throws Exception {
        try {
            UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CmpItemUpdateDataUI.class.getName(), (Map)new UIContext((Object)this), null, OprtState.VIEW).show();
            this.actionRefresh_actionPerformed(null);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkMaintainDataPermission();
        super.actionEdit_actionPerformed(e);
    }

    private void checkMaintainDataPermission() throws Exception {
        String id = this.getSelectedKeyValue();
        HROrgUnitInfo hro = SysContext.getSysContext().getCurrentHRUnit();
        if (!StringUtils.isEmpty((String)id) && hro != null) {
            HashSet<String> hroSet = new HashSet<String>();
            hroSet.add(hro.getId().toString());
            EntityViewInfo view = CommonPermissionFacadeFactory.getRemoteInstance().getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpItem_maintain");
            CmpItemCollection coll = CmpItemFactory.getRemoteInstance().getCmpItemCollection(view);
            boolean flag = false;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (!coll.get(i).getId().toString().equals(id)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                Object[] param = new String[]{hro.getName(), ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.ServerResource", (String)"cmpItem_maintain", (Locale)SysContext.getSysContext().getLocale())};
                throw new CompenException(CompenException.DATAPERMISSION_EXCEPTION, param);
            }
        }
    }

    @Override
    public void actionGeneraTemplater_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FixedSchemeListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }
}

