/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpCalFacadeFactory;
import com.kingdee.eas.hr.compensation.FormulaFacadeFactory;
import com.kingdee.eas.hr.compensation.IFormulaFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCmpSchemeItemFormulasUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CmpSchemeItemFormulasUI
extends AbstractCmpSchemeItemFormulasUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpSchemeItemFormulasUI.class);
    private KDTSortManager sm = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getUIMenuBar().setVisible(false);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("seq").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("formula").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn("formula").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblMain.setDefaultRowHeight(100);
        this.loadAllFormulaData();
    }

    private KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.tblMain);
        }
        return this.sm;
    }

    private void loadAllFormulaData() throws BOSException, EASBizException, SQLException {
        Object cmpSchemeID = this.getUIContext().get("schemeId");
        if (cmpSchemeID == null) {
            return;
        }
        this.txtSchemeName.setText(this.getUIContext().get("schemeName").toString());
        this.tblMain.removeRows();
        HashMap hsItemOrder = CmpCalFacadeFactory.getRemoteInstance().getCalculateItemOrder(cmpSchemeID.toString());
        int maxLevel = 0;
        Iterator it = hsItemOrder.keySet().iterator();
        while (it.hasNext()) {
            int iLevel = (Integer)hsItemOrder.get(it.next().toString());
            if (iLevel <= maxLevel) continue;
            maxLevel = iLevel;
        }
        IFormulaFacade iFml = FormulaFacadeFactory.getRemoteInstance();
        IRowSet rs = iFml.getAllFormulasByScheme(cmpSchemeID.toString());
        int iSeq = 0;
        for (int i = maxLevel; i >= 0; --i) {
            it = hsItemOrder.keySet().iterator();
            while (it.hasNext()) {
                String strItemNum = it.next().toString();
                int iLevel = (Integer)hsItemOrder.get(strItemNum);
                if (iLevel != i) continue;
                rs.beforeFirst();
                while (rs.next()) {
                    if (!strItemNum.toUpperCase().equals(rs.getString("cmpItem.number").toUpperCase())) continue;
                    IRow row = this.tblMain.addRow();
                    row.getCell("seq").setValue((Object)String.valueOf(iSeq + 1));
                    row.getCell("itemName").setValue((Object)rs.getString("cmpItem.name"));
                    row.getCell("formulaNum").setValue((Object)rs.getString("cmpFormula.number"));
                    row.getCell("formulaName").setValue((Object)rs.getString("cmpFormula.name"));
                    row.getCell("formula").setValue((Object)rs.getString("cmpFormula.formulaDesc"));
                    ++iSeq;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        int iRowCount = this.tblMain.getRowCount();
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        Object[] objs = new Object[]{iRowCount};
        msg = MessageFormat.format(msg, objs);
        this.setMessageBarText(msg);
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.tblMain, 0, this.tblMain.getRowCount() - 1, this.getKDSortManger());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.loadAllFormulaData();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }
}

