/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.FormulaCmpItemData;
import com.kingdee.eas.hr.compensation.FormulaFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.IFormulaFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCmpStructReportItemPanel;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpStructReportItemPanel
extends AbstractCmpStructReportItemPanel {
    private static final Logger logger = CoreUIObject.getLogger(CmpStructReportItemPanel.class);
    private Map mapItemValue = new HashMap();
    String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";
    private List lstAllItemData = null;
    private List lstSelectItemData = null;
    private CmpItemInfo infoAnalysisCmpItem = null;
    List lst = new ArrayList();
    private final String AdminOrgUnit_CP = "AdminOrgUnit_CP";
    private final String OrgWeidu_CP = "OrgWeidu_CP";
    private final String OtherWeidu_CP = "OtherWeidu_CP";
    private final String LstSelectItem_CP = "lstSelectItem";
    private final HROrgUnitInfo curHROrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();

    public CmpStructReportItemPanel() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        int i;
        this.initOrgControl();
        this.initControlState();
        this.lst = HRReportUtils.getAnalysisItem();
        this.cmbItem.removeAllItems();
        this.cmbItem.addItems(this.lst.toArray());
        if (this.infoAnalysisCmpItem != null) {
            int size = this.lst.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (!((CmpItemInfo)this.lst.get(i2)).getNumber().equals(this.infoAnalysisCmpItem.getNumber())) continue;
                this.cmbItem.setSelectedIndex(i2);
                break;
            }
        }
        ArrayList<String> lstCmpItemNumber = new ArrayList<String>();
        int size = this.lst.size();
        for (i = 0; i < size; ++i) {
            lstCmpItemNumber.add(((CmpItemInfo)this.lst.get(i)).getNumber());
        }
        this.mapItemValue = this.getCmpItemData(lstCmpItemNumber);
        if (this.lstAllItemData != null && this.lstSelectItemData != null) {
            this.lstAllItem.removeAllElements();
            this.lstSelectItem.removeAllElements();
            size = this.lstAllItemData.size();
            for (i = 0; i < size; ++i) {
                this.lstAllItem.addElement(this.lstAllItemData.get(i));
            }
            size = this.lstSelectItemData.size();
            for (i = 0; i < size; ++i) {
                this.lstSelectItem.addElement(this.lstSelectItemData.get(i));
            }
        } else {
            this.reloadItemValue((CmpItemInfo)this.cmbItem.getSelectedItem());
        }
        this.lstAllItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        CmpStructReportItemPanel.this.actionRight_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    CmpStructReportItemPanel.this.handUIException(exc);
                }
            }
        });
        this.lstSelectItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        CmpStructReportItemPanel.this.actionLeft_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    CmpStructReportItemPanel.this.handUIException(exc);
                }
            }
        });
        this.cmbItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    CmpItemInfo info = (CmpItemInfo)CmpStructReportItemPanel.this.cmbItem.getSelectedItem();
                    try {
                        CmpStructReportItemPanel.this.reloadItemValue(info);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
                    }
                }
            }
        });
    }

    private void initOrgControl() {
        CompUtils.initF7SelectorNoHR(this, this.prmtAdminOrgUnit);
        this.prmtAdminOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CmpStructReportItemPanel.this.initOrgListener();
            }
        });
    }

    private void initOrgListener() {
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        if (this.prmtAdminOrgUnit.getData() == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        AdminOrgUnitInfo org = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)org.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)"0"));
        SorterItemInfo sortLongNumber = new SorterItemInfo("longNumber");
        evi.setFilter(filterInfo);
        evi.getSorter().add(sortLongNumber);
        try {
            AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(evi);
            int j = adminOrgUnitCollection.size();
            for (int i = 0; i < j; ++i) {
                AdminOrgUnitInfo adminOrgUnit = adminOrgUnitCollection.get(i);
                this.lstAllItem.addElement((Object)adminOrgUnit);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    private void setHrOrgFilter(FilterInfo filterInfo) throws EASBizException, BOSException {
        AdminOrgUnitCollection adminColl = HROrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(this.curHROrgUnitInfo.getId().toString());
        HashSet<String> rangeOrgSet = new HashSet<String>();
        int j = adminColl.size();
        for (int i = 0; i < j; ++i) {
            rangeOrgSet.add(adminColl.get(i).getId().toString());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", rangeOrgSet, CompareType.INCLUDE));
    }

    private void initControlState() {
        this.prmtAdminOrgUnit.setData(null);
        this.prmtAdminOrgUnit.setEnabled(false);
        this.btnOtherWeidu.setSelected(true);
        this.cmbItem.setEnabled(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstSelectItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElement(info);
            this.lstAllItem.addElement(info);
            this.lstAllItem.setSelectedValue(info, true);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
        }
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            Object info = null;
            for (int i = 0; i < count; ++i) {
                info = this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement(info);
                this.lstSelectItem.removeElement(info);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            Object info = null;
            for (int i = 0; i < count; ++i) {
                info = this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement(info);
                this.lstAllItem.removeElement(info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstAllItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            Object info = this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement(info, indexSelect);
            this.lstAllItem.removeElement(info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue(info, true);
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    public List getSelectedCmpItem() throws Exception {
        return this.lstSelectItemData;
    }

    protected void initListener() {
    }

    private void reloadItemValue(CmpItemInfo info) throws Exception {
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        if (info == null) {
            return;
        }
        FormulaCmpItemData data = (FormulaCmpItemData)this.mapItemValue.get(info.getNumber());
        if (data != null && data.getCmpItemInstList() != null && data.getCmpItemInstList().length > 0) {
            IHRObject[] obj = data.getCmpItemInstList();
            int size = obj.length;
            for (int i = 0; i < size; ++i) {
                this.lstAllItem.addElement((Object)obj[i]);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    private Map getCmpItemData(List cmpItemList) throws Exception {
        IFormulaFacade formula = FormulaFacadeFactory.getRemoteInstance();
        Map rst = formula.getAllCmpItemInstanceList(cmpItemList);
        return rst;
    }

    public void onLoad() throws Exception {
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        super.onLoad();
    }

    public List getItemValue() {
        return this.lstSelectItemData;
    }

    public CmpItemInfo getAnalyseCmpItem() {
        if (this.btnOrgWeidu.isSelected()) {
            try {
                this.infoAnalysisCmpItem = this.getAnalysisItem();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.infoAnalysisCmpItem = (CmpItemInfo)this.cmbItem.getSelectedItem();
        }
        return this.infoAnalysisCmpItem;
    }

    private CmpItemInfo getAnalysisItem() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FPER004"));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        CmpItemCollection colItem = iCmpItem.getCmpItemCollection(evi);
        CmpItemInfo cii = null;
        if (colItem != null && colItem.size() > 0) {
            cii = colItem.get(0);
        }
        return cii;
    }

    public boolean verify() {
        int i;
        if (this.lstSelectItem.getElementCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MESSAGE_ANANLYNOTNULL")));
            return false;
        }
        this.infoAnalysisCmpItem = (CmpItemInfo)this.cmbItem.getSelectedItem();
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        this.lstAllItemData = new ArrayList();
        size = this.lstAllItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstAllItemData.add(this.lstAllItem.getElement(i));
        }
        return super.verify();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean(this.OrgWeidu_CP, this.btnOrgWeidu.isSelected());
        cp.putBoolean(this.OtherWeidu_CP, this.btnOtherWeidu.isSelected());
        if (this.btnOrgWeidu.isSelected()) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
            if (adminOrgUnitInfo != null) {
                cp.addCustomerParam(this.AdminOrgUnit_CP, adminOrgUnitInfo.getId().toString());
            }
            cp.addCustomerParam(this.LstSelectItem_CP, this.getSelectedItemIDS(this.lstSelectItemData));
        } else {
            if (this.cmbItem.getSelectedItem() != null) {
                cp.addCustomerParam("cmbAnalysisCmpItem", ((CmpItemInfo)this.cmbItem.getSelectedItem()).getId().toString());
            }
            cp.addCustomerParam("lstSelectItem", HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemData));
        }
        return cp;
    }

    private String getSelectedItemIDS(List lstSelectItemData) {
        StringBuffer ids = new StringBuffer("");
        if (lstSelectItemData.size() < 1) {
            return ids.toString();
        }
        int size = lstSelectItemData.size();
        for (int i = 0; i < size; ++i) {
            if (lstSelectItemData.get(i) instanceof AdminOrgUnitInfo) {
                ids.append(((AdminOrgUnitInfo)lstSelectItemData.get(i)).getId().toString());
            }
            ids.append("~");
        }
        if (ids.length() > 1) {
            ids.deleteCharAt(ids.length() - 1);
        }
        return ids.toString();
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        boolean orgWeidu = cp.getBoolean(this.OrgWeidu_CP);
        if (orgWeidu) {
            this.setOrgWeidu(cp);
            this.btnOrgWeidu.setSelected(true);
        } else {
            this.setOtherWeidu(cp);
            this.btnOtherWeidu.setSelected(true);
        }
    }

    private void setOrgWeidu(CustomerParams cp) {
        String orgId = cp.getCustomerParam(this.AdminOrgUnit_CP);
        if (orgId != null) {
            try {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                this.prmtAdminOrgUnit.setData((Object)adminOrgUnitInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        String strOrgIdSet = cp.getCustomerParam(this.LstSelectItem_CP);
        this.lstSelectItemData = this.getSelectedItemListOrg(strOrgIdSet);
        try {
            this.fillSelectItemListOrg(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtAdminOrgUnit.setEnabled(true);
        this.cmbItem.setEnabled(false);
    }

    private void setOtherWeidu(CustomerParams cp) {
        Object pk = null;
        if (cp.getCustomerParam("cmbAnalysisCmpItem") != null && this.cmbItem.getItemCount() > 0) {
            String id = cp.getCustomerParam("cmbAnalysisCmpItem");
            CmpItemInfo temp = null;
            try {
                int size = this.cmbItem.getItemCount();
                for (int i = 0; i < size; ++i) {
                    temp = (CmpItemInfo)this.cmbItem.getItemAt(i);
                    if (!temp.getId().toString().equals(id)) continue;
                    this.cmbItem.setSelectedItem((Object)temp);
                    this.reloadItemValue(temp);
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (cp.getCustomerParam("lstSelectItem") != null) {
            String ids = cp.getCustomerParam("lstSelectItem");
            try {
                this.lstSelectItemData = CmpStructReportItemPanel.getSelectedItemList(ids);
                this.fillSelectItemList(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.prmtAdminOrgUnit.setEnabled(false);
        this.prmtAdminOrgUnit.setData(null);
        this.cmbItem.setEnabled(true);
    }

    private List getSelectedItemListOrg(String ids) {
        ArrayList<AdminOrgUnitInfo> lstItem = new ArrayList<AdminOrgUnitInfo>();
        if (ids.length() < 1) {
            return lstItem;
        }
        String[] items = ids.split("~");
        AdminOrgUnitInfo org = null;
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            org = new AdminOrgUnitInfo();
            org.setId(BOSUuid.read((String)items[i]));
            lstItem.add(org);
        }
        return lstItem;
    }

    private void fillSelectItemListOrg(List lst, KDList lstSelectItem, KDList lstAllItem) throws Exception {
        int i;
        if (lst == null || lst.size() <= 0) {
            return;
        }
        AdminOrgUnitInfo infoTempSelect = null;
        AdminOrgUnitInfo infoTempAll = null;
        this.lstSelectItemData = new ArrayList();
        this.lstAllItemData = new ArrayList();
        int size = this.lstAllItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstAllItemData.add(lstAllItem.getElement(i));
        }
        size = lst.size();
        for (i = 0; i < size; ++i) {
            infoTempSelect = (AdminOrgUnitInfo)lst.get(i);
            int n = lstAllItem.getElementCount();
            for (int m = 0; m < n; ++m) {
                infoTempAll = (AdminOrgUnitInfo)lstAllItem.getElement(m);
                if (!infoTempAll.getId().toString().equals(infoTempSelect.getId().toString())) continue;
                this.lstSelectItemData.add(infoTempAll);
                this.lstAllItemData.remove(infoTempAll);
            }
        }
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        size = this.lstAllItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstAllItem.addElement(this.lstAllItemData.get(i));
        }
        size = this.lstSelectItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstSelectItem.addElement(this.lstSelectItemData.get(i));
        }
        lstAllItem.setSelectedIndex(0);
    }

    public static List getSelectedItemList(String ids) throws Exception {
        ArrayList<FormulaCmpItemData> lstItem = new ArrayList<FormulaCmpItemData>();
        if (ids.length() < 1) {
            return lstItem;
        }
        String[] items = ids.split("~");
        FormulaCmpItemData temp = null;
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            temp = new FormulaCmpItemData();
            temp.setUuid(items[i]);
            lstItem.add(temp);
        }
        return lstItem;
    }

    private void fillSelectItemList(List lst, KDList lstSelectItem, KDList lstAllItem) throws Exception {
        int i;
        lstSelectItem.removeAllElements();
        if (lst == null || lst.size() <= 0) {
            return;
        }
        FormulaCmpItemData infoTempSelect = null;
        FormulaCmpItemData infoTempAll = null;
        this.lstSelectItemData = new ArrayList();
        this.lstAllItemData = new ArrayList();
        int size = this.lstAllItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstAllItemData.add(lstAllItem.getElement(i));
        }
        size = lst.size();
        for (i = 0; i < size; ++i) {
            infoTempSelect = (FormulaCmpItemData)lst.get(i);
            int n = lstAllItem.getElementCount();
            for (int m = 0; m < n; ++m) {
                infoTempAll = (FormulaCmpItemData)lstAllItem.getElement(m);
                if (!infoTempAll.getUuid().toString().equals(infoTempSelect.getUuid().toString())) continue;
                this.lstSelectItemData.add(infoTempAll);
                this.lstAllItemData.remove(infoTempAll);
            }
        }
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        size = this.lstAllItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstAllItem.addElement(this.lstAllItemData.get(i));
        }
        size = this.lstSelectItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstSelectItem.addElement(this.lstSelectItemData.get(i));
        }
        lstAllItem.setSelectedIndex(0);
    }

    public void clear() {
        super.clear();
        this.initControlState();
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.lstSelectItemData = new ArrayList();
        if (this.infoAnalysisCmpItem != null) {
            int size = this.lst.size();
            for (int i = 0; i < size; ++i) {
                if (!((CmpItemInfo)this.lst.get(i)).getNumber().equals(this.infoAnalysisCmpItem.getNumber())) continue;
                this.cmbItem.setSelectedIndex(i);
                break;
            }
        }
        try {
            this.reloadItemValue((CmpItemInfo)this.cmbItem.getSelectedItem());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void setWhenOrgWeiduSelect() {
        this.cmbItem.setEnabled(false);
        this.prmtAdminOrgUnit.setEnabled(true);
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
    }

    @Override
    public void actionOrgWeidu_actionPerformed(ActionEvent e) throws Exception {
        this.setWhenOrgWeiduSelect();
    }

    @Override
    public void actionOtherWeiduButton_actionPerformed(ActionEvent e) throws Exception {
        this.prmtAdminOrgUnit.setEnabled(false);
        this.cmbItem.setEnabled(true);
        this.initOrgControl();
        this.initControlState();
        this.cmbItem.setSelectedIndex(0);
        CmpItemInfo info = (CmpItemInfo)this.cmbItem.getSelectedItem();
        this.reloadItemValue(info);
    }
}

