/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.AssignTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.TeamGroupCollection;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.client.AbstractDeptSchemeEntryImportUI;
import com.kingdee.eas.hr.compensation.client.DeptSchemeEntryEditUI;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class DeptSchemeEntryImportUI
extends AbstractDeptSchemeEntryImportUI {
    private static final Logger logger = CoreUIObject.getLogger(DeptSchemeEntryImportUI.class);
    private static final String RES = "com.kingdee.eas.hr.compensation.client.ImportDateEndDataResource";
    private HSSFWorkbook workbook;
    private AssignTypeEnum assignType = AssignTypeEnum.ADMIN;
    private AdminOrgUnitCollection adminColl = null;
    private TeamGroupCollection teamGroupColl = null;
    private CmpPeriodCollection periodColl = null;
    private DeptSchemeEntryEditUI editUI = null;
    private int errorHandleStyle = 0;
    private int errorCount = 0;
    private int successCount = 0;
    private StringBuffer errorStr;
    private boolean isOver = false;
    private boolean isShowMsg = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("Dept_AssignType") != null) {
            this.assignType = (AssignTypeEnum)((Object)this.getUIContext().get("Dept_AssignType"));
        }
        if (this.getUIContext().get("Dept_TeamGroupColl") != null) {
            this.teamGroupColl = (TeamGroupCollection)((Object)this.getUIContext().get("Dept_TeamGroupColl"));
        }
        if (this.getUIContext().get("Dept_AdminUnitColl") != null) {
            this.adminColl = (AdminOrgUnitCollection)this.getUIContext().get("Dept_AdminUnitColl");
        }
        if (this.getUIContext().get("Dept_CmpPeriodColl") != null) {
            this.periodColl = (CmpPeriodCollection)((Object)this.getUIContext().get("Dept_CmpPeriodColl"));
        }
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenTen);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFifty);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenhundred);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.setSelectedIndex(0);
        this.txtFile.setEditable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        int i;
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"339_DeptSchemeEntryImportUI") + ".xls");
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(expFilePath);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"can_not_update_open_file"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(wb);
        HSSFCellStyle cellStyle = this.createValueCellStyle(wb);
        HSSFSheet sheet = wb.createSheet();
        int rowIndex = 0;
        int columnIndex = 0;
        HSSFRow headRow = sheet.createRow(rowIndex++);
        HSSFRow headRow1 = sheet.createRow(rowIndex++);
        this.createCellAndSetValue(headRow, HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"730_DeptSchemeEntryImportUI", (String[])new String[]{this.assignType.getAlias()}), columnIndex, titleStyle);
        this.createCellAndSetValue(headRow1, "", columnIndex, titleStyle);
        this.createCellAndSetValue(headRow, HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"731_DeptSchemeEntryImportUI", (String[])new String[]{this.assignType.getAlias()}), ++columnIndex, titleStyle);
        this.createCellAndSetValue(headRow1, "", columnIndex, titleStyle);
        ++columnIndex;
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 1, 0));
        sheet.addMergedRegion(new CellRangeAddress(0, 1, 1, 1));
        CmpPeriodInfo cmpPeriodInfo = null;
        for (i = 0; i < this.periodColl.size(); ++i) {
            int startIndex = columnIndex;
            cmpPeriodInfo = this.periodColl.get(i);
            this.createCellAndSetValue(headRow, cmpPeriodInfo.getName(), columnIndex, titleStyle);
            this.createCellAndSetValue(headRow1, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"339_DeptSchemeEntryImportUI"), columnIndex++, titleStyle);
            this.createCellAndSetValue(headRow, "", columnIndex, titleStyle);
            this.createCellAndSetValue(headRow1, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"342_DeptSchemeEntryImportUI"), columnIndex++, titleStyle);
            this.createCellAndSetValue(headRow, "", columnIndex, titleStyle);
            this.createCellAndSetValue(headRow1, cmpPeriodInfo.getId().toString(), columnIndex, titleStyle);
            sheet.setColumnWidth((int)((short)columnIndex), 0);
            sheet.addMergedRegion(new CellRangeAddress(0, (int)((short)startIndex), 0, (int)((short)columnIndex)));
            ++columnIndex;
        }
        this.fillAdminOrTeam(sheet);
        for (i = 0; i < columnIndex; ++i) {
            sheet.setDefaultColumnStyle((int)((short)i), (CellStyle)cellStyle);
            sheet.setDefaultColumnWidth(30);
        }
        sheet.setColumnWidth(0, 4500);
        sheet.setColumnWidth(1, 6000);
        wb.setSheetName(0, EASResource.getString((String)RES, (String)"Dept_Totalplan"));
        wb.write((OutputStream)out);
        out.flush();
        out.close();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"export_template_success"));
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_file"));
            return;
        }
        if (this.tblMain.getRowCount() >= 0) {
            String str = filePath.substring(filePath.lastIndexOf("."));
            if (".xls".equals(str)) {
                this.initSheet();
                int sheetNum = this.comboLabel.getSelectedIndex();
                HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
                int rowNum = sheet.getPhysicalNumberOfRows();
                if (rowNum < 1) {
                    MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
                    this.txtFile.setText("");
                    this.comboLabel.removeAllItems();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
                this.txtFile.setText("");
                this.comboLabel.removeAllItems();
                SysUtil.abort();
            }
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int sheetNum;
        HSSFSheet sheet;
        int rowNum;
        if (this.workbook == null) {
            return;
        }
        if (!this.checkFile()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        this.editUI = (DeptSchemeEntryEditUI)((Object)this.getUIContext().get("Owner"));
        DeptSchemeInfo deptScheme = null;
        if (this.getUIContext().get("DeptScheme") != null) {
            deptScheme = (DeptSchemeInfo)this.getUIContext().get("DeptScheme");
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum = this.comboLabel.getSelectedIndex())).getPhysicalNumberOfRows()) <= 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"template_file_is_null"));
            return;
        }
        this.isOver = this.chkUpdate.isSelected();
        ErrorHandleModeEnum mode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
        this.errorHandleStyle = mode.getValue();
        this.errorCount = 0;
        this.errorStr = new StringBuffer();
        this.successCount = 0;
        String errorMsg = null;
        StringBuffer msg = new StringBuffer();
        Pattern p = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
        String at = EASResource.getString((String)RES, (String)"at");
        TeamGroupInfo teamGroup = null;
        AdminOrgUnitInfo adminOrg = null;
        HashMap returnMap = new HashMap();
        HashMap<String, BigDecimal[]> rowMap = null;
        HSSFRow row = null;
        for (int i = 2; i < rowNum; ++i) {
            rowMap = new HashMap<String, BigDecimal[]>();
            row = sheet.getRow(i);
            errorMsg = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"732_DeptSchemeEntryImportUI", (String[])new String[]{String.valueOf(i + 1)});
            if (StringUtils.isEmpty((String)ExcelUtil.getCellValue((HSSFCell)row.getCell(0)))) {
                if (!this.handError(errorMsg = errorMsg + HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"733_DeptSchemeEntryImportUI", (String[])new String[]{this.assignType.getAlias()}))) continue;
                SysUtil.abort();
            } else {
                int k;
                int length;
                if (this.teamGroupColl != null && this.teamGroupColl.size() > 0) {
                    length = this.teamGroupColl.size();
                    for (k = 0; k < length; ++k) {
                        if (!ExcelUtil.getCellValue((HSSFCell)row.getCell(0)).equals(this.teamGroupColl.get(k).getNumber())) continue;
                        teamGroup = this.teamGroupColl.get(k);
                        break;
                    }
                    if (teamGroup == null) {
                        errorMsg = errorMsg + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"DeptSchemeEntryImportUI_NOTEXIT");
                    }
                }
                if (this.adminColl != null && this.adminColl.size() > 0) {
                    length = this.adminColl.size();
                    for (k = 0; k < length; ++k) {
                        if (!ExcelUtil.getCellValue((HSSFCell)row.getCell(0)).equals(this.adminColl.get(k).getNumber())) continue;
                        adminOrg = this.adminColl.get(k);
                        break;
                    }
                    if (teamGroup == null) {
                        errorMsg = errorMsg + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"DeptSchemeEntryImportUI_NOTEXIT2");
                    }
                }
            }
            String periodKey = null;
            String amountPlanStr = null;
            String sendRateStr = null;
            BigDecimal amountPlan = null;
            BigDecimal sendRate = null;
            for (int j = 0; j < this.periodColl.size(); ++j) {
                amountPlan = new BigDecimal("0");
                sendRate = new BigDecimal("0");
                errorMsg = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"734_DeptSchemeEntryImportUI", (String[])new String[]{String.valueOf(i + 1), this.periodColl.get(j).getName()});
                amountPlanStr = ExcelUtil.getCellValue((HSSFCell)row.getCell((int)((short)(2 + j * 3 + 0))));
                sendRateStr = ExcelUtil.getCellValue((HSSFCell)row.getCell((int)((short)(2 + j * 3 + 1))));
                periodKey = ExcelUtil.getCellValue((HSSFCell)sheet.getRow(1).getCell((int)((short)(2 + j * 3 + 2))));
                if (StringUtils.isEmpty((String)periodKey)) {
                    if (!this.handError(errorMsg)) continue;
                    SysUtil.abort();
                }
                if (StringUtils.isEmpty((String)amountPlanStr) && StringUtils.isEmpty((String)sendRateStr)) continue;
                boolean isNumber = false;
                if (!StringUtils.isEmpty((String)amountPlanStr)) {
                    if (p.matcher(amountPlanStr).matches()) {
                        amountPlan = new BigDecimal(amountPlanStr);
                        isNumber = true;
                    }
                    if (!isNumber || amountPlan.compareTo(new BigDecimal("9999999999.99")) > 0) {
                        if (!this.handError(errorMsg = errorMsg + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"347_DeptSchemeEntryImportUI"))) continue;
                        SysUtil.abort();
                    }
                }
                isNumber = false;
                if (!StringUtils.isEmpty((String)sendRateStr)) {
                    if (p.matcher(sendRateStr).matches()) {
                        sendRate = new BigDecimal(sendRateStr);
                        isNumber = true;
                    }
                    if (!isNumber || sendRate.compareTo(new BigDecimal("0")) < 0 || sendRate.compareTo(new BigDecimal("1")) > 0) {
                        if (!this.handError(errorMsg = errorMsg + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"348_DeptSchemeEntryImportUI"))) continue;
                        SysUtil.abort();
                    }
                }
                StringBuffer oql = new StringBuffer();
                oql.append("select id where deptScheme = '").append(deptScheme.getId().toString()).append("' and ");
                if (teamGroup != null) {
                    oql.append("teamGroup = '").append(teamGroup.getId().toString()).append("' and ");
                }
                if (adminOrg != null) {
                    oql.append("adminOrgUnit = '").append(adminOrg.getId().toString()).append("' and ");
                }
                oql.append(" cmpPeriod = '").append(periodKey).append("' and ");
                oql.append(" deptInnerScheme is not null ");
                CoreBaseCollection coll = DeptSchemeEntryFactory.getRemoteInstance().getCollection(oql.toString());
                if (coll != null && coll.size() > 0) {
                    errorMsg = errorMsg + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"689_DeptSchemeEntryImportUI") + ExcelUtil.getCellValue((HSSFCell)row.getCell(0)) + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"690_DeptSchemeEntryImportUI");
                    msg.append(errorMsg);
                    continue;
                }
                rowMap.put(periodKey, new BigDecimal[]{amountPlan, sendRate});
                ++this.successCount;
            }
            returnMap.put(ExcelUtil.getCellValue((HSSFCell)row.getCell(0)), rowMap);
        }
        this.handError(msg.toString());
        this.editUI.fillDataFromExcel(returnMap, this.isOver);
        if (this.errorHandleStyle == 5 || !this.isShowMsg) {
            this.showMsg();
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    private boolean checkFile() {
        HSSFSheet sheet;
        int rowNum;
        int sheetNum = this.comboLabel.getSelectedIndex();
        if (sheetNum < 0) {
            return false;
        }
        if (this.workbook == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                return false;
            }
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum)).getPhysicalNumberOfRows()) < 1) {
            return false;
        }
        HSSFRow row = sheet.getRow(0);
        if (row == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        HSSFRow headRow = sheet.getRow(0);
        String pNumber = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"735_DeptSchemeEntryImportUI", (String[])new String[]{this.assignType.getAlias()});
        HSSFCell fCell = headRow.getCell(0);
        String value = ExcelUtil.getCellValue((HSSFCell)fCell);
        if (value == null || !value.trim().equals(pNumber + "*")) {
            // empty if block
        }
        String periodKey = null;
        for (int j = 0; j < this.periodColl.size(); ++j) {
            periodKey = ExcelUtil.getCellValue((HSSFCell)sheet.getRow(1).getCell((int)((short)(2 + j * 3 + 2))));
            if (periodKey == null) {
                return false;
            }
            if (periodKey.equals(this.periodColl.get(j).getId().toString())) continue;
            return false;
        }
        return true;
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        String path = "";
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(path);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn("excelTabName").setEditor((ICellEditor)itemEditor);
        this.comboLabel.addItemListener((ItemListener)new ItemListenerImpl());
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)new FileInputStream(path));
        this.workbook = new HSSFWorkbook(pfs);
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle valueStyle = workbook.createCellStyle();
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setHidden(true);
        BorderStyle borderstyle = BorderStyle.DOTTED;
        valueStyle.setBorderLeft(borderstyle);
        valueStyle.setBorderRight(borderstyle);
        valueStyle.setBorderTop(borderstyle);
        valueStyle.setBorderBottom(borderstyle);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"350_DeptSchemeEntryImportUI"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont(defaultFont);
        valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return valueStyle;
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setHidden(false);
        titleStyle.setLocked(false);
        titleStyle.setBorderLeft(BorderStyle.DASHED);
        titleStyle.setBorderRight(BorderStyle.DASHED);
        titleStyle.setBorderTop(BorderStyle.DASHED);
        titleStyle.setBorderBottom(BorderStyle.DASHED);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"350_DeptSchemeEntryImportUI"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        short size = 13;
        defaultFont.setFontHeight(size);
        defaultFont.setFontHeightInPoints(size);
        titleStyle.setFont(defaultFont);
        return titleStyle;
    }

    private void fillAdminOrTeam(HSSFSheet sheet) {
        HSSFRow row = null;
        if (1 == this.assignType.getValue()) {
            if (this.adminColl == null) {
                return;
            }
            AdminOrgUnitInfo adminInfo = null;
            for (int i = 0; i < this.adminColl.size(); ++i) {
                adminInfo = this.adminColl.get(i);
                row = sheet.createRow(2 + i);
                this.createCellAndSetValue(row, adminInfo.getNumber(), 0);
                this.createCellAndSetValue(row, adminInfo.getName(), 1);
            }
        } else {
            if (this.teamGroupColl == null) {
                return;
            }
            TeamGroupInfo teamInfo = null;
            for (int i = 0; i < this.teamGroupColl.size(); ++i) {
                teamInfo = this.teamGroupColl.get(i);
                row = sheet.createRow(2 + i);
                this.createCellAndSetValue(row, teamInfo.getNumber(), 0);
                this.createCellAndSetValue(row, teamInfo.getName(), 1);
            }
        }
    }

    private void setCellStringValue(HSSFCell cell, String value, HSSFCellStyle cellStyle) {
        cell.setCellType(CellType.STRING);
        cell.setCellValue(value);
        cell.setCellStyle(cellStyle);
    }

    private void setCellStringValue(HSSFCell cell, String value) {
        cell.setCellType(CellType.NUMERIC);
        cell.setCellValue(value);
    }

    private HSSFCell createCellAndSetValue(HSSFRow row, String value, int columnIndex, HSSFCellStyle cellStyle) {
        HSSFCell cell = row.createCell((int)((short)columnIndex));
        this.setCellStringValue(cell, value, cellStyle);
        return cell;
    }

    private HSSFCell createCellAndSetValue(HSSFRow row, String value, int columnIndex) {
        HSSFCell cell = row.createCell((int)((short)columnIndex));
        this.setCellStringValue(cell, value);
        return cell;
    }

    private boolean handError(String msg) {
        ++this.errorCount;
        this.errorStr.append(msg).append("\n");
        if (this.errorHandleStyle == 1) {
            this.showMsg();
            this.isShowMsg = true;
            return true;
        }
        if (this.errorHandleStyle == 2) {
            if (this.errorCount == 10) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        if (this.errorHandleStyle == 3) {
            if (this.errorCount == 50) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        if (this.errorHandleStyle == 4) {
            if (this.errorCount == 100) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        return false;
    }

    private void showMsg() {
        StringBuffer titleInfo = new StringBuffer();
        if (this.successCount > 0) {
            titleInfo.append(EASResource.getString((String)RES, (String)"success_import")).append(this.successCount).append(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"351_DeptSchemeEntryImportUI")).append("\n");
        }
        if (this.errorCount > 0) {
            titleInfo.append(EASResource.getString((String)RES, (String)"fail_import")).append(this.errorCount).append(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"351_DeptSchemeEntryImportUI"));
        }
        if (this.errorStr == null || this.errorStr.toString().trim().length() == 0) {
            if (this.successCount > 0) {
                titleInfo.append("\n" + EASResource.getString((String)RES, (String)"PLEASE_SAVE_INTIME"));
            }
            if (!StringUtils.isEmpty((String)titleInfo.toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)titleInfo.toString());
            }
        } else {
            titleInfo.append("\uff0c" + EASResource.getString((String)RES, (String)"PLEANSE_SEEDETAIL"));
            if (this.successCount > 0) {
                titleInfo.append("\n" + EASResource.getString((String)RES, (String)"PLEASE_SAVE_INTIME"));
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)titleInfo.toString(), (String)this.errorStr.toString(), (int)2);
        }
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ICell cell;
            Object obj = DeptSchemeEntryImportUI.this.comboLabel.getSelectedItem();
            if (obj != null && (cell = DeptSchemeEntryImportUI.this.tblMain.getCell(0, "excelTabName")) != null) {
                cell.setValue((Object)obj.toString());
            }
        }
    }
}

