/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpCommonFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpReportFilterF7Info;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpCommonFacade;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractEmpSumReportFilterNewUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUtil;
import com.kingdee.eas.hr.compensation.client.HRF7CmpSchemePromptBox;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBoxMutiSelect;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EmpSumReportFilterNewUI
extends AbstractEmpSumReportFilterNewUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpSumReportFilterNewUI.class);
    protected CmpItemFilterUI cmpItemFilterUI = null;
    private String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    protected List lstAllSelectItemData = null;
    protected List lstSelectItemData = new ArrayList();
    protected List lstSelectItemNotData = new ArrayList();
    private AdminOrgUnitCollection colDept = null;
    private int level = 0;
    private String cmpItemFilter = "";
    HashSet deletedItemSet = new HashSet();
    protected CmpItemCollection colCmpItem = null;
    protected CmpItemCollection colNecessaryCmpItem = new CmpItemCollection();
    protected String empSumResource = "com.kingdee.eas.hr.compensation.client.EmpSumReportResource.";
    private final String RADIOBTN = "radiobtn";
    private String hrOrgId = null;

    public String getCmpItemFilter() {
        return this.cmpItemFilter;
    }

    public void setCmpItemFilter(String cmpItemFilter) {
        this.cmpItemFilter = cmpItemFilter;
    }

    public CmpItemFilterUI getCmpItemFilterUI() {
        return this.cmpItemFilterUI;
    }

    public void setCmpItemFilterUI(CmpItemFilterUI cmpItemFilterUI) {
        this.cmpItemFilterUI = cmpItemFilterUI;
    }

    public CmpPeriodInfo getCmpPeriodInfo() {
        CmpPeriodInfo cmpPeriodInfo = new CmpPeriodInfo();
        if (this.prmtCmpPeriod.getData() != null) {
            cmpPeriodInfo = (CmpPeriodInfo)this.prmtCmpPeriod.getData();
        }
        return cmpPeriodInfo;
    }

    public String getCmpSchemeId() {
        CmpSchemeInfo schemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        String schemeId = null;
        if (schemeInfo == null) {
            return schemeId;
        }
        return schemeInfo.getId().toString();
    }

    public CmpSchemeInfo getCmpSchemeInfo() {
        CmpSchemeInfo schemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        if (schemeInfo == null) {
            return null;
        }
        return schemeInfo;
    }

    public HashMap getAllSchemeItems() {
        this.getAllSelectItem();
        HashMap allMap = new HashMap();
        CmpSchemeInfo schemeInfo = this.getCmpSchemeInfo();
        if (schemeInfo == null) {
            return allMap;
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        lstSchemeIds.add(schemeInfo.getId().toString());
        ArrayList<String> notCollectItems = null;
        if (this.lstSelectItemData != null && this.lstSelectItemData.size() > 0) {
            notCollectItems = new ArrayList<String>();
            ArrayList<CmpItemInfo> personItemList = new ArrayList<CmpItemInfo>();
            int size = this.lstSelectItemData.size();
            for (int i = 0; i < size; ++i) {
                if (!((CmpItemInfo)this.lstSelectItemData.get(i)).getNumber().startsWith("FPER")) {
                    notCollectItems.add(((CmpItemInfo)this.lstSelectItemData.get(i)).getNumber());
                    continue;
                }
                personItemList.add((CmpItemInfo)this.lstSelectItemData.get(i));
            }
            try {
                boolean notIncDelItem = this.chkIncDelItem.isSelected();
                allMap = CmpReportFacadeFactory.getRemoteInstance().getPrivateItemsByScheme(lstSchemeIds, notCollectItems, notIncDelItem);
                if (allMap.get(this.getCmpSchemeId()) != null) {
                    this.lstSelectItemNotData = (List)allMap.get(this.getCmpSchemeId());
                }
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            allMap.put("PersonItem", personItemList);
        }
        return allMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AdminOrgUnitCollection getDeptCol(boolean isShowSealUp) {
        try {
            if (this.btnSingleOrg.isSelected()) {
                AdminOrgUnitInfo infoDept = (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
                infoDept = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(infoDept.getId()));
                if (infoDept == null) return new AdminOrgUnitCollection();
                if (this.chkHasSubAdminOrg.isSelected()) {
                    this.level = infoDept.getLevel();
                    if (this.cmbLevel.getSelectedIndex() != -1) {
                        this.level = (Integer)this.cmbLevel.getSelectedItem();
                    }
                    this.colDept = HRUtils.getSubDeptCollectionNew(infoDept, this.level, isShowSealUp);
                    return this.colDept;
                } else {
                    this.colDept = new AdminOrgUnitCollection();
                    this.colDept.add(infoDept);
                }
                return this.colDept;
            } else {
                this.colDept = new AdminOrgUnitCollection();
                Object[] value = (Object[])this.prmtAdminUnitOrg.getData();
                HashSet<String> set = new HashSet<String>();
                if (value != null && value.length > 0) {
                    for (int i = 0; i < value.length; ++i) {
                        set.add(((AdminOrgUnitInfo)value[i]).getId().toString());
                    }
                }
                if (set.size() <= 0) return this.colDept;
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                String adminSql = HRSchemeUtils.getAdminByUserRange(null);
                FilterItemInfo item = new FilterItemInfo("id", (Object)adminSql, CompareType.INNER);
                fi.getFilterItems().add(item);
                evi.setFilter(fi);
                AdminOrgUnitCollection col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                if (isShowSealUp) {
                    this.colDept.addCollection(col);
                    return this.colDept;
                } else {
                    AdminOrgUnitInfo infoTmp = null;
                    int size = col.size();
                    for (int i = 0; i < size; ++i) {
                        infoTmp = col.get(i);
                        if (infoTmp.isIsSealUp()) continue;
                        this.colDept.add(infoTmp);
                    }
                }
            }
            return this.colDept;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.colDept;
    }

    public List getAllSelectItem() {
        ArrayList allSelectItems = new ArrayList();
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        if (this.lstSelectItemData != null) {
            allSelectItems.addAll(this.lstSelectItemData);
        }
        return allSelectItems;
    }

    public HashMap getCustomFilterMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CmpSchemeInfos", new CmpSchemeInfo[]{this.getCmpSchemeInfo()});
        map.put("CmpPeriodInfo", (CmpPeriodInfo)this.prmtCmpPeriod.getData());
        map.put("zeroItemDisplayNull", this.chkZeroItemDisplayNull.isSelected());
        map.put("AdminOrgUnitColl", this.getDeptCol(this.chkShowSealUp.isSelected()));
        map.put("AllSelectItem", this.getAllSelectItem());
        CmpItemInfo cmpItemInfo = null;
        ArrayList<CmpItemInfo> lstSelectItemDa = new ArrayList<CmpItemInfo>();
        boolean flag = false;
        int size = this.lstSelectItemData.size();
        for (int i = 0; i < size; ++i) {
            cmpItemInfo = (CmpItemInfo)this.lstSelectItemData.get(i);
            int sizee = this.lstSelectItemNotData.size();
            for (int j = 0; j < sizee; ++j) {
                if (!((CmpItemInfo)this.lstSelectItemNotData.get(j)).getNumber().equals(cmpItemInfo.getNumber())) continue;
                flag = true;
                break;
            }
            if (flag) {
                flag = false;
                continue;
            }
            lstSelectItemDa.add(cmpItemInfo);
        }
        map.put("AllPublicItem", lstSelectItemDa);
        map.put("AllPrivateItem", this.lstSelectItemNotData);
        map.put("RootHROrgID", this.hrOrgId);
        map.put("chkIncDelItem", this.chkIncDelItem.isSelected());
        AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
        try {
            if (this.btnSingleOrg.isSelected()) {
                unitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
            }
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        map.put("AdminOrgUnitInfo", unitInfo);
        map.put("IsShowLongName", true);
        map.put("isShowSealUp", this.chkShowSealUp.isSelected());
        map.put("IsIncludeChild", this.chkHasSubAdminOrg.isSelected());
        map.put("IncludeChildLevel", this.cmbLevel.getSelectedIndex() + 1);
        map.put("IsSumChild", this.chkSumChild.isSelected());
        map.put("SumChildLevel", this.cmbSumChild.getSelectedIndex() + 1);
        map.put("IsAdminSubSum", this.chkAdminSub.isSelected());
        map.put("IsSingleDept", this.btnSingleOrg.isSelected());
        map.put("enableTime", this.enableTime.isSelected());
        map.put("fromTime", this.fromTime.getIntegerValue());
        map.put("toTime", this.fromTime.getIntegerValue());
        map.put("ISPrintByOrg", this.chkPrintOrg.isSelected());
        if (this.getCmpItemFilterUI() != null) {
            map.put("cmpItemCustFilter", this.getCmpItemFilterUI().getCondition().toString());
        } else {
            map.put("cmpItemCustFilter", this.getCmpItemFilter());
        }
        return map;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        if (this.btnSingleOrg.isSelected()) {
            this.setAdminPrmtState(true);
        } else {
            this.setAdminPrmtState(false);
        }
    }

    private void setAdminPrmtState(boolean isSingleSelect) {
        this.prmtAdminUnitOrg.setEnabled(!isSingleSelect);
        this.chkAdminSub.setEnabled(!isSingleSelect);
        this.prmtSingleAdminOrg.setEnabled(isSingleSelect);
        this.chkHasSubAdminOrg.setEnabled(isSingleSelect);
        this.cmbLevel.setEnabled(isSingleSelect);
        this.chkSumChild.setEnabled(isSingleSelect);
        this.cmbSumChild.setEnabled(isSingleSelect);
        if (isSingleSelect) {
            this.prmtAdminUnitOrg.setData(null);
            this.chkAdminSub.setSelected(false);
        } else {
            this.prmtSingleAdminOrg.setData(null);
            this.chkHasSubAdminOrg.setSelected(false);
            this.cmbLevel.setSelectedItem(null);
            this.chkSumChild.setSelected(false);
            this.cmbSumChild.setSelectedItem(null);
            this.chkPrintOrg.setSelected(false);
            this.chkPrintOrg.setEnabled(true);
        }
    }

    private void initAllEditor() throws ParserException, BOSException {
        HRF7CmpSchemePromptBox f7PromptBox = new HRF7CmpSchemePromptBox((IUIObject)this);
        f7PromptBox.setIsSingleSelect(true);
        this.prmtCmpScheme.setDefaultF7UIName(HRF7CmpSchemePromptBox.class.getName());
        this.prmtCmpScheme.setEditable(false);
        this.prmtCmpScheme.setEditFormat("$name$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        this.prmtCmpScheme.setSelector((KDPromptSelector)f7PromptBox);
        this.prmtCmpScheme.setEnabledMultiSelection(false);
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filterInfoCmpSch.setMaskString("(#0 or #1 ) and #2");
        evi.setFilter(filterInfoCmpSch);
        this.prmtCmpScheme.setEntityViewInfo(evi);
        this.prmtCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtCmpPeriod.setEditable(false);
        this.prmtCmpPeriod.setEditFormat("$name$");
        this.prmtCmpPeriod.setDisplayFormat("$name$");
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrOrgId));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        CompUtils.initF7SelectorNoHR(this, this.prmtSingleAdminOrg);
        this.prmtSingleAdminOrg.setEditable(false);
        AdminByOrgRangePromptBoxMutiSelect prmtUnit = new AdminByOrgRangePromptBoxMutiSelect();
        prmtUnit.showChkSealUp(true);
        prmtUnit.setIncludeSealUp("false");
        this.prmtAdminUnitOrg.setSelector((KDPromptSelector)prmtUnit);
        this.prmtAdminUnitOrg.setEditable(false);
        this.prmtAdminUnitOrg.setEditFormat("$name$");
        this.prmtAdminUnitOrg.setDisplayFormat("$name$");
        this.prmtAdminUnitOrg.setHasCUDefaultFilter(false);
        this.prmtAdminUnitOrg.setEnabledMultiSelection(true);
    }

    protected void initListener() {
        super.initListener();
        this.btnSingleOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EmpSumReportFilterNewUI.this.btnSingleOrg.isSelected()) {
                    EmpSumReportFilterNewUI.this.setAdminPrmtState(true);
                } else {
                    EmpSumReportFilterNewUI.this.setAdminPrmtState(false);
                }
            }
        });
        this.btnSingleOrg.setSelected(true);
        this.prmtSingleAdminOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    EmpSumReportFilterNewUI.this.cmbLevel.removeAllItems();
                    EmpSumReportFilterNewUI.this.cmbSumChild.removeAllItems();
                    if (EmpSumReportFilterNewUI.this.prmtSingleAdminOrg.getData() == null) {
                        return;
                    }
                    int level = EmpSumReportFilterNewUI.this.getAdminOrgLevelCount((AdminOrgUnitInfo)EmpSumReportFilterNewUI.this.prmtSingleAdminOrg.getData());
                    if (level > 0) {
                        EmpSumReportFilterNewUI.this.chkHasSubAdminOrg.setSelected(false);
                        EmpSumReportFilterNewUI.this.chkHasSubAdminOrg.setEnabled(true);
                        EmpSumReportFilterNewUI.this.cmbLevel.setEnabled(true);
                        EmpSumReportFilterNewUI.this.chkSumChild.setSelected(false);
                        EmpSumReportFilterNewUI.this.chkSumChild.setEnabled(true);
                        EmpSumReportFilterNewUI.this.cmbSumChild.setEnabled(true);
                        EmpSumReportFilterNewUI.this.chkPrintOrg.setSelected(false);
                        EmpSumReportFilterNewUI.this.chkPrintOrg.setEnabled(true);
                    } else {
                        EmpSumReportFilterNewUI.this.chkHasSubAdminOrg.setSelected(false);
                        EmpSumReportFilterNewUI.this.chkHasSubAdminOrg.setEnabled(false);
                        EmpSumReportFilterNewUI.this.cmbLevel.setEnabled(false);
                        EmpSumReportFilterNewUI.this.chkSumChild.setSelected(false);
                        EmpSumReportFilterNewUI.this.chkSumChild.setEnabled(false);
                        EmpSumReportFilterNewUI.this.cmbSumChild.setEnabled(false);
                        EmpSumReportFilterNewUI.this.chkPrintOrg.setSelected(false);
                        EmpSumReportFilterNewUI.this.chkPrintOrg.setEnabled(false);
                    }
                    EmpSumReportFilterNewUI.this.initComBox(level, EmpSumReportFilterNewUI.this.cmbLevel);
                    EmpSumReportFilterNewUI.this.initComBox(level, EmpSumReportFilterNewUI.this.cmbSumChild);
                }
                catch (Exception e) {
                    EmpSumReportFilterNewUI.this.handUIException(e);
                }
            }
        });
        this.cmbItemCatalog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    try {
                        EmpSumReportFilterNewUI.this.onLoadAllList();
                        EmpSumReportFilterNewUI.this.lstAllItem.requestFocus();
                    }
                    catch (BOSException e) {
                        EmpSumReportFilterNewUI.this.handUIException(e);
                    }
                }
            }
        });
        this.prmtCmpScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    Object obj = EmpSumReportFilterNewUI.this.prmtCmpScheme.getData();
                    EmpSumReportFilterNewUI.this.lstAllItem.removeAllElements();
                    EmpSumReportFilterNewUI.this.lstSelectItem.removeAllElements();
                    if (obj == null) {
                        EmpSumReportFilterNewUI.this.cmbItemCatalog.removeAllItems();
                        return;
                    }
                    EmpSumReportFilterNewUI.this.setPeriodF7();
                    EmpSumReportFilterNewUI.this.getCmpItemCollection((CmpSchemeInfo)obj);
                    EmpSumReportFilterNewUI.this.fillCmpItemCatalogData();
                }
                catch (Exception exc) {
                    EmpSumReportFilterNewUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void setPeriodF7() throws Exception {
        if (this.prmtCmpScheme.getData() != null) {
            this.hrOrgId = ((CmpSchemeInfo)this.prmtCmpScheme.getData()).getHrOrgUnit().getId().toString();
            EntityViewInfo eviCmpPeriod = new EntityViewInfo();
            FilterInfo filterInfoCmpPeriod = new FilterInfo();
            filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrOrgId));
            eviCmpPeriod.setFilter(filterInfoCmpPeriod);
            this.prmtCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        }
    }

    private CmpItemCollection getPersonItems() throws BOSException, SQLException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("cmpItemCatalog.number"));
        viewInfo.setSelector(selector);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)"FPER"));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrOrgId));
        fi.getFilterItems().add(new FilterItemInfo("subject", (Object)10));
        ArrayList perNumList = HRCmpItemUtils.getMappingPersonItems(null, 1);
        if (perNumList != null && perNumList.size() > 0) {
            HashSet set = new HashSet();
            set.addAll(perNumList);
            fi.getFilterItems().add(new FilterItemInfo("subject", (Object)20));
            fi.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
            fi.setMaskString(" #0 and #1 and (#2 or( #3 and #4))");
        } else {
            fi.setMaskString(" #0 and #1 and #2 ");
        }
        if (viewInfo.getSorter() == null) {
            viewInfo.setSorter(new SorterItemCollection());
        }
        viewInfo.getSorter().add(new SorterItemInfo("defaultOrder"));
        viewInfo.setFilter(fi);
        this.colCmpItem = CmpItemFactory.getRemoteInstance().getCmpItemCollection(viewInfo);
        return this.colCmpItem;
    }

    protected void fillCmpItemCatalogData() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrOrgId));
        evi.setFilter(filterInfo);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longnumber"));
        evi.setSorter(sort);
        CmpItemCatalogCollection colCmpItemCatalog = CmpItemCatalogFactory.getRemoteInstance().getCmpItemCatalogCollection(evi);
        if (colCmpItemCatalog == null || colCmpItemCatalog.size() <= 0) {
            return;
        }
        Iterator itr = colCmpItemCatalog.iterator();
        CmpItemCatalogInfo cmpItemCatalogInfo = null;
        this.cmbItemCatalog.removeAllItems();
        while (itr.hasNext()) {
            cmpItemCatalogInfo = (CmpItemCatalogInfo)itr.next();
            this.cmbItemCatalog.addItem((Object)cmpItemCatalogInfo);
        }
    }

    protected CmpItemCollection getCmpItemCollection(CmpSchemeInfo cmpSchemeInfo) throws Exception {
        this.getPersonItems();
        CmpItemCollection cmpItemColl = this.getCmpItemOfSchemeBySchme(cmpSchemeInfo);
        ArrayList<String> cmpSchemeIDs = new ArrayList<String>();
        cmpSchemeIDs.add(this.getCmpSchemeId());
        this.deletedItemSet = CmpSchemeItemFactory.getRemoteInstance().getDeletedCmpItem(cmpSchemeIDs);
        this.colCmpItem.addCollection(cmpItemColl);
        this.getColNecessaryCmpItem();
        return cmpItemColl;
    }

    private CmpItemCollection getCmpItemOfSchemeBySchme(CmpSchemeInfo cmpSchemeInfo) throws Exception {
        ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.hrOrgUnit.id", (Object)this.hrOrgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.enable", (Object)1));
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("sortOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItem.*"));
        sic.add(new SelectorItemInfo("cmpItem.cmpItemCatalog.number"));
        sic.add(new SelectorItemInfo("cmpItem.cmpItemCatalog.id"));
        sic.add(new SelectorItemInfo("cmpItem.cmpItemCatalog.name"));
        sic.add(new SelectorItemInfo("cmpItem.hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("cmpScheme.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FPER%", CompareType.NOTLIKE));
        filterInfo.mergeFilter(filter, "and");
        CmpSchemeItemCollection cmpSchemeItemColl = iCmpSchemeItem.getCmpSchemeItemCollection(evi);
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        CmpSchemeItemInfo cmpSchemeItemTemp = null;
        Map perMap = HRCmpItemUtils.getPerItemMap(null, 1);
        int j = cmpSchemeItemColl.size();
        for (int i = 0; i < j; ++i) {
            cmpSchemeItemTemp = cmpSchemeItemColl.get(i);
            if (!perMap.containsKey(cmpSchemeItemTemp.getCmpItem().getNumber()) && 10 != cmpSchemeItemTemp.getCmpItem().getSubject().getValue() && cmpSchemeItemTemp.getCmpItem().getNumber().startsWith("FPER")) continue;
            cmpItemColl.add(cmpSchemeItemTemp.getCmpItem());
        }
        return cmpItemColl;
    }

    public void getColNecessaryCmpItem() {
        if (this.colCmpItem == null) {
            return;
        }
        this.colNecessaryCmpItem = new CmpItemCollection();
        Iterator itr = this.colCmpItem.iterator();
        CmpItemInfo info = null;
        while (itr.hasNext()) {
            info = (CmpItemInfo)itr.next();
            if (!this.isNecessaryCmpItem(info)) continue;
            this.colNecessaryCmpItem.add(info);
        }
        this.initLstSelectItem();
    }

    protected void initLstSelectItem() {
        Iterator itr = this.colNecessaryCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpSchemeItemInfo info = null;
        while (itr.hasNext()) {
            infoCmpItem = (CmpItemInfo)itr.next();
            info = new CmpSchemeItemInfo();
            info.setCmpItem(infoCmpItem);
            this.lstSelectItem.addElement((Object)infoCmpItem);
        }
    }

    protected boolean isNecessaryCmpItem(CmpItemInfo info) {
        String number = info.getNumber();
        return number.equalsIgnoreCase("FPER001") || number.equalsIgnoreCase("FPER002") || number.equalsIgnoreCase("FPER005") || number.equalsIgnoreCase("FSAL006");
    }

    protected void onLoadAllList() throws BOSException {
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        if (infoCmpItemCatalog == null || this.colCmpItem == null) {
            return;
        }
        this.lstAllItem.removeAllElements();
        Iterator itrCmpItem = this.colCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpItemCatalogInfo infoTemp = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            infoTemp = infoCmpItem.getCmpItemCatalog();
            if (infoTemp == null || !infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) continue;
            boolean isSame = false;
            CmpItemInfo infoTempCmpItem = null;
            int count = this.lstSelectItem.getElementCount();
            for (int i = 0; i < count; ++i) {
                infoTempCmpItem = (CmpItemInfo)this.lstSelectItem.getElement(i);
                if (!infoTempCmpItem.getId().toString().equals(infoCmpItem.getId().toString())) continue;
                isSame = true;
            }
            if (isSame) continue;
            if (this.chkIncDelItem.isSelected()) {
                if (infoCmpItem.getNumber().indexOf("FPER") == -1) {
                    if (!this.deletedItemSet.contains(infoCmpItem.getNumber())) continue;
                    this.lstAllItem.addElement((Object)infoCmpItem);
                    continue;
                }
                this.lstAllItem.addElement((Object)infoCmpItem);
                continue;
            }
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    private void initComBox(int level, KDComboBox cmbControl) {
        for (int i = 1; i <= level; ++i) {
            cmbControl.addItem((Object)i);
        }
        if (level >= 1) {
            cmbControl.setSelectedIndex(0);
        }
    }

    private int getAdminOrgLevelCount(AdminOrgUnitInfo info) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber()));
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
        fi.setMaskString("(#0 or #1)");
        viewInfo.setFilter(fi);
        SorterItemInfo sortInfo = new SorterItemInfo("level");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection coll = iAdmin.getAdminOrgUnitCollection(viewInfo);
        if (coll != null) {
            int size = coll.size();
            if (size <= 1) {
                return 0;
            }
            if (size > 1) {
                return coll.get(size - 1).getLevel() - coll.get(0).getLevel();
            }
        }
        return 0;
    }

    public void clear() {
        super.clear();
        if (this.btnSingleOrg.isSelected()) {
            this.setAdminPrmtState(true);
        } else {
            this.setAdminPrmtState(false);
        }
        this.cmbItemCatalog.removeAllItems();
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.prmtSingleAdminOrg.setData(null);
        this.cmbLevel.removeAllItems();
        this.chkHasSubAdminOrg.setSelected(false);
        this.cmbSumChild.removeAllItems();
        this.chkSumChild.setSelected(false);
        this.chkPrintOrg.setSelected(false);
        this.chkAdminSub.setSelected(false);
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.lstSelectItemData = new ArrayList();
        this.lstAllSelectItemData = null;
        this.enableTime.setSelected(false);
        this.fromTime.setText(null);
        this.fromTime.setEditable(false);
        this.btnSingleOrg.setSelected(true);
        this.radiobtn0.setSelected(true);
        this.cmbLevel.setEnabled(this.chkHasSubAdminOrg.isSelected());
        this.cmbSumChild.setEnabled(this.chkSumChild.isSelected());
        this.setOrgCommentEnabled();
        this.prmtCmpPeriod.setData(null);
        this.prmtCmpScheme.setData(null);
        this.hrOrgId = null;
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrOrgId));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    @Override
    protected void btnSingleOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.btnSingleOrg_actionPerformed(e);
    }

    @Override
    protected void btnMulOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.btnMulOrg_actionPerformed(e);
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgMultSelected = this.btnMulOrg.isSelected();
        if (this.radiobtn1.isSelected() && isRdOrgMultSelected) {
            this.radiobtn1.setSelected(false);
            this.radiobtn0.setSelected(true);
        }
        this.radiobtn1.setEnabled(!isRdOrgMultSelected);
    }

    @Override
    protected void chkHasSubAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        this.cmbLevel.setEnabled(this.chkHasSubAdminOrg.isSelected());
    }

    @Override
    protected void chkSumChild_stateChanged(ChangeEvent e) throws Exception {
        this.cmbSumChild.setEnabled(this.chkSumChild.isSelected());
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowSealUp_itemStateChanged(e);
        CompUtils.initF7SelectorNoHR(this.prmtSingleAdminOrg, this.chkShowSealUp.isSelected());
    }

    @Override
    protected void enableTime_stateChanged(ChangeEvent e) throws Exception {
        boolean isSelected = this.enableTime.isSelected();
        if (isSelected) {
            this.fromTime.setNumberValue(null);
            this.fromTime.setEditable(true);
        } else {
            this.fromTime.setNumberValue(null);
            this.fromTime.setEditable(false);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        this.leftToRight();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        this.allLeftToRightItem();
    }

    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            if (this.lstSelectItem.getSelectedIndex() == -1) {
                indexSelect = this.lstSelectItem.getElementCount();
            }
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.insertElement((Object)info, indexSelect);
                this.lstAllItem.removeElement((Object)info);
                ++indexSelect;
            }
            this.lstSelectItem.setSelectedIndex(0);
            if (this.lstSelectItem.getElementCount() > 0) {
                CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
            }
        }
    }

    protected void leftToRight() {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            if (this.lstSelectItem.getSelectedIndex() == -1) {
                indexSelect = this.lstSelectItem.getElementCount();
            }
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
            if (!info.getNumber().startsWith("FPER") && !"FSAL000".equals(info.getNumber())) {
                CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, false, false, new CmpItemInfo[]{info});
            }
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        this.rightToLeft();
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        this.allRightToLeftItem();
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstAllItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstSelectItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    protected void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                if (!this.isNecessaryCmpItem(info)) {
                    CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                    CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
                    if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                        this.lstAllItem.addElement((Object)info);
                    }
                }
                this.lstSelectItem.removeElement((Object)info);
            }
            this.initLstSelectItem();
            if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
        }
    }

    protected void rightToLeft() {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            if (this.isNecessaryCmpItem(info)) {
                return;
            }
            this.lstSelectItem.removeElement((Object)info);
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
            CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
            CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
            if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                this.lstAllItem.addElement((Object)info);
                this.lstAllItem.setSelectedIndex(this.lstAllItem.getElementCount() - 1);
            }
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    public boolean verify() {
        if (this.prmtCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmtCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (this.btnSingleOrg.isSelected() && this.prmtSingleAdminOrg.getData() == null || this.btnMulOrg.isSelected() && this.prmtAdminUnitOrg.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_ADMIN")));
            this.prmtSingleAdminOrg.requestFocusInWindow();
            return false;
        }
        if (this.enableTime.isSelected()) {
            int fromTime;
            if (StringUtils.isEmpty((String)this.fromTime.getText())) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "TIMES")));
                this.fromTime.requestFocusInWindow();
                return false;
            }
            if (!StringUtils.isEmpty((String)this.fromTime.getText()) && (fromTime = this.fromTime.getNumberValue().intValue()) < 1) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "TIMENOT")));
                this.fromTime.requestFocusInWindow();
                return false;
            }
        }
        if (this.chkSumChild.isSelected() && !this.chkHasSubAdminOrg.isSelected()) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_GREATERTHANSUBLEVEL")));
            this.chkSumChild.requestFocusInWindow();
            return false;
        }
        int iLevel = 0;
        if (this.cmbLevel.getSelectedIndex() != -1) {
            iLevel = (Integer)this.cmbLevel.getSelectedItem();
        }
        int iSumChildLevel = 0;
        if (this.cmbLevel.getSelectedIndex() != -1) {
            iSumChildLevel = (Integer)this.cmbSumChild.getSelectedItem();
        }
        if (this.chkSumChild.isSelected() && iSumChildLevel > iLevel) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_GREATERTHANSUBLEVEL")));
            this.cmbSumChild.requestFocusInWindow();
            return false;
        }
        Object scheme = this.prmtCmpScheme.getData();
        if (scheme == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"263_CmpSummaryReportFilterUI"));
            this.prmtCmpScheme.requestFocusInWindow();
            return false;
        }
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        FilterInfo filter;
        CustomerParams cp = new CustomerParams();
        if (this.cmpItemFilterUI != null && (filter = this.cmpItemFilterUI.getCondition()) != null) {
            cp.addCustomerParam("CmpItemFilter", filter.toString());
        }
        cp.putBoolean("ISMultiDeptSelect", this.btnMulOrg.isSelected());
        if (this.btnSingleOrg.isSelected()) {
            if (this.prmtSingleAdminOrg.getData() != null) {
                cp.addCustomerParam("prmtSingleAdminOrg", ((AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData()).getId().toString());
            }
            cp.putBoolean("chkHasSubAdminOrg", this.chkHasSubAdminOrg.isSelected());
            if (this.cmbLevel.getSelectedItem() != null) {
                String selectItemLevel = this.cmbLevel.getSelectedItem().toString();
                cp.addCustomerParam("selectItemLevel", selectItemLevel);
            }
            cp.putBoolean("IsSumChild", this.chkSumChild.isSelected());
            Integer iSumChildLevel = 0;
            if (this.cmbSumChild.getSelectedItem() != null) {
                iSumChildLevel = (Integer)this.cmbSumChild.getSelectedItem();
            }
            cp.putInt("SumChildLevel", iSumChildLevel.intValue());
        } else {
            Object[] ogs;
            Object value = this.prmtAdminUnitOrg.getValue();
            if (value != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
                int i;
                StringBuffer orgUnits = new StringBuffer();
                for (i = 0; i < ogs.length - 1; ++i) {
                    orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                    orgUnits.append("\u2014\u2014");
                }
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                cp.addCustomerParam("adminOrgUnitMul", orgUnits.toString());
            }
            cp.addCustomerParam("chkAdminSub", String.valueOf(this.chkAdminSub.isSelected()));
        }
        cp.putBoolean("ISPrintByOrg", this.chkPrintOrg.isSelected());
        if (this.radiobtn0.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn0");
        } else if (this.radiobtn1.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn1");
        } else if (this.radiobtn2.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn2");
            cp.addCustomerParam("level", this.levelComboBox.getSelectedItem().toString());
        }
        cp.putBoolean("isShowSealUp", this.chkShowSealUp.isSelected());
        if (this.prmtCmpPeriod.getData() != null) {
            cp.addCustomerParam("prmtCmpPeriod", ((CmpPeriodInfo)this.prmtCmpPeriod.getData()).getId().toString());
        }
        cp.putBoolean("enableTime", this.enableTime.isSelected());
        cp.addCustomerParam("fromTime", this.fromTime.getText());
        if (this.prmtCmpScheme.getData() != null) {
            cp.addCustomerParam("prmtCmpScheme", ((CmpSchemeInfo)this.prmtCmpScheme.getData()).getId().toString());
        }
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        cp.addCustomerParam("selectListItem", HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemData));
        cp.putBoolean("chkIncDelItem", this.chkIncDelItem.isSelected());
        cp.addCustomerParam("zeroItemDisplayNull", String.valueOf(this.chkZeroItemDisplayNull.isSelected()));
        cp.putBoolean("isShowLongName", true);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.clear();
        try {
            String filterStr;
            CmpSchemeInfo schemeInfo;
            Map paramF7Map = this.getF7ParamMap(cp);
            CmpReportFilterF7Info f7Info = this.getF7Info(paramF7Map);
            this.btnMulOrg.setSelected(cp.getBoolean("ISMultiDeptSelect"));
            this.btnSingleOrg.setSelected(!cp.getBoolean("ISMultiDeptSelect"));
            AdminOrgUnitInfo infoDept = f7Info.getAdminInfo();
            if (infoDept != null) {
                int oldLevel;
                this.prmtSingleAdminOrg.setData((Object)infoDept);
                this.cmbLevel.removeAllItems();
                this.cmbSumChild.removeAllItems();
                int level = f7Info.getLevel();
                HRCommonQueryUtils.initComBox(this.cmbLevel, level);
                HRCommonQueryUtils.initComBox(this.cmbSumChild, level);
                if (level > 0) {
                    this.chkHasSubAdminOrg.setEnabled(true);
                    this.cmbLevel.setEnabled(true);
                    this.chkSumChild.setEnabled(true);
                    this.cmbSumChild.setEnabled(true);
                }
                if (cp.getCustomerParam("selectItemLevel") != null && this.cmbLevel.getItemCount() > 0) {
                    oldLevel = Integer.valueOf(cp.getCustomerParam("selectItemLevel"));
                    if (oldLevel > level && level >= 2) {
                        this.cmbLevel.setSelectedIndex(1);
                    } else if (oldLevel > level && level < 2) {
                        this.cmbLevel.setSelectedIndex(0);
                    } else {
                        this.cmbLevel.setSelectedIndex(oldLevel - 1);
                    }
                }
                if (cp.getCustomerParam("SumChildLevel") != null && this.cmbSumChild.getItemCount() > 0) {
                    oldLevel = Integer.valueOf(cp.getCustomerParam("SumChildLevel"));
                    if (oldLevel > level && level >= 2) {
                        this.cmbSumChild.setSelectedIndex(1);
                    } else if (oldLevel > level && level < 2) {
                        this.cmbSumChild.setSelectedIndex(0);
                    } else {
                        this.cmbSumChild.setSelectedIndex(oldLevel - 1);
                    }
                }
            }
            this.chkPrintOrg.setSelected(cp.getBoolean("ISPrintByOrg"));
            this.chkHasSubAdminOrg.setSelected(cp.getBoolean("chkHasSubAdminOrg"));
            this.cmbLevel.setEnabled(this.chkHasSubAdminOrg.isSelected());
            this.chkSumChild.setSelected(cp.getBoolean("IsSumChild"));
            this.cmbSumChild.setEnabled(this.chkSumChild.isSelected());
            AdminOrgUnitCollection col = f7Info.getAdminColl();
            if (col != null) {
                this.btnSingleOrg.setSelected(false);
                this.btnMulOrg.setSelected(true);
                this.prmtAdminUnitOrg.setValue((Object)col.toArray());
            }
            this.chkAdminSub.setSelected(cp.getBoolean("chkAdminSub"));
            if (cp.getCustomerParam("radiobtn") == null || cp.getCustomerParam("radiobtn").equals("radiobtn0")) {
                this.radiobtn0.setSelected(true);
            } else if (cp.getCustomerParam("radiobtn").equals("radiobtn1")) {
                this.radiobtn1.setSelected(true);
            } else if (cp.getCustomerParam("radiobtn").equals("radiobtn2")) {
                this.radiobtn2.setSelected(true);
                String level = cp.getCustomerParam("level");
                this.levelComboBox.setSelectedIndex(Integer.parseInt(level) - 1);
            }
            this.chkShowSealUp.setSelected(cp.getBoolean("isShowSealUp"));
            CmpPeriodInfo periodInfo = f7Info.getPeriodInfo();
            if (periodInfo != null) {
                this.prmtCmpPeriod.setData((Object)periodInfo);
            }
            if (cp.getCustomerParam("enableTime") != null) {
                this.enableTime.setSelected(cp.getBoolean("enableTime"));
                if (this.enableTime.isSelected()) {
                    this.fromTime.setEditable(true);
                    this.fromTime.setText(cp.getCustomerParam("fromTime"));
                }
            }
            if ((schemeInfo = f7Info.getCmpSchemeInfo()) != null) {
                this.prmtCmpScheme.setData((Object)schemeInfo);
            } else {
                SysUtil.abort();
            }
            String ids = cp.getCustomerParam("selectListItem");
            this.setLstSelectItem(ids);
            this.setOrgCommentEnabled();
            this.chkZeroItemDisplayNull.setSelected(cp.getBoolean("zeroItemDisplayNull"));
            this.chkIncDelItem.setSelected(cp.getBoolean("chkIncDelItem"));
            if (this.cmpItemFilterUI != null && !StringUtils.isEmpty((String)(filterStr = cp.getCustomerParam("CmpItemFilter")))) {
                this.cmpItemFilterUI.loadFilterInfo(new FilterInfo(filterStr));
            }
        }
        catch (AbortException e) {
            ExceptionHandler.handle((Throwable)e);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"236_CmpReportFilterBaseUI"));
            SysUtil.abort();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void setLstSelectItem(String ids) {
        if (ids != null && !"".equals(ids)) {
            try {
                List lstSelectItemData = this.getSelectedItemList(ids, "~");
                HRCommonQueryUtils.fillSelectItemList(lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        try {
            this.onLoadAllList();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private List getSelectedItemList(String ids, String splitStr) throws Exception {
        ArrayList<CmpItemInfo> lstItem = new ArrayList<CmpItemInfo>();
        if (ids.length() < 1) {
            return lstItem;
        }
        String[] items = ids.split(splitStr);
        HashSet<String> setItemID = new HashSet<String>();
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            setItemID.add(items[i]);
        }
        CmpItemCollection colCmpItem = (CmpItemCollection)CmpItemFactory.getRemoteInstance().getForNotDataAuthority(setItemID);
        if (colCmpItem != null && colCmpItem.size() > 0) {
            int length = items.length;
            for (int j = 0; j < length; ++j) {
                int size2 = colCmpItem.size();
                for (int i = 0; i < size2; ++i) {
                    if (!colCmpItem.get(i).getId().toString().equals(items[j])) continue;
                    lstItem.add(colCmpItem.get(i));
                }
            }
        }
        return lstItem;
    }

    @Override
    protected void chkIncDelItem_itemStateChanged(ItemEvent e) throws Exception {
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        if (infoCmpItemCatalog == null || this.colCmpItem == null) {
            return;
        }
        CmpItemInfo infoCmpItem = null;
        boolean isDelItem = this.chkIncDelItem.isSelected();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = (CmpItemInfo)this.lstSelectItem.getElement(i);
            if (!isDelItem || this.deletedItemSet.contains(infoCmpItem.getNumber()) || infoCmpItem.getNumber().indexOf("FPER") != -1) continue;
            this.lstSelectItem.removeElementAt(i);
            --i;
            --size;
        }
        this.onLoadAllList();
    }

    private KDList getCmpItemFilterItem(KDList items) {
        KDList kdList = new KDList();
        CmpItemInfo info = null;
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            info = (CmpItemInfo)this.lstSelectItem.getElement(i);
            if ("FSAL000".equals(info.getNumber())) continue;
            kdList.addElement((Object)info);
        }
        return kdList;
    }

    protected Map getF7ParamMap(CustomerParams cp) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String value = cp.getCustomerParam("adminOrgUnitMul");
        String[] idArrays = null;
        if (!StringUtils.isEmpty((String)value)) {
            idArrays = StringUtils.split((String)value, (String)"\u2014\u2014");
            paramMap.put("cmpreport_admin_mul", idArrays);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("prmtSingleAdminOrg")))) {
            paramMap.put("cmpreport_admin_single", value);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("prmtCmpPeriod")))) {
            paramMap.put("cmpreport_period_start", value);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("prmtCmpScheme")))) {
            paramMap.put("cmpreport_scheme_single", value);
        }
        return paramMap;
    }

    protected CmpReportFilterF7Info getF7Info(Map paramMap) throws BOSException, EASBizException {
        ICmpCommonFacade cmpCommonFacade = CmpCommonFacadeFactory.getRemoteInstance();
        CmpReportFilterF7Info f7Info = cmpCommonFacade.getF7InfoFromFilterUI(paramMap);
        return f7Info;
    }
}

