/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.affair.Affair2FacadeFactory;
import com.kingdee.eas.hr.affair.AffairHistoryFactory;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.EnrollBillEntryCollection;
import com.kingdee.eas.hr.affair.EnrollBillEntryFactory;
import com.kingdee.eas.hr.affair.EnrollBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBillEntryCollection;
import com.kingdee.eas.hr.affair.FluctuationBillEntryFactory;
import com.kingdee.eas.hr.affair.FluctuationBillEntryInfo;
import com.kingdee.eas.hr.affair.HireBillEntryFactory;
import com.kingdee.eas.hr.affair.HireBillEntryInfo;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.compensation.AdjHistoryFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeFactory;
import com.kingdee.eas.hr.compensation.EMPsCmpScheme;
import com.kingdee.eas.hr.compensation.FillFillException;
import com.kingdee.eas.hr.compensation.IAdjHistoryFacade;
import com.kingdee.eas.hr.compensation.ICmpAdjustFacade;
import com.kingdee.eas.hr.compensation.ICmpAdjustScheme;
import com.kingdee.eas.hr.compensation.client.AbstractEmpTransformListUI;
import com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI;
import com.kingdee.eas.hr.compensation.client.HRBaseQueryPanelUI;
import com.kingdee.eas.hr.compensation.client.SelectAdjCmpSchUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class EmpTransformListUI
extends AbstractEmpTransformListUI {
    private static final String AFFAIRTYPE_COL_NAME = "affairType";
    private static final String ID_COL_NAME = "id";
    private static final String BELONGSCH_COL_NAME = "belongCmpSch";
    private static final String TUNEDSCH_COL_NAME = "tunedCmpSch";
    private static final String TRANSFORMDATE_COL_NAME = "affairDate";
    private static final String EMPNAME_COL_NAME = "person.name";
    private static final String EMPNAME_COL_NUMBER = "person.number";
    private static final String EMPNAME_COL_ID = "person.id";
    private CommonQueryDialog dialog = null;
    private boolean isFirstDefaultQuery = true;
    private EntityViewInfo entityViewInfoResult = null;
    private static final Logger log = Logger.getLogger(EmpTransformListUI.class);
    public boolean REFRESH = true;
    private Map empsSchemeMap = null;

    public EmpTransformListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.loadFilterUI(true);
    }

    public void loadFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = EmpTransformListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            boolean isNullWhere = false;
            int size = solution.getQueryPanelInfo().size();
            for (int i = 0; i < size; ++i) {
                if (solution.getQueryPanelInfo().get(i) == null || solution.getQueryPanelInfo().get(i).getCustomerParams() == null) continue;
                isNullWhere = true;
            }
            if (isNullWhere) {
                this.mainQuery = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                this.mainQuery.getFilter().mergeFilter(this.getEntityViewInfo(new EntityViewInfo()).getFilter(), "and");
            } else {
                this.showQueryDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showQueryDialog();
        }
    }

    public void showQueryDialog() throws EASBizException, BOSException {
        HRBaseQueryPanelUI hrBaseQueryPanelUI = null;
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setWidth(400);
            this.dialog.setHeight(300);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.CmpFilterTitleResource", (String)"EmpTransformListUI_title"));
            try {
                hrBaseQueryPanelUI = new HRBaseQueryPanelUI();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
            this.dialog.addUserPanel((KDPanel)hrBaseQueryPanelUI);
        }
        if (this.dialog.show()) {
            this.mainQuery = null;
            this.entityViewInfoResult = new EntityViewInfo();
            this.mainQuery = this.getEntityViewInfo(new EntityViewInfo());
            this.mainQuery.getSorter().addObjectCollection((IObjectCollection)this.dialog.getCommonSorters());
            this.entityViewInfoResult = this.dialog.getEntityViewInfoResult();
            if (FilterUtility.hasFilterItem((FilterInfo)this.entityViewInfoResult.getFilter())) {
                this.mainQuery.getFilter().mergeFilter(this.entityViewInfoResult.getFilter(), "and");
            }
            this.doQuery(this.dialog);
            this.tblMain.removeRows();
        } else {
            SysUtil.abort();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected void initListener() {
        super.initListener();
        this.initCtl();
    }

    private void initCtl() {
        KDComboBox cbBox = new KDComboBox();
        cbBox.addItems(AffairTypeEnum.getEnumList().toArray());
        this.tblMain.getColumn(AFFAIRTYPE_COL_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbBox));
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    EmpTransformListUI.this.fillCmpScheme(e);
                }
                catch (Exception e1) {
                    EmpTransformListUI.this.handUIException(e1);
                }
            }
        });
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ATTACHTypeRela.ID", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        filter.getFilterItems().add(new FilterItemInfo("ATTACHORGRANGE.Type", (Object)20));
        filter.getFilterItems().add(new FilterItemInfo("ATTACHPMUSER.id", (Object)userid));
        CompUtils.addPermissionFilter(filter, EMPNAME_COL_ID);
        return filter;
    }

    private void getEmpsSchemeData() {
        try {
            ICmpAdjustFacade adjFacade = CmpAdjustFacadeFactory.getRemoteInstance();
            this.empsSchemeMap = adjFacade.getTransEmpsCmpScheme();
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
    }

    private void fillCmpScheme(KDTDataRequestEvent e) throws EASDBException, EASBizException, BOSException {
        if (this.empsSchemeMap != null) {
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                Object emp;
                IRow row = this.tblMain.getRow(i);
                String rowID = (String)row.getCell(0).getValue();
                Object value = this.empsSchemeMap.get(rowID);
                EMPsCmpScheme empScheme = null;
                if (value != null) {
                    empScheme = (EMPsCmpScheme)value;
                    empScheme.tag = 0;
                }
                if ((emp = row.getCell(EMPNAME_COL_NAME).getValue()) != null && empScheme != null) {
                    empScheme.empName = (String)emp;
                }
                row.getCell(BELONGSCH_COL_NAME).setValue((Object)empScheme);
            }
        }
    }

    public void onLoad() throws Exception {
        if (this.isBillUpdate()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"370_EmpTransformListUI"));
            SysUtil.abort();
        }
        super.onLoad();
    }

    private boolean isBillUpdate() throws BOSException {
        HRInitCollection upgrade = HRInitFactory.getRemoteInstance().getHRInitCollection("where key = 'BILL_UPGRADE'");
        return upgrade != null && upgrade.size() > 0;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionDispose_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks.size() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.EmpTransformResource.SELECT_ONEDISPOSEEMP"));
            return;
        }
        super.actionDispose_actionPerformed(e);
        List disposeEmpIDList = this.getDisposeList(blocks);
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.EmpTransformResource.COMFIRM_DELETE")))) {
            IAdjHistoryFacade adjHisFacade = AdjHistoryFacadeFactory.getRemoteInstance();
            adjHisFacade.disposeAdjItem(disposeEmpIDList);
            this.actionRefresh_actionPerformed(e);
        }
    }

    private List getDisposeList(List blocks) throws FillFillException {
        int size = blocks.size();
        ArrayList<Object> lst = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            KDTBlock block = (KDTBlock)blocks.get(i);
            int jsize = block.getBottom();
            for (int j = block.getTop(); j <= jsize; ++j) {
                if (j == -1) continue;
                if (((Boolean)this.tblMain.getRow(j).getCell("isTuned").getValue()).booleanValue()) {
                    throw new FillFillException(FillFillException.HAS_DEAL);
                }
                lst.add(this.tblMain.getRow(j).getCell(ID_COL_NAME).getValue());
            }
        }
        return lst;
    }

    @Override
    public void actionProcess_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcess_actionPerformed(e);
        ArrayList selBlks = this.tblMain.getSelectManager().getBlocks();
        if (selBlks == null || selBlks.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.EmpTransformResource", (String)"SELECT_EMP"));
            return;
        }
        if (this.tblMain.getSelectManager().getActiveRowIndex() == -1) {
            return;
        }
        List lstDispose = this.getDisposeList(selBlks);
        Map mapPerson = this.getSelectedPerson(selBlks);
        Map ctx = this.getUIContext();
        ctx.put("ADJUSTSCHEMEEDITUIPARM", mapPerson);
        ctx.put("FromEmpTransformListUI", "true");
        IUIWindow adjEditUI = UIFactory.createUIFactory((String)this.getEditUIModal()).create("com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI", ctx, null, OprtState.ADDNEW);
        adjEditUI.show();
        if (AdjustSchemeEditUI.isSubmited) {
            IAdjHistoryFacade adjHisFacade = AdjHistoryFacadeFactory.getRemoteInstance();
            adjHisFacade.disposeAdjItem(lstDispose);
            AdjustSchemeEditUI.isSubmited = false;
        }
        this.actionRefresh_actionPerformed(e);
    }

    private Map getEmpTransformDate() {
        HashMap<String, Object> rst = new HashMap<String, Object>();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell obj = row.getCell(BELONGSCH_COL_NAME);
            if (!(obj instanceof EMPsCmpScheme)) continue;
            EMPsCmpScheme data = (EMPsCmpScheme)obj;
            rst.put(data.empID, row.getCell(TRANSFORMDATE_COL_NAME).getValue());
        }
        return rst;
    }

    private Map getSelectedPerson(List selBlks) throws Exception {
        HashMap<String, HashMap> mapPerson = new HashMap<String, HashMap>(32);
        String personId = null;
        String name = null;
        String number = null;
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        String affairHisID = null;
        HashSet<String> personIDSet = new HashSet<String>();
        int size = selBlks.size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)selBlks.get(i);
            int end = block.getEndRow();
            for (int begin = block.getBeginRow(); begin <= end; ++begin) {
                IRow row = this.tblMain.getRow(begin);
                personId = row.getCell(EMPNAME_COL_ID).getValue().toString();
                personIDSet.add(personId);
                if (row.getCell(EMPNAME_COL_NAME).getValue() != null) {
                    name = row.getCell(EMPNAME_COL_NAME).getValue().toString();
                }
                if (row.getCell(EMPNAME_COL_NUMBER).getValue() != null) {
                    number = row.getCell(EMPNAME_COL_NUMBER).getValue().toString();
                }
                if (row.getCell(ID_COL_NAME).getValue() != null) {
                    affairHisID = row.getCell(ID_COL_NAME).getValue().toString();
                }
                tmp = new HashMap();
                tmp.put("name", name);
                tmp.put("number", number);
                tmp.put("affairHisID", affairHisID);
                tmp.put("effectDate", row.getCell(TRANSFORMDATE_COL_NAME).getValue());
                String entryID = null;
                String bosType = null;
                if (row.getCell("entrybillID").getValue() != null) {
                    SelectorItemCollection sic;
                    FilterInfo filterInfo;
                    EntityViewInfo viewInfo;
                    entryID = row.getCell("entrybillID").getValue().toString();
                    bosType = BOSUuid.read((String)entryID).getType().toString();
                    if ("5681143E".equals(bosType)) {
                        viewInfo = new EntityViewInfo();
                        filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("bill.bizState", (Object)3));
                        filterInfo.getFilterItems().add(new FilterItemInfo(ID_COL_NAME, (Object)entryID));
                        viewInfo.setFilter(filterInfo);
                        sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo(ID_COL_NAME));
                        sic.add(new SelectorItemInfo("oldPosition.id"));
                        sic.add(new SelectorItemInfo("oldPosition.name"));
                        sic.add(new SelectorItemInfo("oldPosition.number"));
                        sic.add(new SelectorItemInfo("newPosition.id"));
                        sic.add(new SelectorItemInfo("newPosition.name"));
                        sic.add(new SelectorItemInfo("newPosition.number"));
                        sic.add(new SelectorItemInfo("oldJobLevel.id"));
                        sic.add(new SelectorItemInfo("oldJobLevel.name"));
                        sic.add(new SelectorItemInfo("oldJobLevel.number"));
                        sic.add(new SelectorItemInfo("newJobLevel.id"));
                        sic.add(new SelectorItemInfo("newJobLevel.number"));
                        sic.add(new SelectorItemInfo("newJobLevel.name"));
                        sic.add(new SelectorItemInfo("oldPosType.id"));
                        sic.add(new SelectorItemInfo("oldPosType.number"));
                        sic.add(new SelectorItemInfo("oldPosType.name"));
                        sic.add(new SelectorItemInfo("newPosType.id"));
                        sic.add(new SelectorItemInfo("newPosType.number"));
                        sic.add(new SelectorItemInfo("newPosType.name"));
                        sic.add(new SelectorItemInfo("nowSalePoint.id"));
                        sic.add(new SelectorItemInfo("nowSalePoint.name"));
                        sic.add(new SelectorItemInfo("nowSalePoint.number"));
                        sic.add(new SelectorItemInfo("newSalePoint.id"));
                        sic.add(new SelectorItemInfo("newSalePoint.name"));
                        sic.add(new SelectorItemInfo("newSalePoint.number"));
                        sic.add(new SelectorItemInfo("newSalePoint.parent.id"));
                        sic.add(new SelectorItemInfo("newSalePoint.parent.name"));
                        sic.add(new SelectorItemInfo("newSalePoint.parent.number"));
                        sic.add(new SelectorItemInfo("newAdminOrg.id"));
                        sic.add(new SelectorItemInfo("newAdminOrg.name"));
                        sic.add(new SelectorItemInfo("newAdminOrg.displayname"));
                        sic.add(new SelectorItemInfo("oldPosition.adminOrgUnit.id"));
                        sic.add(new SelectorItemInfo("oldPosition.adminOrgUnit.name"));
                        sic.add(new SelectorItemInfo("oldPosition.adminOrgUnit.displayname"));
                        viewInfo.setSelector(sic);
                        FluctuationBillEntryCollection fluctuationCollection = FluctuationBillEntryFactory.getRemoteInstance().getFluctuationBillEntryCollection(viewInfo);
                        FluctuationBillEntryInfo fluctuationBillEntryInfo = null;
                        if (fluctuationCollection != null && fluctuationCollection.size() > 0) {
                            fluctuationBillEntryInfo = fluctuationCollection.get(0);
                            tmp.put("oldPosition", fluctuationBillEntryInfo.getOldPosition());
                            tmp.put("newPosition", fluctuationBillEntryInfo.getNewPosition());
                            tmp.put("oldJOBLev", fluctuationBillEntryInfo.getOldJobLevel());
                            tmp.put("newJOBLev", fluctuationBillEntryInfo.getNewJobLevel());
                            tmp.put("newPosType", fluctuationBillEntryInfo.getNewPosType());
                            tmp.put("oldPosType", fluctuationBillEntryInfo.getOldPosType());
                            tmp.put("nowSalePoint", fluctuationBillEntryInfo.getNowSalePoint());
                            tmp.put("newSalePoint", fluctuationBillEntryInfo.getNewSalePoint());
                            if (fluctuationBillEntryInfo.getOldPosition() != null && fluctuationBillEntryInfo.getOldPosition().getId() != null) {
                                tmp.put("oldAdmin", fluctuationBillEntryInfo.getOldPosition().getAdminOrgUnit());
                            }
                            tmp.put("newAdmin", fluctuationBillEntryInfo.getNewAdminOrg());
                        }
                    }
                    if ("25404999".equals(bosType)) {
                        viewInfo = new EntityViewInfo();
                        filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("bill.bizState", (Object)3));
                        filterInfo.getFilterItems().add(new FilterItemInfo(ID_COL_NAME, (Object)entryID));
                        viewInfo.setFilter(filterInfo);
                        sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo(ID_COL_NAME));
                        sic.add(new SelectorItemInfo("Position.id"));
                        sic.add(new SelectorItemInfo("Position.name"));
                        sic.add(new SelectorItemInfo("Position.number"));
                        sic.add(new SelectorItemInfo("JobLevel.id"));
                        sic.add(new SelectorItemInfo("JobLevel.name"));
                        sic.add(new SelectorItemInfo("JobLevel.number"));
                        sic.add(new SelectorItemInfo("positionType.id"));
                        sic.add(new SelectorItemInfo("positionType.number"));
                        sic.add(new SelectorItemInfo("positionType.name"));
                        sic.add(new SelectorItemInfo("xinDian.id"));
                        sic.add(new SelectorItemInfo("xinDian.name"));
                        sic.add(new SelectorItemInfo("xinDian.number"));
                        sic.add(new SelectorItemInfo("xinDian.parent.id"));
                        sic.add(new SelectorItemInfo("xinDian.parent.name"));
                        sic.add(new SelectorItemInfo("xinDian.parent.number"));
                        sic.add(new SelectorItemInfo("Position.adminOrgUnit.id"));
                        sic.add(new SelectorItemInfo("Position.adminOrgUnit.name"));
                        sic.add(new SelectorItemInfo("Position.adminOrgUnit.displayname"));
                        viewInfo.setSelector(sic);
                        EnrollBillEntryCollection enrollBillEntryCollection = EnrollBillEntryFactory.getRemoteInstance().getEnrollBillEntryCollection(viewInfo);
                        EnrollBillEntryInfo enrollenEntryInfo = null;
                        if (enrollBillEntryCollection != null && enrollBillEntryCollection.size() > 0) {
                            enrollenEntryInfo = enrollBillEntryCollection.get(0);
                            tmp.put("newPosition", enrollenEntryInfo.getPosition());
                            tmp.put("newJOBLev", enrollenEntryInfo.getJobLevel());
                            tmp.put("newPosType", enrollenEntryInfo.getPositionType());
                            tmp.put("newSalePoint", enrollenEntryInfo.getXinDian());
                            if (enrollenEntryInfo.getPosition() != null && enrollenEntryInfo.getPosition().getId() != null) {
                                tmp.put("newAdmin", enrollenEntryInfo.getPosition().getAdminOrgUnit());
                            }
                        }
                    }
                    if ("6EBA2704".equals(bosType)) {
                        viewInfo = new EntityViewInfo();
                        filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("bill.bizState", (Object)3));
                        filterInfo.getFilterItems().add(new FilterItemInfo(ID_COL_NAME, (Object)entryID));
                        viewInfo.setFilter(filterInfo);
                        sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo(ID_COL_NAME));
                        sic.add(new SelectorItemInfo("ePosition.id"));
                        sic.add(new SelectorItemInfo("ePosition.name"));
                        sic.add(new SelectorItemInfo("ePosition.number"));
                        sic.add(new SelectorItemInfo("JobLevel.id"));
                        sic.add(new SelectorItemInfo("JobLevel.name"));
                        sic.add(new SelectorItemInfo("JobLevel.number"));
                        sic.add(new SelectorItemInfo("newJobLevel.id"));
                        sic.add(new SelectorItemInfo("newJobLevel.number"));
                        sic.add(new SelectorItemInfo("newJobLevel.name"));
                        sic.add(new SelectorItemInfo("PositionType.id"));
                        sic.add(new SelectorItemInfo("PositionType.number"));
                        sic.add(new SelectorItemInfo("PositionType.name"));
                        sic.add(new SelectorItemInfo("nowSalePoint.id"));
                        sic.add(new SelectorItemInfo("nowSalePoint.name"));
                        sic.add(new SelectorItemInfo("nowSalePoint.number"));
                        sic.add(new SelectorItemInfo("newSalePoint.id"));
                        sic.add(new SelectorItemInfo("newSalePoint.name"));
                        sic.add(new SelectorItemInfo("newSalePoint.number"));
                        sic.add(new SelectorItemInfo("newSalePoint.parent.id"));
                        sic.add(new SelectorItemInfo("newSalePoint.parent.name"));
                        sic.add(new SelectorItemInfo("newSalePoint.parent.number"));
                        sic.add(new SelectorItemInfo("ePosition.adminOrgUnit.id"));
                        sic.add(new SelectorItemInfo("ePosition.adminOrgUnit.name"));
                        sic.add(new SelectorItemInfo("ePosition.adminOrgUnit.displayname"));
                        viewInfo.setSelector(sic);
                        CoreBaseCollection hireBillEntryCollection = HireBillEntryFactory.getRemoteInstance().getCollection(viewInfo);
                        HireBillEntryInfo hireBillEntryInfo = null;
                        if (hireBillEntryCollection != null && hireBillEntryCollection.size() > 0) {
                            hireBillEntryInfo = (HireBillEntryInfo)hireBillEntryCollection.get(0);
                            tmp.put("newPosition", hireBillEntryInfo.getEposition());
                            tmp.put("oldJOBLev", hireBillEntryInfo.getJobLevel());
                            tmp.put("newJOBLev", hireBillEntryInfo.getNewJobLevel());
                            tmp.put("newPosType", hireBillEntryInfo.getPositionType());
                            tmp.put("nowSalePoint", hireBillEntryInfo.getNowSalePoint());
                            tmp.put("newSalePoint", hireBillEntryInfo.getNewSalePoint());
                            if (hireBillEntryInfo.getEposition() != null && hireBillEntryInfo.getEposition().getId() != null) {
                                tmp.put("newAdmin", hireBillEntryInfo.getEposition().getAdminOrgUnit());
                            }
                        }
                    }
                }
                if (("91B41A02".equals(bosType) || "37A34A7D".equals(bosType) || "79E18FC8".equals(bosType) || "6EBA2704".equals(bosType)) && row.getCell(ID_COL_NAME).getValue() != null) {
                    Map historyMap = Affair2FacadeFactory.getRemoteInstance().getHistoryRefInfo(row.getCell(ID_COL_NAME).getValue().toString());
                    tmp.put("oldPosition", historyMap.get("oldPosition"));
                    if (historyMap.get("oldPosType") != null) {
                        tmp.put("oldPosType", historyMap.get("oldPosType"));
                    }
                    if (tmp.get("oldJOBLev") == null) {
                        tmp.put("oldJOBLev", historyMap.get("oldJobLevel"));
                    }
                    tmp.put("oldAdmin", historyMap.get("oldAdmin"));
                    tmp.put("newAdmin", historyMap.get("newAdmin"));
                }
                mapPerson.put(personId, tmp);
            }
        }
        ICmpAdjustScheme ica = CmpAdjustSchemeFactory.getRemoteInstance();
        HashMap effDateMap = ica.getPersonLastAdjDate(personIDSet);
        mapPerson.put("effDateMap", effDateMap);
        return mapPerson;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionProcess.setEnabled(true);
        this.btnProc.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.actionDispose.setEnabled(true);
        this.btnDispose.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.tblMain.setColumnMoveable(true);
        this.menuItemProcess.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.menuItemDispose.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return SelectAdjCmpSchUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AffairHistoryFactory.getRemoteInstance();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
            return;
        }
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            ActionEvent event = null;
            event = new ActionEvent(this.btnProc, 0, "Double Clicked");
            ItemAction act = this.getActionFromActionEvent(event);
            act.actionPerformed(event);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    public static class TransformData {
        private String affairID = "";
        private String cmpSchemeID = "";
        private String cmpSchemeName = "";
        private String empID = "";
        private String empName = "";
        private Date tranformDate = null;

        public String getAffairID() {
            return this.affairID;
        }

        public void setAffairID(String affID) {
            this.affairID = affID;
        }

        public String getCmpSchemeID() {
            return this.cmpSchemeID;
        }

        public void setCmpSchemeID(String cmpSchemeID) {
            this.cmpSchemeID = cmpSchemeID;
        }

        public String getCmpSchemeName() {
            return this.cmpSchemeName;
        }

        public void setCmpSchemeName(String cmpSchemeName) {
            this.cmpSchemeName = cmpSchemeName;
        }

        public String getEmpID() {
            return this.empID;
        }

        public void setEmpID(String empID) {
            this.empID = empID;
        }

        public String getEmpName() {
            return this.empName;
        }

        public void setEmpName(String empName) {
            this.empName = empName;
        }

        public Date getTranformDate() {
            return this.tranformDate;
        }

        public void setTranformDate(Date tranformDate) {
            this.tranformDate = tranformDate;
        }
    }
}

