/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.client.AbstractFillDeductFillPayQueryUI;
import com.kingdee.eas.hr.compensation.client.FillFillQueryInfo;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FillDeductFillPayQueryUI
extends AbstractFillDeductFillPayQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(FillDeductFillPayQueryUI.class);
    private boolean isLoadScheme = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompeScheme.setRequired(true);
        this.prmtPayCmpPeriod.setRequired(true);
        this.chkShowFullName.setVisible(false);
        if (!this.isLoadScheme) {
            this.chkConSubOrg.setEnabled(false);
            this.chkShowFullName.setEnabled(false);
            this.comboSubLevel.setEnabled(false);
        }
        CompUtils.initF7SelectorNoHR(this, this.prmtOrg);
        this.initCmpPeriodF7();
        this.initPersonF7();
        HRSchemeUtils.getEnableCmpSchemeF7(this.prmtCompeScheme);
        this.prmtOrg.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    FillDeductFillPayQueryUI.this.initComboBox(e);
                    FillDeductFillPayQueryUI.this.comboSubLevel.setEnabled(false);
                    FillDeductFillPayQueryUI.this.chkConSubOrg.setSelected(false);
                }
                catch (Exception e1) {
                    FillDeductFillPayQueryUI.this.handUIException(e1);
                }
            }
        });
    }

    public void initPersonF7() {
        EmployeeMultiF7PromptBox select = new EmployeeMultiF7PromptBox((IUIObject)this);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        viewInfo.setFilter(filter);
        IUserPermission iup = null;
        UserPermissionCollection collection = null;
        try {
            iup = UserPermissionFactory.getRemoteInstance();
            collection = iup.getUserPermissionCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
            ExceptionHandler.handle((Throwable)e);
        }
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        try {
            filter = new FilterInfo(filterString);
        }
        catch (ParserException e) {
            logger.info((Object)e.getMessage());
            ExceptionHandler.handle((Throwable)e);
        }
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        try {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
            ExceptionHandler.handle((Throwable)e);
        }
        select.setNopositionPersonFilter(filter);
        select.setRefresh(false);
        select.setModal(true);
        select.showNoPositionPerson(true);
        select.showOnlyPayPerson(true);
        select.setUserOrgRangeFilter(true);
        select.setReturnPositionAndUnit(false);
        select.setIsSingleSelect(true);
        this.prmtEmp.setSelector((KDPromptSelector)select);
        this.prmtEmp.setEditFormat("$number$");
        this.prmtEmp.setCommitFormat("$number$");
        this.prmtEmp.setDisplayFormat("$name$");
        this.prmtEmp.setEditable(true);
    }

    private void initComboBox(PreChangeEvent e) throws Exception {
        this.comboSubLevel.removeAllItems();
        if (e.getData() == null) {
            return;
        }
        int level = this.getAdminOrgLevelCount((AdminOrgUnitInfo)e.getData());
        this.comboSubLevel.setEnabled(false);
        if (level == 0) {
            this.chkConSubOrg.setSelected(false);
            this.chkConSubOrg.setEnabled(false);
        } else {
            this.chkConSubOrg.setEnabled(true);
        }
        this.initComBox(level);
    }

    private void initComBox(int level) {
        for (int i = 1; i <= level; ++i) {
            this.comboSubLevel.addItem((Object)i);
        }
        if (level > 1) {
            this.comboSubLevel.setSelectedIndex(1);
        }
    }

    protected int getAdminOrgLevelCount(AdminOrgUnitInfo info) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber()));
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
        fi.setMaskString("(#0 or #1)");
        viewInfo.setFilter(fi);
        SorterItemInfo sortInfo = new SorterItemInfo("level");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection coll = iAdmin.getAdminOrgUnitCollection(viewInfo);
        if (coll != null) {
            int size = coll.size();
            if (size <= 1) {
                return 0;
            }
            if (size > 1) {
                return coll.get(size - 1).getLevel() - coll.get(0).getLevel();
            }
        }
        return 0;
    }

    @Override
    protected void chkConSubOrg_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkConSubOrg.isSelected()) {
            this.comboSubLevel.setEnabled(true);
        } else {
            this.comboSubLevel.setEnabled(false);
        }
    }

    private void initCmpPeriodF7() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableState", (Object)"0"));
        filterInfo.setMaskString("#0 and #1");
        CompUtils.initF7Selector(filterInfo, this.prmtPayCmpPeriod, "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        AdminOrgUnitInfo org = (AdminOrgUnitInfo)this.prmtOrg.getData();
        PersonInfo person = (PersonInfo)this.prmtEmp.getData();
        CmpSchemeInfo cmpSchemeInfo = (CmpSchemeInfo)this.prmtCompeScheme.getData();
        CmpPeriodInfo payPeriodInfo = (CmpPeriodInfo)this.prmtPayCmpPeriod.getData();
        Integer level = 0;
        try {
            if (org != null) {
                level = org.getLevel();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (this.prmtOrg.getData() != null && this.chkConSubOrg.isSelected()) {
            Integer nowlevel = null;
            nowlevel = this.comboSubLevel.getSelectedItem() != null ? Integer.valueOf((Integer)this.comboSubLevel.getSelectedItem() + level) : level;
            filter.getFilterItems().add(new FilterItemInfo("admin.level", (Object)level, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("admin.level", (Object)nowlevel, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            if (person != null) {
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString(), CompareType.EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4");
            }
        } else if (this.prmtOrg.getData() != null) {
            filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)org.getLongNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            if (person != null) {
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString(), CompareType.EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3 and #4");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3");
            }
        } else if (person != null) {
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            filter.setMaskString("#0 and #1 and #2");
        }
        return filter;
    }

    public FillFillQueryInfo getQryFilter() throws BOSException {
        FillFillQueryInfo qryFilter = new FillFillQueryInfo();
        if (this.prmtOrg.getData() != null) {
            qryFilter.adminOrgUnit = ((AdminOrgUnitInfo)this.prmtOrg.getData()).getLongNumber().toString();
        }
        if (this.prmtEmp.getData() != null) {
            qryFilter.personinfo = (PersonInfo)this.prmtEmp.getData();
        }
        if (this.chkConSubOrg.isSelected()) {
            qryFilter.isLowLevel = true;
            if (this.comboSubLevel.getSelectedItem() != null) {
                qryFilter.level = (Integer)this.comboSubLevel.getSelectedItem();
            }
        } else {
            qryFilter.isLowLevel = false;
        }
        qryFilter.isDisplayName = this.chkShowFullName.isSelected();
        qryFilter.payPeriod = (CmpPeriodInfo)this.prmtPayCmpPeriod.getData();
        qryFilter.cmpSchemeInfo = (CmpSchemeInfo)this.prmtCompeScheme.getData();
        HRUtils.getCmpPeriodInfoByConstantClient(null, qryFilter.payPeriod, -1);
        if (this.txtTime.getIntegerValue() != null) {
            qryFilter.time = this.txtTime.getIntegerValue();
        }
        return qryFilter;
    }

    public void clear() {
        super.clear();
        this.prmtOrg.setData(null);
        this.comboSubLevel.removeAllItems();
        this.chkConSubOrg.setSelected(false);
        this.chkConSubOrg.setEnabled(false);
        this.chkShowFullName.setEnabled(false);
        this.comboSubLevel.setEnabled(false);
        this.prmtEmp.setData(null);
        this.prmtPayCmpPeriod.setData(null);
        this.prmtCompeScheme.setData(null);
        this.txtTime.setValue((Object)1);
        this.chkShowFullName.setSelected(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean("chkConSubOrg", this.chkConSubOrg.isSelected());
        cp.putBoolean("chkShowFullName", this.chkShowFullName.isSelected());
        if (this.comboSubLevel.getSelectedItem() != null) {
            cp.putInt("level", ((Integer)this.comboSubLevel.getSelectedItem()).intValue());
        }
        CommonQueryUtil.getAdminFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.prmtOrg);
        CommonQueryUtil.getPerFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.prmtEmp);
        CommonQueryUtil.getCmpFromQueryPanel((String)"cmpPeriod", (CustomerParams)cp, (KDBizPromptBox)this.prmtPayCmpPeriod);
        this.saveCmpScheme(cp);
        cp.addCustomerParam("CmpTime", this.txtTime.getIntegerValue().toString());
        return cp;
    }

    protected void saveCmpScheme(CustomerParams cp) {
        if (this.prmtCompeScheme.getData() != null) {
            cp.addCustomerParam("cmpScheme", ((CmpSchemeInfo)this.prmtCompeScheme.getData()).getId().toString());
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        this.isLoadScheme = true;
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("adminOrg") != null) {
            this.prmtOrg.setData((Object)CommonQueryUtil.getAdminOrgUnitInfo((String)"adminOrg", (CustomerParams)cp));
            try {
                this.comboSubLevel.removeAllItems();
                int level = this.getAdminOrgLevelCount((AdminOrgUnitInfo)this.prmtOrg.getData());
                this.comboSubLevel.setEnabled(false);
                if (level == 0) {
                    this.chkConSubOrg.setSelected(false);
                    this.chkConSubOrg.setEnabled(false);
                } else {
                    this.chkConSubOrg.setEnabled(true);
                }
                this.initComBox(level);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            this.chkConSubOrg.setSelected(cp.getBoolean("chkConSubOrg"));
            this.chkShowFullName.setSelected(cp.getBoolean("chkShowFullName"));
            this.comboSubLevel.setSelectedItem((Object)cp.getInt("level"));
            this.chkConSubOrg.setEnabled(true);
            this.chkShowFullName.setEnabled(true);
            this.comboSubLevel.setEnabled(true);
        } else {
            this.prmtOrg.setData(null);
            this.chkConSubOrg.setSelected(false);
            this.comboSubLevel.removeAllItems();
            this.chkConSubOrg.setEnabled(false);
            this.chkShowFullName.setEnabled(false);
            this.comboSubLevel.setEnabled(false);
        }
        this.chkConSubOrg.setSelected(cp.getBoolean("chkConSubOrg"));
        this.chkShowFullName.setSelected(cp.getBoolean("chkShowFullName"));
        if (cp.getCustomerParam("person") != null) {
            CommonQueryUtil.setPerFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.prmtEmp);
        } else {
            this.prmtEmp.setData(null);
        }
        CommonQueryUtil.setCmpFromQueryPanel((String)"cmpPeriod", (CustomerParams)cp, (KDBizPromptBox)this.prmtPayCmpPeriod);
        if (cp.getCustomerParam("CmpTime") != null) {
            this.txtTime.setValue((Object)Integer.valueOf(cp.getCustomerParam("CmpTime")));
        } else {
            this.txtTime.setValue((Object)1);
        }
        this.restoreCmpScheme(cp);
    }

    protected void restoreCmpScheme(CustomerParams cp) {
        try {
            ICmpScheme iCmpScheme = CmpSchemeFactory.getRemoteInstance();
            CmpSchemeInfo info = iCmpScheme.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("cmpScheme")));
            this.prmtCompeScheme.setData((Object)info);
        }
        catch (Exception e) {
            this.prmtCompeScheme.setData(null);
            this.prmtCompeScheme.requestFocus();
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"236_CmpReportFilterBaseUI"));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null) {
            this.chkShowFullName.setEnabled(true);
        } else {
            this.chkShowFullName.setEnabled(false);
        }
    }

    public boolean verify() {
        if (this.prmtPayCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.FillFillResource.PAYCMP_NOT_NULL"));
            return false;
        }
        if (this.prmtCompeScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.FillFillResource.CMPSCHEME_NOT_NULL"));
            return false;
        }
        if (this.prmtPayTo.getData() != null) {
            CmpPeriodInfo end = (CmpPeriodInfo)this.prmtPayTo.getData();
            CmpPeriodInfo payCmpPeriod = (CmpPeriodInfo)this.prmtPayCmpPeriod.getData();
            if (end.getEndDate().after(payCmpPeriod.getBeginDate())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.FillFillResource.FILL_NOT_GREATER"));
                return false;
            }
        }
        if (this.txtTime.getIntegerValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.PeriodEndInputResource.CMP_TIME"));
            return false;
        }
        int timeCon = this.txtTime.getNumberValue().intValue();
        if (timeCon < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.PeriodEndInputResource.CMP_TIME_CON"));
            this.txtTime.requestFocusInWindow();
            return false;
        }
        return super.verify();
    }

    public int getTime() {
        return this.txtTime.getIntegerValue();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

