/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.client.AbstractFixedCmpSchemeReportFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpReportFilterBaseUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FixedCmpSchemeReportFilterUI
extends AbstractFixedCmpSchemeReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FixedCmpSchemeReportFilterUI.class);
    String resClass = "com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource.";
    private final String ALLLISTITEM_CP = "allListItem";
    private final String LSTSELECTITEM_CP = "lstSelectItem";
    private ArrayList hrOrgList;
    private ArrayList adminOrgList;
    private String fixcmpHrOrgId;
    private final String RADIOBTN = "radiobtn";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminOrgUnit, false);
        this.countByOrg.setSelected(true);
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminOrgUnit, this.chkShowSealUp.isSelected());
    }

    protected void initListener() {
        super.initListener();
        this.prmtAdminOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    FixedCmpSchemeReportFilterUI.this.lstAllItem.removeAllElements();
                    FixedCmpSchemeReportFilterUI.this.lstSelectItem.removeAllElements();
                    FixedCmpSchemeReportFilterUI.this.adminOrgList = FixedCmpSchemeReportFilterUI.this.getAdminOrgUnitList();
                    if (FixedCmpSchemeReportFilterUI.this.adminOrgList != null && FixedCmpSchemeReportFilterUI.this.adminOrgList.size() > 0) {
                        FixedCmpSchemeReportFilterUI.this.hrOrgList = FixedCmpSchemeReportFilterUI.this.getHrOrgUnitList(FixedCmpSchemeReportFilterUI.this.adminOrgList);
                    } else {
                        FixedCmpSchemeReportFilterUI.this.hrOrgList = new ArrayList();
                        FixedCmpSchemeReportFilterUI.this.hrOrgList.add(SysContext.getSysContext().getCurrentHRUnit());
                    }
                    CmpItemCollection itemCol = FixedCmpSchemeReportFilterUI.this.getCmpItemCollection();
                    FixedCmpSchemeReportFilterUI.this.fillCmpItem(itemCol);
                }
                catch (Exception exc) {
                    FixedCmpSchemeReportFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrgUnit.setData(null);
        this.lstAllItem.removeAll();
        this.lstSelectItem.removeAll();
        this.countByOrg.setSelected(true);
        this.displayAllName.setSelected(false);
        this.chkShowSealUp.setSelected(false);
        this.radiobtn0.setSelected(true);
        if (this.adminOrgList != null) {
            this.adminOrgList.clear();
        }
        if (this.hrOrgList != null) {
            this.hrOrgList.clear();
        }
    }

    public boolean verify() {
        if (this.hrOrgList != null && this.hrOrgList.size() == 0 && this.adminOrgList != null && this.adminOrgList.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MSG_ADMIN_ORG_NOTEXITS_HR_ORG")));
            this.prmtAdminOrgUnit.requestFocusInWindow();
            return false;
        }
        if (this.lstSelectItem.getElementCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MSG_CHOOSE_FIXED_CMPITEM")));
            this.lstAllItem.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void fillCmpItem(CmpItemCollection itemCol) {
        Iterator itemIterator = itemCol.iterator();
        while (itemIterator.hasNext()) {
            CmpItemInfo fixItem = (CmpItemInfo)itemIterator.next();
            this.lstAllItem.addElement((Object)fixItem);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtAdminOrgUnit.getData() != null) {
            ArrayList adminlist = this.getAdminOrgUnitList();
            String adminOrgStr = HRUtils.getOrgIdString(adminlist);
            cp.addCustomerParam("adminOrgUnit", adminOrgStr);
        }
        cp.addCustomerParam("emptyDisplayNull", String.valueOf(this.emptyDisplayNull.isSelected()));
        cp.addCustomerParam("countByOrg", String.valueOf(this.countByOrg.isSelected()));
        cp.addCustomerParam("countByPerson", String.valueOf(this.countByPerson.isSelected()));
        cp.addCustomerParam("displayAllName", String.valueOf(this.displayAllName.isSelected()));
        cp.addCustomerParam("isShowSealUp", String.valueOf(this.chkShowSealUp.isSelected()));
        cp.addCustomerParam("emptyDisplayNull", String.valueOf(this.emptyDisplayNull.isSelected()));
        cp.addCustomerParam(this.ALLLISTITEM_CP, this.allListStr());
        cp.addCustomerParam(this.LSTSELECTITEM_CP, this.selectListStr());
        if (this.radiobtn0.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn0");
        } else if (this.radiobtn2.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn2");
            cp.addCustomerParam("level", this.levelComboBox.getSelectedItem().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("radiobtn") == null || cp.getCustomerParam("radiobtn").equals("radiobtn0")) {
            this.radiobtn0.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn2")) {
            this.radiobtn2.setSelected(true);
            String level = cp.getCustomerParam("level");
            this.levelComboBox.setSelectedIndex(Integer.parseInt(level) - 1);
        }
        if (cp.getCustomerParam("emptyDisplayNull") != null) {
            this.emptyDisplayNull.setSelected(Boolean.valueOf(cp.getCustomerParam("emptyDisplayNull")).booleanValue());
        }
        if (cp.getCustomerParam("countByOrg") != null) {
            this.countByOrg.setSelected(Boolean.valueOf(cp.getCustomerParam("countByOrg")).booleanValue());
        }
        if (cp.getCustomerParam("countByPerson") != null) {
            this.countByPerson.setSelected(Boolean.valueOf(cp.getCustomerParam("countByPerson")).booleanValue());
        }
        if (cp.getCustomerParam("displayAllName") != null) {
            this.displayAllName.setSelected(Boolean.valueOf(cp.getCustomerParam("displayAllName")).booleanValue());
        }
        if (cp.getCustomerParam("isShowSealUp") != null) {
            this.chkShowSealUp.setSelected(Boolean.valueOf(cp.getCustomerParam("isShowSealUp")).booleanValue());
        }
        if (cp.getCustomerParam("emptyDisplayNull") != null) {
            this.emptyDisplayNull.setSelected(Boolean.valueOf(cp.getCustomerParam("emptyDisplayNull")).booleanValue());
        }
        this.prmtAdminOrgUnit.setData(null);
        if (cp.getCustomerParam("adminOrgUnit") != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            String orgIds = cp.getCustomerParam("adminOrgUnit");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgIds, CompareType.INNER));
            entityViewInfo.setFilter(filterInfo);
            try {
                AdminOrgUnitCollection admOrgCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(entityViewInfo);
                this.prmtAdminOrgUnit.setData((Object)admOrgCollection.toArray());
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        String allListStr = cp.getCustomerParam(this.ALLLISTITEM_CP);
        this.setAllItem(allListStr);
        String ids = cp.getCustomerParam(this.LSTSELECTITEM_CP);
        this.setLstSelectItem(ids);
        super.setCustomerParams(cp);
    }

    private ArrayList getAdminOrgUnitList() {
        Object adminOrg = this.prmtAdminOrgUnit.getData();
        ArrayList<AdminOrgUnitInfo> orgUnitList = new ArrayList<AdminOrgUnitInfo>();
        if (adminOrg != null) {
            AdminOrgUnitInfo[] info = this.getAdminOrgUnitInfoArrayByObject((Object[])adminOrg);
            int size = info.length;
            for (int i = 0; i < size; ++i) {
                orgUnitList.add(info[i]);
            }
        }
        return orgUnitList;
    }

    private ArrayList getHrOrgUnitList(ArrayList adminOrgList) throws Exception {
        CmpReportFilterBaseUI baseUi = new CmpReportFilterBaseUI();
        ArrayList hrOrgList = baseUi.getSelectHROS(adminOrgList);
        return hrOrgList;
    }

    private AdminOrgUnitInfo[] getAdminOrgUnitInfoArrayByObject(Object[] objA) {
        AdminOrgUnitInfo[] info = new AdminOrgUnitInfo[objA.length];
        int size = objA.length;
        for (int i = 0; i < size; ++i) {
            info[i] = (AdminOrgUnitInfo)objA[i];
        }
        return info;
    }

    public List getListSelectItem() {
        ArrayList<CmpItemInfo> listSelectList = new ArrayList<CmpItemInfo>();
        int countListSelectItem = this.lstSelectItem.getElementCount();
        if (countListSelectItem > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < countListSelectItem; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(i);
                listSelectList.add(i, info);
            }
        }
        return listSelectList;
    }

    private CmpItemCollection getCmpItemCollection() throws Exception {
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        if (this.hrOrgList.size() == 0) {
            return cmpItemColl;
        }
        CmpReportFilterBaseUI baseUi = new CmpReportFilterBaseUI();
        String fixcmpHrOrgId = baseUi.getRootHROID(this.hrOrgList);
        StringBuffer sql = new StringBuffer("SELECT DISTINCT T1.FNumber ");
        sql.append("FROM T_HR_CMPITEM T1 ");
        sql.append("INNER JOIN T_HR_FixedCmpSchemeItem T2 ON T1.FID = T2.FCmpItemID ");
        sql.append("INNER JOIN T_HR_FixedCmpScheme T3 ON T3.FID = T2.FFixedCmpSchemeID ");
        sql.append("WHERE T3.FHrOrgUnitID IN (");
        int size = this.hrOrgList.size() - 1;
        for (int i = 0; i < size; ++i) {
            sql.append("'");
            sql.append(((HROrgUnitInfo)this.hrOrgList.get(i)).getId());
            sql.append("',");
        }
        sql.append("'");
        sql.append(((HROrgUnitInfo)this.hrOrgList.get(this.hrOrgList.size() - 1)).getId());
        sql.append("') and T3.FEnable = 1 ");
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)fixcmpHrOrgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)sql.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 and #1");
        env.setFilter(filterInfo);
        cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(env);
        return cmpItemColl;
    }

    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.insertElement((Object)info, indexSelect);
                this.lstAllItem.removeElement((Object)info);
                ++indexSelect;
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    protected void leftToRight() {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        this.rightToLeft();
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        this.allRightToLeftItem();
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        this.leftToRight();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        this.allLeftToRightItem();
    }

    protected void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
            }
            if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
        }
    }

    protected void rightToLeft() {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
            this.lstAllItem.addElement((Object)info);
            this.lstAllItem.setSelectedIndex(this.lstAllItem.getElementCount() - 1);
        }
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    private String allListStr() {
        StringBuffer allListArray = new StringBuffer();
        int allListItemSize = this.lstAllItem.getElementCount();
        int controlInt = allListItemSize - 1;
        for (int i = 0; i < allListItemSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstAllItem.getElement(i);
            allListArray.append(cmpItemInfo.getId().toString());
            if (i == controlInt) continue;
            allListArray.append("~");
        }
        return allListArray.toString();
    }

    private String selectListStr() {
        ArrayList<Object> lstSelectItemData = new ArrayList<Object>();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return HRCommonQueryUtils.getSelectedItemIDS(lstSelectItemData);
    }

    private void setAllItem(String allListStr) {
        this.lstAllItem.removeAllElements();
        if (allListStr != null) {
            String[] allListStrArray = allListStr.split("~");
            int arrayInt = allListStrArray.length;
            HashSet<String> keySet = new HashSet<String>();
            for (int i = 0; i < arrayInt; ++i) {
                keySet.add(allListStrArray[i]);
            }
            EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
            FilterInfo fitlerInfoTmp = new FilterInfo();
            fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            entityViewInfoTmp.setFilter(fitlerInfoTmp);
            try {
                CmpItemCollection cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(entityViewInfoTmp);
                int catalogSize = cmpItemColl.size();
                for (int i = 0; i < catalogSize; ++i) {
                    CmpItemInfo cmpItemInfo = cmpItemColl.get(i);
                    this.lstAllItem.addElement((Object)cmpItemInfo);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void setLstSelectItem(String ids) {
        if (ids != null && !"".equals(ids)) {
            try {
                List lstSelectItemData = HRCommonQueryUtils.getSelectedItemList(ids, "~");
                HRCommonQueryUtils.fillSelectItemList(lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public ArrayList getHrOrgList() throws Exception {
        if (this.hrOrgList == null) {
            this.hrOrgList = this.getHrOrgUnitList(this.adminOrgList);
        }
        return this.hrOrgList;
    }

    public ArrayList getAdminOrgList() {
        if (this.adminOrgList == null) {
            this.adminOrgList = this.getAdminOrgUnitList();
        }
        return this.adminOrgList;
    }

    public String getFixcmpHrOrgId() {
        return this.fixcmpHrOrgId;
    }

    public List getLstSelectItem() {
        ArrayList<CmpItemInfo> cmpItemList = new ArrayList<CmpItemInfo>();
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(i);
                cmpItemList.add(info);
            }
        }
        return cmpItemList;
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }
}

