/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.IDAPBillTrans;
import com.kingdee.eas.hr.compensation.GrantFactory;
import com.kingdee.eas.hr.compensation.client.AbstractGrantListUI;
import com.kingdee.eas.hr.compensation.client.GrantEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;

public class GrantListUI
extends AbstractGrantListUI {
    public GrantListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return GrantEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GrantFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLocate.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnCopyTo.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.tblMain.setColumnMoveable(true);
        this.menuItemLocate.setVisible(false);
        this.btnDelVoucher.setVisible(true);
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
    }

    protected boolean isBaseList() {
        return true;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.accountCredit.*"));
        sic.add(new SelectorItemInfo("entries.accountDebit.*"));
        sic.add(new SelectorItemInfo("entries.cmpItem.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("cmpPeriod.*"));
        return sic;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String adminRangeSql = HRSchemeUtils.getAdminByUserRange(null);
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminRangeSql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected OrgUnitInfo getBizDefineOrgUnit() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length < 1) {
            return null;
        }
        String companyID = this.tblMain.getRow(selectRows[0]).getCell("company.id").getValue().toString();
        CompanyOrgUnitInfo orgUnitInfo = null;
        try {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            EntityViewInfo eviColPeriod = new EntityViewInfo();
            FilterInfo infoFilter = new FilterInfo();
            infoFilter.getFilterItems().add(new FilterItemInfo("id", (Object)companyID, CompareType.EQUALS));
            eviColPeriod.setFilter(infoFilter);
            SelectorItemCollection sic = eviColPeriod.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("taxNumber"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.name"));
            sic.add(new SelectorItemInfo("CU.number"));
            CompanyOrgUnitCollection companyCollection = companyOrgUnit.getCompanyOrgUnitCollection(eviColPeriod);
            if (companyCollection.size() >= 1) {
                orgUnitInfo = companyCollection.get(0);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return orgUnitInfo;
    }

    protected void actionVoucherByID(IDAPBillTrans dapTransform, ActionEvent e) throws Exception {
        if (dapTransform == null) {
            return;
        }
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                if (this.tblMain.getRow(rowIndex).getCell("voucher.number").getValue() == null) continue;
                StringBuffer msg = new StringBuffer();
                msg.append(this.tblMain.getRow(rowIndex).getCell("cmpScheme.name").getValue()).append(EASResource.getString((String)"com.kingdee.eas.hr.compensation.GrantResource.VOUCHER_NUMBER_EXIST")).append(this.tblMain.getRow(rowIndex).getCell("voucher.number").getValue());
                MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
                SysUtil.abort();
            }
        }
        ArrayList idList = new ArrayList();
        ArrayList entriesKey = new ArrayList();
        this.getBillIdList(idList, entriesKey);
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        if (this.isDAPTrans()) {
            entriesKey.clear();
        }
        if (idList.size() > 0) {
            HashMap<String, OrgUnitInfo> ctx = new HashMap<String, OrgUnitInfo>();
            ctx.put("TRANSMITCUFROMBIZ", this.getBizDefineOrgUnit());
            boolean succ = dapTransform.trans(idArray, new String[]{this.getEntriesName()}, entriesKey, this.getBOTPSelectors(), ctx);
            if (succ) {
                this.refreshList();
            }
        }
    }
}

