/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.service.formula.api.IParaInputFormulaFunctions;
import com.kingdee.bos.service.formula.api.InvokeFunctionException;
import com.kingdee.bos.service.formula.api.funcpara.IFuncParaInputProvider;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.client.FuncInfo;
import com.kingdee.eas.hr.compensation.client.HRFuncGetYMDProvider;
import com.kingdee.eas.hr.compensation.client.HRFunctionCompareYearProvider;
import com.kingdee.eas.hr.compensation.client.HRFunctionGetFixedProvider;
import com.kingdee.eas.hr.compensation.client.HRFunctionGetPeriodDayProvider;
import com.kingdee.eas.hr.compensation.client.HRFunctionPersonAdjustAgeProvider;
import com.kingdee.eas.hr.compensation.client.HRFunctionPersonAgeProvider;
import com.kingdee.eas.hr.compensation.client.HrFunItemValueSumAdminProvider;
import com.kingdee.eas.hr.compensation.client.HrFuncParaGetOrgPerfProvider;
import com.kingdee.eas.hr.compensation.client.HrFuncParaGetPerfInputProvider;
import com.kingdee.eas.hr.compensation.client.HrFuncParaInputProvider;
import com.kingdee.eas.hr.compensation.client.HrFuncParaOtherInputProvider;
import com.kingdee.eas.hr.compensation.client.HrFunctionConditionSumProvider;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class HRFormulaFunction
implements IParaInputFormulaFunctions {
    private static Vector funcInfos = new Vector();
    private static HashSet specialFunctions = new HashSet(16);
    private static Locale locale;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
    private GregorianCalendar leapYearCalendar = new GregorianCalendar();

    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).funcName)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllFuncNames() {
        String[] funcNames = new String[funcInfos.size()];
        for (int i = 0; i < funcInfos.size(); ++i) {
            funcNames[i] = ((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).funcName;
        }
        return funcNames;
    }

    public String getFuncCategory(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).funcCategory;
        }
        return null;
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).funcDesc;
        }
        return null;
    }

    private Object now(List paramList) throws InvokeFunctionException {
        if (paramList != null && paramList.size() > 0) {
            throw new InvokeFunctionException("now", 1);
        }
        return this.dateFormat.format(new Date());
    }

    private Object convertJavaDate(List paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException("convertJavaDate", 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException("convertJavaDate", 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException("convertJavaDate", 1);
        }
        if (!(paramList.get(0) instanceof Date)) {
            throw new InvokeFunctionException("convertJavaDate", 3);
        }
        return this.dateFormat.format((Date)paramList.get(0));
    }

    private Object timeFuncSetString(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        try {
            if ("year".equals(funcName)) {
                int year = this.dateFormat.parse((String)paramList.get(0)).getYear() + 1900;
                return year;
            }
            if ("month".equals(funcName)) {
                int month = this.dateFormat.parse((String)paramList.get(0)).getMonth() + 1;
                return month;
            }
            if ("dayofmonth".equals(funcName)) {
                int date = this.dateFormat.parse((String)paramList.get(0)).getDate();
                return date;
            }
            if ("to_date".equals(funcName)) {
                return "to_date(" + paramList.get(0) + ")";
            }
            if ("hour".equals(funcName)) {
                int hour = this.dateFormat.parse((String)paramList.get(0)).getHours();
                return hour;
            }
            if ("minute".equals(funcName)) {
                int minute = this.dateFormat.parse((String)paramList.get(0)).getMinutes();
                return minute;
            }
            if ("second".equals(funcName)) {
                int year = this.dateFormat.parse((String)paramList.get(0)).getSeconds();
                return year;
            }
            if ("dayofyear".equals(funcName)) {
                Date date = this.dateFormat.parse((String)paramList.get(0));
                Calendar calendar = Calendar.getInstance();
                calendar.set(date.getYear(), date.getMonth(), date.getDate());
                return calendar.get(6);
            }
            if ("dayofweek".equals(funcName)) {
                int weekday = this.dateFormat.parse((String)paramList.get(0)).getDay();
                return weekday;
            }
            if ("datevalue".equals(funcName)) {
                long time = this.dateFormat.parse((String)paramList.get(0)).getTime();
                return time;
            }
            return null;
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, "" + e);
        }
    }

    private Object timeFuncDateDiff(List paramList) throws InvokeFunctionException {
        String funcName = "dateDiff";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof String) || !(paramList.get(1) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        try {
            int currMonth;
            Date date1 = this.dateFormat.parse((String)paramList.get(0));
            Date date2 = this.dateFormat.parse((String)paramList.get(1));
            boolean isMinus = false;
            if (date2.after(date1)) {
                Date tmpDate = date1;
                date1 = date2;
                date2 = tmpDate;
                isMinus = true;
            }
            int year1 = date1.getYear() + 1900;
            int year2 = date2.getYear() + 1900;
            int month1 = date1.getMonth() + 1;
            int month2 = date2.getMonth() + 1;
            int d1 = date1.getDate();
            int d2 = date2.getDate();
            if (year1 == year2 && month1 == month2) {
                if (!isMinus) {
                    return d1 - d2;
                }
                return d2 - d1;
            }
            int yearDates = 0;
            if (year1 - year2 >= 2) {
                for (int currYear = year2 + 1; currYear < year1; ++currYear) {
                    if (this.leapYearCalendar.isLeapYear(currYear)) {
                        yearDates += 366;
                        continue;
                    }
                    yearDates += 365;
                }
            }
            int year2dates = 0;
            int year1dates = 0;
            if (year1 == year2) {
                for (currMonth = month2 + 1; currMonth <= month1 - 1; ++currMonth) {
                    year1dates += this.monthDates(year1, currMonth);
                }
            } else {
                for (currMonth = month2 + 1; currMonth <= 12; ++currMonth) {
                    year2dates += this.monthDates(year2, currMonth);
                }
                for (currMonth = 1; currMonth <= month1 - 1; ++currMonth) {
                    year1dates += this.monthDates(year1, currMonth);
                }
            }
            int month2dates = this.monthDates(year2, month2) - d2;
            int month1dates = d1;
            int totalDates = yearDates + year2dates + year1dates + month2dates + month1dates;
            if (isMinus) {
                totalDates = -totalDates;
            }
            return totalDates;
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, "" + e);
        }
    }

    private int monthDates(int year, int month) {
        if (month < 1 || month > 12) {
            return 0;
        }
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 2) {
            if (this.leapYearCalendar.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 30;
    }

    private Object timeFuncSetInt(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof Long) && !(paramList.get(0) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        long time = 0L;
        if (paramList.get(0) instanceof Long) {
            time = (Long)paramList.get(0);
        } else if (paramList.get(0) instanceof Integer) {
            time = ((Integer)paramList.get(0)).intValue();
        }
        if ("days".equals(funcName)) {
            return (int)(time / 86400000L);
        }
        if ("hours".equals(funcName)) {
            return (int)(time / 3600000L);
        }
        if ("milliseconds".equals(funcName)) {
            return (int)time;
        }
        if ("minutes".equals(funcName)) {
            return (int)(time / 60000L);
        }
        if ("seconds".equals(funcName)) {
            return (int)(time / 1000L);
        }
        if ("ticks".equals(funcName)) {
            return (int)(time / 3600000L);
        }
        if ("totaldays".equals(funcName)) {
            return new Double((double)time / 8.64E7);
        }
        if ("totalhours".equals(funcName)) {
            return new Double((double)time / 3600000.0);
        }
        if ("totalmilliseconds".equals(funcName)) {
            return new Double(time);
        }
        if ("totalminutes".equals(funcName)) {
            return new Double((double)time / 60000.0);
        }
        if ("totalseconds".equals(funcName)) {
            return new Double((double)time / 1000.0);
        }
        return null;
    }

    private Object trim(List paramList) throws InvokeFunctionException {
        String funcName = "trim";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        return ((String)paramList.get(0)).trim();
    }

    private Object stringFuncSet(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof String) || paramList.get(1) instanceof Integer) {
            throw new InvokeFunctionException(funcName, 3);
        }
        String inputStr = (String)paramList.get(0);
        int cnt = (Integer)paramList.get(1);
        if (cnt < 0) {
            throw new InvokeFunctionException(funcName, "parameter 2 must be greater than 0!");
        }
        if ("left".equals(funcName)) {
            if (inputStr.length() < cnt) {
                throw new InvokeFunctionException(funcName, "the string is not long enough!");
            }
            return inputStr.substring(0, cnt);
        }
        if ("right".equals(funcName)) {
            if (inputStr.length() < cnt) {
                throw new InvokeFunctionException(funcName, "the string is not long enough!");
            }
            return inputStr.substring(inputStr.length() - cnt, cnt);
        }
        if ("rept".equals(funcName)) {
            StringBuffer retStr = new StringBuffer();
            for (int i = 0; i < cnt; ++i) {
                retStr.append(inputStr);
            }
            return retStr.toString();
        }
        return null;
    }

    private Object mathFuncSet0(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList != null && paramList.size() > 0) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if ("pi".equals(funcName)) {
            return new Double(Math.PI);
        }
        if ("rand".equals(funcName)) {
            return new Double(Math.random());
        }
        return null;
    }

    private Object mathFuncSet1(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.valueOf(paramList.get(0).toString());
        if ("sqrt".equals(funcName)) {
            return new Double(Math.sqrt(param1));
        }
        if ("int".equals(funcName)) {
            return (int)param1;
        }
        if ("ln".equals(funcName)) {
            return new Double(Math.log(param1));
        }
        if ("log10".equals(funcName)) {
            return new Double(Math.log(param1) / Math.log(10.0));
        }
        if ("exp".equals(funcName)) {
            return new Double(Math.pow(10.0, param1));
        }
        if ("degrees".equals(funcName)) {
            return new Double(Math.toDegrees(param1));
        }
        if ("radians".equals(funcName)) {
            return new Double(Math.toRadians(param1));
        }
        if ("sin".equals(funcName)) {
            return new Double(Math.sin(param1));
        }
        if ("asin".equals(funcName)) {
            return new Double(Math.asin(param1));
        }
        if ("cos".equals(funcName)) {
            return new Double(Math.cos(param1));
        }
        if ("acos".equals(funcName)) {
            return new Double(Math.acos(param1));
        }
        if ("tan".equals(funcName)) {
            return new Double(Math.tan(param1));
        }
        if ("atan".equals(funcName)) {
            return new Double(Math.atan(param1));
        }
        return null;
    }

    private Object mathFuncSet2(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof Number) || !(paramList.get(1) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.valueOf(paramList.get(0).toString());
        double param2 = Double.valueOf(paramList.get(1).toString());
        if ("log".equals(funcName)) {
            return new Double(Math.log(param2) / Math.log(param1));
        }
        if ("power".equals(funcName)) {
            return new Double(Math.pow(param1, param2));
        }
        if ("mod".equals(funcName)) {
            return new Double(param1 % param2);
        }
        return null;
    }

    private Object convertBigDecimal(List paramList) throws InvokeFunctionException {
        String funcName = "convertBigDecimal";
        if (paramList == null) {
            return 0;
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return 0;
        }
        if (!(paramList.get(0) instanceof BigDecimal)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        return ((BigDecimal)paramList.get(0)).intValue();
    }

    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        if (funcName == null) {
            return null;
        }
        try {
            if ("now".equals(funcName)) {
                return this.now(paramList);
            }
            if ("convertJavaDate".equals(funcName)) {
                return this.convertJavaDate(paramList);
            }
            if ("year".equals(funcName) || "month".equals(funcName) || "dayofmonth".equals(funcName) || "hour".equals(funcName) || "minute".equals(funcName) || "second".equals(funcName) || "dayofyear".equals(funcName) || "dayofweek".equals(funcName) || "datevalue".equals(funcName)) {
                return this.timeFuncSetString(paramList, funcName);
            }
            if ("dateDiff".equals(funcName)) {
                return this.timeFuncDateDiff(paramList);
            }
            if ("days".equals(funcName) || "hours".equals(funcName) || "milliseconds".equals(funcName) || "minutes".equals(funcName) || "seconds".equals(funcName) || "ticks".equals(funcName) || "totaldays".equals(funcName) || "totalhours".equals(funcName) || "totalmilliseconds".equals(funcName) || "totalminutes".equals(funcName) || "totalseconds".equals(funcName)) {
                return this.timeFuncSetInt(paramList, funcName);
            }
            if ("trim".equals(funcName)) {
                return this.trim(paramList);
            }
            if ("left".equals(funcName) || "right".equals(funcName) || "rept".equals(funcName)) {
                return this.stringFuncSet(paramList, funcName);
            }
            if ("pi".equals(funcName) || "rand".equals(funcName)) {
                return this.mathFuncSet0(paramList, funcName);
            }
            if ("sqrt".equals(funcName) || "int".equals(funcName) || "ln".equals(funcName) || "log10".equals(funcName) || "exp".equals(funcName) || "degrees".equals(funcName) || "radians".equals(funcName) || "sin".equals(funcName) || "asin".equals(funcName) || "cos".equals(funcName) || "acos".equals(funcName) || "tan".equals(funcName) || "atan".equals(funcName)) {
                return this.mathFuncSet1(paramList, funcName);
            }
            if ("convertBigDecimal".equals(funcName)) {
                return this.convertBigDecimal(paramList);
            }
            if ("log".equals(funcName) || "power".equals(funcName) || "mod".equals(funcName)) {
                return this.mathFuncSet2(paramList, funcName);
            }
        }
        catch (InvokeFunctionException e) {
            throw new KScriptException(e.toString());
        }
        return null;
    }

    public static HashSet getSpecialFunctions() {
        return specialFunctions;
    }

    public IFuncParaInputProvider getFuncParaInputProvider(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)HRFormulaFunction.funcInfos.get((int)i)).input;
        }
        return null;
    }

    static {
        funcInfos.add(new FuncInfo("round", FuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"444_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("sqrt", FuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"445_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("count", FuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"446_HRFormulaFunction") + "count()\u3002"));
        funcInfos.add(new FuncInfo("average", FuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"446_HRFormulaFunction") + "average()\u3002"));
        funcInfos.add(new FuncInfo("power", FuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"447_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"448_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"449_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("mod", FuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"450_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"451_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"452_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("avg", FuncInfo.CATEGORY_MATH, com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.HrCompenMultLangResource", (String)"label93", (Locale)SysContext.getSysContext().getLocale())));
        funcInfos.add(new FuncInfo("max", FuncInfo.CATEGORY_MATH, com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.HrCompenMultLangResource", (String)"label94", (Locale)SysContext.getSysContext().getLocale())));
        funcInfos.add(new FuncInfo("min", FuncInfo.CATEGORY_MATH, com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.HrCompenMultLangResource", (String)"label95", (Locale)SysContext.getSysContext().getLocale())));
        funcInfos.add(new FuncInfo("sum", FuncInfo.CATEGORY_MATH, com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.HrCompenMultLangResource", (String)"label96", (Locale)SysContext.getSysContext().getLocale())));
        funcInfos.add(new FuncInfo("left", FuncInfo.CATEGORY_STRING, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"453_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"454_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"455_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("right", FuncInfo.CATEGORY_STRING, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"456_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"454_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"455_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("replace", FuncInfo.CATEGORY_STRING, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"457_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"454_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"458_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"459_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("substring", FuncInfo.CATEGORY_STRING, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"460_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"461_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("now", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"462_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"463_HRFormulaFunction") + "\uff1a\"2004-4-17 14:43:05\""));
        funcInfos.add(new FuncInfo("to_date", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"464_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"465_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("year", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"466_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("month", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"467_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("dayofmonth", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"468_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("hour", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"469_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("minute", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"470_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("second", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"471_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("dayofyear", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"472_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("dayofweek", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"473_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("dateDiff", FuncInfo.CATEGORY_TIME, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"474_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"475_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("abs", FuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"476_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("len", FuncInfo.CATEGORY_STRING, EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"477_HRFormulaFunction")));
        funcInfos.add(new FuncInfo("avg", FuncInfo.CATEGORY_MATH, ""));
        funcInfos.add(new FuncInfo("max", FuncInfo.CATEGORY_MATH, ""));
        funcInfos.add(new FuncInfo("min", FuncInfo.CATEGORY_MATH, ""));
        funcInfos.add(new FuncInfo("sum", FuncInfo.CATEGORY_MATH, ""));
        HrFuncParaInputProvider provider1 = new HrFuncParaInputProvider();
        String strABSPeriod = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"479_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"481_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"482_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"483_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"399_FunctionSettingOtherUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"484_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"485_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"486_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"487_HRFormulaFunction") + "\nitemvalue_abs_period(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"488_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"489_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"490_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"491_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"492_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"493_HRFormulaFunction") + ")\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"494_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"495_HRFormulaFunction") + "= itemvalue_abs_period(\"200612\", \"001\", \"FSAL004\",\"\",\"\",\"\") ";
        FuncInfo fun1 = new FuncInfo("itemvalue_abs_period", FuncInfo.CATEGORY_OTHER, strABSPeriod, provider1);
        funcInfos.add(fun1);
        HrFuncParaOtherInputProvider provider2 = new HrFuncParaOtherInputProvider();
        String strRELPeriod = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"496_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"497_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"482_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"498_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"399_FunctionSettingOtherUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"400_FunctionSettingOtherUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"401_FunctionSettingOtherUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"499_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"500_HRFormulaFunction") + "\nitemvalue_rel_period(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"501_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"489_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"490_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"491_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"492_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"493_HRFormulaFunction") + ")" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"502_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"503_HRFormulaFunction") + "=  itemvalue_rel_period(\"-1\", \"001\", \"FSAL004\",\"\",\"\",\"\") ";
        FuncInfo fun2 = new FuncInfo("itemvalue_rel_period", FuncInfo.CATEGORY_OTHER, strRELPeriod, provider2);
        funcInfos.add(fun2);
        HRFunctionPersonAgeProvider providerPersonAge = new HRFunctionPersonAgeProvider();
        String strPersonAge = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"504_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"505_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"500_HRFormulaFunction") + "person_age(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"506_HRFormulaFunction") + ")" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"507_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"508_HRFormulaFunction") + "= person_age(\"FPER015\")*500  ";
        funcInfos.add(new FuncInfo("person_age", FuncInfo.CATEGORY_OTHER, strPersonAge, providerPersonAge));
        HRFunctionPersonAdjustAgeProvider providerAdjustAge = new HRFunctionPersonAdjustAgeProvider();
        String strAdjustAge = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"509_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"510_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"500_HRFormulaFunction") + "get_adjust_age(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"511_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"512_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"513_HRFormulaFunction") + ")   " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"514_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"515_HRFormulaFunction") + "= get_adjust_age(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"516_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"517_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"518_HRFormulaFunction") + ")*50";
        funcInfos.add(new FuncInfo("get_adjust_age", FuncInfo.CATEGORY_OTHER, strAdjustAge, providerAdjustAge));
        HRFunctionCompareYearProvider providerCompareYear = new HRFunctionCompareYearProvider();
        String strCompareYear = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"519_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"520_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"521_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"500_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"522_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"523_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"524_HRFormulaFunction") + "\uff1dget_period_compare_year(\"FPER028\",\"15\")    " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"525_HRFormulaFunction");
        funcInfos.add(new FuncInfo("get_period_compare_year", FuncInfo.CATEGORY_OTHER, strCompareYear, providerCompareYear));
        String strPeriodYear = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"526_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"527_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"528_HRFormulaFunction") + "get_period_year ()   " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"529_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"530_HRFormulaFunction") + "= ( get_period_year() - 2000) * 1000  ";
        funcInfos.add(new FuncInfo("get_period_year", FuncInfo.CATEGORY_OTHER, strPeriodYear));
        String strPeriodMonth = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"531_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"527_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"528_HRFormulaFunction") + "get_period_month()   " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"532_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"533_HRFormulaFunction");
        funcInfos.add(new FuncInfo("get_period_month", FuncInfo.CATEGORY_OTHER, strPeriodMonth));
        String strGetPerfResult = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"534_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"535_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"536_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"537_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"500_HRFormulaFunction") + "get_perf_result(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"538_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"539_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"540_HRFormulaFunction") + ")   " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"541_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"542_HRFormulaFunction") + "=get_perf_result(1," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"543_HRFormulaFunction") + ",1)   " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"544_HRFormulaFunction");
        HrFuncParaGetPerfInputProvider provider3 = new HrFuncParaGetPerfInputProvider();
        funcInfos.add(new FuncInfo("get_perf_result", FuncInfo.CATEGORY_OTHER, strGetPerfResult, provider3));
        String strGetOrgPerfResult = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"545_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"546_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"536_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"537_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"500_HRFormulaFunction") + "get_perf_org_result(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"538_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"539_HRFormulaFunction") + "," + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"540_HRFormulaFunction") + ")   " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"547_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"548_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"549_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"550_HRFormulaFunction");
        HrFuncParaGetOrgPerfProvider orgPerfProvider = new HrFuncParaGetOrgPerfProvider();
        funcInfos.add(new FuncInfo("get_perf_org_result", FuncInfo.CATEGORY_OTHER, strGetOrgPerfResult, orgPerfProvider));
        String strPeriodDay = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"551_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"415_GetPeriodDayGuideUI") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"552_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"553_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"554_HRFormulaFunction") + "get_period_day (20,-2,1)  ";
        HRFunctionGetPeriodDayProvider getPeriodDayProvider = new HRFunctionGetPeriodDayProvider();
        funcInfos.add(new FuncInfo("get_period_day", FuncInfo.CATEGORY_OTHER, strPeriodDay, getPeriodDayProvider));
        String strGetYMD = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"555_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"556_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"557_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"558_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"559_HRFormulaFunction") + "\n " + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"560_HRFormulaFunction") + "\n";
        HRFuncGetYMDProvider getYMDProvider = new HRFuncGetYMDProvider();
        funcInfos.add(new FuncInfo("get_y_m_d", FuncInfo.CATEGORY_OTHER, strGetYMD, getYMDProvider));
        HrFunItemValueSumAdminProvider providerItemValueSumAdm = new HrFunItemValueSumAdminProvider();
        String strSUMAdmin = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"561_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"480_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"562_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"500_HRFormulaFunction") + "itemvalue_admin_sum(" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"490_HRFormulaFunction") + ")   \n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"563_HRFormulaFunction") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"564_HRFormulaFunction") + " =  itemvalue_admin_sum( \"FSAL001\")  ";
        FuncInfo funItemValueSumAdmin = new FuncInfo("itemvalue_admin_sum", FuncInfo.CATEGORY_OTHER, strSUMAdmin, providerItemValueSumAdm);
        funcInfos.add(funItemValueSumAdmin);
        HRFunctionGetFixedProvider providerGetFixed = new HRFunctionGetFixedProvider();
        String strGetFixed = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"643_FunctionGetFixedUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"640_FunctionGetFixedUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"644_FunctionGetFixedUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"641_FunctionGetFixedUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"642_FunctionGetFixedUI") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"645_FunctionGetFixedUI");
        FuncInfo funGetFixed = new FuncInfo("get_Fixed_Fun", FuncInfo.CATEGORY_OTHER, strGetFixed, providerGetFixed);
        funcInfos.add(funGetFixed);
        HrFunctionConditionSumProvider providerConditionSum = new HrFunctionConditionSumProvider();
        String strConditionSum = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"478_HRFormulaFunction") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"652FunctionConditionSum") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"649FunctionConditionSum") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"653FunctionConditionSum") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"650FunctionConditionSum") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"651FunctionConditionSum");
        FuncInfo funConditionSum = new FuncInfo("itemvalue_Condition_sum", FuncInfo.CATEGORY_OTHER, strConditionSum, providerConditionSum);
        funcInfos.add(funConditionSum);
        specialFunctions.add("itemvalue_abs_period");
        specialFunctions.add("itemvalue_rel_period");
        specialFunctions.add("person_age");
        funcInfos.add(new FuncInfo("calendar_month_begingday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("calendar_month_endday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("calendar_today", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("calendar_week_beginday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("calendar_week_endday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("calendar_year_beginday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("calendar_year_endday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("payroll_month_beginday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("payroll_month_endday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("payroll_year_beginday", FuncInfo.CATEGORY_SYSTEM, ""));
        funcInfos.add(new FuncInfo("payroll_year_endday", FuncInfo.CATEGORY_SYSTEM, ""));
        locale = null;
        locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
    }
}

