/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ITaxReportFacade;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.TaxRateListCollection;
import com.kingdee.eas.hr.compensation.TaxReportFacadeFactory;
import com.kingdee.eas.hr.compensation.TaxReportParamsInfo;
import com.kingdee.eas.hr.compensation.TaxReportResultInfo;
import com.kingdee.eas.hr.compensation.client.AbstractHSTaxDetailReportUI;
import com.kingdee.eas.hr.compensation.client.HSTaxDetailReportPanelUI;
import com.kingdee.eas.hr.compensation.client.PersonCmpItemFilterUI;
import com.kingdee.eas.hr.compensation.util.CmpConstant;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class HSTaxDetailReportUI
extends AbstractHSTaxDetailReportUI {
    private static final Logger logger = CoreUIObject.getLogger(HSTaxDetailReportUI.class);
    private CommonQueryDialog commonQueryDialog = new CommonQueryDialog();
    private QuerySolutionInfo solutionInfo = null;
    private boolean isFirstDefaultQuery = true;
    private HSTaxDetailReportPanelUI customerPanel = new HSTaxDetailReportPanelUI();
    private CmpPeriodInfo infoCmpPeriod = null;
    private CmpSchemeInfo[] infoCmpSchemes = null;
    private String usePeriod = "";
    private EntityViewInfo infoEntityView = new EntityViewInfo();
    private TaxRateListCollection colTaxRateList = null;
    private boolean isZeroItemNull = false;
    private boolean isShowSealUp = false;
    private List taxRateList = null;
    private AdminOrgUnitCollection adminColl = null;
    private boolean isShowTaxRate = false;
    private boolean isYearbonus = false;
    private List cmpItemList = null;
    private boolean isSingleScheme = false;
    private HashMap mapAllSchemeItems = null;
    String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";
    private QuerySolutionInfo defaultQuerySolutionInfo = null;
    PersonCmpItemFilterUI personItemFilterUI = new PersonCmpItemFilterUI();
    private int personItemCount = 0;
    private List personItemList = null;
    private DynamicTableInfo infoDynamicTable = new DynamicTableInfo();
    protected List lstColumns = null;

    public HSTaxDetailReportUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.showFilterDialog();
        HRUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        this.tblMain.getHeadStyleAttributes().setWrapText(true);
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    private void doQueryDialog() throws Exception {
        this.infoCmpPeriod = this.customerPanel.getCmpPeriodInfo();
        this.infoCmpSchemes = this.customerPanel.getCmpSchemeColl();
        this.isShowSealUp = this.customerPanel.chkShowSealUp.isSelected();
        this.usePeriod = this.customerPanel.getUsePeriod();
        this.adminColl = this.customerPanel.getDeptCol(this.isShowSealUp);
        this.isShowTaxRate = this.customerPanel.isShowTaxRate();
        this.isYearbonus = this.customerPanel.isYearbonus();
        this.isZeroItemNull = this.customerPanel.isZeroItemValueNull();
        this.cmpItemList = this.customerPanel.getAllSelectItem();
        this.isSingleScheme = this.infoCmpSchemes == null || this.infoCmpSchemes.length <= 1;
        this.mapAllSchemeItems = this.customerPanel.getAllSchemeItems();
        this.isZeroItemNull = this.customerPanel.isZeroItemValueNull();
        this.taxRateList = this.customerPanel.getTaxRateList();
        if (this.isFirstDefaultQuery) {
            this.isFirstDefaultQuery = false;
        } else {
            this.infoEntityView = this.commonQueryDialog.getEntityViewInfoResult();
        }
        Window parentDlg = SwingUtilities.getWindowAncestor((Component)((Object)this));
        GetDataDialog dlg = null;
        dlg = parentDlg instanceof Dialog ? new GetDataDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this))) : (parentDlg instanceof Frame ? new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this))) : new GetDataDialog());
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                HSTaxDetailReportUI.this.loadTableData();
                return null;
            }
        });
        dlg.show();
    }

    private void loadTableData() throws Exception {
        this.createTable();
        TaxReportParamsInfo paramInfo = this.getCustomFilterParam();
        ITaxReportFacade iTaxReportFacade = TaxReportFacadeFactory.getRemoteInstance();
        Map mapData = iTaxReportFacade.getTaxDetailReportData(paramInfo);
        this.fillTableData(mapData);
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.tblMain.getSelectManager().setSelectMode(15);
        }
        this.tblMain.setScrollStateHorizon(2);
    }

    private void fillTableData(Map mapData) throws Exception {
        int i;
        this.tblMain.removeRows();
        this.tblMain.setRefresh(false);
        if (mapData == null) {
            return;
        }
        if (this.tHelper != null) {
            this.tHelper.init();
        }
        IRow iRow = null;
        TaxReportResultInfo resultInfo = null;
        Map itemValueMap = null;
        List resultList = (List)mapData.get("resultDataList");
        Map totalRowMap = (Map)mapData.get("totalPersonCount");
        List itemList = null;
        String schemeID2 = this.infoCmpSchemes[0].getId().toString();
        int size = resultList.size();
        for (i = 0; i < size; ++i) {
            resultInfo = (TaxReportResultInfo)resultList.get(i);
            iRow = this.tblMain.addRow();
            iRow.getCell("FPersonID").setValue((Object)resultInfo.getPersonID());
            CmpItemInfo personItemInfo = null;
            for (int j = 0; j < this.personItemCount; ++j) {
                personItemInfo = (CmpItemInfo)this.personItemList.get(j);
                if (iRow.getCell(personItemInfo.getNumber()) == null) continue;
                iRow.getCell(personItemInfo.getNumber()).setValue(this.getResultInfo(resultInfo, personItemInfo));
            }
            iRow.getCell("Nationality_name").setValue((Object)resultInfo.getNationality());
            iRow.getCell("Cmp_Period").setValue((Object)this.infoCmpPeriod);
            itemValueMap = resultInfo.getItemValueMap();
            if (this.isSingleScheme) {
                this.fillOneRow(iRow, itemValueMap, schemeID2, this.cmpItemList, false, this.isShowTaxRate, true);
                continue;
            }
            this.fillOneRow(iRow, itemValueMap, null, this.cmpItemList, true, this.isShowTaxRate, true);
            for (String schemeID2 : this.mapAllSchemeItems.keySet()) {
                itemList = (List)this.mapAllSchemeItems.get(schemeID2);
                this.fillOneRow(iRow, itemValueMap, schemeID2, itemList, false, this.isShowTaxRate, true);
            }
        }
        this.addTotalRow(totalRowMap, schemeID2);
        iRow = this.tblMain.addRow();
        iRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
        DynamicTableInfo.ColumnInfo columnInfo = null;
        StyleAttributes sty = iRow.getCell("FPER001").getStyleAttributes();
        sty.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        iRow.getCell("FPER001").setStyleAttributes(sty);
        iRow.getCell("FPER001").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"4_BIEmpCmpDiffFacadeControllerBean"));
        BigDecimal data = null;
        for (i = 0; i < this.lstColumns.size(); ++i) {
            columnInfo = (DynamicTableInfo.ColumnInfo)this.lstColumns.get(i);
            if (columnInfo.getKey().indexOf("FPER") > -1 || columnInfo.getKey().indexOf("Nationality_name") > -1 || columnInfo.getKey().indexOf("FPer") > -1 || columnInfo.getKey().indexOf("FFPER") > -1 || columnInfo.getKey().indexOf("Cmp_Period") > -1 || columnInfo.getKey().indexOf("FSAL029") > -1 || columnInfo.getKey().indexOf("taxRate") > -1 || columnInfo.getKey().indexOf("fastSub") > -1) continue;
            data = null;
            for (int t = 0; t < this.tblMain.getRowCount(); ++t) {
                if (this.tblMain.getRow(t).getCell(columnInfo.getKey()).getValue() == null || this.tblMain.getRow(t).getUserObject() != null && this.tblMain.getRow(t).getUserObject().toString().equals("SmallSum")) continue;
                data = data == null ? (BigDecimal)this.tblMain.getRow(t).getCell(columnInfo.getKey()).getValue() : data.add((BigDecimal)this.tblMain.getRow(t).getCell(columnInfo.getKey()).getValue());
            }
            iRow.getCell(columnInfo.getKey()).setValue(data);
        }
        this.tblMain.setRefresh(true);
    }

    private Object getResultInfo(TaxReportResultInfo resultInfo, CmpItemInfo itemInfo) throws BOSException {
        Object result = null;
        String itemNumber = itemInfo.getNumber();
        try {
            Class<?> c = resultInfo.getClass();
            if ("FPER040".equals(itemNumber)) {
                Method m = c.getMethod("is" + itemNumber, null);
                result = m.invoke((Object)resultInfo, null);
            } else {
                Method m = c.getMethod("get" + itemNumber, null);
                result = m.invoke((Object)resultInfo, null);
                if ("FPER010".equals(itemNumber)) {
                    if (result == null || "0".equals(result.toString())) {
                        result = null;
                    } else if ("1".equals(result.toString())) {
                        result = Genders.Male.getAlias();
                    } else if ("2".equals(result.toString())) {
                        result = Genders.Female.getAlias();
                    }
                }
                if (itemInfo.getDataType().getValue() == 20 && result != null) {
                    result = DateTimeUtils.parseDate((String)result.toString());
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void addTotalRow(Map totalRowMap, String schemeID) {
        if (totalRowMap == null || this.taxRateList == null) {
            return;
        }
        int size = this.tblMain.getRowCount();
        int index = 0;
        for (int i = 1; i < size; ++i) {
            if (this.tblMain.getCell(i - 1, "taxRate") == null || this.tblMain.getCell(i - 1, "taxRate").getValue() == null) continue;
            BigDecimal preTaxRate = (BigDecimal)this.tblMain.getCell(i - 1, "taxRate").getValue();
            BigDecimal currTaxRate = (BigDecimal)this.tblMain.getCell(i, "taxRate").getValue();
            if (currTaxRate == null || currTaxRate.compareTo(preTaxRate) == 0) continue;
            String key = preTaxRate.multiply(new BigDecimal("100")).toString();
            this.fillTotalRow((Map)totalRowMap.get(index++), schemeID, key, i++);
            ++size;
        }
        int rowCount = this.tblMain.getRowCount();
        if (rowCount < 1) {
            return;
        }
        String key = ((BigDecimal)this.tblMain.getCell(rowCount - 1, "taxRate").getValue()).multiply(new BigDecimal("100")).toString();
        this.fillTotalRow((Map)totalRowMap.get(index), schemeID, key, rowCount);
    }

    private void fillTotalRow(Map itemValueMap, String schemeID, String key, int index) {
        IRow iRow = this.tblMain.addRow(index);
        Integer count = (Integer)itemValueMap.get("personCount");
        key = key.substring(0, key.indexOf("."));
        String taxCount = key + "%(" + count + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"573_HSTaxDetailReportUI");
        iRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
        iRow.getCell("FPER001").setValue((Object)taxCount);
        iRow.setUserObject((Object)"SmallSum");
        if (this.isSingleScheme) {
            schemeID = this.infoCmpSchemes[0].getId().toString();
            this.fillOneRow(iRow, itemValueMap, schemeID, this.cmpItemList, false, false, false);
        } else {
            this.fillOneRow(iRow, itemValueMap, schemeID, this.cmpItemList, true, false, false);
            Iterator itPrivate = this.mapAllSchemeItems.keySet().iterator();
            List itemList = null;
            while (itPrivate.hasNext()) {
                schemeID = (String)itPrivate.next();
                itemList = (List)this.mapAllSchemeItems.get(schemeID);
                this.fillOneRow(iRow, itemValueMap, schemeID, itemList, false, false, false);
            }
        }
    }

    private void fillOneRow(IRow iRow, Map itemValueMap, String schemeID, List itemList, boolean isSum, boolean isShowTaxRate, boolean needBasePoint) {
        BigDecimal value;
        String key = null;
        CmpItemInfo itemInfo = null;
        for (int j = 0; j < itemList.size(); ++j) {
            itemInfo = (CmpItemInfo)itemList.get(j);
            if (!needBasePoint && "FSAL029".equals(itemInfo.getNumber())) continue;
            value = null;
            key = isSum || this.isSingleScheme ? itemInfo.getNumber() : itemInfo.getNumber() + "~" + schemeID;
            value = (BigDecimal)itemValueMap.get(key);
            if (this.isSingleScheme) {
                value = (BigDecimal)itemValueMap.get(itemInfo.getNumber() + "~" + schemeID);
            }
            if (this.isZeroItemNull && value != null && value instanceof BigDecimal && ((BigDecimal)value).compareTo(new BigDecimal("0.0")) == 0) {
                value = null;
            }
            iRow.getCell(key).setValue(value);
        }
        if (isShowTaxRate) {
            key = "taxRate";
            if (!isSum) {
                key = "taxRate_" + schemeID;
                if (!this.isSingleScheme) {
                    // empty if block
                }
            }
            Object valueTmp = null;
            valueTmp = this.getTaxRate(itemValueMap.get(key));
            if (!this.isZeroItemNull && (valueTmp == null || valueTmp != null && valueTmp instanceof BigDecimal && ((BigDecimal)valueTmp).compareTo(new BigDecimal("0.0")) == 0)) {
                valueTmp = new BigDecimal("0.0");
            } else if (this.isZeroItemNull && valueTmp != null && valueTmp instanceof BigDecimal && ((BigDecimal)valueTmp).compareTo(new BigDecimal("0.0")) == 0) {
                valueTmp = null;
            }
            if (!this.isSingleScheme) {
                this.tblMain.getColumn(key).getStyleAttributes().setNumberFormat("0%");
                iRow.getCell(key).setValue(valueTmp);
            } else {
                this.tblMain.getColumn("taxRate").getStyleAttributes().setNumberFormat("0%");
                iRow.getCell("taxRate").setValue(valueTmp);
            }
            key = "fastSub";
            if (!isSum) {
                key = "fastSub_" + schemeID;
            }
            value = null;
            value = (BigDecimal)itemValueMap.get(key);
            if (this.isZeroItemNull && value != null && value.compareTo(new BigDecimal("0.0")) == 0) {
                value = null;
            } else if (!this.isZeroItemNull && (value == null || valueTmp != null && valueTmp instanceof BigDecimal && ((BigDecimal)valueTmp).compareTo(new BigDecimal("0.0")) == 0)) {
                value = new BigDecimal("0.0");
            }
            if (!this.isSingleScheme) {
                iRow.getCell(key).setValue((Object)value);
            } else {
                iRow.getCell("fastSub").setValue((Object)value);
            }
        }
    }

    private Object getTaxRate(Object value) {
        if (value == null || !(value instanceof BigDecimal)) {
            return value;
        }
        return ((BigDecimal)value).divide(new BigDecimal("100"), 4, 4);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnQuery);
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.tblMain.setColumnMoveable(true);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.commonQueryDialog.show()) {
            this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
            this.doQueryDialog();
        }
    }

    protected void showFilterDialog() throws Exception {
        this.commonQueryDialog = new CommonQueryDialog();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoQuery");
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = HRSchemeUtils.getQueryInfo((IMetaDataPK)queryPK).getFullName();
        this.commonQueryDialog.setWidth(570);
        this.commonQueryDialog.setHeight(505);
        if (this.getUIWindow() == null) {
            this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.commonQueryDialog.setOwner((Component)((Object)this));
        }
        this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.commonQueryDialog.setShowFilter(true);
        this.commonQueryDialog.setShowSorter(false);
        this.commonQueryDialog.setShowToolbar(true);
        this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.customerPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpPeriodResource.CMPPERIOD_NAME"));
        this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
        this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.TITLE_TAXDETAIL_REPORT"));
        this.commonQueryDialog.setMaxReturnCountVisible(false);
        this.personItemFilterUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"49_FormulaFacadeControllerBean"));
        this.commonQueryDialog.addUserPanel((KDPanel)this.personItemFilterUI);
        this.commonQueryDialog.setDynQueryVisible(true);
        this.commonQueryDialog.setDynF7FilterInfo(HRCmpItemUtils.getDynF7FilterInfo(1));
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            this.infoEntityView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (this.infoEntityView == null) {
                this.infoEntityView = new EntityViewInfo();
            }
            this.defaultQuerySolutionInfo = this.solutionInfo = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (CompUtils.isNullWhere(this.solutionInfo)) {
                CustomerParams cp = CustomerParams.getCustomerParams2((String)CompUtils.getCustmerParamsUtil(this.solutionInfo, HSTaxDetailReportPanelUI.class.getName()));
                CustomerParams cp2 = CustomerParams.getCustomerParams2((String)CompUtils.getCustmerParamsUtil(this.solutionInfo, PersonCmpItemFilterUI.class.getName()));
                if (cp == null) {
                    this.isFirstDefaultQuery = false;
                    this.showFilterDialog();
                }
                try {
                    this.customerPanel.setCustomerParams(cp);
                    this.personItemFilterUI.setCustomerParams(cp2);
                    if (this.customerPanel.getCmpSchemeColl() == null || this.customerPanel.getCmpSchemeColl().length == 0) {
                        this.isFirstDefaultQuery = false;
                        this.showFilterDialog();
                    }
                    this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
                    this.doQueryDialog();
                }
                catch (AbortException e) {
                    this.isFirstDefaultQuery = false;
                    this.showFilterDialog();
                }
            } else {
                this.isFirstDefaultQuery = false;
                if (this.commonQueryDialog.show()) {
                    this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
                    this.doQueryDialog();
                } else {
                    SysUtil.abort();
                }
            }
        } else {
            this.isFirstDefaultQuery = false;
            if (this.commonQueryDialog.show()) {
                this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
                this.doQueryDialog();
            } else {
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected Variant tableRequestPrintData(String varName) {
        Variant v = new Variant();
        v.setObject((Object)"");
        return v;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    public QuerySolutionInfo getQuerySolutionInfo() {
        return this.solutionInfo;
    }

    public Object getTablePreferenceSchemaKey() {
        String key = null;
        if (this.commonQueryDialog != null && this.commonQueryDialog.getCurrentSolutionInfo() != null) {
            key = this.commonQueryDialog.getCurrentSolutionInfo().getName();
        } else if (this.defaultQuerySolutionInfo != null) {
            key = this.defaultQuerySolutionInfo.getName();
        }
        return key;
    }

    private void createTable() throws Exception {
        this.tblMain.setRefresh(false);
        this.infoDynamicTable.setCountHeadLine(2);
        this.infoDynamicTable.setHeadMergeMode(4);
        this.lstColumns = this.getDynamicColumnInfos();
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[this.lstColumns.size()];
        if (infosColumn == null || infosColumn.length <= 0) {
            return;
        }
        int size = this.lstColumns.size();
        for (int i = 0; i < size; ++i) {
            infosColumn[i] = (DynamicTableInfo.ColumnInfo)this.lstColumns.get(i);
        }
        this.infoDynamicTable.setInfosColumn(infosColumn);
        HRDynamicTableUtils.createTableHead(this.tblMain, this.infoDynamicTable);
        if (this.tblMain.getColumn("taxRate") != null) {
            this.tblMain.getColumn("taxRate").getStyleAttributes().setNumberFormat("0%");
        }
        this.setHeadMerge();
        this.tblMain.setRefresh(true);
    }

    private List getDynamicColumnInfos() {
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumns = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo infoColumn = null;
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(true);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setColor(HRReportUtils.UNEDIT_COLOR);
        infoColumn.setType(30);
        infoColumn.setColumnType(30);
        infoColumn.setKey("FPersonID");
        infoColumn.setColumnNumber("FPersonID");
        infoColumn.setColumnName("FPersonID");
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)(this.resClass + "NAME_ITEM_PERSON_ID")));
        infoColumn.getInfosHead()[0].setHeadValue("FPersonID");
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName("FPersonID");
        infoColumn.getInfosHead()[1].setHeadValue("FPersonID");
        lstColumns.add(infoColumn);
        this.personItemList = this.personItemFilterUI.getSelectedCmpItem();
        this.personItemCount = this.personItemList.size();
        String personItemNumber = null;
        CmpItemInfo personItemInfo = null;
        HashMap<String, CmpItemInfo> personItemMaps = new HashMap<String, CmpItemInfo>();
        int size = this.personItemList.size();
        for (int i = 0; i < size; ++i) {
            personItemInfo = (CmpItemInfo)this.personItemList.get(i);
            personItemNumber = personItemInfo.getNumber();
            personItemMaps.put(personItemNumber, personItemInfo);
            infoColumn = new DynamicTableInfo.ColumnInfo();
            infoColumn.setHide(false);
            infoColumn.setReadOnly(true);
            infoColumn.setLocked(true);
            infoColumn.setColor(HRReportUtils.UNEDIT_COLOR);
            infoColumn.setType(30);
            infoColumn.setColumnType(30);
            if (personItemInfo.getDataType() == ItemDataTypeEnum.CURRENCY || personItemInfo.getDataType() == ItemDataTypeEnum.FLOAT) {
                infoColumn.setFormat(HRCmpItemUtils.getColumnFormatStr(personItemInfo.getDecDigital()));
                infoColumn.setScale(personItemInfo.getDecDigital());
                infoColumn.setPrecisionType(personItemInfo.getPrecisionType());
            }
            if (personItemInfo.getDataType() == ItemDataTypeEnum.DATE) {
                infoColumn.setFormat(CmpConstant.DATEFORMAT);
                infoColumn.setColumnType(20);
            }
            infoColumn.setKey(personItemNumber);
            infoColumn.setColumnNumber(personItemNumber);
            infoColumn.setColumnName(personItemNumber);
            infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
            infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[0].setHeadName(personItemInfo.getName());
            infoColumn.getInfosHead()[0].setHeadValue(personItemNumber);
            infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[1].setHeadName(personItemInfo.getName());
            infoColumn.getInfosHead()[1].setHeadValue(personItemNumber);
            lstColumns.add(infoColumn);
        }
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setColumnType(30);
        infoColumn.setAlignHor(Styles.HorizontalAlignment.LEFT);
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setKey("Nationality_name");
        infoColumn.setColumnNumber("Nationality_name");
        infoColumn.setColumnName("Nationality_name");
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"576_HSTaxDetailReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue("Nationality_name");
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"576_HSTaxDetailReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue("Nationality_name");
        lstColumns.add(infoColumn);
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setColumnType(30);
        infoColumn.setAlignHor(Styles.HorizontalAlignment.LEFT);
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setKey("Cmp_Period");
        infoColumn.setColumnNumber("Cmp_Period");
        infoColumn.setColumnName("Cmp_Period");
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"262_CmpStatisticsReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue("Cmp_Period");
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"262_CmpStatisticsReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue("Cmp_Period");
        lstColumns.add(infoColumn);
        if (this.cmpItemList == null) {
            return lstColumns;
        }
        List itemList = null;
        String key = null;
        if (this.isSingleScheme) {
            this.setItemColumn(lstColumns, this.cmpItemList, false, null);
            return lstColumns;
        }
        this.setItemColumn(lstColumns, this.cmpItemList, true, null);
        for (int i = 0; i < this.infoCmpSchemes.length; ++i) {
            key = this.infoCmpSchemes[i].getId().toString();
            itemList = (List)this.mapAllSchemeItems.get(key);
            if (itemList == null) continue;
            this.setItemColumn(lstColumns, this.exchangeSeq(itemList, this.cmpItemList), false, key);
        }
        return lstColumns;
    }

    private void setItemColumn(List lstColumns, List itemList, boolean isSum, String key) {
        CmpItemInfo itemInfo = null;
        DynamicTableInfo.ColumnInfo infoColumn = null;
        boolean hasTaxRate = false;
        int size = itemList.size();
        for (int j = 0; j < size; ++j) {
            itemInfo = (CmpItemInfo)itemList.get(j);
            infoColumn = new DynamicTableInfo.ColumnInfo();
            String name = itemInfo.getName();
            String number = null;
            number = isSum || this.isSingleScheme ? itemInfo.getNumber() : itemInfo.getNumber() + "~" + key;
            infoColumn.setColumnType(60);
            infoColumn.setAlignHor(Styles.HorizontalAlignment.RIGHT);
            infoColumn.setHide(false);
            infoColumn.setReadOnly(true);
            infoColumn.setLocked(true);
            infoColumn.setKey(number);
            infoColumn.setColumnNumber(number);
            infoColumn.setColumnName(name);
            if (itemInfo.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo.getDataType() == ItemDataTypeEnum.FLOAT) {
                infoColumn.setFormat(HRCmpItemUtils.getColumnFormatStr(itemInfo.getDecDigital()));
                infoColumn.setScale(itemInfo.getDecDigital());
                infoColumn.setPrecisionType(itemInfo.getPrecisionType());
            }
            infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
            infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
            if (isSum) {
                infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"577_HSTaxDetailReportUI"));
                infoColumn.getInfosHead()[0].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"577_HSTaxDetailReportUI"));
            } else if (this.isSingleScheme) {
                String schemeName = this.infoCmpSchemes[0].getName();
                infoColumn.getInfosHead()[0].setHeadName(schemeName);
                infoColumn.getInfosHead()[0].setHeadValue(schemeName);
            } else {
                infoColumn.getInfosHead()[0].setHeadName(itemInfo.getCmpSchemeName());
                infoColumn.getInfosHead()[0].setHeadValue(itemInfo.getCmpSchemeName());
            }
            infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[1].setHeadName(name);
            infoColumn.getInfosHead()[1].setHeadValue(number);
            lstColumns.add(infoColumn);
            if (!itemInfo.getNumber().equals("FSAL014")) continue;
            hasTaxRate = true;
            this.addTaxRateColumn(lstColumns, isSum, key);
        }
        if (!hasTaxRate) {
            this.addTaxRateColumn(lstColumns, isSum, key);
        }
    }

    private void addTaxRateColumn(List lstColumns, boolean isSum, String key) {
        if (!this.isShowTaxRate) {
            return;
        }
        String columnKeyRate = "taxRate";
        String columnKeySub = "fastSub";
        if (!isSum && key != null) {
            columnKeyRate = "taxRate_" + key;
            columnKeySub = "fastSub_" + key;
        }
        DynamicTableInfo.ColumnInfo infoColumn = null;
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setColumnType(50);
        infoColumn.setAlignHor(Styles.HorizontalAlignment.LEFT);
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setKey(columnKeyRate);
        infoColumn.setColumnNumber(columnKeyRate);
        infoColumn.setColumnName(columnKeyRate);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"578_HSTaxDetailReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(columnKeyRate);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"578_HSTaxDetailReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue(columnKeyRate);
        lstColumns.add(infoColumn);
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setColumnType(60);
        infoColumn.setAlignHor(Styles.HorizontalAlignment.LEFT);
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setKey(columnKeySub);
        infoColumn.setColumnNumber(columnKeySub);
        infoColumn.setColumnName(columnKeySub);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
        infoColumn.setFormat("0.00");
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"579_HSTaxDetailReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(columnKeySub);
        infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"579_HSTaxDetailReportUI"));
        infoColumn.getInfosHead()[1].setHeadValue(columnKeySub);
        lstColumns.add(infoColumn);
    }

    private void setHeadMerge() throws Exception {
        int iBeginMergeRow;
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        for (int col = iBeginMergeRow = 1; col <= this.personItemCount; ++col) {
            mm.mergeBlock(0, col, 1, col, 4);
        }
        mm.mergeBlock(0, this.personItemCount + 1, 1, this.personItemCount + 1, 4);
        mm.mergeBlock(0, this.personItemCount + 2, 1, this.personItemCount + 2, 4);
        iBeginMergeRow = iBeginMergeRow + this.personItemCount + 2;
        int size = this.cmpItemList.size();
        if (this.isShowTaxRate) {
            size += 2;
        }
        mm.mergeBlock(0, iBeginMergeRow, 0, iBeginMergeRow + size - 1, 4);
        iBeginMergeRow += size;
        if (this.isSingleScheme) {
            return;
        }
        String key = null;
        for (int i = 0; i < this.infoCmpSchemes.length; ++i) {
            key = this.infoCmpSchemes[i].getId().toString();
            List lstItems = (List)this.mapAllSchemeItems.get(key);
            if (lstItems == null) continue;
            int length = lstItems.size();
            if (this.isShowTaxRate) {
                length += 2;
            }
            mm.mergeBlock(0, iBeginMergeRow, 0, iBeginMergeRow + length - 1, 4);
            iBeginMergeRow += length;
        }
    }

    private TaxReportParamsInfo getCustomFilterParam() {
        TaxReportParamsInfo paramInfo = new TaxReportParamsInfo();
        paramInfo.setAdminColl(Arrays.asList(this.adminColl.toArray()));
        paramInfo.setCmpItemColl(this.cmpItemList);
        paramInfo.setCmpPeriod(this.infoCmpPeriod);
        paramInfo.setInfoEntityView(this.infoEntityView);
        paramInfo.setSchemeInfos(Arrays.asList(this.infoCmpSchemes));
        paramInfo.setShowTaxRate(this.isShowTaxRate);
        paramInfo.setTaxRateList(this.taxRateList);
        paramInfo.setInfoEntityView(this.infoEntityView);
        paramInfo.setMapAllSchemeItems(this.mapAllSchemeItems);
        paramInfo.setTaxRateList(this.taxRateList);
        paramInfo.SetUsePeriod(this.usePeriod);
        paramInfo.setPersonItemColl(this.personItemList);
        paramInfo.setYearbonus(this.isYearbonus);
        return paramInfo;
    }

    private List exchangeSeq(List oldList, List consultList) {
        ArrayList<CmpItemInfo> newList = new ArrayList<CmpItemInfo>();
        CmpItemInfo info1 = null;
        CmpItemInfo info2 = null;
        block0: for (int i = 0; i < consultList.size(); ++i) {
            info1 = (CmpItemInfo)consultList.get(i);
            for (int j = 0; j < oldList.size(); ++j) {
                info2 = (CmpItemInfo)oldList.get(j);
                if (!info1.getNumber().equals(info2.getNumber())) continue;
                newList.add(info2);
                continue block0;
            }
        }
        return newList;
    }

    protected void checkTableCommonMenu(KDTable table) {
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if (!"menuItemPaste".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }
}

