/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.IPeriodEndInputFacade;
import com.kingdee.eas.hr.compensation.PeriodEndInputFacadeFactory;
import com.kingdee.eas.hr.compensation.PeriodEndInputInfo;
import com.kingdee.eas.hr.compensation.TryPeriodEndInputInfo;
import com.kingdee.eas.hr.compensation.client.AbstractImportDateEndDataUI;
import com.kingdee.eas.hr.compensation.client.EndInputEmployeeCalcuUI;
import com.kingdee.eas.hr.compensation.client.EndInputEmployeeUI;
import com.kingdee.eas.hr.compensation.client.IPeriodEndInputUI;
import com.kingdee.eas.hr.compensation.client.TryEndInputEmployeeUI;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ImportDateEndDataUI
extends AbstractImportDateEndDataUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportDateEndDataUI.class);
    private static final String RES = "com.kingdee.eas.hr.compensation.client.ImportDateEndDataResource";
    private HSSFWorkbook workbook;
    private List lstSelectCmpItem;
    private Map cmpItemNameIds = new LinkedHashMap();
    private Map realCmpItemNameIds = new LinkedHashMap();
    private Map cmpItemIdInfoMap = new LinkedHashMap();
    private int errorHandleStyle = 0;
    private int errorCount = 0;
    private int successCount = 0;
    private StringBuffer errorStr;
    boolean isTryScheme = false;
    private IPeriodEndInputUI EIEUI = null;
    private int baseRowNum = 1;
    private boolean isShowMsg = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("isTryScheme") != null) {
            this.isTryScheme = (Boolean)this.getUIContext().get("isTryScheme");
        }
        this.lstSelectCmpItem = (List)this.getUIContext().get("lstSelectCmpItem");
        this.tblMain.getColumn("taskName").getStyleAttributes().setLocked(true);
        if (this.lstSelectCmpItem != null) {
            this.cmpItemNameIds.clear();
            this.cmpItemIdInfoMap.clear();
            int j = this.lstSelectCmpItem.size();
            for (int i = 0; i < j; ++i) {
                CmpItemInfo info = (CmpItemInfo)this.lstSelectCmpItem.get(i);
                String cmpItemName = info.getName().trim();
                if (this.cmpItemNameIds.containsKey(cmpItemName)) {
                    if (this.isTryScheme) {
                        this.cmpItemNameIds.put(cmpItemName + "_", info.getNumber());
                    } else {
                        this.cmpItemNameIds.put(cmpItemName + "_", info.getId().toString());
                    }
                } else if (this.isTryScheme) {
                    this.cmpItemNameIds.put(cmpItemName, info.getNumber());
                } else {
                    this.cmpItemNameIds.put(cmpItemName, info.getId().toString());
                }
                if (this.isTryScheme) {
                    this.cmpItemIdInfoMap.put(info.getNumber(), info);
                    continue;
                }
                this.cmpItemIdInfoMap.put(info.getId().toString(), info);
            }
        }
        this.btnRefreshSheet.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenTen);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFifty);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenhundred);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.setSelectedIndex(0);
        this.txtFile.setEditable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"580_ImportDateEndDataUI"));
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(expFilePath);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"can_not_update_open_file"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(wb);
        HSSFCellStyle cellStyle = this.createValueCellStyle(wb);
        HSSFSheet sheet = wb.createSheet();
        int columnIndex = 0;
        HSSFRow headRow = sheet.createRow(0);
        HSSFCell cell1 = headRow.createCell(0);
        cell1.setCellType(CellType.STRING);
        cell1.setCellValue(EASResource.getString((String)RES, (String)"person_number") + "*");
        cell1.setCellStyle(titleStyle);
        ++columnIndex;
        HSSFCell cell2 = headRow.createCell(1);
        cell2.setCellType(CellType.STRING);
        cell2.setCellValue(EASResource.getString((String)RES, (String)"person_name"));
        cell2.setCellStyle(titleStyle);
        ++columnIndex;
        for (Map.Entry entry : this.cmpItemNameIds.entrySet()) {
            if (entry.getKey() == null || columnIndex >= 256) continue;
            HSSFCell cell = headRow.createCell((int)((short)columnIndex));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(entry.getKey().toString());
            cell.setCellStyle(titleStyle);
            ++columnIndex;
        }
        List lstData = (List)this.getUIContext().get("listPersonData");
        HashMap paramsMap = (HashMap)this.getUIContext().get("paramsMap");
        if (paramsMap != null) {
            IPeriodEndInputFacade iPeriodEndInputFacade = PeriodEndInputFacadeFactory.getRemoteInstance();
            Hashtable hstData = iPeriodEndInputFacade.getEmpDataByAuditState(paramsMap);
            lstData = (List)hstData.get("listPersonData");
        }
        if (lstData != null) {
            int n = lstData.size();
            for (int i = 0; i < n; ++i) {
                Hashtable data = (Hashtable)lstData.get(i);
                HSSFRow headRowNew = sheet.createRow(i + 1);
                HSSFCell cellNumber = headRowNew.createCell(0);
                cellNumber.setCellType(CellType.STRING);
                cellNumber.setCellValue(data.get("FPER002").toString());
                HSSFCell cellName = headRowNew.createCell(1);
                cellName.setCellType(CellType.STRING);
                cellName.setCellValue(data.get("FPER001").toString());
            }
        }
        this.createValueCellStyle(wb);
        for (int i = 0; i < columnIndex; ++i) {
            sheet.setDefaultColumnStyle((int)((short)i), (CellStyle)cellStyle);
            sheet.setDefaultColumnWidth(20);
        }
        wb.setSheetName(0, EASResource.getString((String)RES, (String)"date_end_input"));
        wb.write((OutputStream)out);
        out.flush();
        out.close();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"export_template_success"));
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_file"));
            return;
        }
        if (this.tblMain.getRowCount() >= 0) {
            String str = filePath.substring(filePath.lastIndexOf("."));
            if (".xls".equals(str)) {
                this.initSheet();
                int sheetNum = this.comboLabel.getSelectedIndex();
                HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
                int rowNum = sheet.getPhysicalNumberOfRows();
                if (rowNum < 1) {
                    MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
                    this.txtFile.setText("");
                    this.comboLabel.removeAllItems();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
                this.txtFile.setText("");
                this.comboLabel.removeAllItems();
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initSheet();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int sheetNum;
        HSSFSheet sheet;
        int rowNum;
        if (this.workbook == null) {
            return;
        }
        if (!this.checkFile()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        if (this.isTryScheme) {
            this.EIEUI = (TryEndInputEmployeeUI)this.getUIContext().get("Owner");
        } else if (this.getUIContext().get("Owner") instanceof EndInputEmployeeUI) {
            this.EIEUI = (EndInputEmployeeUI)this.getUIContext().get("Owner");
        } else if (this.getUIContext().get("Owner") instanceof EndInputEmployeeCalcuUI) {
            this.EIEUI = (EndInputEmployeeCalcuUI)this.getUIContext().get("Owner");
        }
        if (this.EIEUI == null) {
            return;
        }
        KDTable tblMain = this.EIEUI.getTable();
        HashMap<String, Integer> pRowIndexMap = new HashMap<String, Integer>();
        HashMap<String, String> pNumberIdMap = new HashMap<String, String>();
        int j = tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            ICell cellId;
            ICell cell = tblMain.getCell(i, "FPER002");
            if (cell != null && cell.getValue() != null) {
                pRowIndexMap.put(cell.getValue().toString().trim(), i);
            }
            if ((cellId = tblMain.getCell(i, "FPersonID")) == null || cellId.getValue() == null) continue;
            pNumberIdMap.put(cell.getValue().toString().trim(), cellId.getValue().toString().trim());
        }
        HashMap<String, Integer> tableColumnKeyIndexMap = new HashMap<String, Integer>();
        int size = tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            tableColumnKeyIndexMap.put(tblMain.getColumn(i).getKey(), i);
        }
        Hashtable hstChanged = this.EIEUI.getHstChanged();
        if (hstChanged == null) {
            hstChanged = new Hashtable();
            this.EIEUI.setHstChanged(hstChanged);
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum = this.comboLabel.getSelectedIndex())).getPhysicalNumberOfRows()) <= 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"template_file_is_null"));
            return;
        }
        boolean isOver = this.chkUpdate.isSelected();
        boolean isAdd = this.chkAdd.isSelected();
        if (isAdd) {
            isOver = true;
        }
        ErrorHandleModeEnum mode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
        this.errorHandleStyle = mode.getValue();
        this.errorCount = 0;
        this.errorStr = new StringBuffer();
        this.successCount = 0;
        Pattern p = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
        Pattern dateP = Pattern.compile("^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$");
        String at = EASResource.getString((String)RES, (String)"at");
        String line = EASResource.getString((String)RES, (String)"row");
        String pNumberNull = EASResource.getString((String)RES, (String)"peron_number_can_not_null");
        String pNumberError = EASResource.getString((String)RES, (String)"person_number_error");
        String cmpItemError = EASResource.getString((String)RES, (String)"cmpItem_value_error");
        String cmpItem_value_too_big = EASResource.getString((String)RES, (String)"cmpItem_value_too_big");
        String dateError = EASResource.getString((String)RES, (String)"dateValue_error");
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        HSSFRow headRow = sheet.getRow(0);
        LinkedHashMap<String, Object> cmpItemValue = new LinkedHashMap<String, Object>();
        boolean hasCmpItemError = false;
        HashMap<String, String> mapImportPerNum = new HashMap<String, String>();
        List unEditItemList = (List)this.getUIContext().get("unEditItemList");
        for (int i = 1; i < rowNum; ++i) {
            String columnKey;
            String errorMsg;
            int currRowNum = i + 1;
            hasCmpItemError = false;
            HSSFRow row = sheet.getRow(i);
            if (row == null) {
                ++rowNum;
                continue;
            }
            HSSFCell fCell = row.getCell(0);
            HSSFCell fCellName = row.getCell(1);
            String pName = ExcelUtil.getCellValue((HSSFCell)fCellName);
            String pNumber = ExcelUtil.getCellValue((HSSFCell)fCell);
            if (!isAdd && mapImportPerNum.containsKey(pNumber)) {
                errorMsg = at + currRowNum + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"581_ImportDateEndDataUI");
                if (!this.handError(errorMsg)) continue;
                SysUtil.abort();
            } else {
                mapImportPerNum.put(pNumber, pNumber);
            }
            if (pNumber == null || pNumber.trim().length() == 0) {
                errorMsg = at + currRowNum + pNumberNull;
                if (!this.handError(errorMsg)) continue;
                SysUtil.abort();
            } else if (!pRowIndexMap.containsKey(pNumber.trim())) {
                errorMsg = at + currRowNum + pNumberError;
                if (!this.handError(errorMsg)) continue;
                SysUtil.abort();
            }
            List lstData = (List)this.getUIContext().get("listAllPersonData");
            Map personAuditMap = (Map)this.getUIContext().get("personAuditMap");
            boolean isContinue = false;
            String personId = null;
            Hashtable data = null;
            if (lstData != null) {
                int n = lstData.size();
                for (int j2 = 0; j2 < n; ++j2) {
                    String auditState;
                    data = (Hashtable)lstData.get(j2);
                    String entryNumber = data.get("FPER002").toString();
                    String entryName = data.get("FPER001").toString();
                    if (!entryNumber.trim().equals(pNumber.trim())) continue;
                    if (!StringUtils.isEmpty((String)pName) && !entryName.trim().equals(pName.trim())) {
                        errorMsg = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"742_ImportDateEndDataUI", (String[])new String[]{String.valueOf(currRowNum), entryName});
                        if (this.handError(errorMsg)) {
                            SysUtil.abort();
                        } else {
                            isContinue = true;
                            break;
                        }
                    }
                    if (!"1".equals(auditState = (String)personAuditMap.get(personId = data.get("FPersonID").toString()))) continue;
                    errorMsg = at + currRowNum + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"584_ImportDateEndDataUI");
                    if (this.handError(errorMsg)) {
                        SysUtil.abort();
                        continue;
                    }
                    isContinue = true;
                    break;
                }
            }
            if (isContinue) continue;
            int rowIndex = (Integer)pRowIndexMap.get(pNumber);
            IRow tRow = tblMain.getRow(rowIndex);
            cmpItemValue.clear();
            int m = this.realCmpItemNameIds.size();
            for (int k = 0; k < m; ++k) {
                String title = ExcelUtil.getCellValue((HSSFCell)headRow.getCell((int)((short)(k + 2))));
                if (title == null || title.trim().length() < 1 || !this.realCmpItemNameIds.containsKey(title.trim()) || this.realCmpItemNameIds.get(title.trim()) == null) continue;
                columnKey = this.realCmpItemNameIds.get(title.trim()).toString();
                fCell = row.getCell((int)((short)(k + 2)));
                String value = ExcelUtil.getCellValue((HSSFCell)fCell);
                if (unEditItemList != null) {
                    boolean isEditable = false;
                    int size2 = unEditItemList.size();
                    for (int keyNum = 0; keyNum < size2; ++keyNum) {
                        if (!columnKey.equals(unEditItemList.get(keyNum).toString())) continue;
                        cmpItemValue.put(columnKey, null);
                        isEditable = true;
                        break;
                    }
                    if (isEditable) continue;
                }
                if (value == null || value.trim().length() < 1) {
                    cmpItemValue.put(columnKey, null);
                    continue;
                }
                value = value.trim();
                CmpItemInfo cmpItemInfo = (CmpItemInfo)this.cmpItemIdInfoMap.get(columnKey);
                if (cmpItemInfo == null || cmpItemInfo.getDataType() == null) continue;
                int dataType = cmpItemInfo.getDataType().getValue();
                if (dataType == 60 || dataType == 50 || dataType == 40) {
                    if (value != null && value.trim().length() > 0 && !p.matcher(value).matches()) {
                        hasCmpItemError = true;
                        errorMsg = at + currRowNum + line + cmpItemInfo.getName() + cmpItemError;
                        if (!this.handError(errorMsg)) break;
                        SysUtil.abort();
                    }
                    if (dataType == 40 && value.indexOf(".") > 0) {
                        hasCmpItemError = true;
                        errorMsg = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"743_ImportDateEndDataUI", (String[])new String[]{String.valueOf(currRowNum)});
                        if (!this.handError(errorMsg)) break;
                        SysUtil.abort();
                    }
                    int len = cmpItemInfo.getLength();
                    int valueLen = value.length();
                    if (value.length() > len) {
                        if (value.lastIndexOf(".") > 0) {
                            valueLen = value.substring(0, value.lastIndexOf(".")).length();
                        }
                        if (valueLen > len) {
                            hasCmpItemError = true;
                            errorMsg = at + currRowNum + line + cmpItemInfo.getName() + cmpItem_value_too_big;
                            if (!this.handError(errorMsg)) break;
                            SysUtil.abort();
                        }
                    }
                    BigDecimal tmpDec = new BigDecimal("0");
                    Integer tmpIn = Integer.valueOf("0");
                    if (tRow.getCell(columnKey).getValue() != null && dataType != 40) {
                        tmpDec = (BigDecimal)tRow.getCell(columnKey).getValue();
                    } else if (tRow.getCell(columnKey).getValue() != null && dataType == 40) {
                        tmpIn = (Integer)tRow.getCell(columnKey).getValue();
                    }
                    if (dataType == 60) {
                        if (isAdd) {
                            cmpItemValue.put(columnKey, tmpDec.add(new BigDecimal(value)));
                            continue;
                        }
                        cmpItemValue.put(columnKey, new BigDecimal(value));
                        continue;
                    }
                    if (dataType == 50) {
                        if (isAdd) {
                            cmpItemValue.put(columnKey, tmpDec.add(new BigDecimal(value)));
                            continue;
                        }
                        cmpItemValue.put(columnKey, new BigDecimal(value));
                        continue;
                    }
                    if (dataType == 40) {
                        if (isAdd) {
                            int nValue = Integer.valueOf(value);
                            int totmp = tmpIn;
                            cmpItemValue.put(columnKey, nValue + totmp);
                            continue;
                        }
                        cmpItemValue.put(columnKey, Integer.valueOf(value));
                        continue;
                    }
                    if (isAdd) {
                        cmpItemValue.put(columnKey, tmpDec.add(new BigDecimal(value)));
                        continue;
                    }
                    cmpItemValue.put(columnKey, Integer.valueOf(value));
                    continue;
                }
                if (dataType == 20) {
                    if (!dateP.matcher(value).matches()) {
                        hasCmpItemError = true;
                        errorMsg = at + currRowNum + line + dateError;
                        if (!this.handError(errorMsg)) break;
                        SysUtil.abort();
                    }
                    Date dateValue = df.parse(value);
                    cmpItemValue.put(columnKey, dateValue);
                    continue;
                }
                if (dataType != 30) continue;
                if (value.trim().length() > 255 || value.trim().length() > cmpItemInfo.getLength()) {
                    hasCmpItemError = true;
                    errorMsg = at + currRowNum + line + cmpItemInfo.getName() + cmpItem_value_too_big;
                    if (!this.handError(errorMsg)) break;
                    SysUtil.abort();
                }
                cmpItemValue.put(columnKey, value);
            }
            if (hasCmpItemError || cmpItemValue.size() <= 0) continue;
            Set set = cmpItemValue.entrySet();
            int columnIndex = 0;
            ICell itemCell = null;
            for (Map.Entry entry : set) {
                Object oldValue;
                columnKey = entry.getKey().toString();
                columnIndex = (Integer)tableColumnKeyIndexMap.get(columnKey);
                itemCell = tRow.getCell(columnIndex);
                Object newValue = entry.getValue();
                if (isOver) {
                    ObjectBaseInfo info;
                    if (newValue == null || newValue.toString().trim().length() == 0) continue;
                    if (itemCell.getUserObject() == null) {
                        itemCell.setValue(newValue);
                        continue;
                    }
                    if (itemCell.getUserObject() instanceof TryPeriodEndInputInfo && ((info = (TryPeriodEndInputInfo)itemCell.getUserObject()) == null || info.getSupply() == null || info.getSupply().getValue() == 10)) {
                        itemCell.setValue(newValue);
                    }
                    if (!(itemCell.getUserObject() instanceof PeriodEndInputInfo) || (info = (PeriodEndInputInfo)itemCell.getUserObject()) != null && info.getSupply() != null && info.getSupply().getValue() != 10) continue;
                    itemCell.setValue(newValue);
                    continue;
                }
                if (newValue == null || newValue.toString().trim().length() == 0 || (oldValue = itemCell.getValue()) != null && oldValue.toString().trim().length() != 0) continue;
                itemCell.setValue(newValue);
            }
            ++this.successCount;
            if (!pNumberIdMap.containsKey(pNumber)) continue;
            hstChanged.put(pNumberIdMap.get(pNumber), pRowIndexMap.get(pNumber));
        }
        if (this.errorHandleStyle == 5 || !this.isShowMsg) {
            this.showMsg();
        }
        this.getUIWindow().close();
    }

    private boolean handError(String msg) {
        ++this.errorCount;
        this.errorStr.append(msg).append("\n");
        if (this.errorHandleStyle == 1) {
            this.showMsg();
            this.isShowMsg = true;
            return true;
        }
        if (this.errorHandleStyle == 2) {
            if (this.errorCount == 10) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        if (this.errorHandleStyle == 3) {
            if (this.errorCount == 50) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        if (this.errorHandleStyle == 4) {
            if (this.errorCount == 100) {
                this.showMsg();
                this.isShowMsg = true;
                return true;
            }
            return false;
        }
        return false;
    }

    private void showMsg() {
        StringBuffer titleInfo = new StringBuffer();
        if (this.successCount > 0) {
            titleInfo.append(EASResource.getString((String)RES, (String)"success_import")).append(this.successCount).append(EASResource.getString((String)RES, (String)"item")).append("\n");
        }
        if (this.errorCount > 0) {
            titleInfo.append(EASResource.getString((String)RES, (String)"fail_import")).append(this.errorCount).append(EASResource.getString((String)RES, (String)"item"));
        }
        if (this.errorStr == null || this.errorStr.toString().trim().length() == 0) {
            if (this.successCount > 0) {
                titleInfo.append("\n" + EASResource.getString((String)RES, (String)"PLEASE_SAVE_INTIME"));
            }
            MsgBox.showInfo((Component)((Object)this), (String)titleInfo.toString());
        } else {
            titleInfo.append("\uff0c" + EASResource.getString((String)RES, (String)"PLEANSE_SEEDETAIL"));
            if (this.successCount > 0) {
                titleInfo.append("\n" + EASResource.getString((String)RES, (String)"PLEASE_SAVE_INTIME"));
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)titleInfo.toString(), (String)this.errorStr.toString(), (int)2);
        }
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        String path = "";
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(path);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn("excelTabName").setEditor((ICellEditor)itemEditor);
        this.comboLabel.addItemListener((ItemListener)new ItemListenerImpl());
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)new FileInputStream(path));
        this.workbook = new HSSFWorkbook(pfs);
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle valueStyle = workbook.createCellStyle();
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setHidden(true);
        BorderStyle borderstyle = BorderStyle.DOTTED;
        valueStyle.setBorderLeft(borderstyle);
        valueStyle.setBorderRight(borderstyle);
        valueStyle.setBorderTop(borderstyle);
        valueStyle.setBorderBottom(borderstyle);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"350_DeptSchemeEntryImportUI"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont(defaultFont);
        valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return valueStyle;
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setHidden(false);
        titleStyle.setLocked(false);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"350_DeptSchemeEntryImportUI"));
        defaultFont.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        short size = 13;
        defaultFont.setFontHeight(size);
        defaultFont.setFontHeightInPoints(size);
        titleStyle.setFont(defaultFont);
        return titleStyle;
    }

    private boolean checkTemplate(String filePath) {
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (!".xls".equals(str)) {
            return false;
        }
        int sheetNum = this.comboLabel.getSelectedIndex();
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        int rowNum = sheet.getPhysicalNumberOfRows();
        return rowNum >= 1;
    }

    private boolean checkFile() {
        HSSFSheet sheet;
        int rowNum;
        int sheetNum = this.comboLabel.getSelectedIndex();
        if (sheetNum < 0) {
            return false;
        }
        if (this.workbook == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                return false;
            }
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum)).getPhysicalNumberOfRows()) < 1) {
            return false;
        }
        HSSFRow row = sheet.getRow(0);
        if (row == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        int rows = row.getPhysicalNumberOfCells();
        HSSFRow headRow = sheet.getRow(0);
        String pNumber = EASResource.getString((String)RES, (String)"person_number");
        HSSFCell fCell = headRow.getCell(0);
        String value = ExcelUtil.getCellValue((HSSFCell)fCell);
        if (value == null || !value.trim().equals(pNumber + "*")) {
            return false;
        }
        String pName = EASResource.getString((String)RES, (String)"person_name");
        fCell = headRow.getCell(1);
        value = ExcelUtil.getCellValue((HSSFCell)fCell);
        if (value == null || !value.trim().equals(pName)) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        String itemNameError = EASResource.getString((String)RES, (String)"cmpItem_name_error");
        String at = EASResource.getString((String)RES, (String)"at");
        boolean hasCmpItemError = false;
        int j = rows - 2;
        for (int i = 0; i < j; ++i) {
            fCell = headRow.getCell((int)((short)(i + 2)));
            value = ExcelUtil.getCellValue((HSSFCell)fCell);
            if (value == null || !this.cmpItemNameIds.containsKey(value.trim())) {
                sb.append(at).append(i + 3).append(itemNameError).append("\n");
                hasCmpItemError = true;
            }
            if (value == null) continue;
            this.realCmpItemNameIds.put(value.trim(), this.cmpItemNameIds.get(value.trim()));
        }
        if (hasCmpItemError) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"586_ImportDateEndDataUI"), (String)sb.toString(), (int)2);
            SysUtil.abort();
            return false;
        }
        return true;
    }

    @Override
    protected void chkUpdate_stateChanged(ChangeEvent e) throws Exception {
        super.chkUpdate_stateChanged(e);
        if (this.chkUpdate.isSelected()) {
            this.chkAdd.setSelected(false);
        }
    }

    @Override
    protected void chkAdd_stateChanged(ChangeEvent e) throws Exception {
        super.chkAdd_stateChanged(e);
        if (this.chkAdd.isSelected()) {
            this.chkUpdate.setSelected(false);
        }
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object obj = ImportDateEndDataUI.this.comboLabel.getSelectedItem();
            if (obj != null) {
                ICell cell = ImportDateEndDataUI.this.tblMain.getCell(0, "excelTabName");
                cell.setValue((Object)obj.toString());
            }
        }
    }
}

