/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.AbstractCmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpReportFacade;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.client.AbstractMyCmp;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MyCmp
extends AbstractMyCmp {
    private static final Logger logger = CoreUIObject.getLogger(MyCmp.class);
    private PersonInfo curPerson = null;
    private DynamicTableInfo infoDynamicTable = new DynamicTableInfo();
    private String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initLoadData();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        FilterInfo filter = new FilterInfo("shutMyCmp = 0 or shutMyCmp is null");
        filterInfo.mergeFilter(filter, "and");
        evi.setFilter(filterInfo);
        this.bizPromptBoxCmpPeriod = HRSchemeUtils.getCmpPeriodF7(this.bizPromptBoxCmpPeriod, evi);
        this.bizPromptBoxCmpPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                CmpPeriodInfo infoCmpPeriod = (CmpPeriodInfo)MyCmp.this.bizPromptBoxCmpPeriod.getData();
                if (infoCmpPeriod != null) {
                    try {
                        MyCmp.this.doCmpPeriod(infoCmpPeriod);
                    }
                    catch (Exception e) {
                        MyCmp.this.handleException(e);
                    }
                } else {
                    if (MyCmp.this.tblMain.getColumnCount() > 0) {
                        MyCmp.this.tblMain.removeColumns();
                    }
                    MyCmp.this.lblDescription.setText(null);
                }
            }
        });
    }

    private void initLoadData() throws Exception {
        PersonPositionInfo ppInfo;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.curPerson = userInfo.getPerson();
        if (this.curPerson == null) {
            throw new HRAffairException(HRAffairException.CANNOT_FIND_PERSON);
        }
        this.lblName.setText(this.curPerson.getName());
        AdminOrgUnitInfo infoAdmin = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.adminOrgUnit.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.curPerson.getId().toString()));
        entityViewInfo.setFilter(filterInfo);
        PersonPositionCollection ppcoll = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(entityViewInfo);
        if (ppcoll.size() > 0 && (ppInfo = ppcoll.get(0)).getPrimaryPosition() != null) {
            infoAdmin = ppInfo.getPrimaryPosition().getAdminOrgUnit();
        }
        if (infoAdmin != null) {
            this.lblDepartment.setText(infoAdmin.getName());
        }
    }

    private void doCmpPeriod(CmpPeriodInfo infoCmpPeriod) throws Exception {
        ICmpReportFacade iCmpReportFacade;
        Map hstData;
        if (this.tblMain.getColumnCount() > 0) {
            this.tblMain.removeColumns();
        }
        if ((hstData = (iCmpReportFacade = CmpReportFacadeFactory.getRemoteInstance()).getMyCmpData(this.curPerson.getId().toString(), infoCmpPeriod.getId().toString())) != null && !hstData.isEmpty() && hstData.keySet().size() > 1) {
            if (this.chkRepeatx.isSelected()) {
                this.createTableRepeatx(hstData);
                this.loadTableDataRepeatx(hstData);
            } else {
                this.createTable(hstData);
                this.loadTableData(hstData);
            }
        } else {
            StringBuffer sb = new StringBuffer("");
            sb.append("<html><title></title><body>");
            sb.append(" ");
            sb.append("<font face='" + HRReportUtils.getReportHtmlResource("HEITI") + "' size='4' color='red'>&nbsp;&nbsp;&nbsp;" + HRReportUtils.getReportHtmlResource("noData") + "");
            sb.append("</font>");
            sb.append("</body></html>");
            this.lblDescription.setText(sb.toString());
        }
    }

    private void createTable(Map hstData) throws Exception {
        this.tblMain.setRefresh(false);
        List lstColumn = this.getTblMainColumn(hstData);
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[lstColumn.size()];
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infosColumn[i] = (DynamicTableInfo.ColumnInfo)lstColumn.get(i);
        }
        this.infoDynamicTable.setInfosColumn(infosColumn);
        this.infoDynamicTable.setCountHeadLine(2);
        this.infoDynamicTable.setHeadMergeMode(3);
        HRDynamicTableUtils.createTableHead(this.tblMain, this.infoDynamicTable);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
    }

    private void createTableRepeatx(Map hstData) throws Exception {
        int column = (Integer)hstData.get("number");
        this.tblMain.setRefresh(false);
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[column + 1];
        this.infoDynamicTable.setInfosColumn(infosColumn);
        this.infoDynamicTable.setCountHeadLine(1);
        this.infoDynamicTable.setHeadMergeMode(3);
        HRDynamicTableUtils.createTableHead(this.tblMain, this.infoDynamicTable);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
    }

    private int getRow(Map hstData) {
        HashMap schemeTimesMap = (HashMap)hstData.get("CmpSchemeTimes");
        Iterator itrSchemeTimesMap = schemeTimesMap.entrySet().iterator();
        int row = 0;
        Map.Entry entry = null;
        while (itrSchemeTimesMap.hasNext()) {
            entry = itrSchemeTimesMap.next();
            CmpSchemeInfo infoCmpScheme = (CmpSchemeInfo)entry.getKey();
            if (hstData.get(infoCmpScheme) == null) continue;
            int size = ((int[])entry.getValue()).length;
            row += 3 + size;
        }
        return ++row;
    }

    private List getTblMainColumn(Map hstData) {
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumn = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo infoColumn = null;
        CmpSchemeInfo infoCmpScheme = null;
        String strColumn = null;
        Map schemeTimesMap = (Map)hstData.get("CmpSchemeTimes");
        String strAmount = EASResource.getString((String)(this.resClass + "AMOUNT"));
        String strCmpItem = EASResource.getString((String)(this.resClass + "CMP_ITEM"));
        for (Object obj : hstData.keySet()) {
            if (!(obj instanceof CmpSchemeInfo)) continue;
            infoCmpScheme = (CmpSchemeInfo)obj;
            int[] times = (int[])schemeTimesMap.get(infoCmpScheme);
            strColumn = infoCmpScheme.getName() + strCmpItem;
            infoColumn = new DynamicTableInfo.ColumnInfo();
            infoColumn.setHide(false);
            infoColumn.setReadOnly(true);
            infoColumn.setLocked(true);
            infoColumn.setType(30);
            infoColumn.setColumnType(30);
            infoColumn.setKey(strColumn);
            infoColumn.setColumnNumber(strColumn);
            infoColumn.setColumnName(strColumn);
            infoColumn.setAlignHor(Styles.HorizontalAlignment.LEFT);
            infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
            infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[0].setHeadName(infoCmpScheme.getName());
            infoColumn.getInfosHead()[0].setHeadValue(infoCmpScheme.getName());
            infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[1].setHeadName(strCmpItem);
            infoColumn.getInfosHead()[1].setHeadValue(strCmpItem);
            lstColumn.add(infoColumn);
            for (int i = 0; i < times.length; ++i) {
                String columnName = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"744_MyCmp", (String[])new String[]{String.valueOf(times[i])});
                strColumn = infoCmpScheme.getName() + strAmount + i;
                infoColumn = new DynamicTableInfo.ColumnInfo();
                infoColumn.setHide(false);
                infoColumn.setReadOnly(true);
                infoColumn.setLocked(true);
                infoColumn.setType(60);
                infoColumn.setColumnType(60);
                infoColumn.setKey(strColumn);
                infoColumn.setColumnNumber(strColumn);
                infoColumn.setColumnName(strColumn);
                infoColumn.setWidth(120);
                infoColumn.setAlignHor(Styles.HorizontalAlignment.RIGHT);
                infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
                infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[0].setHeadName(infoCmpScheme.getName());
                infoColumn.getInfosHead()[0].setHeadValue(infoCmpScheme.getName());
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(columnName);
                infoColumn.getInfosHead()[1].setHeadValue(columnName);
                lstColumn.add(infoColumn);
            }
            lstColumn.add(HRSchemeUtils.getSplitColumn(this.infoDynamicTable));
        }
        if (lstColumn.size() > 1) {
            lstColumn.remove(lstColumn.size() - 1);
        }
        return lstColumn;
    }

    public static void swap(ArrayList list, int i, int j) {
        Object obj = list.get(i);
        list.set(i, list.get(j));
        list.set(j, obj);
    }

    public static ArrayList getSortKeyList(HashMap map) {
        ArrayList list = new ArrayList();
        Iterator iter = map.keySet().iterator();
        int count = 0;
        while (iter.hasNext()) {
            list.add(count, iter.next());
            ++count;
        }
        for (int i = 0; i < list.size(); ++i) {
            for (int j = list.size() - 1; j > i; --j) {
                if (((CmpSchemeItemInfo)list.get(j)).getSortOrder() >= ((CmpSchemeItemInfo)list.get(j - 1)).getSortOrder()) continue;
                MyCmp.swap(list, j, j - 1);
            }
        }
        return list;
    }

    private void loadTableDataRepeatx(Map hstData) throws Exception {
        HashMap schemeTimesMap = (HashMap)hstData.get("CmpSchemeTimes");
        this.tblMain.removeRows();
        int row = this.getRow(hstData);
        int column = (Integer)hstData.get("number");
        int count = 0;
        this.tblMain.addRows(row);
        KDTMergeManager mm = this.tblMain.getMergeManager();
        HashMap hspValue = null;
        HashMap timeValueMap = null;
        AbstractCmpItemInfo infoCmpItem = null;
        Iterator itrHstData = hstData.keySet().iterator();
        ArrayList list = null;
        while (itrHstData.hasNext()) {
            Object obj = itrHstData.next();
            if (!(obj instanceof CmpSchemeInfo)) continue;
            CmpSchemeInfo infoCmpScheme = (CmpSchemeInfo)obj;
            int[] times = (int[])schemeTimesMap.get(infoCmpScheme);
            int size = times.length;
            for (int i = 0; i < 3 + size; ++i) {
                CmpSchemeItemInfo infoCmpSchemeItem;
                int j;
                IRow rowCmpItem = this.tblMain.getRow(count);
                if (i == 0) {
                    mm.mergeBlock(count, 0, count, column, 4);
                    rowCmpItem.getCell(0).setValue((Object)infoCmpScheme);
                    rowCmpItem.getStyleAttributes().setBackground(HRReportUtils.UNEDIT_COLOR);
                } else if (i == 1) {
                    hspValue = (HashMap)hstData.get(infoCmpScheme);
                    list = MyCmp.getSortKeyList(hspValue);
                    for (j = 0; j < list.size() + 1; ++j) {
                        if (j == 0) {
                            rowCmpItem.getCell(j).setValue((Object)EASResource.getString((String)(this.resClass + "CMP_ITEM")));
                            rowCmpItem.getCell(j).getStyleAttributes().setBackground(HRReportUtils.UNEDIT_COLOR);
                            continue;
                        }
                        infoCmpSchemeItem = (CmpSchemeItemInfo)list.get(j - 1);
                        rowCmpItem.getCell(j).setValue((Object)infoCmpSchemeItem.getCmpItem().getName());
                        rowCmpItem.getCell(j).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                    }
                } else if (i == 2 + size) {
                    mm.mergeBlock(count, 0, count, column, 4);
                } else {
                    hspValue = (HashMap)hstData.get(infoCmpScheme);
                    list = MyCmp.getSortKeyList(hspValue);
                    for (j = 0; j < list.size() + 1; ++j) {
                        if (j == 0) {
                            rowCmpItem.getCell(j).setValue((Object)HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"744_MyCmp", (String[])new String[]{String.valueOf(times[i - 2])}));
                            rowCmpItem.getCell(j).getStyleAttributes().setBackground(HRReportUtils.UNEDIT_COLOR);
                            continue;
                        }
                        infoCmpSchemeItem = (CmpSchemeItemInfo)list.get(j - 1);
                        infoCmpItem = infoCmpSchemeItem.getCmpItem();
                        timeValueMap = (HashMap)hspValue.get(infoCmpSchemeItem);
                        rowCmpItem.getCell(j).setValue(timeValueMap.get(times[i - 2]));
                        rowCmpItem.getCell(j).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY) || infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                            rowCmpItem.getCell(j).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr(infoCmpItem.getDecDigital()));
                            continue;
                        }
                        if (!infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.DATE)) continue;
                        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
                        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
                        rowCmpItem.getCell(j).getStyleAttributes().setNumberFormat(sdf.toString());
                    }
                }
                ++count;
            }
        }
        BigDecimal bdTotal = (BigDecimal)hstData.get("total");
        for (int j = 0; j < column + 1; ++j) {
            if (j == 0) {
                this.tblMain.getRow(count).getCell(0).setValue((Object)EASResource.getString((String)(this.resClass + "SHOULDTOTAL")));
                continue;
            }
            mm.mergeBlock(count, 1, count, column, 4);
            this.tblMain.getRow(count).getCell(1).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr(infoCmpItem.getDecDigital()));
            this.tblMain.getRow(count).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getRow(count).getCell(1).setValue((Object)bdTotal);
        }
        this.tblMain.getRow(count).getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.setDescription(bdTotal, infoCmpItem.getDecDigital());
    }

    private void loadTableData(Map hstData) throws Exception {
        this.tblMain.removeRows();
        if (this.tblMain.getColumnCount() < 1) {
            return;
        }
        int countRow = (Integer)hstData.get("number");
        this.tblMain.addRows(countRow);
        IRow iRow = null;
        BigDecimal bdTotal = (BigDecimal)hstData.get("total");
        CmpSchemeInfo infoCmpScheme = null;
        CmpSchemeItemInfo infoCmpItem = null;
        CmpItemInfo itemInfo = null;
        HashMap hspValue = null;
        String strCmpItem = EASResource.getString((String)(this.resClass + "CMP_ITEM"));
        Iterator itrKey = hstData.keySet().iterator();
        ArrayList list = null;
        while (itrKey.hasNext()) {
            Object obj = itrKey.next();
            if (!(obj instanceof CmpSchemeInfo)) continue;
            infoCmpScheme = (CmpSchemeInfo)obj;
            hspValue = (HashMap)hstData.get(infoCmpScheme);
            int count = 0;
            int column = this.tblMain.getColumnIndex(infoCmpScheme.getName() + strCmpItem);
            list = MyCmp.getSortKeyList(hspValue);
            Map timeValueMap = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                infoCmpItem = (CmpSchemeItemInfo)list.get(i);
                timeValueMap = (Map)hspValue.get(infoCmpItem);
                IRow rowCmpItem = this.tblMain.getRow(count);
                ++count;
                itemInfo = infoCmpItem.getCmpItem();
                rowCmpItem.getCell(column).setValue((Object)itemInfo.getName());
                ArrayList newlist = new ArrayList();
                newlist.addAll(timeValueMap.keySet());
                Collections.sort(newlist);
                for (int j = 1; j <= newlist.size(); ++j) {
                    Integer times = (Integer)newlist.get(j - 1);
                    rowCmpItem.getCell(column + j).setValue(timeValueMap.get(times));
                    if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY) || itemInfo.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                        rowCmpItem.getCell(column + j).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr(itemInfo.getDecDigital()));
                        continue;
                    }
                    if (!itemInfo.getDataType().equals((Object)ItemDataTypeEnum.DATE)) continue;
                    String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
                    SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
                    rowCmpItem.getCell(column + j).getStyleAttributes().setNumberFormat(sdf.toString());
                }
            }
        }
        KDTMergeManager mm = this.tblMain.getMergeManager();
        iRow = this.tblMain.addRow();
        mm.mergeBlock(iRow.getRowIndex(), 0, iRow.getRowIndex(), this.tblMain.getColumnCount() - 1, 4);
        iRow = this.tblMain.addRow();
        itemInfo = (CmpItemInfo)HRCmpItemUtils.getCmpItemInfoByNumberNoPermission(null, new String[]{"FSAL006"}).get("FSAL006");
        iRow.getCell(1).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr(itemInfo.getDecDigital()));
        iRow.getCell(0).setValue((Object)EASResource.getString((String)(this.resClass + "SHOULDTOTAL")));
        iRow.getCell(1).setValue((Object)bdTotal);
        mm.mergeBlock(iRow.getRowIndex(), 1, iRow.getRowIndex(), this.tblMain.getColumnCount() - 1, 4);
        iRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
        this.setDescription(bdTotal, itemInfo.getDecDigital());
    }

    @Override
    protected void chkRepeatx_itemStateChanged(ItemEvent e) throws Exception {
        if (this.bizPromptBoxCmpPeriod.getData() != null) {
            CmpPeriodInfo infoCmpPeriod = (CmpPeriodInfo)this.bizPromptBoxCmpPeriod.getData();
            this.doCmpPeriod(infoCmpPeriod);
        }
    }

    private void setDescription(BigDecimal bdTotal, int digital) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<html><title></title><body>");
        sb.append(" ");
        sb.append("<font face='" + HRReportUtils.getReportHtmlResource("HEITI") + "' size='4' color='red'>&nbsp;&nbsp;&nbsp;" + HRReportUtils.getReportHtmlResource("myCmp_bz") + "");
        sb.append(bdTotal.setScale(digital, 4));
        sb.append("\u3002");
        sb.append("<br>");
        sb.append("&nbsp;&nbsp;&nbsp;");
        sb.append(HRReportUtils.getReportHtmlResource("myCmp_tqzy"));
        sb.append("</font>");
        sb.append("</body></html>");
        this.lblDescription.setText(sb.toString());
    }
}

