/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDBusiCurrencyField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.DepCmpStandSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.PlanMoneySourceCollection;
import com.kingdee.eas.hr.compensation.PlanMoneySourceException;
import com.kingdee.eas.hr.compensation.PlanMoneySourceFactory;
import com.kingdee.eas.hr.compensation.PlanMoneySourceInfo;
import com.kingdee.eas.hr.compensation.client.AbstractPlanMoneySourceListUI;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PlanMoneySourceListUI
extends AbstractPlanMoneySourceListUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanMoneySourceListUI.class);
    private final String JHJE = "jhje";
    private String RESOURCE_ISSAVEDATA = "com.kingdee.eas.hr.compensation.client.PlanMoneySourceResource.";
    private boolean isChang = false;
    boolean isChangeError = false;
    KDBusiCurrencyField field = new KDBusiCurrencyField();
    private DeptSchemeInfo deptSchemeInfo = null;
    private DepCmpStandradSchemeInfo depCmpStandradInfo = null;
    private CmpPeriodInfo cmpPeriodInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private void initTable() throws Exception {
        List adminOrgUnitList = (List)this.getUIContext().get("adminList");
        List indexList = (List)this.getUIContext().get("indexList");
        Map hashDeptPlan = (Map)this.getUIContext().get("hashDeptPlan");
        HashMap branchEmpMap = DeptSchemeEntryFactory.getRemoteInstance().getDeptPlanAmountIFForYT(this.deptSchemeInfo);
        if (adminOrgUnitList == null || adminOrgUnitList.size() == 0 || hashDeptPlan == null) {
            return;
        }
        int digit = this.deptSchemeInfo.getDecDigital();
        BigDecimal zero = null;
        zero = digit == 2 ? new BigDecimal("0.00") : (digit == 3 ? new BigDecimal("0.000") : (digit == 4 ? new BigDecimal("0.0000") : new BigDecimal(0)));
        if (this.tblMain.getBody().size() > 0) {
            int len = this.tblMain.getRowCount();
            for (int i = 0; i < len; ++i) {
                this.tblMain.removeRow(i);
            }
        }
        Map entryMap = (Map)this.getUIContext().get("DeptSchemeEntryMap");
        String adminOrgUnitId = null;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        IRow row = null;
        DeptSchemeEntryInfo infoEntry = null;
        int i = 0;
        int len = adminOrgUnitList.size();
        if (i < len) {
            adminOrgUnitId = (String)adminOrgUnitList.get(i);
            infoEntry = (DeptSchemeEntryInfo)entryMap.get(adminOrgUnitId);
            if (i == 0) {
                this.cmpPeriodInfo = infoEntry.getCmpPeriod();
            }
        }
        Map moneyAndYEMap = this.getMoneyAndPreYE(adminOrgUnitList);
        int len2 = adminOrgUnitList.size();
        for (int i2 = 0; i2 < len2; ++i2) {
            adminOrgUnitId = (String)adminOrgUnitList.get(i2);
            infoEntry = (DeptSchemeEntryInfo)entryMap.get(adminOrgUnitId);
            Object[] objs = (Object[])moneyAndYEMap.get(adminOrgUnitId);
            row = this.tblMain.addRow();
            row.setUserObject(indexList.get(i2));
            adminOrgUnitInfo = infoEntry.getAdminOrgUnit();
            row.getCell("adminOrgUnit").setValue((Object)adminOrgUnitInfo);
            if (branchEmpMap != null && branchEmpMap.size() != 0) {
                BigDecimal branchEmpObj = (BigDecimal)branchEmpMap.get(adminOrgUnitInfo.getId().toString());
                row.getCell("branchEmpCoefficient").setValue((Object)HRCmpItemUtils.formatBigDecimalWeiShu(this.deptSchemeInfo, branchEmpObj));
            } else {
                row.getCell("branchEmpCoefficient").setValue((Object)zero);
            }
            BigDecimal standardForeMoney = new BigDecimal("0.00");
            BigDecimal branchAssessMoney = (BigDecimal)objs[0];
            BigDecimal planMoney = (BigDecimal)objs[1];
            if (infoEntry.getDeptInnerScheme() != null && infoEntry.getDeptInnerScheme().getId() != null || infoEntry.isIsAudit()) {
                if (planMoney != null) {
                    standardForeMoney = planMoney.subtract(branchAssessMoney);
                }
            } else if (hashDeptPlan.get(adminOrgUnitInfo.getId().toString()) != null) {
                standardForeMoney = new BigDecimal(hashDeptPlan.get(adminOrgUnitInfo.getId().toString()).toString()).setScale(digit, 4);
            }
            if (standardForeMoney != null) {
                row.getCell("standarForeMoney").setValue((Object)HRCmpItemUtils.formatBigDecimalWeiShu(this.deptSchemeInfo, standardForeMoney));
            } else {
                row.getCell("standarForeMoney").setValue((Object)zero);
            }
            row.getCell("branchAssessMoney").setValue((Object)branchAssessMoney.setScale(digit, 4));
            BigDecimal upPeriodBranchBalance = (BigDecimal)objs[2];
            row.getCell("upPeriodBranchBalance").setValue((Object)HRCmpItemUtils.formatBigDecimalWeiShu(this.deptSchemeInfo, upPeriodBranchBalance));
            if (standardForeMoney != null) {
                planMoney = standardForeMoney.add(branchAssessMoney);
                row.getCell("planMoney").setValue((Object)planMoney);
            } else {
                row.getCell("planMoney").setValue((Object)zero);
            }
            if (row.getCell("standarForeMoney").getValue() != null && row.getCell("branchAssessMoney").getValue() != null && new BigDecimal(row.getCell("standarForeMoney").getValue().toString()).intValue() != 0 && new BigDecimal(row.getCell("branchAssessMoney").getValue().toString()).intValue() == 0) {
                row.getCell("planMoney").setValue((Object)HRCmpItemUtils.formatBigDecimalWeiShu(this.deptSchemeInfo, standardForeMoney));
            }
            BigDecimal currPeriodTotal = null;
            if (planMoney != null && upPeriodBranchBalance != null) {
                currPeriodTotal = planMoney.add(upPeriodBranchBalance);
                row.getCell("currPeriodTotal").setValue((Object)currPeriodTotal.setScale(digit, 4));
            } else {
                row.getCell("currPeriodTotal").setValue((Object)zero);
            }
            if (row.getCell("planMoney").getValue() != null && row.getCell("upPeriodBranchBalance").getValue() != null && new BigDecimal(row.getCell("planMoney").getValue().toString()).intValue() != 0 && new BigDecimal(row.getCell("upPeriodBranchBalance").getValue().toString()).intValue() == 0) {
                row.getCell("currPeriodTotal").setValue((Object)HRCmpItemUtils.formatBigDecimalWeiShu(this.deptSchemeInfo, new BigDecimal(row.getCell("planMoney").getValue().toString())));
            }
            if ((infoEntry.getDeptInnerScheme() == null || infoEntry.getDeptInnerScheme().getId() == null) && !infoEntry.isIsAudit()) continue;
            row.getCell("branchAssessMoney").getStyleAttributes().setBackground(Color.orange);
            row.getCell("branchAssessMoney").getStyleAttributes().setLocked(true);
        }
        if (this.cmpPeriodInfo != null) {
            for (int t = 1; t < 6; ++t) {
                this.tblMain.getHeadRow(0).getCell(t).setValue((Object)this.cmpPeriodInfo.getName());
            }
        }
    }

    private void hideButton() {
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnEdit.setEnabled(true);
        this.btnSave.setEnabled(false);
        this.btnLocate.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnQuery.setVisible(false);
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        PlanMoneySourceListUI.initCurrencyField((BasicFormattedTextField)this.field);
        this.field.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)this.field);
        this.tblMain.getColumn("branchAssessMoney").setEditor((ICellEditor)editor);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setText("");
        this.hideButton();
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.tblMain.getColumn("branchAssessMoney").getStyleAttributes().setBackground(Color.WHITE);
        this.setTableFormat();
        this.initTable();
        this.tblMain.getColumn("branchAssessMoney").getStyleAttributes().setLocked(true);
        HROrgUnitInfo currHRUnit = this.getCurrHRUnit();
        if (currHRUnit != null) {
            if (!this.isHaveBranchEmpCoefficient(currHRUnit)) {
                this.tblMain.getColumn("branchEmpCoefficient").getStyleAttributes().setHided(true);
            }
            String branchEmpXishu = this.getCmpItemNameByNumber("FOTH2166", currHRUnit);
            this.tblMain.getHeadRow(1).getCell("branchEmpCoefficient").setValue((Object)branchEmpXishu);
            String branchAssessXishu = this.getCmpItemNameByNumber("FOTH2167", currHRUnit);
            this.tblMain.getHeadRow(1).getCell("branchAssessMoney").setValue((Object)branchAssessXishu);
        }
    }

    private HROrgUnitInfo getCurrHRUnit() {
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    private boolean isHaveBranchEmpCoefficient(HROrgUnitInfo currHR) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("depCmpStardScheme.id", (Object)this.depCmpStandradInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FOTH2166"));
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.hrOrgUnit.id", (Object)currHR.getId().toString()));
        return DepCmpStandSchemeEntryFactory.getRemoteInstance().exists(filter);
    }

    private String getCmpItemNameByNumber(String cmpItemNumber, HROrgUnitInfo hrInfo) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)cmpItemNumber));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrInfo.getId().toString()));
        evi.setFilter(filter);
        CmpItemCollection coll = CmpItemFactory.getRemoteInstance().getCmpItemCollection(evi);
        if (coll != null && coll.size() > 0) {
            CmpItemInfo info = coll.get(0);
            String formatString = HRCmpItemUtils.getColumnFormatStr(info.getDecDigital());
            if (!cmpItemNumber.equals("FOTH2167") && cmpItemNumber.equals("FOTH2166")) {
                this.tblMain.getColumn("branchEmpCoefficient").getStyleAttributes().setNumberFormat(formatString);
            }
            return info.getName();
        }
        return null;
    }

    private void checkInput() {
        int len = this.tblMain.getRowCount();
        for (int i = 0; i < len; ++i) {
            String obj = this.tblMain.getRow(i).getCell("branchAssessMoney").getValue() == null ? "0.00" : this.tblMain.getRow(i).getCell("branchAssessMoney").getValue();
            try {
                new BigDecimal(obj.toString());
                continue;
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"598_PlanMoneySourceListUI"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isChangeError) {
            this.checkInput();
            List indexList = (List)this.getUIContext().get("indexList");
            KDTable table = (KDTable)this.getUIContext().get("deptSchemeEntryEditUI_kdTable");
            table.checkParsed();
            Map entryMap = (Map)this.getUIContext().get("DeptSchemeEntryMap");
            DeptSchemeEntryInfo deptSchemeEntryInfo = null;
            String sql = " update t_hr_deptschemeentry set FAmountPlan = ? where fid = ? ";
            BigDecimal planMoney = new BigDecimal("0.00");
            BigDecimal branchAssessMoney = null;
            int len = this.tblMain.getRowCount();
            for (int i = 0; i < len; ++i) {
                Object obj = this.tblMain.getRow(i).getCell("planMoney").getValue();
                if (obj != null) {
                    planMoney = (BigDecimal)obj;
                }
                branchAssessMoney = new BigDecimal(this.tblMain.getRow(i).getCell("branchAssessMoney").getValue() == null ? "0.00" : this.tblMain.getRow(i).getCell("branchAssessMoney").getValue().toString());
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.tblMain.getRow(i).getCell("adminOrgUnit").getValue();
                String adminOrgUnitId = adminOrgUnitInfo.getId().toString();
                deptSchemeEntryInfo = (DeptSchemeEntryInfo)entryMap.get(adminOrgUnitId);
                PlanMoneySourceInfo planMoneySourceInfo = this.getPlanMoneySourceInfo(this.deptSchemeInfo, adminOrgUnitInfo, this.cmpPeriodInfo);
                if (planMoneySourceInfo == null) {
                    planMoneySourceInfo = new PlanMoneySourceInfo();
                    planMoneySourceInfo.setDeptSceme(this.deptSchemeInfo);
                    planMoneySourceInfo.setCmpPeriod(this.cmpPeriodInfo);
                    planMoneySourceInfo.setAdminOrgUnit(adminOrgUnitInfo);
                    planMoneySourceInfo.setBranchAssessMoney(branchAssessMoney);
                    planMoneySourceInfo.setPlanMoney(planMoney);
                    PlanMoneySourceFactory.getRemoteInstance().save((CoreBaseInfo)planMoneySourceInfo);
                } else {
                    planMoneySourceInfo.setBranchAssessMoney(branchAssessMoney);
                    planMoneySourceInfo.setPlanMoney(planMoney);
                    PlanMoneySourceFactory.getRemoteInstance().update((IObjectPK)new ObjectStringPK(planMoneySourceInfo.getId().toString()), planMoneySourceInfo);
                }
                PlanMoneySourceFactory.getRemoteInstance().executeSQL(sql, new Object[]{planMoney, deptSchemeEntryInfo.getId().toString()});
                int index = (Integer)this.tblMain.getRow(i).getUserObject();
                if (indexList == null) continue;
                table.getCell(index, "jhje" + this.cmpPeriodInfo.getId().toString()).setValue((Object)planMoney);
            }
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.tblMain.getColumn("branchAssessMoney").getStyleAttributes().setLocked(true);
            this.isChang = false;
        }
    }

    private PlanMoneySourceInfo getPlanMoneySourceInfo(DeptSchemeInfo deptScheme, AdminOrgUnitInfo adminOrgUnit, CmpPeriodInfo cmpPeriod) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deptSceme.id", (Object)deptScheme.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)cmpPeriod.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminOrgUnit.getId().toString()));
        evi.setFilter(filter);
        PlanMoneySourceCollection coll = PlanMoneySourceFactory.getRemoteInstance().getPlanMoneySourceCollection(evi);
        if (coll != null && coll.size() > 0) {
            PlanMoneySourceInfo info = coll.get(0);
            return info;
        }
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getKeyFieldName() {
        return "adminOrgUnit";
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.btnSave.setEnabled(true);
        this.btnEdit.setEnabled(false);
        this.setRowLocked();
    }

    private void setRowLocked() throws BOSException {
        List adminOrgUnitList = (List)this.getUIContext().get("adminList");
        Map entryMap = (Map)this.getUIContext().get("DeptSchemeEntryMap");
        String adminOrgUnitId = null;
        IRow row = null;
        DeptSchemeEntryInfo infoEntry = null;
        int len = adminOrgUnitList.size();
        for (int i = 0; i < len; ++i) {
            adminOrgUnitId = (String)adminOrgUnitList.get(i);
            infoEntry = (DeptSchemeEntryInfo)entryMap.get(adminOrgUnitId);
            row = this.tblMain.getRow(i);
            if (infoEntry.getDeptInnerScheme() != null && infoEntry.getDeptInnerScheme().getId() != null || infoEntry.isIsAudit()) {
                row.getCell("branchAssessMoney").getStyleAttributes().setBackground(Color.orange);
                row.getCell("branchAssessMoney").getStyleAttributes().setLocked(true);
                continue;
            }
            if (row == null) continue;
            row.getCell("branchAssessMoney").getStyleAttributes().setLocked(false);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        try {
            if (e == null) {
                return;
            }
            String kaohejin = this.tblMain.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue() == null ? "0.0" : this.tblMain.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue().toString();
            BigDecimal branchAssessMoney = null;
            branchAssessMoney = new BigDecimal(kaohejin);
            String jihuajin = this.tblMain.getRow(e.getRowIndex()).getCell("standarForeMoney").getValue() == null ? "0.0" : this.tblMain.getRow(e.getRowIndex()).getCell("standarForeMoney").getValue().toString();
            BigDecimal standarForeMoney = new BigDecimal(jihuajin);
            BigDecimal planMoney = null;
            if (branchAssessMoney != null && standarForeMoney != null) {
                planMoney = branchAssessMoney.add(standarForeMoney);
                this.tblMain.getRow(e.getRowIndex()).getCell("planMoney").setValue((Object)planMoney);
            }
            BigDecimal upPeriodBranchBalance = (BigDecimal)this.tblMain.getRow(e.getRowIndex()).getCell("upPeriodBranchBalance").getValue();
            BigDecimal currPeriodTotal = null;
            if (upPeriodBranchBalance != null && planMoney != null) {
                currPeriodTotal = upPeriodBranchBalance.add(planMoney);
                this.tblMain.getRow(e.getRowIndex()).getCell("currPeriodTotal").setValue((Object)currPeriodTotal);
            }
            if (e.getOldValue() == null && e.getValue() == null) {
                return;
            }
            if (e.getOldValue() instanceof BigDecimal) {
                if (branchAssessMoney.compareTo((BigDecimal)e.getOldValue()) != 0) {
                    this.isChang = true;
                }
            } else if (e.getOldValue() instanceof String && new BigDecimal((String)e.getOldValue()).compareTo(branchAssessMoney) != 0) {
                this.isChang = true;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage(), ex);
        }
    }

    @Override
    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        Object obj = e.getValue();
        if (obj != null && obj.toString().length() != 0) {
            try {
                new BigDecimal(obj.toString());
                this.isChangeError = false;
            }
            catch (Exception ex) {
                e.setCancel(true);
                this.isChangeError = true;
                throw new PlanMoneySourceException(PlanMoneySourceException.INPUTEXCEPTION);
            }
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.initTable();
    }

    public boolean destroyWindow() {
        if (this.isChang) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                try {
                    this.isChang = false;
                    this.btnRefresh.setRequestFocusEnabled(true);
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (result == 2) {
                return false;
            }
            return super.destroyWindow();
        }
        return super.destroyWindow();
    }

    private Map getMoneyAndPreYE(List adminOrgUnitList) throws EASBizException, BOSException {
        return PlanMoneySourceFactory.getRemoteInstance().getMoneyAndPreYE(adminOrgUnitList, this.cmpPeriodInfo, this.deptSchemeInfo.getId().toString(), false);
    }

    private void setTableFormat() {
        this.deptSchemeInfo = (DeptSchemeInfo)this.getUIContext().get("deptSchemeInfo");
        this.depCmpStandradInfo = this.deptSchemeInfo.getDepCmpStandrad();
        int digit = this.deptSchemeInfo.getDecDigital();
        String formatString = HRCmpItemUtils.getColumnFormatStr(digit);
        this.tblMain.getColumn("branchEmpCoefficient").getStyleAttributes().setNumberFormat(formatString);
        this.tblMain.getColumn("standarForeMoney").getStyleAttributes().setNumberFormat(formatString);
        this.tblMain.getColumn("branchAssessMoney").getStyleAttributes().setNumberFormat(formatString);
        this.tblMain.getColumn("planMoney").getStyleAttributes().setNumberFormat(formatString);
        this.tblMain.getColumn("upPeriodBranchBalance").getStyleAttributes().setNumberFormat(formatString);
        this.tblMain.getColumn("currPeriodTotal").getStyleAttributes().setNumberFormat(formatString);
    }

    public static void initCurrencyField(BasicFormattedTextField txt) {
        txt.setHorizontalAlignment(4);
        if (txt instanceof KDFormattedTextField) {
            KDFormattedTextField ftTxt = (KDFormattedTextField)txt;
            ftTxt.setDataType(BigDecimal.class);
            ftTxt.setPrecision(4);
            ftTxt.setRemoveingZeroInDispaly(false);
            ftTxt.setRemoveingZeroInEdit(true);
        } else if (txt instanceof KDNumberTextField) {
            KDNumberTextField numText = (KDNumberTextField)txt;
            numText.setDataType(BigDecimal.class);
            numText.setPrecision(4);
            numText.setRemoveingZeroInDispaly(false);
            numText.setRemoveingZeroInEdit(true);
        } else if (txt instanceof KDBusiCurrencyField) {
            KDBusiCurrencyField currencyText = (KDBusiCurrencyField)txt;
            currencyText.setPrecision(4);
            currencyText.setDataType(BigDecimal.class);
            currencyText.setRemoveingZeroInDispaly(false);
            currencyText.setRemoveingZeroInEdit(true);
        }
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
    }

    protected void lockAction() {
        super.lockAction();
    }

    @Override
    public void actionCloseWin_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isChangeError) {
            this.destroyWindow();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        return null;
    }
}

