/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.ICmpSchemePerson;
import com.kingdee.eas.hr.compensation.client.AbstractRemovePersonListUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class RemovePersonListUI
extends AbstractRemovePersonListUI {
    private static final Logger logger = CoreUIObject.getLogger(RemovePersonListUI.class);
    private final String personListCtxKey = "personList";
    private final String displayLongName = "displayLongName";
    private final String synPersonSet = "synPersonSet";
    private final String PersonID_Cell = "personID";
    private final String PersonName_Cell = "personName";
    private final String PersonNumber_Cell = "personNumber";
    private final String DeptName_Cell = "deptName";
    private final String PositionName_Cell = "positionName";
    private boolean isDelete = false;
    private boolean isSync = false;
    private List personLists = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
    }

    private void initTable() {
        List personLst = (List)this.getUIContext().get(this.personListCtxKey);
        this.fillPersonTableRow(personLst);
    }

    private void fillPersonTableRow(List personLst) {
        CmpSchemePersonInfo info = null;
        PersonInfo infoPerson = null;
        IRow iRow = null;
        CmpSchemePersonInfo perinfo = null;
        int length = personLst.size();
        for (int i = 0; i < length; ++i) {
            info = (CmpSchemePersonInfo)personLst.get(i);
            infoPerson = info.getPerson();
            String oql = "select id,person.id,person.name,person.number,adminOrgUnit.id,adminOrgUnit.name,adminOrgUnit.displayName,position.id,position.name where cmpScheme.id ='" + info.getCmpScheme().getId().toString() + "' and isDelete = 0 and person.id='" + infoPerson.getId().toString() + "'";
            ICmpSchemePerson icsp = null;
            try {
                icsp = CmpSchemePersonFactory.getRemoteInstance();
                perinfo = icsp.getCmpSchemePersonInfo(oql);
                infoPerson = perinfo.getPerson();
                iRow = this.tblMain.addRow();
                ICell iCell = null;
                iCell = iRow.getCell(this.PersonID_Cell);
                if (iCell != null) {
                    iCell.setValue((Object)infoPerson.getId().toString());
                }
                if ((iCell = iRow.getCell(this.PersonName_Cell)) != null) {
                    iCell.setValue((Object)infoPerson.getName());
                }
                if ((iCell = iRow.getCell(this.PersonNumber_Cell)) != null) {
                    iCell.setValue((Object)infoPerson.getNumber());
                }
                if ((iCell = iRow.getCell(this.DeptName_Cell)) != null) {
                    iCell.setValue((Object)perinfo.getAdminOrgUnit());
                }
                if ((iCell = iRow.getCell(this.PositionName_Cell)) == null) continue;
                iCell.setValue((Object)perinfo.getPosition());
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void actionRemovePerson_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionRemovePerson_actionPerformed(e);
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        Object[] obj = new Object[this.tblMain.getRowCount()];
        for (i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int bottom = sb.getBottom();
            int j = sb.getTop();
            if (sb.getMode() == 8) {
                bottom = this.tblMain.getRowCount() - 1;
                j = 0;
            }
            while (j <= bottom) {
                obj[j] = " delete";
                ++j;
            }
        }
        for (i = obj.length - 1; i >= 0; --i) {
            if (obj[i] == null) continue;
            this.tblMain.removeRow(i);
        }
        if (this.tblMain.getRowCount() >= 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.ctnPerson.setEnableActive(false);
        this.ctnPerson.addButton((JButton)this.btnRemoveRow);
        this.btnSyncAdminAndPosition.setIcon(EASResource.getIcon((String)"imgTbtn_autoarrange"));
        this.btnSyncAdminAndPosition.setText(null);
        this.btnSyncAdminAndPosition.setEnabled(true);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRemove.setText(null);
        this.btnRemoveRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveRow.setText(null);
        this.btnRemoveRow.setEnabled(true);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isDelete = false;
        this.isSync = false;
        this.actionExitCurrent_actionPerformed(null);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        this.personLists = this.getPersonList();
        this.tblMain.removeRows();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.isDelete = true;
        this.actionExitCurrent_actionPerformed(null);
    }

    @Override
    public void actionSyncAdminAndPosition_actionPerformed(ActionEvent e) throws Exception {
        HashSet synPersonSet = (HashSet)this.getUIContext().get(this.synPersonSet);
        List personList = this.getPersonList();
        if (personList == null || personList.size() < 1) {
            return;
        }
        if (this.confirmSyn()) {
            int i;
            String personID = null;
            String[] idList = new String[this.tblMain.getRowCount()];
            HashMap<String, Integer> id_index_map = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < idList.length; ++i2) {
                personID = this.tblMain.getRow(i2).getCell("personID").getValue().toString();
                if (!synPersonSet.contains(personID)) continue;
                idList[i2] = personID;
                id_index_map.put(personID, i2);
            }
            HashMap valueMap = HRUtils.getPersonOrgAndPositionByIds(idList);
            Object[] personIds = valueMap.keySet().toArray();
            Object[] adminAndPosition = null;
            AdminOrgUnitInfo adminInfo = null;
            PositionInfo positionInfo = null;
            IRow row = null;
            String personId = null;
            for (i = 0; i < personIds.length; ++i) {
                personId = (String)personIds[i];
                adminAndPosition = (Object[])valueMap.get(personId);
                adminInfo = (AdminOrgUnitInfo)adminAndPosition[0];
                adminInfo.setSimpleName(adminInfo.getName());
                adminInfo.setDisplayName(adminInfo.getDisplayName());
            }
            for (i = 0; i < personIds.length; ++i) {
                personId = (String)personIds[i];
                adminAndPosition = (Object[])valueMap.get(personId);
                adminInfo = (AdminOrgUnitInfo)adminAndPosition[0];
                Boolean chkDisplayLongName = (Boolean)this.getUIContext().get(this.displayLongName);
                if (chkDisplayLongName.booleanValue()) {
                    adminInfo.setName(adminInfo.getDisplayName());
                } else {
                    adminInfo.setName(adminInfo.getSimpleName());
                }
                positionInfo = (PositionInfo)adminAndPosition[1];
                row = this.tblMain.getRow(((Integer)id_index_map.get(personId)).intValue());
                row.getCell("deptName").setValue((Object)adminInfo);
                row.getCell("positionName").setValue((Object)positionInfo);
            }
            this.isSync = true;
        }
    }

    protected boolean confirmSyn() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.CmpSchemeEditPersonSysResource.COMFIRM_SYN2")));
    }

    public List getPersonList() {
        ArrayList<String> al = new ArrayList<String>();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            al.add((String)this.tblMain.getCell(i, this.PersonID_Cell).getValue());
        }
        return al;
    }

    public boolean getIsDelete() {
        return this.isDelete;
    }

    public boolean getIsSync() {
        return this.isSync;
    }

    public List getPersonLists() {
        return this.personLists;
    }
}

