/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ISHReportFacade;
import com.kingdee.eas.hr.compensation.SHReportFacadeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractSHRcmpTotalReportListUI;
import com.kingdee.eas.hr.compensation.client.SHRcmpTotalReportFilterUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SHRcmpTotalReportListUI
extends AbstractSHRcmpTotalReportListUI {
    private static final String resourceURL = "com.kingdee.eas.hr.compensation.client.SHRcmpResource.";
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog commonQueryDialog = null;
    private static final String YF = "MONTH";
    private static final String RC = "PERSONNUMBER";
    private static final String ZJ = "SUMMARY";
    private static final String RJ = "PERSONNUMBERAVERAGE";
    private static final String XJ = "SUBSUMMARY";
    private static final String JSGZ = "JSGZ";
    private static final String GNGZ = "GNGZ";
    private static final String YT = "FFSAL209";
    private static final String WJ = "FFSAL211";
    private static final String TSJT = "FFSAL238";
    private static final String JBH = "FFSAL240";
    private static final String ZYBH = "FFSAL242";
    private static final String KQT = "FFSAL244";
    private static final String DQT = "FFSAL246";
    private static final String XSH = "FFSAL284";
    private static final String JJ = "FSAL002";
    private static final String YCXJ1 = "FFSAL253";
    private static final String SX = "FFSAL224";
    private static final String XZQJ = "Fperiod";
    private ISHReportFacade iSHReportFacade = null;
    private HashMap paramMap = new HashMap();
    private String OperationFlag = "";
    private List cmpItemList = new ArrayList();
    private HashMap mapDept = new HashMap();

    protected ISHReportFacade getSHReportFacadeBizInterface() throws BOSException {
        if (this.iSHReportFacade == null) {
            this.iSHReportFacade = SHReportFacadeFactory.getRemoteInstance();
        }
        return this.iSHReportFacade;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        HRUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        this.showFilterDialog();
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    private void initAllEditor() {
        this.tblMain.checkParsed();
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.tblMain.getSelectManager().setSelectMode(2);
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        mm.mergeBlock(0, 0, 1, this.tblMain.getColumnCount() - 1, 3);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.setButtonDefaultStyl(this.btnPrintView);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnQuery);
    }

    private void encloseCmpItem(boolean allFlag) {
        this.cmpItemList.clear();
        if (allFlag) {
            this.cmpItemList.add(RC);
            this.cmpItemList.add(JSGZ);
            this.cmpItemList.add(GNGZ);
            this.cmpItemList.add(JJ);
            this.cmpItemList.add(YCXJ1);
            this.cmpItemList.add(SX);
            this.cmpItemList.add(JBH);
        }
        this.cmpItemList.add(YT);
        this.cmpItemList.add(TSJT);
        this.cmpItemList.add(KQT);
        this.cmpItemList.add(DQT);
        this.cmpItemList.add(WJ);
        this.cmpItemList.add(ZYBH);
        this.cmpItemList.add(XSH);
    }

    private void loadDate() throws Exception {
        HashMap dataMap = this.getSHReportFacadeBizInterface().getTotalData(this.paramMap);
        this.fillDateToTable(dataMap);
    }

    private void fillDateToTable(HashMap dataMap) throws Exception {
        IRow row = this.tblMain.getHeadRow(0);
        if (row != null && row.getCell(YF) != null) {
            row.getCell(YF).setValue((Object)HRReportUtils.getResource(YF));
        }
        this.tblMain.removeRows();
        if (this.OperationFlag.equals("personalFlag")) {
            this.processPersonalTotal(dataMap);
        } else if (this.OperationFlag.equals("departmentFlag")) {
            this.processDepartmentTotal(dataMap);
        } else if (this.OperationFlag.equals("companyFlag")) {
            this.processCompanyTotal(dataMap);
        }
    }

    private void processCompanyTotal(HashMap dataMap) throws Exception {
        this.doTableHeadInfo();
        List periodList = (List)this.paramMap.get("periodList");
        int size = periodList.size();
        if (size == 0) {
            return;
        }
        IRowSet rowSet = (IRowSet)dataMap.get("fillData");
        if (rowSet.size() == 0) {
            this.doHeader();
            return;
        }
        this.encloseCmpItem(true);
        this.enCloseCompanyWithDeptDate(rowSet);
        this.doCompanyOtherTable(this.tblMain.getRowCount());
    }

    private void enCloseCompanyWithDeptDate(IRowSet companyTotalSet) throws BOSException {
        if (companyTotalSet.size() == 0) {
            return;
        }
        ArrayList<String> lstSHSpecial = new ArrayList<String>();
        String otherDeptLongNumber = "00!01!99";
        String workOutLongNumber = "workOutKey";
        String workOutlayerId = "wO/cOwENEADgAj3bCgrIEgzgjS4=";
        String workOutlayerId1 = "wO/cOwENEADgAj6tCgrIEgzgjS4=";
        lstSHSpecial.add(workOutLongNumber);
        String cbjLongNumber = "00!01!99!9907";
        lstSHSpecial.add(cbjLongNumber);
        String sentToLongNumber = "00!01!65";
        lstSHSpecial.add(sentToLongNumber);
        String pyLongNumber = "00!01!81";
        lstSHSpecial.add(pyLongNumber);
        String ylLongNumber = "00!01!99!9905";
        lstSHSpecial.add(ylLongNumber);
        String ltxLongNumber = "00!01!99!9902";
        lstSHSpecial.add(ltxLongNumber);
        String dtxLongNumber = "00!01!99!9908";
        lstSHSpecial.add(dtxLongNumber);
        String fxLongNumber = "00!01!99!9903";
        lstSHSpecial.add(fxLongNumber);
        String dgLongNumber = "00!01!99!9906";
        lstSHSpecial.add(dgLongNumber);
        String txLongNumber = "00!01!99!9901";
        lstSHSpecial.add(txLongNumber);
        String qtLongNumber = "00!01!99!9904";
        lstSHSpecial.add(qtLongNumber);
        String currentDeptLayerID = "";
        String currentDeptLongNumber = "";
        int currentDeptLevel = 0;
        this.mapDept = new HashMap();
        IRow iRow = null;
        try {
            boolean isDoneLevel3 = false;
            int indexAddRow = 0;
            int size = lstSHSpecial.size();
            for (int i = 0; i < size; ++i) {
                iRow = this.tblMain.addRow();
                String temp = lstSHSpecial.get(i).toString();
                iRow.setUserObject((Object)temp);
                if (temp.equals(workOutLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("WB"));
                } else if (temp.equals(cbjLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("CBJ"));
                } else if (temp.equals(sentToLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("WJ"));
                } else if (temp.equals(pyLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("PY"));
                } else if (temp.equals(ylLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("YL"));
                } else if (temp.equals(ltxLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("LTX"));
                } else if (temp.equals(dtxLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("DTX"));
                } else if (temp.equals(fxLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("FX"));
                } else if (temp.equals(dgLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("DG"));
                } else if (temp.equals(txLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("TX"));
                } else if (temp.equals(qtLongNumber)) {
                    iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("QT"));
                }
                this.mapDept.put(lstSHSpecial.get(i), 0);
            }
            while (companyTotalSet.next()) {
                int i;
                int size2;
                currentDeptLevel = companyTotalSet.getInt("Flevel");
                currentDeptLongNumber = companyTotalSet.getString("Flongnumber");
                currentDeptLongNumber = companyTotalSet.getString("Flongnumber");
                currentDeptLayerID = companyTotalSet.getString("unitlayerid") != null ? companyTotalSet.getString("unitlayerid") : "";
                boolean isWB = false;
                if (currentDeptLayerID.equals(workOutlayerId) || currentDeptLayerID.equals(workOutlayerId1)) {
                    isWB = true;
                }
                if (isWB) {
                    size2 = this.tblMain.getRowCount();
                    for (i = 0; i < size2; ++i) {
                        Object temp = this.tblMain.getRow(i).getCell(YF).getValue();
                        if (temp == null || !temp.toString().equals(HRReportUtils.getResource("WB"))) continue;
                        iRow = this.tblMain.getRow(i);
                        break;
                    }
                    this.fillCompanyTable(companyTotalSet, iRow);
                    continue;
                }
                if (currentDeptLevel == 3) {
                    if (currentDeptLongNumber.equals(sentToLongNumber)) {
                        iRow = this.tblMain.getRow(indexAddRow + 2);
                    } else if (currentDeptLongNumber.equals(pyLongNumber)) {
                        iRow = this.tblMain.getRow(indexAddRow + 3);
                    } else if (this.mapDept.get(currentDeptLongNumber) == null) {
                        iRow = this.tblMain.addRow(indexAddRow);
                        this.mapDept.put(currentDeptLongNumber, indexAddRow);
                        ++indexAddRow;
                        iRow.setUserObject((Object)currentDeptLongNumber);
                        iRow.getCell(YF).setValue((Object)companyTotalSet.getString("FName"));
                    }
                    this.fillCompanyTable(companyTotalSet, iRow);
                }
                if (currentDeptLevel > 3 && !isDoneLevel3 && !isWB) {
                    isDoneLevel3 = true;
                    size2 = this.tblMain.getRowCount();
                    for (i = 0; i < size2; ++i) {
                        this.mapDept.put(this.tblMain.getRow(i).getUserObject(), i);
                    }
                }
                if (currentDeptLevel <= 3 || isWB) continue;
                if (this.mapDept.get(currentDeptLongNumber) != null) {
                    iRow = this.tblMain.getRow(((Integer)this.mapDept.get(currentDeptLongNumber)).intValue());
                    iRow.getCell(YF).setValue((Object)companyTotalSet.getString("FName"));
                    this.fillCompanyTable(companyTotalSet, iRow);
                    continue;
                }
                String strTemp = this.getLongNumberString(currentDeptLongNumber, 3);
                if (this.mapDept.get(strTemp) == null) continue;
                iRow = this.tblMain.getRow(((Integer)this.mapDept.get(strTemp)).intValue());
                this.fillCompanyTable(companyTotalSet, iRow);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    private void fillCompanyTable(IRowSet iRowSet, IRow iRow) throws Exception {
        ICell iCell = null;
        int size = this.cmpItemList.size();
        for (int i = 0; i < size; ++i) {
            iCell = iRow.getCell(this.cmpItemList.get(i).toString());
            iCell.setValue((Object)HRSchemeUtils.addData((BigDecimal)iCell.getValue(), (BigDecimal)iRowSet.getObject(this.cmpItemList.get(i).toString())));
        }
    }

    private String getLongNumberString(String str, int level) {
        String[] strs = str.split("!");
        StringBuffer regex = new StringBuffer("");
        for (int i = 0; i < level; ++i) {
            regex.append(strs[i]);
            regex.append("!");
        }
        regex.deleteCharAt(regex.length() - 1);
        return regex.toString();
    }

    private void processDepartmentTotal(HashMap dataMap) throws SQLException {
        List periodList = (List)this.paramMap.get("periodList");
        int size = periodList.size();
        if (size == 0) {
            return;
        }
        IRow currentRow = null;
        ICell currentCell = null;
        HashMap<String, Integer> rowRecordMap = new HashMap<String, Integer>();
        CmpPeriodInfo cmpPeriodInfoTemp = null;
        for (int i = 0; i < size; ++i) {
            cmpPeriodInfoTemp = (CmpPeriodInfo)periodList.get(i);
            currentRow = this.tblMain.addRow();
            currentCell = currentRow.getCell(YF);
            currentCell.setValue((Object)cmpPeriodInfoTemp.getName());
            rowRecordMap.put(cmpPeriodInfoTemp.getId().toString(), currentRow.getRowIndex());
        }
        IRowSet rowSet = (IRowSet)dataMap.get("fillData");
        if (rowSet.size() == 0) {
            this.doHeader();
            return;
        }
        this.encloseCmpItem(true);
        Integer rowIndex = null;
        int listSize = this.cmpItemList.size();
        BigDecimal valueTemp = HRSchemeUtils.BD_ZERO;
        while (rowSet.next()) {
            rowIndex = (Integer)rowRecordMap.get(rowSet.getString(XZQJ));
            currentRow = this.tblMain.getRow(rowIndex.intValue());
            for (int i = 0; i < listSize; ++i) {
                valueTemp = HRSchemeUtils.BD_ZERO;
                String cmpItemString = this.cmpItemList.get(i).toString();
                if (rowSet.getBigDecimal(cmpItemString) != null) {
                    valueTemp = rowSet.getBigDecimal(cmpItemString);
                }
                currentCell = currentRow.getCell(cmpItemString);
                currentCell.setValue((Object)valueTemp);
            }
        }
        this.doOtherTable(this.tblMain.getRowCount());
    }

    private void doOtherTable(int rowCount) {
        int i;
        int j;
        this.encloseCmpItem(false);
        BigDecimal valueTemp = HRSchemeUtils.BD_ZERO;
        BigDecimal sumValueTemp = HRSchemeUtils.BD_ZERO;
        BigDecimal personalNumTemp = HRSchemeUtils.BD_ZERO;
        int size = this.cmpItemList.size();
        String cmpItemKey = "";
        IRow currentRow = null;
        ICell currentCell = null;
        for (j = 0; j < rowCount; ++j) {
            sumValueTemp = HRSchemeUtils.BD_ZERO;
            currentRow = this.tblMain.getRow(j);
            for (i = 0; i < size; ++i) {
                cmpItemKey = this.cmpItemList.get(i).toString();
                currentCell = currentRow.getCell(cmpItemKey);
                if (currentCell.getValue() != null) {
                    valueTemp = new BigDecimal(currentCell.getValue().toString());
                }
                sumValueTemp = sumValueTemp.add(valueTemp);
            }
            currentCell = currentRow.getCell(XJ);
            currentCell.setValue((Object)sumValueTemp.setScale(2, 4));
        }
        this.encloseCmpItem(true);
        this.cmpItemList.remove(RC);
        size = this.cmpItemList.size();
        for (j = 0; j < rowCount; ++j) {
            sumValueTemp = HRSchemeUtils.BD_ZERO;
            valueTemp = HRSchemeUtils.BD_ZERO;
            currentRow = this.tblMain.getRow(j);
            for (i = 0; i < size; ++i) {
                cmpItemKey = this.cmpItemList.get(i).toString();
                currentCell = currentRow.getCell(cmpItemKey);
                if (currentCell.getValue() != null) {
                    valueTemp = new BigDecimal(currentCell.getValue().toString());
                }
                sumValueTemp = sumValueTemp.add(valueTemp);
            }
            currentCell = currentRow.getCell(ZJ);
            currentCell.setValue((Object)sumValueTemp.setScale(2, 4));
            currentCell = currentRow.getCell(RC);
            if (currentCell.getValue() == null) continue;
            personalNumTemp = new BigDecimal(currentCell.getValue().toString());
            valueTemp = sumValueTemp.divide(personalNumTemp, 2, 4);
            currentCell = currentRow.getCell(RJ);
            currentCell.setValue((Object)valueTemp);
        }
        this.encloseCmpItem(true);
        size = this.cmpItemList.size();
        IRow sumRow = this.tblMain.addRow();
        IRow monthAverageRow = this.tblMain.addRow();
        IRow monthPersonAverageRow = this.tblMain.addRow();
        this.tblMain.getColumn(ZJ).getStyleAttributes().setBackground(new Color(0xF6F6BF));
        this.tblMain.getColumn(RJ).getStyleAttributes().setBackground(new Color(16711379));
        sumRow.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        monthAverageRow.getStyleAttributes().setBackground(new Color(16711379));
        monthPersonAverageRow.getStyleAttributes().setBackground(new Color(16711379));
        sumRow.getCell(YF).setValue((Object)EASResource.getString((String)(resourceURL + "ZJ")));
        monthAverageRow.getCell(YF).setValue((Object)EASResource.getString((String)(resourceURL + "YJ")));
        monthPersonAverageRow.getCell(YF).setValue((Object)EASResource.getString((String)(resourceURL + "YRJ")));
        BigDecimal sumPersonNum = HRSchemeUtils.BD_ZERO;
        this.cmpItemList.add(ZJ);
        this.cmpItemList.add(XJ);
        size = this.cmpItemList.size();
        List periodList = (List)this.paramMap.get("periodList");
        BigDecimal periodNumber = new BigDecimal(periodList.size());
        for (int i2 = 0; i2 < size; ++i2) {
            sumValueTemp = HRSchemeUtils.BD_ZERO;
            cmpItemKey = this.cmpItemList.get(i2).toString();
            for (int j2 = 0; j2 < rowCount; ++j2) {
                valueTemp = HRSchemeUtils.BD_ZERO;
                currentCell = this.tblMain.getCell(j2, cmpItemKey);
                if (currentCell.getValue() != null) {
                    valueTemp = new BigDecimal(currentCell.getValue().toString());
                }
                sumValueTemp = sumValueTemp.add(valueTemp);
                if (!cmpItemKey.equals(RC)) continue;
                sumPersonNum = sumValueTemp;
            }
            if (cmpItemKey.equals(RC) && sumPersonNum.compareTo(new BigDecimal("1")) < 0) {
                sumRow.getCell(cmpItemKey).setValue((Object)"1");
            } else {
                sumRow.getCell(cmpItemKey).setValue((Object)sumValueTemp);
            }
            personalNumTemp = periodNumber.compareTo(HRSchemeUtils.BD_ZERO) != 0 ? sumValueTemp.divide(periodNumber, 2, 4) : HRSchemeUtils.BD_ZERO;
            if (cmpItemKey.equals(RC) && personalNumTemp.compareTo(new BigDecimal("1")) < 0) {
                monthAverageRow.getCell(cmpItemKey).setValue((Object)"1");
            } else {
                monthAverageRow.getCell(cmpItemKey).setValue((Object)personalNumTemp);
            }
            personalNumTemp = sumPersonNum.compareTo(HRSchemeUtils.BD_ZERO) != 0 ? sumValueTemp.divide(sumPersonNum, 2, 4) : HRSchemeUtils.BD_ZERO;
            if (cmpItemKey.equals(RC) && personalNumTemp.compareTo(new BigDecimal("1")) < 0) {
                monthPersonAverageRow.getCell(cmpItemKey).setValue((Object)"1");
            } else {
                monthPersonAverageRow.getCell(cmpItemKey).setValue((Object)personalNumTemp);
            }
            this.doHeader();
        }
    }

    private void doHeader() {
        List periodList = (List)this.paramMap.get("periodList");
        CmpPeriodInfo cmpPeriodInfoTemp = (CmpPeriodInfo)periodList.get(0);
        this.txtBeginCmpPeriod.setText(cmpPeriodInfoTemp.getName());
        int endPeriodSize = periodList.size() - 1;
        cmpPeriodInfoTemp = (CmpPeriodInfo)periodList.get(endPeriodSize);
        this.txtEndPeriod.setText(cmpPeriodInfoTemp.getName());
        if (this.paramMap.get("operationkey") == "personalFlag") {
            PersonInfo pinfo = (PersonInfo)this.paramMap.get("personalInfo");
            this.txtObjectName.setVisible(true);
            this.txtObjectName.setText(pinfo.getName());
        } else if (this.paramMap.get("operationkey") == "departmentFlag") {
            AdminOrgUnitInfo aInfo = (AdminOrgUnitInfo)this.paramMap.get("adminInfo");
            this.txtObjectName.setVisible(true);
            this.txtObjectName.setText(aInfo.getName());
        } else {
            this.txtObjectName.setVisible(false);
            this.txtObjectName.setText("");
        }
    }

    private void doCompanyOtherTable(int rowCount) {
        int m;
        int n;
        int i;
        this.encloseCmpItem(false);
        BigDecimal valueTemp = HRSchemeUtils.BD_ZERO;
        BigDecimal sumValueTemp = HRSchemeUtils.BD_ZERO;
        int cmpItemsize = this.cmpItemList.size();
        String cmpItemKey = "";
        IRow currentRow = null;
        ICell currentCell = null;
        for (int j = 0; j < rowCount; ++j) {
            sumValueTemp = HRSchemeUtils.BD_ZERO;
            currentRow = this.tblMain.getRow(j);
            for (int i2 = 0; i2 < cmpItemsize; ++i2) {
                cmpItemKey = this.cmpItemList.get(i2).toString();
                currentCell = currentRow.getCell(cmpItemKey);
                if (currentCell.getValue() != null) {
                    valueTemp = new BigDecimal(currentCell.getValue().toString());
                }
                sumValueTemp = sumValueTemp.add(valueTemp);
            }
            currentCell = currentRow.getCell(XJ);
            currentCell.setValue((Object)sumValueTemp.setScale(2, 4));
        }
        cmpItemKey = "";
        IRow iRow = null;
        ICell iCell = null;
        ICell iCellTemp = null;
        this.encloseCmpItem(true);
        BigDecimal bdTotal = null;
        BigDecimal bdTemp = null;
        BigDecimal bdAllTotal = null;
        int size = this.tblMain.getRowCount();
        for (i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            iCell = iRow.getCell(ZJ);
            bdTotal = null;
            n = this.cmpItemList.size();
            for (m = 0; m < n; ++m) {
                if (this.cmpItemList.get(m).toString().equals(RC) || this.cmpItemList.get(m).toString().equals(XJ)) continue;
                iCellTemp = iRow.getCell(this.cmpItemList.get(m).toString());
                bdTotal = HRSchemeUtils.addData(bdTotal, (BigDecimal)iCellTemp.getValue());
            }
            iCell.setValue(bdTotal);
            iCell = iRow.getCell(RC);
            bdTemp = (BigDecimal)iCell.getValue();
            if (bdTotal == null || bdTemp == null || bdTemp.intValue() == 0) continue;
            iRow.getCell(RJ).setValue((Object)bdTotal.divide(bdTemp, 2, 4));
        }
        this.tblMain.getColumn(ZJ).getStyleAttributes().setBackground(new Color(0xF6F6BF));
        this.tblMain.getColumn(RJ).getStyleAttributes().setBackground(new Color(16711379));
        this.cmpItemList.add(XJ);
        iRow = this.tblMain.addRow();
        bdAllTotal = null;
        size = this.cmpItemList.size();
        for (i = 0; i < size; ++i) {
            bdTotal = null;
            n = this.tblMain.getRowCount();
            for (m = 0; m < n; ++m) {
                iCellTemp = this.tblMain.getRow(m).getCell(this.cmpItemList.get(i).toString());
                bdTotal = HRSchemeUtils.addData(bdTotal, (BigDecimal)iCellTemp.getValue());
            }
            iCell = iRow.getCell(this.cmpItemList.get(i).toString());
            iCell.setValue((Object)bdTotal);
            if (this.cmpItemList.get(i).toString().equals(RC) || this.cmpItemList.get(i).toString().equals(XJ)) continue;
            bdAllTotal = HRSchemeUtils.addData(bdAllTotal, bdTotal);
        }
        iRow.getCell(ZJ).setValue(bdAllTotal);
        bdTotal = (BigDecimal)iRow.getCell(ZJ).getValue();
        bdTemp = (BigDecimal)iRow.getCell(RC).getValue();
        if (bdTotal != null && bdTemp != null && bdTemp.intValue() != 0) {
            iRow.getCell(RJ).setValue((Object)bdTotal.divide(bdTemp, 2, 4));
        }
        iRow.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("XJ"));
        int indexRowWB = (Integer)this.mapDept.get("workOutKey");
        iRow = this.tblMain.addRow(indexRowWB);
        bdAllTotal = null;
        int size2 = this.cmpItemList.size();
        for (int i3 = 0; i3 < size2; ++i3) {
            bdTotal = null;
            int n2 = indexRowWB;
            for (int m2 = 0; m2 < n2; ++m2) {
                iCellTemp = this.tblMain.getRow(m2).getCell(this.cmpItemList.get(i3).toString());
                bdTotal = HRSchemeUtils.addData(bdTotal, (BigDecimal)iCellTemp.getValue());
            }
            iCell = iRow.getCell(this.cmpItemList.get(i3).toString());
            iCell.setValue((Object)bdTotal);
            if (this.cmpItemList.get(i3).toString().equals(RC) || this.cmpItemList.get(i3).toString().equals(XJ)) continue;
            bdAllTotal = HRSchemeUtils.addData(bdAllTotal, bdTotal);
        }
        iRow.getCell(ZJ).setValue((Object)bdAllTotal);
        bdTotal = (BigDecimal)iRow.getCell(ZJ).getValue();
        bdTemp = (BigDecimal)iRow.getCell(RC).getValue();
        if (bdTotal != null && bdTemp != null && bdTemp.intValue() != 0) {
            iRow.getCell(RJ).setValue((Object)bdTotal.divide(bdTemp, 2, 4));
        }
        iRow.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        iRow.getCell(YF).setValue((Object)HRReportUtils.getResource("XJ"));
        this.doTableHeadInfo();
    }

    private void doTableHeadInfo() {
        List periodList = (List)this.paramMap.get("periodList");
        CmpPeriodInfo cmpPeriodInfoTemp = (CmpPeriodInfo)periodList.get(0);
        this.txtBeginCmpPeriod.setText(cmpPeriodInfoTemp.getName());
        cmpPeriodInfoTemp = (CmpPeriodInfo)periodList.get(periodList.size() - 1);
        this.txtEndPeriod.setText(cmpPeriodInfoTemp.getName());
        this.txtObjectName.setVisible(false);
        IRow row = this.tblMain.getHeadRow(0);
        if (row != null && row.getCell(YF) != null) {
            row.getCell(YF).setValue((Object)HRReportUtils.getResource("Department"));
        }
    }

    private void processPersonalTotal(HashMap dataMap) throws SQLException {
        List periodList = (List)this.paramMap.get("periodList");
        int size = periodList.size();
        if (size == 0) {
            return;
        }
        IRow currentRow = null;
        ICell currentCell = null;
        HashMap<String, Integer> rowRecordMap = new HashMap<String, Integer>();
        CmpPeriodInfo cmpPeriodInfoTemp = null;
        for (int i = 0; i < size; ++i) {
            cmpPeriodInfoTemp = (CmpPeriodInfo)periodList.get(i);
            currentRow = this.tblMain.addRow();
            currentCell = currentRow.getCell(YF);
            currentCell.setValue((Object)cmpPeriodInfoTemp.getName());
            rowRecordMap.put(cmpPeriodInfoTemp.getId().toString(), currentRow.getRowIndex());
        }
        IRowSet rowSet = (IRowSet)dataMap.get("fillData");
        if (rowSet.size() == 0) {
            this.doHeader();
            return;
        }
        Integer rowIndex = null;
        this.encloseCmpItem(true);
        int listSize = this.cmpItemList.size();
        BigDecimal valueTemp = HRSchemeUtils.BD_ZERO;
        while (rowSet.next()) {
            rowIndex = (Integer)rowRecordMap.get(rowSet.getString(XZQJ));
            currentRow = this.tblMain.getRow(rowIndex.intValue());
            for (int i = 0; i < listSize; ++i) {
                valueTemp = HRSchemeUtils.BD_ZERO;
                String cmpItemString = this.cmpItemList.get(i).toString();
                if (rowSet.getBigDecimal(cmpItemString) != null) {
                    valueTemp = rowSet.getBigDecimal(cmpItemString);
                }
                currentCell = currentRow.getCell(cmpItemString);
                currentCell.setValue((Object)valueTemp);
            }
        }
        this.doOtherTable(this.tblMain.getRowCount());
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    protected void showFilterDialog() throws Exception {
        int dialogHight = 300;
        int dialogWidth = 420;
        SHRcmpTotalReportFilterUI shrCmpTotalReportFilterUI = new SHRcmpTotalReportFilterUI();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = SHRcmpTotalReportListUI.getQueryInfo(this.bankOrgPersonNewQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getSolutionType().getValue().equals("10")) {
                this.isFirstDefaultQuery = false;
                this.showFilterDialog();
                return;
            }
            CustomerParams cp = CustomerParams.getCustomerParams2((String)CompUtils.getCustmerParamsUtil(solution));
            SHRcmpTotalReportFilterUI shrCmpTotalReportFilterUIShow = new SHRcmpTotalReportFilterUI();
            shrCmpTotalReportFilterUIShow.setCustomerParams(cp);
            this.paramMap = shrCmpTotalReportFilterUIShow.getFilterParam();
            this.OperationFlag = this.paramMap.get("operationkey").toString();
            this.loadDate();
            this.isFirstDefaultQuery = false;
            return;
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(dialogHight);
            this.commonQueryDialog.setWidth(dialogWidth);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.bankOrgPersonNewQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.addUserPanel((KDPanel)shrCmpTotalReportFilterUI);
            this.commonQueryDialog.setTitle(EASResource.getString((String)(resourceURL + "LABTOTALUETITLE")));
        }
        if (this.commonQueryDialog.show()) {
            SHRcmpTotalReportFilterUI shrCmpTotalReportFilterUIShow = (SHRcmpTotalReportFilterUI)this.commonQueryDialog.getUserPanel(0);
            this.paramMap = shrCmpTotalReportFilterUIShow.getFilterParam();
            this.OperationFlag = this.paramMap.get("operationkey").toString();
            this.loadDate();
        } else {
            SysUtil.abort();
        }
    }

    protected boolean isLoadPrintSetting() {
        return false;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.showFilterDialog();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintView_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        super.preparePrintPageHeader(headerModel);
        StyleAttributes sty = Styles.getDefaultSA();
        StringBuffer sbFirst = new StringBuffer();
        sbFirst.append(this.lblMonth.getBoundLabelText() + this.txtBeginCmpPeriod.getText());
        sbFirst.append(this.lblmonthend.getBoundLabelText() + this.txtEndPeriod.getText());
        sbFirst.append("&|");
        if (this.txtObjectName.isVisible()) {
            sbFirst.append(this.txtObjectName.getText());
        }
        headerModel.addRow(sbFirst.toString(), sty);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }
}

