/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.SalPointSalGradeAdminOrgCollection;
import com.kingdee.eas.hr.compensation.SalPointSalGradeAdminOrgInfo;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemCollection;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemInfo;
import com.kingdee.eas.hr.compensation.SalariatPointPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatPointPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeFactory;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatPointSalariatGradeEditUI;
import com.kingdee.eas.hr.compensation.client.ImportDateSalariatPointTableUI;
import com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SalariatPointSalariatGradeEditUI
extends AbstractSalariatPointSalariatGradeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SalariatPointSalariatGradeEditUI.class);
    String salariatSchemeID = null;
    private List columnNames = null;
    private List columnTypes = null;
    private SalariatHiberPropsCollection pointList = null;
    private CmpItemCollection cmpItemColls = null;
    private SalariatSchemeInfo salariatSchemeInfo = null;
    private DynamicTableInfo.ColumnInfo[] infosColumn = null;
    private KDTSortManager sm = null;
    private boolean isChanged = false;
    private boolean isEditStopped = false;
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);
    private List columnNamesGrade = null;
    private List pointColumnNames = null;
    private List itemColumnNames = null;
    private Map newColumnTypes = null;
    private SalariatMapPersonItemCollection mapPersonList = null;
    private Map enumMap = new HashMap();
    private int rowIndex = -1;
    private KDTSortManager smm = null;
    private boolean isAlreadyImport = false;
    private static final String NUMDISPSTR = "%r{#,##0.00}f";

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.kdtSalPoint.getStyleAttributes().setNumberFormat("#,###,##0.00");
        this.kdtSalPoint.addKDTEditListener((KDTEditListener)new CellEditAdapter());
        this.kdtSalGrade.addKDTEditListener((KDTEditListener)new CellEditGradeAdapter());
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setOperateState(false);
        } else {
            this.setOperateState(true);
        }
        this.loadFields();
    }

    private void setSalPointTable() throws Exception, BOSException, EASBizException {
        CmpItemCollection cmpItems;
        this.columnNames = new ArrayList();
        this.columnTypes = new ArrayList();
        this.columnNames.add("FPointID");
        this.columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        this.salariatSchemeID = this.getUIContext().get("salariatSchemeID").toString();
        this.pointList = HRUtils.getPointItemsByScheme(this.salariatSchemeID);
        this.cmpItemColls = cmpItems = HRUtils.getCmpItemsByScheme(this.salariatSchemeID);
        ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)this.salariatSchemeID));
        this.salariatSchemeInfo = (SalariatSchemeInfo)SalariatSchemeFactory.getRemoteInstance().getValue((IObjectPK)schemePK);
        DynamicTableInfo dynTableInfo = new DynamicTableInfo();
        dynTableInfo.setName(this.salariatSchemeInfo.getPointTableName());
        int countColumn = cmpItems.size() + 1;
        this.infosColumn = new DynamicTableInfo.ColumnInfo[countColumn];
        DynamicTableInfo.ColumnInfo pointColumnInfo = new DynamicTableInfo.ColumnInfo();
        pointColumnInfo.setHide(false);
        pointColumnInfo.setReadOnly(false);
        pointColumnInfo.setKey("FPointID");
        pointColumnInfo.setColumnNumber("FPointID");
        pointColumnInfo.setColumnName("FPointID");
        pointColumnInfo.setColumnType(30);
        pointColumnInfo.setObjectType(ItemObjectTypeEnum.BIZOBJECT);
        pointColumnInfo.setDefaultObj("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
        pointColumnInfo.setDefaultF7UI("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
        pointColumnInfo.setCellEditorByObjtype();
        pointColumnInfo.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        pointColumnInfo.getInfosHead()[0].setHeadName(HRUtils.getSalariatResourceStr("POINT"));
        this.infosColumn[0] = pointColumnInfo;
        int j = 1;
        int i = 0;
        while (i < cmpItems.size()) {
            this.infosColumn[j] = new DynamicTableInfo.ColumnInfo(cmpItems.get(i));
            this.columnNames.add(cmpItems.get(i).getNumber());
            this.columnTypes.add(cmpItems.get(i).getDataType());
            ++i;
            ++j;
        }
        dynTableInfo.setInfosColumn(this.infosColumn);
        HRDynamicTableUtils.createTableHead(this.kdtSalPoint, dynTableInfo);
        this.loadSalPointTableData();
        if (this.kdtSalPoint.getRowCount() > 0) {
            this.kdtSalPoint.getSelectManager().select(0, 0, 0, 0);
        }
        this.kdtSalPoint.getSelectManager().setSelectMode(15);
    }

    private void loadSalPointTableData() throws Exception {
        if (StringUtils.isEmpty((String)this.salariatSchemeInfo.getPointTableName())) {
            return;
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            SalariatSchemeFactory.getRemoteInstance().upGradeSalTable(this.salariatSchemeInfo.getPointTableName(), this.salariatSchemeInfo.getGradeTableName());
        }
        if (this.editData.getId() == null) {
            return;
        }
        String querySQL = " select * from " + this.salariatSchemeInfo.getPointTableName() + " where FSalPointSalGradeID ='" + this.editData.getId() + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)querySQL);
        IRowSet rs = exec.executeSQL();
        if (rs == null) {
            return;
        }
        this.kdtSalPoint.removeRows();
        int coumnCount = this.kdtSalPoint.getColumnCount();
        IRow row = null;
        ICell cell = null;
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            row = this.kdtSalPoint.addRow();
            for (int i = 0; i < coumnCount; ++i) {
                cell = row.getCell(i);
                String columnName = (String)this.columnNames.get(i);
                Object columnType = this.columnTypes.get(i);
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT)) {
                    String objID = rs.getString(columnName);
                    SalariatHiberPropsInfo info = this.getPointInfoByID(objID);
                    cell.setValue((Object)info);
                    map.put(objID, "true");
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) continue;
                if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                    String strValue = rs.getString(columnName);
                    cell.setValue((Object)strValue);
                    continue;
                }
                if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    BigDecimal value = rs.getBigDecimal(columnName);
                    cell.setValue((Object)value);
                    continue;
                }
                if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                int intValue = rs.getInt(columnName);
                cell.setValue((Object)intValue);
            }
        }
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdtSalPoint, 0, this.kdtSalPoint.getRowCount() - 1, this.getKDSortManger());
    }

    private KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.kdtSalPoint);
        }
        return this.sm;
    }

    private SalariatHiberPropsInfo getPointInfoByID(String id) {
        if (id == null) {
            return null;
        }
        SalariatHiberPropsInfo info = null;
        for (int i = 0; i < this.pointList.size(); ++i) {
            if (!id.equals(this.pointList.get(i).getId().toString())) continue;
            info = this.pointList.get(i);
            return info;
        }
        return info;
    }

    @Override
    public void loadFields() {
        try {
            super.loadFields();
            CompUtils.initF7ForMutilSelectOrg(this.prmtAdminUnitOrg, false);
            this.prmtAdminUnitOrg.setEditable(false);
            SalPointSalGradeAdminOrgCollection salPointSalGradeAdminOrgCol = this.editData.getAdminOrgEntry();
            AdminOrgUnitCollection adminOrgUnitCol = new AdminOrgUnitCollection();
            int size = salPointSalGradeAdminOrgCol.size();
            for (int i = 0; i < size; ++i) {
                adminOrgUnitCol.add(salPointSalGradeAdminOrgCol.get(i).getAdminOrg());
            }
            if (adminOrgUnitCol.size() > 0) {
                this.prmtAdminUnitOrg.setValue((Object)adminOrgUnitCol.toArray());
            }
            this.setSalPointTable();
            this.setSalGradeTable();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        SalPointSalGradeAdminOrgCollection salPointSalGradeAdminOrgCol = this.editData.getAdminOrgEntry();
        salPointSalGradeAdminOrgCol.clear();
        Object value = this.prmtAdminUnitOrg.getValue();
        SalPointSalGradeAdminOrgInfo salPointSalGradeAdminOrgInfo = null;
        if (value != null && value instanceof Object[]) {
            AdminOrgUnitInfo adminOrgInfo;
            Object[] ogs = (Object[])value;
            int size = ogs.length;
            for (int i = 0; i < size && (adminOrgInfo = (AdminOrgUnitInfo)ogs[i]) != null; ++i) {
                salPointSalGradeAdminOrgInfo = new SalPointSalGradeAdminOrgInfo();
                salPointSalGradeAdminOrgInfo.setAdminOrg(adminOrgInfo);
                salPointSalGradeAdminOrgCol.add(salPointSalGradeAdminOrgInfo);
            }
        }
        this.storeSalPointTableData();
        this.storeSalGradeTableData();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setOperateState(true);
        this.prmtAdminUnitOrg.setEditable(false);
    }

    protected IObjectValue createNewData() {
        SalariatPointSalariatGradeInfo salPointSalGradeInfo = new SalariatPointSalariatGradeInfo();
        if (this.getUIContext().get("salariatSchemeID") != null) {
            this.salariatSchemeID = this.getUIContext().get("salariatSchemeID").toString();
            SalariatSchemeInfo salariatSchemeInfo = new SalariatSchemeInfo();
            salariatSchemeInfo.setId(BOSUuid.read((String)this.salariatSchemeID));
            salPointSalGradeInfo.setSalariatScheme(salariatSchemeInfo);
        }
        salPointSalGradeInfo.setEnable(StateEnum.UNENABLE);
        return salPointSalGradeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SalariatPointSalariatGradeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("salariatScheme"));
        sic.add(new SelectorItemInfo("adminOrgEntry.id"));
        sic.add(new SelectorItemInfo("adminOrgEntry.adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrgEntry.adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrgEntry.adminOrg.name"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSalPointDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSalPointInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnSalPointAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnSalPointImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnInputOldData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuInputOldData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnSalPointDelete.setText(null);
        this.btnSalPointInsert.setText(null);
        this.btnSalPointAddNewLine.setText(null);
        this.btnSalPointImport.setText(null);
        this.ctnSalPoint.addButton((JButton)this.btnSalPointAddNewLine);
        this.ctnSalPoint.addButton((JButton)this.btnSalPointInsert);
        this.ctnSalPoint.addButton((JButton)this.btnSalPointDelete);
        this.ctnSalPoint.addButton((JButton)this.btnSalPointImport);
        this.btnSalGradeDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSalGradeInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnSalGradeAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnSalGradeDelete.setText(null);
        this.btnSalGradeInsert.setText(null);
        this.btnSalGradeAddNewLine.setText(null);
        this.ctnSalGrade.addButton((JButton)this.btnSalGradeAddNewLine);
        this.ctnSalGrade.addButton((JButton)this.btnSalGradeInsert);
        this.ctnSalGrade.addButton((JButton)this.btnSalGradeDelete);
    }

    private void setOperateState(boolean state) {
        if (state) {
            this.btnSalPointAddNewLine.setEnabled(true);
            this.btnSalPointInsert.setEnabled(true);
            this.btnSalPointDelete.setEnabled(true);
            this.btnSalPointImport.setEnabled(true);
            this.btnInputOldData.setEnabled(true);
            this.menuInputOldData.setEnabled(true);
            this.btnSalGradeAddNewLine.setEnabled(true);
            this.btnSalGradeInsert.setEnabled(true);
            this.btnSalGradeDelete.setEnabled(true);
        } else {
            this.btnSalPointAddNewLine.setEnabled(false);
            this.btnSalPointInsert.setEnabled(false);
            this.btnSalPointDelete.setEnabled(false);
            this.btnSalPointImport.setEnabled(false);
            this.btnInputOldData.setEnabled(false);
            this.menuInputOldData.setEnabled(false);
            this.btnSalGradeAddNewLine.setEnabled(false);
            this.btnSalGradeInsert.setEnabled(false);
            this.btnSalGradeDelete.setEnabled(false);
        }
    }

    @Override
    public void actionSalPointAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.salariatSchemeID != null) {
            SalariatPointPromptBox pointPromtBox = new SalariatPointPromptBox();
            pointPromtBox.putParameter((Object)"IsSingleSelect", Boolean.FALSE);
            pointPromtBox.putParameter("schemeID", this.salariatSchemeID);
            pointPromtBox.putParameter("Owner", "SalariatPointSalariatGradeEditUI");
            pointPromtBox.show();
            if (!pointPromtBox.isCanceled() && pointPromtBox.getData() instanceof Object[]) {
                Object[] objs = (Object[])pointPromtBox.getData();
                HashSet<String> set = new HashSet<String>();
                int size = this.kdtSalPoint.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (this.kdtSalPoint.getRow(i).getCell("FPointID").getValue() == null || !(this.kdtSalPoint.getRow(i).getCell("FPointID").getValue() instanceof SalariatHiberPropsInfo)) continue;
                    set.add(((SalariatHiberPropsInfo)this.kdtSalPoint.getRow(i).getCell("FPointID").getValue()).getId().toString());
                }
                IRow row = null;
                int length = objs.length;
                for (int i = 0; i < length; ++i) {
                    if (set.contains(((SalariatHiberPropsInfo)objs[i]).getId().toString())) continue;
                    row = this.kdtSalPoint.addRow();
                    row.getCell("FPointID").setValue((Object)((SalariatHiberPropsInfo)objs[i]));
                    this.setInitRowValue(row);
                    this.isChanged = true;
                }
            }
        }
    }

    @Override
    public void actionSalPointDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionSalPointDelete_actionPerformed(e);
        int activeIndex = this.kdtSalPoint.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        this.kdtSalPoint.removeRow(activeIndex);
        this.isChanged = true;
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdtSalPoint, 0, this.kdtSalPoint.getRowCount() - 1, this.getKDSortManger());
        if (this.kdtSalPoint.getRowCount() <= 1) {
            this.getKDSortManger().setSortAuto(true);
            this.getKDSortManger().clearGroup();
            if (this.kdtSalPoint.getRowCount() > 0) {
                this.getKDSortManger().addGroup(0, 0);
            }
        }
    }

    @Override
    public void actionSalPointInsert_actionPerformed(ActionEvent e) throws Exception {
        if (this.salariatSchemeID != null) {
            SalariatPointPromptBox pointPromtBox = new SalariatPointPromptBox();
            pointPromtBox.putParameter((Object)"IsSingleSelect", Boolean.FALSE);
            pointPromtBox.putParameter("schemeID", this.salariatSchemeID);
            pointPromtBox.putParameter("Owner", "SalariatPointSalariatGradeEditUI");
            pointPromtBox.show();
            if (!pointPromtBox.isCanceled() && pointPromtBox.getData() instanceof Object[]) {
                Object[] objs = (Object[])pointPromtBox.getData();
                HashSet<String> set = new HashSet<String>();
                int size = this.kdtSalPoint.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (this.kdtSalPoint.getRow(i).getCell("FPointID").getValue() == null || !(this.kdtSalPoint.getRow(i).getCell("FPointID").getValue() instanceof SalariatHiberPropsInfo)) continue;
                    set.add(((SalariatHiberPropsInfo)this.kdtSalPoint.getRow(i).getCell("FPointID").getValue()).getId().toString());
                }
                IRow row = null;
                int activeIndex = this.kdtSalPoint.getSelectManager().getActiveRowIndex();
                ++activeIndex;
                int length = objs.length;
                for (int i = 0; i < length; ++i) {
                    if (set.contains(((SalariatHiberPropsInfo)objs[i]).getId().toString())) continue;
                    if (activeIndex == -1) {
                        row = this.kdtSalPoint.addRow();
                        row.getCell("FPointID").setValue((Object)((SalariatHiberPropsInfo)objs[i]));
                        this.setInitRowValue(row);
                        continue;
                    }
                    row = this.kdtSalPoint.addRow(activeIndex);
                    row.getCell("FPointID").setValue((Object)((SalariatHiberPropsInfo)objs[i]));
                    this.setInitRowValue(row);
                    ++activeIndex;
                }
            }
        }
    }

    @Override
    public void actionSalPointImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.cmpItemColls == null || this.cmpItemColls.size() < 1) {
            return;
        }
        UIContext context = new UIContext((Object)this);
        ArrayList<DatataskParameter> importParam = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.compensation.SalariatPointTableUI";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.ImportDateEndDataResource", (String)"SALTABLE");
        importParam.add(param);
        context.put((Object)"params", importParam);
        context.put((Object)"mode", (Object)0);
        LinkedHashMap<String, String> colKeyName = new LinkedHashMap<String, String>();
        colKeyName.put("FPointID", HRUtils.getSalariatResourceStr("POINT"));
        int size = this.cmpItemColls.size();
        for (int i = 0; i < size; ++i) {
            colKeyName.put(this.cmpItemColls.get(i).getNumber(), this.cmpItemColls.get(i).getName());
        }
        context.put((Object)"colKeyName", colKeyName);
        context.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(ImportDateSalariatPointTableUI.class.getName(), (Map)context, null, OprtState.ADDNEW);
        curDialog.show();
    }

    @Override
    public void actionSalGradeAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionSalGradeAddNew_actionPerformed(e);
        this.kdtSalGrade.addRow();
        this.isChanged = true;
    }

    @Override
    public void actionSalGradeDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionSalGradeDelete_actionPerformed(e);
        int activeIndex = this.kdtSalGrade.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        this.kdtSalGrade.removeRow(activeIndex);
        this.isChanged = true;
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdtSalGrade, 0, this.kdtSalGrade.getRowCount() - 1, this.getKDSortMangerGrade());
        if (this.kdtSalGrade.getRowCount() <= 1) {
            this.getKDSortManger().setSortAuto(true);
            this.getKDSortManger().clearGroup();
            if (this.kdtSalGrade.getRowCount() > 0) {
                this.getKDSortManger().addGroup(0, 0);
            }
        }
    }

    private KDTSortManager getKDSortMangerGrade() {
        if (this.smm == null) {
            this.smm = new KDTSortManager(this.kdtSalGrade);
        }
        return this.smm;
    }

    @Override
    public void actionSalGradeInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionSalGradeInsert_actionPerformed(e);
        int activeIndex = this.kdtSalGrade.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        this.isChanged = true;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            throw new SalariatException(SalariatException.NULL_NUMBER);
        }
        if (StringUtils.isEmpty((String)this.txtName1.getSelectedItem().toString())) {
            throw new SalariatException(SalariatException.NULL_NAME);
        }
        Object value = this.prmtAdminUnitOrg.getData();
        if (value == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"218_CmpItemAccountDeptFilterUI"));
            SysUtil.abort();
        }
        if (value != null && value instanceof Object[]) {
            Object[] ogs = (Object[])value;
            int size = ogs.length;
            for (int i = 0; i < size; ++i) {
                if (ogs[i] != null) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"218_CmpItemAccountDeptFilterUI"));
                SysUtil.abort();
            }
        }
        this.verifySalPointDataNew();
        this.verifySalGradeDataNew();
    }

    public void verifySalPointDataNew() throws Exception {
        CmpItemCollection cmpItems1 = HRUtils.getCmpItemsBySchem(null, this.salariatSchemeID);
        CmpItemCollection cmpItess2 = HRUtils.getCmpItemCollection();
        if (cmpItess2.size() == 0) {
            throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(0).getNumber()});
        }
        if (cmpItems1.size() > 0) {
            int j = cmpItems1.size();
            for (int i = 0; i < j; ++i) {
                if (cmpItess2.contains(cmpItems1.get(i))) continue;
                throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(i).getNumber()});
            }
        }
        int rowCount = this.kdtSalPoint.getRowCount();
        IRow row = null;
        ICell cell = null;
        HashSet<String> pointids = new HashSet<String>();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtSalPoint.getRow(i);
            cell = row.getCell("FPointID");
            if (cell.getValue() == null) {
                MsgBox.showInfo((String)MessageFormat.format(HRUtils.getSalariatResourceStr("MISS_ROWSET_POINT"), i + 1));
                SysUtil.abort();
                this.kdtSalPoint.getSelectManager().removeAll(false);
                this.kdtSalPoint.getEditManager().editCellAt(row.getRowIndex(), 0);
            }
            pointids.add(((SalariatHiberPropsInfo)cell.getValue()).getId().toString());
        }
        if (pointids.size() > 0 && pointids.size() < rowCount) {
            super.handUIException((Throwable)((Object)new CmpItemException(CmpItemException.CMPITEM_NOT_ADDSAMEROW)));
            SysUtil.abort();
        }
    }

    public void storeSalPointTableData() {
        ArrayList valueMapList = new ArrayList();
        HashMap valueMap = null;
        IRow row = null;
        ICell cell = null;
        int rowCount = this.kdtSalPoint.getRowCount();
        int columnCount = this.kdtSalPoint.getColumnCount();
        Object cellObj = null;
        HashSet<String> pointids = new HashSet<String>();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtSalPoint.getRow(i);
            valueMap = new HashMap();
            for (int j = 0; j < columnCount; ++j) {
                cell = row.getCell(j);
                cellObj = cell.getValue();
                if (cellObj != null && cellObj instanceof SalariatHiberPropsInfo) {
                    pointids.add(((SalariatHiberPropsInfo)cellObj).getId().toString());
                } else if (cellObj != null && (this.infosColumn[j].getColumnType() == 60 || this.infosColumn[j].getColumnType() == 50)) {
                    cellObj = HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)cellObj, this.infosColumn[j].getScale(), this.infosColumn[j].getPrecisionType());
                }
                valueMap.put(this.columnNames.get(j), cellObj);
            }
            valueMapList.add(valueMap);
        }
        if (pointids.size() > 0 && pointids.size() < rowCount) {
            super.handUIException((Throwable)((Object)new CmpItemException(CmpItemException.CMPITEM_NOT_ADDSAMEROW)));
            SysUtil.abort();
        }
        this.editData.put("PointTableName", this.salariatSchemeInfo.getPointTableName());
        this.editData.put("columnNames", this.columnNames);
        this.editData.put("columnTypes", this.columnTypes);
        this.editData.put("valueMapList", valueMapList);
    }

    private void setInitRowValue(IRow row) {
        for (int i = 1; i < this.kdtSalPoint.getColumnCount(); ++i) {
            ICell cell = row.getCell(i);
            cell.setValue((Object)ZERO);
        }
    }

    private void setSalGradeTable() throws Exception, BOSException, EASBizException {
        int i;
        this.columnNamesGrade = new ArrayList();
        this.pointColumnNames = new ArrayList();
        this.itemColumnNames = new ArrayList();
        this.newColumnTypes = new HashMap();
        this.mapPersonList = HRUtils.getMapPersonItemsByScheme(this.salariatSchemeID);
        CmpItemCollection personItems = HRUtils.getPersonItemsByScheme(this.salariatSchemeID);
        SalariatPointPropsCollection pointGrades = HRUtils.getPointGradeItemsByScheme(this.salariatSchemeID);
        DynamicTableInfo dynTableInfo = new DynamicTableInfo();
        dynTableInfo.setName(this.salariatSchemeInfo.getGradeTableName());
        int countColumn = personItems.size() + pointGrades.size();
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[countColumn];
        HRCmpItemUtils.addF7InfoToCmpItem(personItems);
        int j = 0;
        String value = null;
        boolean existOrgName = false;
        boolean existOrgLongName = false;
        for (i = 0; i < personItems.size(); ++i) {
            value = personItems.get(i).getNumber();
            if ("FPER005".equals(value)) {
                existOrgName = true;
            }
            if (!"FPER003".equals(value)) continue;
            existOrgLongName = true;
        }
        i = 0;
        while (i < personItems.size()) {
            ObjectValueRender avr;
            KDBizPromptBox bizPromptPosi;
            AdminF7 adminOrg;
            infosColumn[j] = new DynamicTableInfo.ColumnInfo(personItems.get(i));
            value = personItems.get(i).getNumber();
            this.columnNamesGrade.add(value);
            if (infosColumn[j].getObjectType() != null) {
                this.newColumnTypes.put(value, infosColumn[j].getObjectType());
                if (ItemObjectTypeEnum.ENUM.equals((Object)infosColumn[j].getObjectType())) {
                    this.enumMap.put(value, infosColumn[j].getDefaultObj());
                }
            } else {
                this.newColumnTypes.put(value, personItems.get(i).getDataType());
            }
            this.itemColumnNames.add(value);
            if ("FPER006".equals(value)) {
                PositionPromptBox2 positionSe = new PositionPromptBox2();
                HashSet<String> hrSet = new HashSet<String>();
                hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                positionSe.setHROFilter(hrSet);
                KDBizPromptBox bizPromptPosi2 = new KDBizPromptBox();
                bizPromptPosi2.setSelector((KDPromptSelector)positionSe);
                bizPromptPosi2.setEditable(false);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi2));
            }
            if ("FPER003".equals(value)) {
                adminOrg = new AdminF7();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)adminOrg);
                bizPromptPosi.setDisplayFormat("$displayName$");
                bizPromptPosi.setEditFormat("$displayName$");
                bizPromptPosi.setEditable(false);
                if (existOrgLongName && existOrgName) {
                    bizPromptPosi.addDataChangeListener(new DataChangeListener(){

                        public void dataChanged(DataChangeEvent eventObj) {
                            OrgUnitInfo adminOrg = (OrgUnitInfo)eventObj.getNewValue();
                            IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER005");
                            cell.setValue((Object)adminOrg);
                        }
                    });
                }
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$displayName$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            if ("FPER004".equals(value)) {
                adminOrg = new AdminF7();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)adminOrg);
                bizPromptPosi.setDisplayFormat("$number$");
                bizPromptPosi.setEditFormat("$number$");
                bizPromptPosi.setEditable(false);
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            if ("FPER002".equals(value)) {
                PersonPromptBox personBox = new PersonPromptBox();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)personBox);
                bizPromptPosi.setDisplayFormat("$number$");
                bizPromptPosi.setEditFormat("$number$");
                bizPromptPosi.setEditable(false);
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            if ("FPER005".equals(value)) {
                adminOrg = new AdminF7();
                bizPromptPosi = new KDBizPromptBox();
                bizPromptPosi.setSelector((KDPromptSelector)adminOrg);
                bizPromptPosi.setDisplayFormat("$name$");
                bizPromptPosi.setEditFormat("$name$");
                bizPromptPosi.setEditable(false);
                if (existOrgLongName && existOrgName) {
                    bizPromptPosi.addDataChangeListener(new DataChangeListener(){

                        public void dataChanged(DataChangeEvent eventObj) {
                            OrgUnitInfo adminOrg = (OrgUnitInfo)eventObj.getNewValue();
                            IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER003");
                            cell.setValue((Object)adminOrg);
                        }
                    });
                }
                avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
                infosColumn[j].setRenderer((IBasicRender)avr);
                infosColumn[j].setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
            }
            ++i;
            ++j;
        }
        i = 0;
        while (i < pointGrades.size()) {
            DynamicTableInfo.ColumnInfo columnInfo = new DynamicTableInfo.ColumnInfo();
            SalariatPointPropsInfo grade = pointGrades.get(i);
            String seqStr = null;
            if (!StringUtils.isEmpty((String)pointGrades.get(i).getNumber())) {
                seqStr = pointGrades.get(i).getNumber().substring(9);
                int currMaxSeq = Integer.parseInt(seqStr);
                value = "FPointID_" + currMaxSeq;
                columnInfo.setHide(false);
                columnInfo.setReadOnly(false);
                columnInfo.setKey(value);
                columnInfo.setColumnNumber(value);
                columnInfo.setColumnName(value);
                this.columnNamesGrade.add(value);
                this.pointColumnNames.add(value);
                this.newColumnTypes.put(value, ItemObjectTypeEnum.BIZOBJECT);
                columnInfo.setColumnType(10);
                columnInfo.setObjectType(ItemObjectTypeEnum.BIZOBJECT);
                columnInfo.setDefaultObj("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
                columnInfo.setCellEditorByObjtype();
                columnInfo.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
                columnInfo.getInfosHead()[0].setHeadName(grade.getName());
                infosColumn[j] = columnInfo;
            }
            ++i;
            ++j;
        }
        this.doWithF7(personItems, infosColumn);
        dynTableInfo.setInfosColumn(infosColumn);
        HRDynamicTableUtils.createTableHead(this.kdtSalGrade, dynTableInfo);
        String key = null;
        for (int i2 = 0; i2 < this.kdtSalGrade.getColumnCount(); ++i2) {
            key = this.kdtSalGrade.getColumnKey(i2);
            if (!"FPER004".equals(key) && !"FPER002".equals(key)) continue;
            this.kdtSalGrade.getColumn(i2).getStyleAttributes().setNumberFormat("");
        }
        if (this.salariatSchemeInfo.getPointTableName() != null) {
            try {
                this.loadSalGradeTableData();
            }
            catch (Exception ex) {
                this.handleException((Exception)((Object)new SalariatException(SalariatException.ERROR_LOAD_POINTDATA, ex)));
            }
        }
        this.kdtSalGrade.setColumnMoveable(false);
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdtSalGrade, 0, this.kdtSalGrade.getRowCount() - 1, new KDTSortManager(this.kdtSalGrade));
    }

    private void doWithF7(CmpItemCollection personItems, DynamicTableInfo.ColumnInfo[] infosColumn) {
        String value = null;
        boolean existPostion = false;
        boolean existOrgName = false;
        boolean existOrgLongName = false;
        for (int i = 0; i < personItems.size(); ++i) {
            value = personItems.get(i).getNumber();
            if ("FPER006".equals(value)) {
                existPostion = true;
            }
            if ("FPER005".equals(value)) {
                existOrgName = true;
            }
            if (!"FPER003".equals(value)) continue;
            existOrgLongName = true;
        }
        if (existPostion && existOrgName && !existOrgLongName) {
            this.kdtSalGrade.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointSalariatGradeEditUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointSalariatGradeEditUI.this.getOprtState())) {
                            SalariatPointSalariatGradeEditUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                            IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER005");
                            int colIndex = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getColumnIndex("FPER006");
                            IColumn column = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getColumn("FPER006");
                            if (colIndex == e.getSelectBlock().getBeginCol()) {
                                if (cell.getValue() != null) {
                                    OrgUnitInfo adminOrg = (OrgUnitInfo)cell.getValue();
                                    KDBizPromptBox promptPos = new KDBizPromptBox();
                                    promptPos.setQueryInfo("com.kingdee.eas.hr.org.app.PositionHRListQuery");
                                    promptPos.setEditable(false);
                                    promptPos.setEditFormat("$name$");
                                    promptPos.setDisplayFormat("$name$");
                                    EntityViewInfo entityView = new EntityViewInfo();
                                    FilterInfo filter = new FilterInfo();
                                    filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrg.getId().toString(), CompareType.EQUALS));
                                    entityView.setFilter(filter);
                                    promptPos.setEntityViewInfo(entityView);
                                    KDTDefaultCellEditor postionCellEditor = new KDTDefaultCellEditor((IKDEditor)promptPos);
                                    promptPos.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)postionCellEditor);
                                } else {
                                    PositionPromptBox2 positionSe = new PositionPromptBox2();
                                    HashSet<String> hrSet = new HashSet<String>();
                                    hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                                    positionSe.setHROFilter(hrSet);
                                    KDBizPromptBox bizPromptPosi = new KDBizPromptBox();
                                    bizPromptPosi.setSelector((KDPromptSelector)positionSe);
                                    bizPromptPosi.setEditable(false);
                                    bizPromptPosi.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointSalariatGradeEditUI.this.handUIException(e1);
                    }
                }
            });
        } else if (existPostion && existOrgLongName && !existOrgName) {
            this.kdtSalGrade.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointSalariatGradeEditUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointSalariatGradeEditUI.this.getOprtState())) {
                            SalariatPointSalariatGradeEditUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                            IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER003");
                            int colIndex = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getColumnIndex("FPER006");
                            IColumn column = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getColumn("FPER006");
                            if (colIndex == e.getSelectBlock().getBeginCol()) {
                                if (cell.getValue() != null) {
                                    OrgUnitInfo adminOrg = (OrgUnitInfo)cell.getValue();
                                    KDBizPromptBox promptPos = new KDBizPromptBox();
                                    promptPos.setQueryInfo("com.kingdee.eas.hr.org.app.PositionHRListQuery");
                                    promptPos.setEditable(false);
                                    promptPos.setEditFormat("$name$");
                                    promptPos.setDisplayFormat("$name$");
                                    EntityViewInfo entityView = new EntityViewInfo();
                                    FilterInfo filter = new FilterInfo();
                                    filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrg.getId().toString(), CompareType.EQUALS));
                                    entityView.setFilter(filter);
                                    promptPos.setEntityViewInfo(entityView);
                                    KDTDefaultCellEditor postionCellEditor = new KDTDefaultCellEditor((IKDEditor)promptPos);
                                    promptPos.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)postionCellEditor);
                                } else {
                                    PositionPromptBox2 positionSe = new PositionPromptBox2();
                                    HashSet<String> hrSet = new HashSet<String>();
                                    hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                                    positionSe.setHROFilter(hrSet);
                                    KDBizPromptBox bizPromptPosi = new KDBizPromptBox();
                                    bizPromptPosi.setSelector((KDPromptSelector)positionSe);
                                    bizPromptPosi.setEditable(false);
                                    bizPromptPosi.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointSalariatGradeEditUI.this.handUIException(e1);
                    }
                }
            });
        } else if (existPostion && existOrgLongName && existOrgName) {
            this.kdtSalGrade.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointSalariatGradeEditUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointSalariatGradeEditUI.this.getOprtState())) {
                            SalariatPointSalariatGradeEditUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                            IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                            if (currRow == null) {
                                return;
                            }
                            ICell cell = currRow.getCell("FPER005");
                            int colIndex = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getColumnIndex("FPER006");
                            IColumn column = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getColumn("FPER006");
                            if (colIndex == e.getSelectBlock().getBeginCol()) {
                                if (cell.getValue() != null) {
                                    OrgUnitInfo adminOrg = (OrgUnitInfo)cell.getValue();
                                    KDBizPromptBox promptPos = new KDBizPromptBox();
                                    promptPos.setQueryInfo("com.kingdee.eas.hr.org.app.PositionHRListQuery");
                                    promptPos.setEditable(false);
                                    promptPos.setEditFormat("$name$");
                                    promptPos.setDisplayFormat("$name$");
                                    EntityViewInfo entityView = new EntityViewInfo();
                                    FilterInfo filter = new FilterInfo();
                                    filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrg.getId().toString(), CompareType.EQUALS));
                                    entityView.setFilter(filter);
                                    promptPos.setEntityViewInfo(entityView);
                                    KDTDefaultCellEditor postionCellEditor = new KDTDefaultCellEditor((IKDEditor)promptPos);
                                    promptPos.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                    cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)postionCellEditor);
                                } else {
                                    PositionPromptBox2 positionSe = new PositionPromptBox2();
                                    HashSet<String> hrSet = new HashSet<String>();
                                    hrSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                                    positionSe.setHROFilter(hrSet);
                                    KDBizPromptBox bizPromptPosi = new KDBizPromptBox();
                                    bizPromptPosi.setSelector((KDPromptSelector)positionSe);
                                    bizPromptPosi.setEditable(false);
                                    bizPromptPosi.addChangeListener(new ChangeListener(){

                                        @Override
                                        public void stateChanged(ChangeEvent e) {
                                            KDBizPromptBox bizPromptPosi = (KDBizPromptBox)e.getSource();
                                            PositionInfo postion = (PositionInfo)bizPromptPosi.getData();
                                            try {
                                                if (postion != null) {
                                                    AdminOrgUnitInfo adminOrg = HRUtils.getAdminOrgByPostion(postion.getId().toString());
                                                    IRow currRow = SalariatPointSalariatGradeEditUI.this.kdtSalGrade.getRow(SalariatPointSalariatGradeEditUI.this.rowIndex);
                                                    if (currRow == null) {
                                                        return;
                                                    }
                                                    ICell cell = currRow.getCell("FPER005");
                                                    cell.setValue((Object)adminOrg);
                                                    cell = currRow.getCell("FPER003");
                                                    cell.setValue((Object)adminOrg);
                                                }
                                            }
                                            catch (BOSException e1) {
                                                ExceptionHandler.handle((Throwable)e1);
                                            }
                                        }
                                    });
                                    column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptPosi));
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointSalariatGradeEditUI.this.handUIException(e1);
                    }
                }
            });
        } else if (!existPostion && existOrgLongName && existOrgName) {
            this.kdtSalGrade.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        if (OprtState.EDIT.equals(SalariatPointSalariatGradeEditUI.this.getOprtState()) || OprtState.ADDNEW.equals(SalariatPointSalariatGradeEditUI.this.getOprtState())) {
                            SalariatPointSalariatGradeEditUI.this.rowIndex = e.getSelectBlock().getBeginRow();
                        }
                    }
                    catch (Exception e1) {
                        SalariatPointSalariatGradeEditUI.this.handUIException(e1);
                    }
                }
            });
        }
    }

    private void loadSalGradeTableData() throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String querySQL = " select * from " + this.salariatSchemeInfo.getGradeTableName() + " where FSalPointSalGradeID ='" + this.editData.getId() + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)querySQL);
        IRowSet rs = exec.executeSQL();
        if (rs == null) {
            return;
        }
        this.kdtSalGrade.removeRows();
        IRow row = null;
        while (rs.next()) {
            int i;
            row = this.kdtSalGrade.addRow();
            String mapPersonID = rs.getString("FPersonMapID");
            SalariatMapPersonItemInfo mapPersonInfo = this.getMapPersonItemsByID(mapPersonID);
            if (mapPersonInfo != null) {
                int size = this.itemColumnNames.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    String columnKey = (String)this.itemColumnNames.get(i2);
                    Object obj = mapPersonInfo.get(columnKey);
                    if (columnKey.equals("FPER010")) {
                        int enumValue = (Integer)obj;
                        row.getCell(columnKey).setValue((Object)Genders.getEnum((int)enumValue));
                        continue;
                    }
                    if (obj instanceof BigDecimal) {
                        BigDecimal bigValue = ((BigDecimal)obj).setScale(2);
                        row.getCell(columnKey).setValue((Object)bigValue);
                        continue;
                    }
                    row.getCell(columnKey).setValue(obj);
                }
            }
            IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            String perItemNumber = null;
            int size = this.itemColumnNames.size();
            for (i = 0; i < size; ++i) {
                perItemNumber = this.itemColumnNames.get(i).toString();
                Object personItemIDValue = rs.getObject(perItemNumber);
                Object columnType = this.newColumnTypes.get(perItemNumber);
                if (personItemIDValue == null) continue;
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT) || "FPER003".equals(perItemNumber)) {
                    BOSUuid id = BOSUuid.read((String)personItemIDValue.toString());
                    IObjectValue valueObject = iDynamicObject.getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
                    row.getCell(perItemNumber).setValue((Object)valueObject);
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                    row.getCell(perItemNumber).setValue(this.getEnumFromClassName(perItemNumber, personItemIDValue.toString()));
                    continue;
                }
                row.getCell(perItemNumber).setValue(personItemIDValue);
            }
            size = this.pointColumnNames.size();
            for (i = 0; i < size; ++i) {
                String pointID = rs.getString((String)this.pointColumnNames.get(i));
                row.getCell((String)this.pointColumnNames.get(i)).setValue((Object)this.getPointInfoByID(pointID));
            }
        }
    }

    private SalariatMapPersonItemInfo getMapPersonItemsByID(String id) {
        if (id == null) {
            return null;
        }
        SalariatMapPersonItemInfo info = null;
        for (int i = 0; i < this.mapPersonList.size(); ++i) {
            if (!id.equals(this.mapPersonList.get(i).getId().toString())) continue;
            info = this.mapPersonList.get(i);
            return info;
        }
        return info;
    }

    private Object getEnumFromClassName(String itemNumber, String value) throws Exception {
        String enumClassName = (String)this.enumMap.get(itemNumber);
        if (enumClassName != null) {
            Class<?> enumClass = null;
            try {
                enumClass = Class.forName(enumClassName);
            }
            catch (ClassNotFoundException ex) {
                logger.error((Object)ex.getMessage());
                return value;
            }
            if (enumClass.getSuperclass().equals(IntEnum.class)) {
                return EnumUtils.getEnum(enumClass, (int)Integer.parseInt(value));
            }
            return EnumUtils.getEnumByValue(enumClass, (String)value);
        }
        return value;
    }

    @Override
    protected void kdtSalGrade_editStopped(KDTEditEvent e) throws Exception {
        int i;
        int size;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if ("FPER001".equals(this.kdtSalGrade.getColumnKey(colIndex))) {
            String perNum = null;
            size = this.kdtSalGrade.getColumnCount();
            for (i = 0; i < size; ++i) {
                if (!"FPER002".equals(this.kdtSalGrade.getColumnKey(i))) continue;
                perNum = this.kdtSalGrade.getColumnKey(i);
                break;
            }
            if (!StringUtils.isEmpty(perNum) && this.kdtSalGrade.getCell(rowIndex, colIndex).getValue() != null) {
                PersonInfo pInfo = (PersonInfo)this.kdtSalGrade.getCell(rowIndex, colIndex).getValue();
                this.kdtSalGrade.getCell(rowIndex, perNum).setValue((Object)pInfo);
            }
        }
        if ("FPER002".equals(this.kdtSalGrade.getColumnKey(colIndex))) {
            String perName = null;
            size = this.kdtSalGrade.getColumnCount();
            for (i = 0; i < size; ++i) {
                if (!"FPER001".equals(this.kdtSalGrade.getColumnKey(i))) continue;
                perName = this.kdtSalGrade.getColumnKey(i);
                break;
            }
            if (!StringUtils.isEmpty(perName) && this.kdtSalGrade.getCell(rowIndex, colIndex).getValue() != null) {
                PersonInfo pInfo = (PersonInfo)this.kdtSalGrade.getCell(rowIndex, colIndex).getValue();
                this.kdtSalGrade.getCell(rowIndex, perName).setValue((Object)pInfo);
            }
        }
    }

    public void verifySalGradeDataNew() throws Exception {
        int i;
        CmpItemCollection cmpItems1 = HRUtils.getPersonItemsBySchem(null, this.salariatSchemeID);
        CmpItemCollection cmpItess2 = HRUtils.getCmpItemCollection();
        if (cmpItess2.size() == 0) {
            throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(0).getNumber()});
        }
        if (cmpItems1.size() > 0) {
            int j = cmpItems1.size();
            for (int i2 = 0; i2 < j; ++i2) {
                if (cmpItess2.contains(cmpItems1.get(i2))) continue;
                throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(i2).getNumber()});
            }
        }
        HashMap<String, String> keyMap = new HashMap<String, String>();
        int rowCount = this.kdtSalGrade.getRowCount();
        int colCount = this.kdtSalGrade.getColumnCount();
        IRow row = null;
        ICell cell = null;
        for (i = 0; i < colCount; ++i) {
            Component comp;
            IColumn col = this.kdtSalGrade.getColumn(i);
            ICellEditor editor = col.getEditor();
            if (editor == null || (comp = editor.getComponent()) == null || !(comp instanceof KDBizPromptBox)) continue;
            for (int j = 0; j < rowCount; ++j) {
                ICell cel = this.kdtSalGrade.getCell(j, i);
                Object obj = cel.getValue();
                if (obj == null || obj instanceof CoreBaseInfo) continue;
                MsgBox.showInfo((String)HRUtils.getSalariatResourceStr("F7_EDIT_ILLEGAL"));
                this.kdtSalGrade.getEditManager().editCellAt(j, i);
                SysUtil.abort();
            }
        }
        for (i = 0; i < rowCount; ++i) {
            row = this.kdtSalGrade.getRow(i);
            StringBuffer newKey = new StringBuffer();
            int size = this.itemColumnNames.size();
            for (int j = 0; j < size; ++j) {
                cell = row.getCell(this.itemColumnNames.get(j).toString());
                Object cellValue = cell.getValue();
                if (cellValue == null) continue;
                Object columnType = this.newColumnTypes.get(this.itemColumnNames.get(j).toString());
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT)) {
                    DataBaseInfo info = (DataBaseInfo)cellValue;
                    newKey.append(info.getId().toString());
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                    IntEnum enum0;
                    if (cellValue instanceof IntEnum) {
                        enum0 = (IntEnum)cellValue;
                        newKey.append(enum0.getValue());
                        continue;
                    }
                    if (!(cellValue instanceof StringEnum)) continue;
                    enum0 = (StringEnum)cellValue;
                    newKey.append(enum0.getValue());
                    continue;
                }
                newKey.append(cellValue);
            }
            if (newKey.toString().equals("")) {
                MsgBox.showInfo((String)MessageFormat.format(HRUtils.getSalariatResourceStr("GRADETABLE_MISS_PERSONITEM"), i + 1));
                this.kdtSalGrade.getSelectManager().removeAll(false);
                this.kdtSalGrade.getEditManager().editCellAt(row.getRowIndex(), this.kdtSalGrade.getColumnIndex(this.itemColumnNames.get(0).toString()));
                SysUtil.abort();
                continue;
            }
            keyMap.put(newKey.toString(), "");
            if (keyMap.size() == i + 1) continue;
            MsgBox.showInfo((String)MessageFormat.format(HRUtils.getSalariatResourceStr("GRADETABLE_MUTIL_PERSIONITEM"), i + 1));
            this.kdtSalGrade.getSelectManager().removeAll(false);
            this.kdtSalGrade.getEditManager().editCellAt(row.getRowIndex(), this.kdtSalGrade.getColumnIndex(this.itemColumnNames.get(0).toString()));
            SysUtil.abort();
        }
    }

    public void storeSalGradeTableData() {
        ArrayList valueMapList = new ArrayList();
        HashMap<String, Object> valueMap = null;
        IRow row = null;
        ICell cell = null;
        HashMap<String, Object> personItemMap = null;
        int rowCount = this.kdtSalGrade.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int j;
            row = this.kdtSalGrade.getRow(i);
            valueMap = new HashMap<String, Object>();
            personItemMap = new HashMap<String, Object>();
            Object cellValue = null;
            int size = this.itemColumnNames.size();
            for (j = 0; j < size; ++j) {
                String columnName = this.itemColumnNames.get(j).toString();
                cell = row.getCell(columnName);
                cellValue = cell.getValue();
                Object columnType = this.newColumnTypes.get(columnName);
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                    IntEnum enum0;
                    if (cellValue instanceof IntEnum) {
                        enum0 = (IntEnum)cellValue;
                        personItemMap.put(columnName, enum0.getValue());
                        continue;
                    }
                    if (!(cellValue instanceof StringEnum)) continue;
                    enum0 = (StringEnum)cellValue;
                    personItemMap.put(columnName, enum0.getValue());
                    continue;
                }
                if (cellValue != null && cellValue instanceof CoreBaseInfo) {
                    personItemMap.put(columnName, ((CoreBaseInfo)cellValue).getId().toString());
                    continue;
                }
                personItemMap.put(columnName, cellValue);
            }
            valueMap.put("map_person", personItemMap);
            size = this.pointColumnNames.size();
            for (j = 0; j < size; ++j) {
                cell = row.getCell(this.pointColumnNames.get(j).toString());
                cellValue = cell.getValue();
                if (cellValue != null && cellValue instanceof CoreBaseInfo) {
                    valueMap.put(this.pointColumnNames.get(j).toString(), ((CoreBaseInfo)cellValue).getId().toString());
                    continue;
                }
                valueMap.put(this.pointColumnNames.get(j).toString(), cellValue);
            }
            valueMapList.add(valueMap);
        }
        try {
            this.editData.put("salariatSchemeID", this.salariatSchemeID);
            this.editData.put("GradeTableName", this.salariatSchemeInfo.getGradeTableName());
            this.editData.put("pointColumnNames", this.pointColumnNames);
            this.editData.put("valueMapListGrade", valueMapList);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public KDTable getTable() {
        return this.kdtSalPoint;
    }

    @Override
    public void actionInputOldData_actionPerformed(ActionEvent e) throws Exception {
        int result;
        if (this.isAlreadyImport && !MsgBox.isYes((int)(result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"703_SalariatPointSalariatGradeEditUI"))))) {
            return;
        }
        String querySQL = " select * from " + this.salariatSchemeInfo.getPointTableName() + " where FSalPointSalGradeID is null";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)querySQL);
        IRowSet rs = exec.executeSQL();
        if (rs == null || rs.size() == 0) {
            return;
        }
        int coumnCount = this.kdtSalPoint.getColumnCount();
        IRow row = null;
        ICell cell = null;
        boolean hasOldData = false;
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            hasOldData = true;
            row = this.kdtSalPoint.addRow();
            this.isChanged = true;
            for (int i = 0; i < coumnCount; ++i) {
                cell = row.getCell(i);
                String columnName = (String)this.columnNames.get(i);
                Object columnType = this.columnTypes.get(i);
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT)) {
                    String objID = rs.getString(columnName);
                    SalariatHiberPropsInfo info = this.getPointInfoByID(objID);
                    cell.setValue((Object)info);
                    map.put(objID, "true");
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) continue;
                if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                    String strValue = rs.getString(columnName);
                    cell.setValue((Object)strValue);
                    continue;
                }
                if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    BigDecimal value = rs.getBigDecimal(columnName);
                    cell.setValue((Object)value);
                    continue;
                }
                if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                int intValue = rs.getInt(columnName);
                cell.setValue((Object)intValue);
            }
        }
        this.isAlreadyImport = true;
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdtSalPoint, 0, this.kdtSalPoint.getRowCount() - 1, this.getKDSortManger());
        querySQL = " select * from " + this.salariatSchemeInfo.getGradeTableName() + " where FSalPointSalGradeID is null";
        exec = SQLExecutorFactory.getRemoteInstance((String)querySQL);
        rs = exec.executeSQL();
        if (rs == null) {
            return;
        }
        row = null;
        while (rs.next()) {
            int i;
            row = this.kdtSalGrade.addRow();
            this.isChanged = true;
            String mapPersonID = rs.getString("FPersonMapID");
            SalariatMapPersonItemInfo mapPersonInfo = this.getMapPersonItemsByID(mapPersonID);
            if (mapPersonInfo != null) {
                int size = this.itemColumnNames.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    String columnKey = (String)this.itemColumnNames.get(i2);
                    Object obj = mapPersonInfo.get(columnKey);
                    if (columnKey.equals("FPER010")) {
                        int enumValue = (Integer)obj;
                        row.getCell(columnKey).setValue((Object)Genders.getEnum((int)enumValue));
                        continue;
                    }
                    if (obj instanceof BigDecimal) {
                        BigDecimal bigValue = ((BigDecimal)obj).setScale(2);
                        row.getCell(columnKey).setValue((Object)bigValue);
                        continue;
                    }
                    row.getCell(columnKey).setValue(obj);
                }
            }
            IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            String perItemNumber = null;
            int size = this.itemColumnNames.size();
            for (i = 0; i < size; ++i) {
                perItemNumber = this.itemColumnNames.get(i).toString();
                Object personItemIDValue = rs.getObject(perItemNumber);
                Object columnType = this.newColumnTypes.get(perItemNumber);
                if (personItemIDValue == null) continue;
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT) || "FPER003".equals(perItemNumber)) {
                    BOSUuid id = BOSUuid.read((String)personItemIDValue.toString());
                    IObjectValue valueObject = iDynamicObject.getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
                    row.getCell(perItemNumber).setValue((Object)valueObject);
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                    row.getCell(perItemNumber).setValue(this.getEnumFromClassName(perItemNumber, personItemIDValue.toString()));
                    continue;
                }
                row.getCell(perItemNumber).setValue(personItemIDValue);
            }
            size = this.pointColumnNames.size();
            for (i = 0; i < size; ++i) {
                String pointID = rs.getString((String)this.pointColumnNames.get(i));
                row.getCell((String)this.pointColumnNames.get(i)).setValue((Object)this.getPointInfoByID(pointID));
            }
        }
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        String number = this.editData.getNumber();
        String name = this.txtName1.getSelectedItem().toString();
        if (number == null && this.txtNumber.getText().length() > 0 || number != null && !number.equals(this.txtNumber.getText())) {
            return true;
        }
        if (name == null && this.txtName1.getSelectedItem().toString().length() > 0 || name != null && !name.equals(this.txtName1.getSelectedItem().toString())) {
            return true;
        }
        SalPointSalGradeAdminOrgCollection salPointSalGradeAdminOrgCol = this.editData.getAdminOrgEntry();
        HashSet<String> set = new HashSet<String>();
        int size = salPointSalGradeAdminOrgCol.size();
        for (int i = 0; i < size; ++i) {
            set.add(salPointSalGradeAdminOrgCol.get(i).getAdminOrg().getId().toString());
        }
        Object value = this.prmtAdminUnitOrg.getData();
        Object[] ogs = null;
        if (value instanceof Object[]) {
            ogs = (Object[])value;
        }
        AdminOrgUnitInfo adminOrgInfo = null;
        if (ogs == null) {
            if (set.size() != 0) {
                return true;
            }
        } else {
            int size2 = ogs.length;
            for (int i = 0; i < size2; ++i) {
                adminOrgInfo = (AdminOrgUnitInfo)ogs[i];
                if (set.size() == 0 && adminOrgInfo != null) {
                    return true;
                }
                if (set.size() > 0 && adminOrgInfo == null) {
                    return true;
                }
                if (set.size() > 0 && size2 != set.size()) {
                    return true;
                }
                if (set.size() <= 0 || set.contains(adminOrgInfo.getId().toString())) continue;
                return true;
            }
        }
        return this.isChanged;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        super.actionSubmit_actionPerformed(e);
        this.isChanged = false;
    }

    class CellEditGradeAdapter
    extends KDTEditAdapter {
        CellEditGradeAdapter() {
        }

        public void editStarting(KDTEditEvent e) {
            ICellEditor editor;
            Component component;
            super.editStarting(e);
            KDTable table = (KDTable)e.getSource();
            int colIndex = e.getColIndex();
            IColumn column = table.getColumn(colIndex);
            if (column.getKey() == null) {
                return;
            }
            if (column.getKey().length() >= "FPointID".length() && column.getKey().substring(0, "FPointID".length()).equals("FPointID") && (component = (editor = table.getEditManager().getEditor()).getComponent()) instanceof KDBizPromptBox) {
                KDBizPromptBox kdBiz = (KDBizPromptBox)component;
                SalariatPointPromptBox pointPromtBox = (SalariatPointPromptBox)kdBiz.getSelector();
                pointPromtBox.putParameter("schemeID", SalariatPointSalariatGradeEditUI.this.salariatSchemeID);
                String sql = null;
                sql = SalariatPointSalariatGradeEditUI.this.salariatSchemeInfo.getPointTableName() != null && SalariatPointSalariatGradeEditUI.this.editData.getId() != null ? "select FPointID from " + SalariatPointSalariatGradeEditUI.this.salariatSchemeInfo.getPointTableName() + " where FsalPointSalGradeID = '" + SalariatPointSalariatGradeEditUI.this.editData.getId() + "'" : "select FPointID from " + SalariatPointSalariatGradeEditUI.this.salariatSchemeInfo.getPointTableName() + " where 1>1";
                pointPromtBox.putParameter("FsalPointSalGradeID", sql);
                pointPromtBox.putParameter("Owner", "SalariatPointSalariatGradeEditUI");
            }
            SalariatPointSalariatGradeEditUI.this.isChanged = true;
            SalariatPointSalariatGradeEditUI.this.isEditStopped = false;
        }

        public void editStopped(KDTEditEvent e) {
            super.editStopped(e);
            SalariatPointSalariatGradeEditUI.this.isEditStopped = true;
        }

        public void editValueChanged(KDTEditEvent e) {
            super.editValueChanged(e);
            SalariatPointSalariatGradeEditUI.this.isChanged = true;
        }
    }

    class CellEditAdapter
    extends KDTEditAdapter {
        CellEditAdapter() {
        }

        public void editStarting(KDTEditEvent e) {
            ICellEditor editor;
            Component component;
            super.editStarting(e);
            KDTable table = (KDTable)e.getSource();
            int colIndex = e.getColIndex();
            IColumn column = table.getColumn(colIndex);
            if (column.getKey() == null) {
                return;
            }
            if (column.getKey().equals("FPointID") && (component = (editor = table.getEditManager().getEditor()).getComponent()) instanceof KDBizPromptBox) {
                KDBizPromptBox kdBiz = (KDBizPromptBox)component;
                SalariatPointPromptBox pointPromtBox = (SalariatPointPromptBox)kdBiz.getSelector();
                pointPromtBox.putParameter("schemeID", SalariatPointSalariatGradeEditUI.this.salariatSchemeID);
                pointPromtBox.putParameter("Owner", "SalariatPointSalariatGradeEditUI");
            }
            SalariatPointSalariatGradeEditUI.this.isEditStopped = false;
            SalariatPointSalariatGradeEditUI.this.isChanged = true;
        }

        public void editStopped(KDTEditEvent evt) {
            super.editStopped(evt);
            KDTable table = (KDTable)evt.getSource();
            int colIndex = evt.getColIndex();
            Object newValue = evt.getValue();
            if (newValue == null) {
                return;
            }
            IColumn column = table.getColumn(colIndex);
            if (column.getKey() == null) {
                return;
            }
            if (column.getKey().equals("FPointID")) {
                SalariatPointSalariatGradeEditUI.this.isEditStopped = true;
            }
        }

        public void editValueChanged(KDTEditEvent e) {
            super.editValueChanged(e);
            SalariatPointSalariatGradeEditUI.this.isChanged = true;
        }
    }
}

