/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.compensation.SalariatCurrencyPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatCurrencyPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchCurrPropsUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;

public class SalariatSchCurrPropsUI
extends AbstractSalariatSchCurrPropsUI {
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_SELECTED = 1;
    private static final int COLUMN_NUMBER = 2;
    private static final int COLUMN_NAME = 3;
    private KDCheckBox kdCheckBox = null;
    private SalariatSchemeInfo schmInfo = null;
    private List selectIDList = new ArrayList();
    private SalariatCurrencyPropsCollection currCollection = null;

    public SalariatSchCurrPropsUI() throws Exception {
        this.initTable();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        KDTEditManager em = this.kdMainTable.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
        }
        this.currCollection = new SalariatCurrencyPropsCollection();
        int seq = 0;
        for (int i = 0; i < this.kdMainTable.getRowCount(); ++i) {
            IRow row = this.kdMainTable.getRow(i);
            ICell cell = row.getCell(1);
            Boolean value = (Boolean)cell.getValue();
            if (!value.equals(true)) continue;
            SalariatCurrencyPropsInfo info = new SalariatCurrencyPropsInfo();
            CurrencyInfo currInfo = new CurrencyInfo();
            cell = row.getCell(0);
            String id = (String)cell.getValue();
            currInfo.setId(BOSUuid.read((String)id));
            cell = row.getCell(2);
            String iosCode = (String)cell.getValue();
            currInfo.setIsoCode(iosCode);
            cell = row.getCell(3);
            String name = (String)cell.getValue();
            currInfo.setName(name);
            info.setCurrency(currInfo);
            info.setSeq(seq);
            ++seq;
            this.currCollection.add(info);
        }
    }

    public boolean verifyDataNew() throws Exception {
        boolean isVerify = false;
        for (int i = 0; i < this.kdMainTable.getRowCount(); ++i) {
            IRow row = this.kdMainTable.getRow(i);
            ICell cell = row.getCell(1);
            Boolean value = (Boolean)cell.getValue();
            if (!value.equals(true)) continue;
            isVerify = true;
            break;
        }
        if (!isVerify) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_CURRENCY)));
        }
        return isVerify;
    }

    private KDCheckBox getKDCheck() {
        if (this.kdCheckBox == null) {
            this.kdCheckBox = new KDCheckBox();
        }
        return this.kdCheckBox;
    }

    private void initTable() {
        this.kdMainTable.checkParsed();
        this.kdMainTable.getSelectManager().setSelectMode(2);
        this.kdMainTable.getColumn(2).getStyleAttributes().setLocked(true);
        this.kdMainTable.getColumn(3).getStyleAttributes().setLocked(true);
        KDTDefaultCellEditor celleditor = new KDTDefaultCellEditor((JCheckBox)this.getKDCheck());
        this.kdMainTable.getColumn(1).setEditor((ICellEditor)celleditor);
    }

    private void setControlState() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.kdMainTable.getColumn(1).getStyleAttributes().setLocked(false);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdMainTable.getColumn(1).getStyleAttributes().setLocked(true);
        }
    }

    public void onLoad() throws Exception {
        this.kdMainTable.removeRows();
        this.loadTableData();
        this.loadExistCurrs();
        this.setControlState();
    }

    private void loadTableData() throws Exception {
        MetaDataPK queryCurrPK = new MetaDataPK("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        IQueryExecutor execAll = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryCurrPK);
        IRowSet rowSet = execAll.executeQuery();
        while (rowSet.next()) {
            IRow newRow = this.kdMainTable.addRow();
            ICell cell = newRow.getCell(0);
            cell.setValue((Object)rowSet.getString("id"));
            cell = newRow.getCell(1);
            cell.setValue((Object)false);
            cell = newRow.getCell(2);
            cell.setValue((Object)rowSet.getString("isoCode"));
            cell = newRow.getCell(3);
            cell.setValue((Object)rowSet.getString("name"));
        }
    }

    private void loadExistCurrs() throws Exception {
        if (!OprtState.EDIT.equals(this.getOprtState()) && !OprtState.VIEW.equals(this.getOprtState())) {
            return;
        }
        if (this.getSchmInfo() == null) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SCHEMEINFO)));
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCurrencyQuery");
        IQueryExecutor execCurr = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.getSchmInfo().getId().toString()));
        entityView.setFilter(filterInfoItem);
        execCurr.setObjectView(entityView);
        IRowSet rowSet = execCurr.executeQuery();
        this.selectIDList = new ArrayList();
        while (rowSet.next()) {
            this.selectIDList.add(rowSet.getString("currency.id"));
        }
        for (int i = 0; i < this.kdMainTable.getRowCount(); ++i) {
            IRow row = this.kdMainTable.getRow(i);
            ICell cell = row.getCell(0);
            Object value = cell.getValue();
            if (!this.selectIDList.contains(value)) continue;
            cell = row.getCell(1);
            cell.setValue((Object)true);
        }
    }

    public SalariatSchemeInfo getSchmInfo() {
        return this.schmInfo;
    }

    public void setSchmInfo(SalariatSchemeInfo info) {
        this.schmInfo = info;
    }

    public SalariatCurrencyPropsCollection getCurrCollection() {
        if (this.currCollection == null) {
            this.currCollection = new SalariatCurrencyPropsCollection();
        }
        return this.currCollection;
    }
}

