/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchHiberPropsUI;
import com.kingdee.eas.hr.compensation.client.SalariatSchHiberPropsEditUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SalariatSchHiberPropsUI
extends AbstractSalariatSchHiberPropsUI {
    private static Logger logger = Logger.getLogger(SalariatSchHiberPropsUI.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.hr.compensation.client.SalariatResource";
    private SalariatSchemeInfo schemeInfo = null;
    private ISalariatHiberProps iBiz = null;
    private SalariatHiberPropsCollection hiberCollection = null;
    private SalariatHiberPropsInfo rootInfo = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.hiberCollection = new SalariatHiberPropsCollection();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            SalariatHiberPropsInfo childInfo = (SalariatHiberPropsInfo)childNode.getUserObject();
            for (int j = 0; j < childNode.getChildCount(); ++j) {
                DefaultKingdeeTreeNode subChildNode = (DefaultKingdeeTreeNode)childNode.getChildAt(j);
                SalariatHiberPropsInfo subChildInfo = (SalariatHiberPropsInfo)subChildNode.getUserObject();
                childInfo.getSubHibersCollection().add(subChildInfo);
            }
            this.hiberCollection.add(childInfo);
        }
    }

    protected boolean verifyDataNew() throws Exception {
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot();
        if (rootNode.getChildCount() == 0) {
            TreePath path = new TreePath(rootNode.getPath());
            this.kDTree.expandPath(path);
            this.kDTree.setSelectionPath(path);
            this.handleException((Exception)((Object)new SalariatException(SalariatException.HALF_HIBER_TREE)));
            return false;
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            if (childNode.getChildCount() != 0) continue;
            TreePath path = new TreePath(childNode.getPath());
            this.kDTree.expandPath(path);
            this.kDTree.setSelectionPath(path);
            this.handleException((Exception)((Object)new SalariatException(SalariatException.HALF_HIBER_TREE)));
            return false;
        }
        return true;
    }

    private ISalariatHiberProps getBizInterface() {
        if (this.iBiz == null) {
            try {
                this.iBiz = SalariatHiberPropsFactory.getRemoteInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return this.iBiz;
    }

    public String getStr(String rsName) {
        return EASResource.getString((String)RESOURCE_PATH, (String)rsName);
    }

    private void setControlState() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(true);
            this.btnUpdate.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(false);
            this.btnUpdate.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        this.buildTree();
        this.setControlState();
    }

    private void buildTree() throws Exception {
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)this.getRootInfo());
        rootNode.setCustomIcon(EASResource.getIcon((String)"imgTbtn_organisearrangement"));
        this.kDTree = new KDTree((ITreeNode)rootNode);
        this.kDTree.setShowCheckBox(false);
        this.hiberCollection = this.getTreeData();
        SalariatHiberPropsCollection sons = this.getSons(null, 0);
        this.appendSons(rootNode, 0, sons);
        this.kDTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
        this.kdTreeView.setTree(this.kDTree);
    }

    private SalariatHiberPropsCollection getSons(String parentID, int sonLevel) {
        SalariatHiberPropsCollection sons = new SalariatHiberPropsCollection();
        for (int i = 0; i < this.hiberCollection.size(); ++i) {
            SalariatHiberPropsInfo info = this.hiberCollection.get(i);
            if (info.getLevel() != sonLevel) continue;
            if (parentID == null) {
                if (info.getParent() != null) continue;
                sons.add(info);
                continue;
            }
            if (info.getParent() == null || !info.getParent().getId().toString().equals(parentID)) continue;
            sons.add(info);
        }
        return sons;
    }

    private void appendSons(DefaultKingdeeTreeNode parent, int sonLevel, SalariatHiberPropsCollection sons) {
        DefaultKingdeeTreeNode sonNode = null;
        SalariatHiberPropsInfo son = null;
        for (int i = 0; i < sons.size(); ++i) {
            son = sons.get(i);
            sonNode = new DefaultKingdeeTreeNode();
            sonNode.setUserObject((Object)son);
            SalariatHiberPropsCollection subSons = this.getSons(son.getId().toString(), sonLevel + 1);
            this.appendSons(sonNode, sonLevel + 1, subSons);
            parent.add((MutableTreeNode)sonNode);
        }
    }

    private SalariatHiberPropsCollection getTreeData() throws Exception {
        SalariatHiberPropsCollection collection = new SalariatHiberPropsCollection();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (this.getSchemeInfo() == null) {
                throw new SalariatException(SalariatException.MISS_SCHEMEINFO);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfoItem = new FilterInfo();
            filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.getSchemeInfo().getId().toString()));
            filterInfoItem.setMaskString(" #0 ");
            view.setFilter(filterInfoItem);
            SorterItemCollection sortCollectiom = view.getSorter();
            sortCollectiom.add(new SorterItemInfo("parent.id"));
            collection = this.getBizInterface().getSalariatHiberPropsCollection(view);
        }
        return collection;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAddNew.setText(null);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnUpdate.setText(null);
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.kdTreeView.getControlPane().add((Component)this.btnAddNew);
        this.kdTreeView.getControlPane().add((Component)this.btnUpdate);
        this.kdTreeView.getControlPane().add((Component)this.btnDelete);
    }

    public SalariatSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(SalariatSchemeInfo info) {
        this.schemeInfo = info;
    }

    private SalariatHiberPropsInfo getRootInfo() {
        if (this.rootInfo == null) {
            this.rootInfo = new SalariatHiberPropsInfo();
            this.rootInfo.setNumber("ROOT");
            this.rootInfo.setName(this.getStr("HIBER_TREEROOT"));
            this.rootInfo.setLevel(-1);
        }
        return this.rootInfo;
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddNew_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext = this.getHashMap(uiContext);
        SalariatHiberPropsInfo selectInfo = (SalariatHiberPropsInfo)uiContext.get((Object)"selectNodeObject");
        if (selectInfo.getLevel() < 1) {
            this.showDialog(SalariatSchHiberPropsEditUI.class.getName(), (Map)uiContext, OprtState.ADDNEW);
        } else {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.OUT_HIBER_LEVEL)));
        }
    }

    @Override
    protected void btnUpdate_actionPerformed(ActionEvent e) throws Exception {
        super.btnUpdate_actionPerformed(e);
        DefaultKingdeeTreeNode node = HRUtils.getSelectTreeNode(this.kDTree);
        if (node == null) {
            throw new SalariatException(SalariatException.MISS_SELECT_NODE);
        }
        if (node.isRoot()) {
            throw new SalariatException(SalariatException.NOT_MODIFY_ROOT);
        }
        UIContext uiContext = new UIContext((Object)this);
        this.showDialog(SalariatSchHiberPropsEditUI.class.getName(), (Map)this.getHashMap(uiContext), OprtState.EDIT);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelete_actionPerformed(e);
        DefaultKingdeeTreeNode selectNode = HRUtils.getSelectTreeNode(this.kDTree);
        if (selectNode == null) {
            throw new SalariatException(SalariatException.MISS_SELECT_NODE);
        }
        if (selectNode.isRoot()) {
            throw new SalariatException(SalariatException.CANNT_DELETE_ROOT);
        }
        ((DefaultTreeModel)this.kDTree.getModel()).removeNodeFromParent((MutableTreeNode)selectNode);
    }

    private void showDialog(String strUI, Map map, String status) throws Exception {
        map.put("Owner", this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(strUI, map, null, status);
            curDialog.show();
        }
        catch (UIException ex1) {
            logger.error((Object)ex1.getMessage());
        }
    }

    private UIContext getHashMap(UIContext uiContext) throws Exception {
        DefaultKingdeeTreeNode node = HRUtils.getSelectTreeNode(this.kDTree);
        if (node != null) {
            if (node.getUserObject() instanceof SalariatHiberPropsInfo) {
                uiContext.put((Object)"selectNodeObject", (Object)((SalariatHiberPropsInfo)node.getUserObject()));
            }
        } else {
            throw new SalariatException(SalariatException.MISS_SELECT_NODE);
        }
        uiContext.put((Object)"selectNode", (Object)node);
        uiContext.put((Object)"tree", (Object)this.kDTree);
        return uiContext;
    }

    public SalariatHiberPropsCollection getHiberCollection() {
        if (this.hiberCollection == null) {
            this.hiberCollection = new SalariatHiberPropsCollection();
        }
        return this.hiberCollection;
    }
}

