/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.SalariatCurrencyPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchNewEditUI;
import com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI;
import com.kingdee.eas.hr.compensation.client.SalariatSchCmpItemPropsUI;
import com.kingdee.eas.hr.compensation.client.SalariatSchPersonItemPropsUI;
import com.kingdee.eas.hr.compensation.client.SalariatSchPointListUI;
import com.kingdee.eas.hr.compensation.client.SalariatSchPointPropsUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;

public class SalariatSchNewEditUI
extends AbstractSalariatSchNewEditUI {
    private static final int TAB_POINTLIST = 0;
    private static final int TAB_CMPITEMPROPS = 1;
    private static final int TAB_POINTPROPS = 2;
    private static final int TAB_PERSONPROPS = 3;
    private SalariatSchPersonItemPropsUI personItemPropsUI = null;
    private SalariatSchCmpItemPropsUI cmpItemPropsUI = null;
    private SalariatSchPointPropsUI pointPropsUI = null;
    private SalariatSchPointListUI pointListUI = null;
    private String oldNumber = null;
    private String orignOperateState = null;
    private double MAXBASEVALUE = 1000000.0;

    public SalariatSchNewEditUI() throws Exception {
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.bizPromptCurrency.setEditFormat("$number$");
        this.bizPromptCurrency.setDisplayFormat("$name$");
        this.bizPromptCurrency.setCommitFormat("$number$");
        this.bizPromptCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyDefaultF7Query");
        this.bizPromptCreator.setDisplayFormat("$name$");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        this.bizPromptCurrency.setSelectorCollection(sic);
        this.personItemPropsUI = new SalariatSchPersonItemPropsUI();
        this.personItemPropsUI.initLayout();
        this.cmpItemPropsUI = new SalariatSchCmpItemPropsUI();
        this.cmpItemPropsUI.initLayout();
        this.pointPropsUI = new SalariatSchPointPropsUI();
        this.pointPropsUI.initLayout();
        this.pointListUI = new SalariatSchPointListUI();
        this.pointListUI.initLayout();
        this.btnCmpAdjust.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemChangeSalaryTable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.txtDescription.setMaxLength(180);
        this.kDBusBase.setPrecision(2);
    }

    private void setControlState() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(true);
            this.txtName.setEnabled(true);
            this.bizPromptCurrency.setEnabled(true);
            this.txtDescription.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.bizPromptCurrency.setEnabled(false);
            this.txtDescription.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setCmpAdjustState();
        this.orignOperateState = this.getOprtState();
        this.bizPromptCurrency.setValue((Object)this.editData.getCurrency());
        this.bizPromptCurrency.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        if (this.editData.getPointTableName() != null) {
            this.cmpItemPropsUI.disableEdit();
        }
        if (this.editData.getGradeTableName() != null) {
            // empty if block
        }
        this.txtNumber.requestFocus(true);
        if (StateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.btnCmpAdjust.setEnabled(true);
            this.actionCmpAdjust.setEnabled(true);
            if (this.orignOperateState.equals(OprtState.EDIT)) {
                this.pointPropsUI.btnDelete.setEnabled(false);
            }
        } else {
            this.btnCmpAdjust.setEnabled(false);
            this.actionCmpAdjust.setEnabled(false);
        }
        this.actionCmpAdjust.setVisible(false);
        if (this.kdchkBase.isSelected()) {
            this.kDBusBase.setEnabled(true);
        } else {
            this.kDBusBase.setEnabled(false);
        }
    }

    private void setCmpAdjustState() {
        this.btnCmpAdjust.setEnabled(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionCmpAdjust.setEnabled(false);
            this.btnCmpAdjust.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.oldNumber = this.editData.getNumber();
        if (this.orignOperateState != null) {
            if (this.orignOperateState.equals(OprtState.EDIT)) {
                if (StateEnum.ENABLE.equals((Object)this.editData.getState())) {
                    this.setOprtState(OprtState.EDIT);
                    this.btnSave.setEnabled(true);
                    this.btnSubmit.setEnabled(true);
                    this.btnAddNew.setEnabled(true);
                } else if (!StateEnum.ENABLE.equals((Object)this.editData.getState())) {
                    this.setOprtState(OprtState.EDIT);
                    this.btnSave.setEnabled(true);
                    this.btnSubmit.setEnabled(true);
                    this.btnAddNew.setEnabled(true);
                }
            } else if (this.orignOperateState.equals(OprtState.VIEW)) {
                this.setOprtState(OprtState.VIEW);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.btnAddNew.setEnabled(false);
            }
        }
        this.setControlState();
        try {
            this.loadPropsData();
            if (this.editData.getId() == null) {
                this.actionRemove.setEnabled(true);
            } else {
                this.setRemoveEnable();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.kdchkBase.setSelected(this.editData.isFlagStandardBase());
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.kdchkBase.setSelected(false);
        }
        if (this.editData.getPointTableName() != null) {
            this.cmpItemPropsUI.disableEdit();
        }
        if (this.editData.getGradeTableName() != null) {
            this.pointPropsUI.btnDelete.setEnabled(false);
        }
        this.txtNumber.requestFocus(true);
    }

    private void setRemoveEnable() throws Exception {
        StateEnum obj = this.editData.getState();
        if (obj != null) {
            StateEnum intSatet = obj;
            if (intSatet.getValue() == 1) {
                this.actionRemove.setEnabled(false);
            }
            if (intSatet.getValue() == 0) {
                this.actionRemove.setEnabled(true);
            }
            if (intSatet.getValue() == 3) {
                if (this.checkHasBeenUsed(this.editData.getId().toString())) {
                    this.actionRemove.setEnabled(false);
                } else {
                    this.actionRemove.setEnabled(true);
                }
            }
        }
    }

    private boolean checkHasBeenUsed(String salSchemeID) throws Exception {
        String sql = "select top 1 * from T_HR_FixedCmpScheme where FSalariatScheme = '" + salSchemeID + "'";
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = executor.executeSQL();
        return rs.next();
    }

    private void loadPropsData() throws Exception {
        this.personItemPropsUI.setOprtState(this.getOprtState());
        this.cmpItemPropsUI.setOprtState(this.getOprtState());
        this.pointPropsUI.setOprtState(this.getOprtState());
        this.pointListUI.setOprtState(this.getOprtState());
        this.personItemPropsUI.setSchmInfo(this.editData);
        this.cmpItemPropsUI.setSchmInfo(this.editData);
        this.pointPropsUI.setSchemeInfo(this.editData);
        this.pointListUI.setSchemeInfo(this.editData);
        this.personItemPropsUI.onLoad();
        this.cmpItemPropsUI.onLoad();
        this.pointPropsUI.onLoad();
        this.pointListUI.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.personItemPropsUI.storeFields();
        this.cmpItemPropsUI.storeFields();
        this.pointPropsUI.storeFields();
        this.pointListUI.storeFields();
        this.editData.setPersonItemsCollection(this.personItemPropsUI.getItemsCollection());
        this.editData.setCmpItemsCollection(this.cmpItemPropsUI.getItemsCollection());
        this.editData.setHiberCollection(this.pointListUI.getHiberCollection());
        this.editData.setPointsCollection(this.pointPropsUI.getPropCollection());
        this.editData.setCurrencyCollection(new SalariatCurrencyPropsCollection());
        this.editData.setFlagStandardBase(this.kdchkBase.isSelected());
        this.editData.setFlagPersonItemPriority(false);
    }

    protected IObjectValue createNewData() {
        SysContext ctx = SysContext.getSysContext();
        UserInfo curUser = (UserInfo)ctx.getProperty((Object)"UserInfo");
        SalariatSchemeInfo info = new SalariatSchemeInfo();
        info.setCreator(curUser);
        info.setLastUpdateUser(curUser);
        try {
            info.setCurrency(HRSchemeUtils.getCurrencyInfo());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SalariatSchemeFactory.getRemoteInstance();
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.btnAddNew.setVisible(true);
        this.btnCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kdPersonPropsTab.add((Component)((Object)this.personItemPropsUI), (Object)"Center");
        this.kdCmpItemPropsTab.add((Component)((Object)this.cmpItemPropsUI), (Object)"Center");
        this.kdPointListTab.add((Component)((Object)this.pointListUI), (Object)"Center");
        this.kdPointGradeTab.add((Component)((Object)this.pointPropsUI), (Object)"Center");
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("flagStandardBase"));
        sic.add(new SelectorItemInfo("flagPersonItemPriority"));
        sic.add(new SelectorItemInfo("standardBase"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("pointTableName"));
        sic.add(new SelectorItemInfo("gradeTableName"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        return sic;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdchkBase.isSelected() && this.kDBusBase.getDoubleValue() == null) {
            this.kDBusBase.requestFocus();
            throw new SalariatException(SalariatException.STANDARD_BIGGER_ZERO);
        }
        CmpItemCollection cmpItems1 = null;
        if (this.editData.getId() != null) {
            cmpItems1 = HRUtils.getPersonItemsBySchem(null, this.editData.getId().toString());
            cmpItems1.addCollection(HRUtils.getCmpItemsBySchem(null, this.editData.getId().toString()));
            CmpItemCollection cmpItess2 = HRUtils.getCmpItemCollection();
            if (cmpItess2.size() == 0 && cmpItems1 != null && cmpItems1.size() > 0) {
                throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(0).getNumber()});
            }
            if (cmpItems1.size() > 0) {
                int j = cmpItems1.size();
                for (int i = 0; i < j; ++i) {
                    if (cmpItess2.contains(cmpItems1.get(i))) continue;
                    throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(i).getNumber()});
                }
            }
        }
        if (!this.verifyDataNew()) {
            SysUtil.abort();
        }
        if (!this.verifyPropsData()) {
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
        this.personItemPropsUI.isChanged = false;
        this.cmpItemPropsUI.isChanged = false;
        this.pointPropsUI.isChanged = false;
        this.pointListUI.isChanged = false;
    }

    public boolean verifyDataNew() throws Exception {
        String newNumber = this.txtNumber.getText();
        if (newNumber == null || newNumber.trim().length() == 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_NUMBER)));
            this.txtNumber.requestFocus();
            return false;
        }
        if (!newNumber.equals(this.oldNumber) && ((ISalariatScheme)this.getBizInterface()).existNumber(this.txtNumber.getText())) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MULTI_NUMBER)));
            this.txtNumber.requestFocus();
            return false;
        }
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        String newName = this.editData.getName();
        if (newName == null || newName.trim().length() == 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_NAME)));
            this.txtName.requestFocus();
            return false;
        }
        Object curr = this.bizPromptCurrency.getValue();
        if (curr == null) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_SCHEME_CURR)));
            this.bizPromptCurrency.requestFocus();
            return false;
        }
        if (this.kdchkBase.isSelected() && (this.kDBusBase.getNumberValue().doubleValue() <= 0.0 || this.kDBusBase.getNumberValue().doubleValue() > this.MAXBASEVALUE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.SalariatResource", (String)"STANDARD_BIGGER_ZERO"));
            return false;
        }
        this.editData.setFlagPersonItemPriority(false);
        return true;
    }

    private boolean verifyPropsData() throws Exception {
        if (!this.pointListUI.verifyDataNew()) {
            this.kdTabPane.setSelectedIndex(0);
            return false;
        }
        if (!this.cmpItemPropsUI.verifyDataNew()) {
            this.kdTabPane.setSelectedIndex(1);
            return false;
        }
        if (!this.pointPropsUI.verifyDataNew()) {
            this.kdTabPane.setSelectedIndex(2);
            return false;
        }
        if (!this.personItemPropsUI.verifyDataNew()) {
            this.kdTabPane.setSelectedIndex(3);
            return false;
        }
        return true;
    }

    @Override
    public void actionCmpAdjust_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpAdjust_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        Map mapPerson = this.getCatalogPerson();
        uiContext.put((Object)"ADJUSTSCHEMEEDITUIPARM", (Object)mapPerson);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AdjustSchemeEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private Map getCatalogPerson() throws Exception {
        HashMap mapPerson = new HashMap();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonFixedCmpSchemeNewQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.id"));
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection colFilterItem = filterInfo.getFilterItems();
        String strFixedSchemIdSql = "select fid from T_HR_FixedCmpScheme where Fenable=1 and FHROrgUnitID = '" + SysContext.getSysContext().getCurrentHRUnit().getId().toString() + "'";
        colFilterItem.add(new FilterItemInfo("fixedCmpScheme.id", (Object)strFixedSchemIdSql, CompareType.INNER));
        colFilterItem.add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        evi.setFilter(filterInfo);
        exec.setObjectView(evi);
        try (IRowSet rowSet = exec.executeQuery();){
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", rowSet.getString("person.name"));
                map.put("number", rowSet.getString("person.number"));
                mapPerson.put(rowSet.getString("person.id"), map);
            }
        }
        return mapPerson;
    }

    @Override
    protected void kDBusBase_dataChanged(DataChangeEvent e) throws Exception {
        super.kDBusBase_dataChanged(e);
    }

    public boolean checkBeforeWindowClosing() {
        if (this.orignOperateState.equals(OprtState.VIEW)) {
            return super.checkBeforeWindowClosing();
        }
        if (this.personItemPropsUI.isChanged || this.cmpItemPropsUI.isChanged || this.pointPropsUI.isChanged || this.pointListUI.isChanged) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return !this.actionSubmit.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return result == 1;
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    protected void kdchkBase_stateChanged(ChangeEvent e) throws Exception {
        if (this.kdchkBase.isSelected()) {
            this.kDBusBase.setEnabled(true);
        } else {
            if (this.kDBusBase.getDoubleValue() == null) {
                this.kDBusBase.setNumberValue((Number)new BigDecimal("0"));
            }
            this.kDBusBase.setEnabled(false);
        }
    }

    private void setViewState() {
        this.setOprtState(OprtState.VIEW);
        this.orignOperateState = this.getOprtState();
        this.btnRemove.setEnabled(false);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.setViewState();
        super.actionFirst_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.setViewState();
        super.actionLast_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.setViewState();
        super.actionNext_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.setViewState();
        super.actionPre_actionPerformed(e);
    }
}

