/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchPointListUI;
import com.kingdee.eas.hr.compensation.client.SalariatSchPointCatalogEditUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SalariatSchPointListUI
extends AbstractSalariatSchPointListUI {
    private static Logger logger = Logger.getLogger(SalariatSchPointListUI.class);
    private static final int COLUMN_NUMBER = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_DES = 2;
    private SalariatSchemeInfo schemeInfo = null;
    private ISalariatHiberProps iBiz = null;
    private SalariatHiberPropsCollection hiberCollection = null;
    private SalariatHiberPropsInfo rootInfo = null;
    private DefaultKingdeeTreeNode rootNode = null;
    private DefaultKingdeeTreeNode nowSelectNode = null;
    private SalariatHiberPropsInfo nowSelectCatalog = null;
    public boolean isChanged = false;
    private List lstName = new ArrayList();

    public SalariatSchPointListUI() throws Exception {
        this.jbInit();
    }

    private void jbInit() {
        this.kdPointTable.checkParsed();
        this.kdPointTable.getColumn(0).getStyleAttributes().setHided(true);
        this.kdPointTable.addKDTEditListener((KDTEditListener)new LineEditAdapter());
        this.rootNode = new DefaultKingdeeTreeNode((Object)this.getRootInfo());
        this.kdPointTable.setEnabled(true);
        this.kdPointTable.getSelectManager().setSelectMode(1);
        this.setColMaxLength();
        HRUtils.setFocusDir(this.kdPointTable, 1);
    }

    private void setColMaxLength() {
        try {
            IColumn col = this.kdPointTable.getColumn(1);
            KDTextField txtField = new KDTextField();
            txtField.setMaxLength(80);
            KDTDefaultCellEditor cellEditorCode = new KDTDefaultCellEditor((JTextField)txtField);
            col.setEditor((ICellEditor)cellEditorCode);
            col = this.kdPointTable.getColumn(2);
            txtField = new KDTextField();
            txtField.setMaxLength(80);
            cellEditorCode = new KDTDefaultCellEditor((JTextField)txtField);
            col.setEditor((ICellEditor)cellEditorCode);
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAddCatalog.setText(null);
        this.btnModifyCatalog.setText(null);
        this.btnDeleteCatalog.setText(null);
        this.btnAddPoint.setText(null);
        this.btnInserPoint.setText(null);
        this.btnRemovePoint.setText(null);
        this.btnInput.setText(null);
        this.btnAddCatalog.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnModifyCatalog.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDeleteCatalog.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAddPoint.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInserPoint.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemovePoint.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnInput.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.kdTreeView.getControlPane().add((Component)this.btnAddCatalog);
        this.kdTreeView.getControlPane().add((Component)this.btnModifyCatalog);
        this.kdTreeView.getControlPane().add((Component)this.btnInput);
        this.kdTreeView.getControlPane().add((Component)this.btnDeleteCatalog);
        this.ctnTable.addButton((JButton)this.btnAddPoint);
        this.ctnTable.addButton((JButton)this.btnInserPoint);
        this.ctnTable.addButton((JButton)this.btnRemovePoint);
    }

    private ISalariatHiberProps getBizInterface() {
        if (this.iBiz == null) {
            try {
                this.iBiz = SalariatHiberPropsFactory.getRemoteInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return this.iBiz;
    }

    public SalariatSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(SalariatSchemeInfo info) {
        this.schemeInfo = info;
    }

    public SalariatHiberPropsCollection getHiberCollection() {
        return this.hiberCollection;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.hiberCollection = new SalariatHiberPropsCollection();
        if (!this.savePointsByCatalog()) {
            return;
        }
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.rootNode.getChildAt(i);
            SalariatHiberPropsInfo childInfo = (SalariatHiberPropsInfo)childNode.getUserObject();
            childInfo.setIsLeaf(false);
            childInfo.setLevel(0);
            this.hiberCollection.add(childInfo);
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("VIEW".equals(this.oprtState)) {
            this.btnAddPoint.setEnabled(false);
            this.btnInserPoint.setEnabled(false);
            this.btnRemovePoint.setEnabled(false);
        }
    }

    protected boolean verifyDataNew() throws Exception {
        int i;
        IRow iRow = null;
        int size = this.kdPointTable.getRowCount();
        for (i = 0; i < size; ++i) {
            iRow = this.kdPointTable.getRow(i);
            if (iRow.getCell("name") == null || !StringUtils.isEmpty((String)iRow.getCell("name").toString())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"600_SalariatSchPointListUI"));
            SysUtil.abort();
        }
        if (!this.savePointsByCatalog()) {
            return false;
        }
        if (this.rootNode.getChildCount() == 0) {
            TreePath path = new TreePath(this.rootNode.getPath());
            this.kdCatalogTree.expandPath(path);
            this.kdCatalogTree.setSelectionPath(path);
            this.handleException((Exception)((Object)new SalariatException(SalariatException.HALF_HIBER_TREE)));
            return false;
        }
        for (i = 0; i < this.rootNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.rootNode.getChildAt(i);
            SalariatHiberPropsInfo childInfo = (SalariatHiberPropsInfo)childNode.getUserObject();
            if (childInfo.getSubHibersCollection().size() != 0) continue;
            TreePath path = new TreePath(childNode.getPath());
            this.kdCatalogTree.expandPath(path);
            this.kdCatalogTree.setSelectionPath(path);
            this.handUIException((Throwable)((Object)new SalariatException(SalariatException.MISS_POINT)));
            return false;
        }
        return true;
    }

    private void resetSigns() {
        this.hiberCollection = null;
        this.nowSelectNode = null;
        this.nowSelectCatalog = null;
    }

    private void setControlState() {
        this.setPointButtonState(false);
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.kdPointTable.getColumn(1).getStyleAttributes().setLocked(false);
            this.kdPointTable.getColumn(2).getStyleAttributes().setLocked(false);
            this.btnAddCatalog.setEnabled(true);
            this.btnModifyCatalog.setEnabled(true);
            this.btnDeleteCatalog.setEnabled(true);
            this.btnInput.setEnabled(true);
            this.kdCatalogTree.setEditable(true);
            this.kdPointTable.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdPointTable.getColumn(1).getStyleAttributes().setLocked(true);
            this.kdPointTable.getColumn(2).getStyleAttributes().setLocked(true);
            this.btnAddCatalog.setEnabled(false);
            this.btnDeleteCatalog.setEnabled(false);
            this.btnModifyCatalog.setEnabled(false);
            this.btnInput.setEnabled(false);
            this.kdCatalogTree.setEditable(false);
            this.kdPointTable.setEnabled(false);
        }
    }

    private void setPointButtonState(boolean enable) {
        if (enable && !"VIEW".equals(this.getOprtState())) {
            this.btnInserPoint.setEnabled(true);
            this.btnAddPoint.setEnabled(true);
            this.btnRemovePoint.setEnabled(true);
        } else {
            this.btnInserPoint.setEnabled(false);
            this.btnAddPoint.setEnabled(false);
            this.btnRemovePoint.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        this.resetSigns();
        this.hiberCollection = this.getTreeData();
        this.buildCatalogTree();
        this.enableExportExcel(this.kdPointTable);
        this.setControlState();
        this.addTableHeadSort(this.kdPointTable);
    }

    public void addTableHeadSort(KDTable table) {
        table.checkParsed();
        KDTSortManager sortManager = new KDTSortManager(table);
        int size = table.getColumnCount();
        for (int i = 0; i < size; ++i) {
            table.getColumn(i).setSortable(true);
        }
        sortManager.setSortAuto(true);
    }

    private void buildCatalogTree() throws Exception {
        this.kdCatalogTree = new KDTree((ITreeNode)this.rootNode);
        this.kdCatalogTree.setShowCheckBox(false);
        this.kdCatalogTree.setRootVisible(true);
        this.kdCatalogTree.getSelectionModel().setSelectionMode(1);
        this.kdCatalogTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    SalariatSchPointListUI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    SalariatSchPointListUI.this.handUIException(exc);
                }
            }
        });
        this.rootNode.removeAllChildren();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            SalariatHiberPropsCollection cataloges = this.getCatalogData();
            DefaultKingdeeTreeNode itemNode = null;
            SalariatHiberPropsInfo item = null;
            for (int i = 0; i < cataloges.size(); ++i) {
                item = cataloges.get(i);
                this.getPointsByCatalog(item);
                itemNode = new DefaultKingdeeTreeNode((Object)item);
                this.rootNode.add((MutableTreeNode)itemNode);
            }
        }
        this.kdCatalogTree.revalidate();
        this.kdCatalogTree.repaint();
        this.kdCatalogTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.rootNode));
        this.kdTreeView.setTree(this.kdCatalogTree);
        if (this.rootNode.getChildCount() > 0) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.rootNode.getChildAt(0);
            TreePath path = new TreePath(childNode.getPath());
            this.kdCatalogTree.expandPath(path);
            this.kdCatalogTree.setSelectionPath(path);
        }
        this.kdCatalogTree.setSelectionNode(this.rootNode);
    }

    private SalariatHiberPropsInfo getRootInfo() {
        if (this.rootInfo == null) {
            this.rootInfo = new SalariatHiberPropsInfo();
            this.rootInfo.setNumber("ROOT");
            this.rootInfo.setName(HRUtils.getSalariatResourceStr("HIBER_TREEROOT"));
            this.rootInfo.setLevel(-1);
        }
        return this.rootInfo;
    }

    private SalariatHiberPropsCollection getCatalogData() {
        SalariatHiberPropsCollection sons = new SalariatHiberPropsCollection();
        for (int i = 0; i < this.hiberCollection.size(); ++i) {
            SalariatHiberPropsInfo info = this.hiberCollection.get(i);
            if (info.getParent() != null) continue;
            sons.add(info);
        }
        return sons;
    }

    private void getPointsByCatalog(SalariatHiberPropsInfo catalog) {
        for (int i = 0; i < this.hiberCollection.size(); ++i) {
            SalariatHiberPropsInfo info = this.hiberCollection.get(i);
            if (info.getParent() == null || !info.getParent().getId().equals((Object)catalog.getId())) continue;
            catalog.getSubHibersCollection().add(info);
        }
    }

    private SalariatHiberPropsCollection getTreeData() throws Exception {
        SalariatHiberPropsCollection collection = new SalariatHiberPropsCollection();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (this.getSchemeInfo() == null || this.getSchemeInfo().getId() == null) {
                throw new SalariatException(SalariatException.MISS_SCHEMEINFO);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfoItem = new FilterInfo();
            filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.getSchemeInfo().getId().toString()));
            filterInfoItem.setMaskString(" #0 ");
            view.setFilter(filterInfoItem);
            SorterItemCollection sortCollectiom = view.getSorter();
            sortCollectiom.add(new SorterItemInfo("name"));
            collection = this.getBizInterface().getSalariatHiberPropsCollection(view);
        }
        return collection;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = HRUtils.getSelectTreeNode(this.kdCatalogTree);
        if (node == null) {
            this.setPointButtonState(false);
            this.kdPointTable.removeRows();
            this.btnAddCatalog.setEnabled(true);
            this.nowSelectNode = null;
            return;
        }
        if (node.equals(this.rootNode)) {
            this.setPointButtonState(false);
            if (!this.savePointsByCatalog() && this.nowSelectNode != null) {
                TreePath path = new TreePath(this.nowSelectNode.getPath());
                this.kdCatalogTree.expandPath(path);
                this.kdCatalogTree.setSelectionPath(path);
            }
            this.kdPointTable.removeRows();
            this.btnAddCatalog.setEnabled(true);
            this.nowSelectNode = null;
            return;
        }
        this.btnAddCatalog.setEnabled(false);
        if (node.equals(this.nowSelectNode)) {
            this.setPointButtonState(true);
            return;
        }
        Object obj = node.getUserObject();
        if (obj == null || !(obj instanceof SalariatHiberPropsInfo)) {
            this.setPointButtonState(false);
            return;
        }
        if (!this.savePointsByCatalog() && this.nowSelectNode != null) {
            TreePath path = new TreePath(this.nowSelectNode.getPath());
            this.kdCatalogTree.expandPath(path);
            this.kdCatalogTree.setSelectionPath(path);
            this.setPointButtonState(true);
            return;
        }
        this.setPointButtonState(true);
        SalariatHiberPropsInfo catalogInfo = (SalariatHiberPropsInfo)obj;
        SalariatHiberPropsCollection pointList = catalogInfo.getSubHibersCollection();
        this.nowSelectNode = node;
        this.nowSelectCatalog = catalogInfo;
        this.kdPointTable.removeRows();
        this.lstName = new ArrayList();
        SalariatHiberPropsInfo pointInfo = null;
        for (int i = 0; i < pointList.size(); ++i) {
            pointInfo = pointList.get(i);
            this.lstName.add(pointInfo.getName());
            IRow row = this.kdPointTable.addRow();
            row.getCell(0).setValue((Object)pointInfo.getNumber());
            row.getCell(1).setValue((Object)pointInfo.getName());
            row.getCell(2).setValue((Object)pointInfo.getDescription());
            row.setUserObject((Object)pointInfo);
        }
    }

    private boolean savePointsByCatalog() {
        this.kdPointTable.getEditManager().stopEditing();
        for (int i = 0; i < this.kdPointTable.getRowCount(); ++i) {
            IRow row = this.kdPointTable.getRow(i);
            if (this.fieldStoreLine(row)) continue;
            return false;
        }
        return true;
    }

    private boolean fieldStoreLine(IRow row) {
        SalariatHiberPropsInfo info = (SalariatHiberPropsInfo)row.getUserObject();
        info.setNumber((String)row.getCell(0).getValue());
        if (info.getName() == null) {
            this.handUIException((Throwable)((Object)new SalariatException(SalariatException.MISS_POINT_NAME)));
            this.kdPointTable.getSelectManager().removeAll(false);
            this.kdPointTable.getEditManager().editCellAt(row.getRowIndex(), 1);
            return false;
        }
        info.setDescription((String)row.getCell(2).getValue());
        info.setString("description_l1", (String)row.getCell(2).getValue());
        info.setString("description_l2", (String)row.getCell(2).getValue());
        info.setString("description_l3", (String)row.getCell(2).getValue());
        info.setIsLeaf(true);
        info.setLevel(1);
        return true;
    }

    @Override
    protected void btnAddCatalog_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddCatalog_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext = this.getHashMap(uiContext);
        this.showDialog(SalariatSchPointCatalogEditUI.class.getName(), (Map)uiContext, OprtState.ADDNEW);
    }

    @Override
    protected void btnModifyCatalog_actionPerformed(ActionEvent e) throws Exception {
        super.btnModifyCatalog_actionPerformed(e);
        DefaultKingdeeTreeNode node = HRUtils.getSelectTreeNode(this.kdCatalogTree);
        if (node == null) {
            throw new SalariatException(SalariatException.MISS_SELECT_NODE);
        }
        if (node.isRoot()) {
            throw new SalariatException(SalariatException.NOT_MODIFY_ROOT);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext = this.getHashMap(uiContext);
        this.showDialog(SalariatSchPointCatalogEditUI.class.getName(), (Map)this.getHashMap(uiContext), OprtState.EDIT);
    }

    @Override
    protected void btnDeleteCatalog_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteCatalog_actionPerformed(e);
        DefaultKingdeeTreeNode node = HRUtils.getSelectTreeNode(this.kdCatalogTree);
        if (node == null) {
            throw new SalariatException(SalariatException.MISS_SELECT_NODE);
        }
        if (node.isRoot()) {
            throw new SalariatException(SalariatException.CANNT_DELETE_ROOT);
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        this.rootNode.remove((MutableTreeNode)node);
        this.kdPointTable.removeRows();
        ((DefaultTreeModel)this.kdCatalogTree.getModel()).nodeStructureChanged((TreeNode)this.rootNode);
        if (this.rootNode.getChildCount() > 0) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.rootNode.getChildAt(0);
            TreePath path = new TreePath(childNode.getPath());
            this.kdCatalogTree.expandPath(path);
            this.kdCatalogTree.setSelectionPath(path);
        }
    }

    @Override
    protected void btnAddPoint_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddPoint_actionPerformed(e);
        IRow row = this.kdPointTable.addRow();
        SalariatHiberPropsInfo newPoint = new SalariatHiberPropsInfo();
        newPoint.setParent(this.nowSelectCatalog);
        newPoint.setIsLeaf(true);
        newPoint.setLevel(1);
        this.nowSelectCatalog.getSubHibersCollection().add(newPoint);
        row.setUserObject((Object)newPoint);
        this.isChanged = true;
    }

    @Override
    protected void btnInserPoint_actionPerformed(ActionEvent e) throws Exception {
        super.btnInserPoint_actionPerformed(e);
        int activeIndex = this.kdPointTable.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        IRow row = this.kdPointTable.addRow(activeIndex);
        SalariatHiberPropsInfo newPoint = new SalariatHiberPropsInfo();
        newPoint.setParent(this.nowSelectCatalog);
        newPoint.setIsLeaf(true);
        newPoint.setLevel(1);
        this.nowSelectCatalog.getSubHibersCollection().addObject(activeIndex, (IObjectValue)newPoint);
        row.setUserObject((Object)newPoint);
        this.isChanged = true;
    }

    @Override
    protected void btnRemovePoint_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemovePoint_actionPerformed(e);
        int activeIndex = this.kdPointTable.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        IRow row = this.kdPointTable.getRow(activeIndex);
        SalariatHiberPropsInfo pointInfo = (SalariatHiberPropsInfo)row.getUserObject();
        this.nowSelectCatalog.getSubHibersCollection().remove(pointInfo);
        this.lstName.remove(pointInfo.getName());
        this.kdPointTable.removeRow(activeIndex);
        this.isChanged = true;
    }

    private void showDialog(String strUI, Map map, String status) throws Exception {
        map.put("Owner", this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(strUI, map, null, status);
            curDialog.show();
        }
        catch (UIException ex1) {
            logger.error((Object)ex1.getMessage());
        }
    }

    private UIContext getHashMap(UIContext uiContext) throws Exception {
        DefaultKingdeeTreeNode node = HRUtils.getSelectTreeNode(this.kdCatalogTree);
        if (node != null) {
            if (node.getUserObject() instanceof SalariatHiberPropsInfo) {
                uiContext.put((Object)"selectNodeObject", (Object)((SalariatHiberPropsInfo)node.getUserObject()));
            }
            uiContext.put((Object)"selectNode", (Object)node);
        }
        uiContext.put((Object)"tree", (Object)this.kdCatalogTree);
        uiContext.put((Object)"root", (Object)this.rootNode);
        return uiContext;
    }

    @Override
    public void actionInputData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getImportParam(), 0, true);
        this.onLoad();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.compensation.SalariatSchPoint";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.SalariatResource.TITLE");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    class LineEditAdapter
    extends KDTEditAdapter {
        private Object oldValue;

        LineEditAdapter() {
        }

        public void editStarting(KDTEditEvent evt) {
            super.editStarting(evt);
            KDTable table = (KDTable)evt.getSource();
            this.oldValue = table.getRow(evt.getRowIndex()).getCell(evt.getColIndex()).getValue();
        }

        public void editStopped(KDTEditEvent evt) {
            super.editStopped(evt);
            KDTable table = (KDTable)evt.getSource();
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            Object newValue = evt.getValue();
            IRow row = table.getRow(rowIndex);
            ICell cell = row.getCell(colIndex);
            SalariatHiberPropsInfo pointInfo = (SalariatHiberPropsInfo)row.getUserObject();
            switch (colIndex) {
                case 1: {
                    String newName = (String)newValue;
                    String oldName = (String)this.oldValue;
                    if (newName == null || newName.equals(oldName)) break;
                    try {
                        if (SalariatSchPointListUI.this.lstName.contains(newName)) {
                            SalariatSchPointListUI.this.handUIException((Throwable)((Object)new SalariatException(SalariatException.MULTI_POINT_NAME)));
                            cell.setValue((Object)oldName);
                            table.getSelectManager().removeAll(false);
                            table.getEditManager().editCellAt(rowIndex, colIndex);
                            break;
                        }
                        cell.setValue((Object)newName);
                        pointInfo.setName(newName);
                        pointInfo.setString("name_l1", newName);
                        pointInfo.setString("name_l2", newName);
                        pointInfo.setString("name_l3", newName);
                        SalariatSchPointListUI.this.lstName.remove(oldName);
                        SalariatSchPointListUI.this.lstName.add(newName);
                        SalariatSchPointListUI.this.isChanged = true;
                    }
                    catch (Exception ex) {
                        SalariatSchPointListUI.this.handUIException(ex);
                    }
                    break;
                }
            }
        }
    }
}

