/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.AbstractListUI;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ColumnMetasInfo;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatPointPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatPointPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchemeListUI;
import com.kingdee.eas.hr.compensation.client.FixSchemeInitUI;
import com.kingdee.eas.hr.compensation.client.HRDynQueryEditUI;
import com.kingdee.eas.hr.compensation.client.SalariatPointSalariatGradeListUI;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.ToolsTableMetas;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class SalariatSchemeListUI
extends AbstractSalariatSchemeListUI {
    private static Logger logger = Logger.getLogger(SalariatSchemeListUI.class);
    private static final String COL_STATE = "state";
    private String formatString = "yyyy-m-d";
    String resClass = "com.kingdee.eas.hr.compensation.client.SalariatResource.";
    boolean isEnable = HRUtils.getParamValue(null, "hr_cmp_011", null);

    public SalariatSchemeListUI() throws Exception {
        HRSchemeUtils.checkInit();
        this.jbInit();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    private void jbInit() throws Exception {
        this.tblMain.addKDTActiveCellListener((KDTActiveCellListener)new LineSwitchListener());
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionQuery.setEnabled(false);
        this.btnQuery.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.tblMain.setColumnMoveable(true);
        ResourceBundleHelper helper = new ResourceBundleHelper(AbstractListUI.class.getName());
        this.menuItemCancel.setText(helper.getString("menuItemCancel.text"));
        this.menuItemCancel.setToolTipText(helper.getString("menuItemCancel.toolTipText"));
        this.menuItemCancel.setMnemonic(67);
        this.menuItemCancelCancel.setText(helper.getString("menuItemCancelCancel.text"));
        this.menuItemCancelCancel.setToolTipText(helper.getString("menuItemCancelCancel.toolTipText"));
        this.menuItemCancelCancel.setMnemonic(83);
        this.menuItemSalaryPoint.setIcon(EASResource.getIcon((String)"imgTbtn_stipenddot"));
        this.menuItemSalaryLevel.setIcon(EASResource.getIcon((String)"imgTbtn_stipendgrade"));
        this.btnItemMapping.setIcon(EASResource.getIcon((String)"imgTbtn_uniterangemaintenance"));
        this.menuItemPointGrade.setIcon(EASResource.getIcon((String)"imgTbtn_trusteeship"));
        this.menuItemItemMapping.setIcon(EASResource.getIcon((String)"imgTbtn_uniterangemaintenance"));
        this.menuItemCopyScheme.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuItemInitFixedScheme.setIcon(EASResource.getIcon((String)"imgTbtn_initialize"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.tblMain.getColumn("createTime").setSortable(false);
        if (this.isEnable) {
            this.actionPointGradeTable.setEnabled(true);
            this.actionPointTable.setEnabled(false);
            this.actionPointMap.setEnabled(false);
        } else {
            this.actionPointGradeTable.setEnabled(false);
            this.actionPointTable.setEnabled(true);
            this.actionPointMap.setEnabled(true);
        }
        CmpDateUtils.setColumnDateFormat(this.tblMain, new String[]{"createTime", "enableDate", "disableDate"});
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.hr.compensation.client.SalariatSchNewEditUI";
    }

    protected String getWizardUIName() {
        return "com.kingdee.eas.hr.compensation.client.SalariatSchWizardUI";
    }

    protected String getPointTableUIName() {
        return "com.kingdee.eas.hr.compensation.client.SalariatPointTableUI";
    }

    protected String getPointGradeTableUIName() {
        return "com.kingdee.eas.hr.compensation.client.SalariatPointGradeTableUI";
    }

    protected String getStateFieldName() {
        return COL_STATE;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SalariatSchemeFactory.getRemoteInstance();
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnAddNew);
        this.toolBar.add((Component)this.btnView);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnRemove);
        this.toolBar.add((Component)this.btnRefresh);
        this.toolBar.add((Component)this.btnLocate);
        this.toolBar.add((Component)this.btnQuery);
        this.toolBar.add((Component)this.barSeparator2);
        this.toolBar.add((Component)this.btnPrint);
        this.toolBar.add((Component)this.btnPrintPreview);
        this.toolBar.add((Component)this.btnPageSetup);
        this.toolBar.add((Component)this.barSeparator1);
        this.toolBar.add((Component)this.btnCopyScheme);
        this.toolBar.add((Component)this.btnEnabledScheme);
        this.toolBar.add((Component)this.btnDisableScheme);
        this.toolBar.add((Component)this.separatorFW2);
        this.toolBar.add((Component)this.btnPointTable);
        this.toolBar.add((Component)this.btnPointMap);
        this.toolBar.add((Component)this.btnPointGrade);
        this.toolBar.add((Component)this.btnItemMapping);
        this.toolBar.add((Component)this.barSeparator2);
        this.toolBar.add((Component)this.btnInitFixedScheme);
        this.btnEnabledScheme.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnPointTable.setIcon(EASResource.getIcon((String)"imgTbtn_stipenddot"));
        this.btnPointMap.setIcon(EASResource.getIcon((String)"imgTbtn_stipendgrade"));
        this.btnPointGrade.setIcon(EASResource.getIcon((String)"imgTbtn_trusteeship"));
        this.btnDisableScheme.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
    }

    private void checkEnableNumber() throws BOSException {
        String oql;
        ISalariatScheme iss = SalariatSchemeFactory.getRemoteInstance();
        if (iss.getCollection(oql = "select state where state = 1 and " + this.gethrOrgFilter()).size() > 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.ONLY_ENABLE_ONESALARIAT)));
            SysUtil.abort();
        }
    }

    private String gethrOrgFilter() {
        String hrOrgUnitId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        return "hrOrgUnit.id = '" + hrOrgUnitId + "'";
    }

    private boolean checkRelatedTable(SalariatSchemeInfo ssinfo) {
        return ssinfo.getPointTableName() != null && ssinfo.getGradeTableName() != null;
    }

    private void disableScheme(String schemeId) throws Exception {
        ObjectUuidPK pk;
        ISalariatScheme iss = SalariatSchemeFactory.getRemoteInstance();
        SalariatSchemeInfo ssinfo = (SalariatSchemeInfo)iss.getValue((IObjectPK)(pk = new ObjectUuidPK(BOSUuid.read((String)schemeId))));
        if (StateEnum.DISABLE.equals((Object)ssinfo.getState())) {
            return;
        }
        IObjectPK logPK = LogUtil.beginLog(null, (String)EASResource.getString((String)(this.resClass + "LOG_SALARIAL_DISABLE")), (BOSObjectType)ssinfo.getBOSType(), (IObjectPK)pk, (String)ssinfo.getName(), (String)"salaritsch_disable");
        ssinfo.setState(StateEnum.DISABLE);
        ssinfo.setDisableDate(new Date());
        iss.updateState((IObjectPK)pk, ssinfo);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.actionRefresh_actionPerformed(null);
    }

    private void checkAdjustBillStatus() throws Exception {
        BizEnumValueInfo enable = (BizEnumValueInfo)HRTableTools.getTableSelectCellValue(this.tblMain, this.getStateFieldName());
        if (enable == null || enable.getInt() == 0) {
            return;
        }
        String sql = "select count(*) as Fnumber from t_hr_adjscheme where fadjschemestate = 20 and fhrorgunitid = '" + HRSchemeUtils.getClientHROrgUnitInfo().getId().toString() + "'";
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = executor.executeSQL();
        if (!rs.next() || rs.getInt(1) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.SalariatResource", (String)"CANNT_DISABLE"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionDisableScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisableScheme_actionPerformed(e);
        this.checkSelected();
        this.checkAdjustBillStatus();
        String schemeId = this.getSelectedKeyValue();
        this.disableScheme(schemeId);
    }

    @Override
    public void actionEnabledScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionEnabledScheme_actionPerformed(e);
        this.checkSelected();
        this.checkEnableNumber();
        int result = MsgBox.showConfirm2((String)HRUtils.getSalariatResourceStr("ENABLED_SCHEME"));
        if (result == 0) {
            String createGradeTableSQL;
            String createPointTableSQL;
            boolean isCreateTable;
            String schemeID = this.getSelectedKeyValue();
            ISalariatScheme iBiz = (ISalariatScheme)this.getBizInterface();
            ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)schemeID));
            SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)iBiz.getValue((IObjectPK)schemePK);
            IObjectPK logPK = LogUtil.beginLog(null, (String)EASResource.getString((String)(this.resClass + "LOG_SALARIAL_ENABLE")), (BOSObjectType)schemeInfo.getBOSType(), (IObjectPK)schemePK, (String)schemeInfo.getName(), (String)"salaritsch_enable");
            if (StateEnum.ENABLE.equals((Object)schemeInfo.getState())) {
                LogUtil.afterLog(null, (IObjectPK)logPK);
                return;
            }
            if (this.checkRelatedTable(schemeInfo)) {
                schemeInfo.setState(StateEnum.ENABLE);
                schemeInfo.setEnableDate(new Date());
                iBiz.updateState((IObjectPK)schemePK, schemeInfo);
                LogUtil.afterLog(null, (IObjectPK)logPK);
                this.actionRefresh_actionPerformed(null);
                return;
            }
            Map tableName = SalariatSchemeFacadeFactory.getRemoteInstance().getDynTableName();
            String pointTableName = (String)tableName.get("pointTableName");
            String gradeTableName = (String)tableName.get("gradeTableName");
            CmpItemCollection cmpItems = HRUtils.getCmpItemsByScheme(schemeID);
            CmpItemCollection personItems = HRUtils.getPersonItemsByScheme(schemeID);
            SalariatPointPropsCollection pointGrades = HRUtils.getPointGradeItemsByScheme(schemeID);
            int pointTableColumnSize = cmpItems.size() + 1;
            int gradeTableColumnSize = pointGrades.size() + 1 + personItems.size();
            if (this.isEnable) {
                ++pointTableColumnSize;
                ++gradeTableColumnSize;
            }
            ColumnMetasInfo[] pointTableMetas = new ColumnMetasInfo[pointTableColumnSize];
            pointTableMetas[0] = this.getPointColumnMetasInfo();
            int i = 0;
            int j = 1;
            while (i < cmpItems.size()) {
                pointTableMetas[j] = this.getColumnMetasInfoByItem(cmpItems.get(i));
                ++i;
                ++j;
            }
            if (this.isEnable) {
                pointTableMetas[pointTableColumnSize - 1] = this.getColumnMetasInfoBySalPointSalGrade();
            }
            ColumnMetasInfo[] gradeTableMetas = new ColumnMetasInfo[gradeTableColumnSize];
            gradeTableMetas[0] = this.getPersonMapColumnMetasInfo();
            int i2 = 0;
            int m = 1;
            while (i2 < pointGrades.size()) {
                gradeTableMetas[m] = this.getColumnMetasInfoByPointGrade(pointGrades.get(i2), i2);
                ++i2;
                ++m;
            }
            i2 = 0;
            m = 1;
            while (i2 < personItems.size()) {
                gradeTableMetas[pointGrades.size() + m] = this.getColumnMetasInfoByItem(personItems.get(i2));
                ++i2;
                ++m;
            }
            if (this.isEnable) {
                gradeTableMetas[gradeTableColumnSize - 1] = this.getColumnMetasInfoBySalPointSalGrade();
            }
            if (isCreateTable = iBiz.createDynTable(createPointTableSQL = ToolsTableMetas.createTable(pointTableName, pointTableMetas, null), createGradeTableSQL = ToolsTableMetas.createTable(gradeTableName, gradeTableMetas, null))) {
                schemeInfo.setPointTableName(pointTableName);
                schemeInfo.setGradeTableName(gradeTableName);
                schemeInfo.setState(StateEnum.ENABLE);
                schemeInfo.setEnableDate(new Date());
                iBiz.updateState((IObjectPK)schemePK, schemeInfo);
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
        }
        this.actionRefresh_actionPerformed(null);
    }

    private ColumnMetasInfo getColumnMetasInfoByItem(CmpItemInfo itemInfo) {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName(itemInfo.getNumber());
        metaInfo.setDataType(HRSchemeUtils.getDataType(itemInfo.getDataType().getValue()));
        if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY)) {
            metaInfo.setPrecision(17);
            metaInfo.setScale(4);
            metaInfo.setLength(17);
            metaInfo.defaultValueExpr = SqlExpr.toExpr((int)0);
        } else if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
            metaInfo.setPrecision(21);
            metaInfo.setScale(8);
            metaInfo.setLength(21);
            metaInfo.defaultValueExpr = SqlExpr.toExpr((int)0);
        } else if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.INT)) {
            metaInfo.setLength(9);
            metaInfo.setPrecision(itemInfo.getLength());
            metaInfo.setScale(itemInfo.getDecDigital());
            metaInfo.defaultValueExpr = SqlExpr.toExpr((int)0);
        } else {
            metaInfo.setPrecision(itemInfo.getLength());
            metaInfo.setScale(itemInfo.getDecDigital());
            metaInfo.setLength(itemInfo.getLength());
        }
        metaInfo.setAllowNull(Boolean.TRUE);
        return metaInfo;
    }

    private ColumnMetasInfo getColumnMetasInfoByPointGrade(SalariatPointPropsInfo gradeInfo, int index) {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName("FPointID_" + index);
        metaInfo.setDataType(HRTableTools.getIDDataType());
        metaInfo.setLength(HRTableTools.getIDLength());
        metaInfo.setPrecision(HRTableTools.getIDPrecision());
        metaInfo.setAllowNull(Boolean.TRUE);
        return metaInfo;
    }

    private ColumnMetasInfo getColumnMetasInfoBySalPointSalGrade() {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName("FSalPointSalGradeID");
        metaInfo.setDataType(HRTableTools.getIDDataType());
        metaInfo.setLength(HRTableTools.getIDLength());
        metaInfo.setPrecision(HRTableTools.getIDPrecision());
        metaInfo.setAllowNull(Boolean.TRUE);
        return metaInfo;
    }

    private ColumnMetasInfo getKeyColumnMetasInfo() {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName("FID");
        metaInfo.setDataType(HRTableTools.getIDDataType());
        metaInfo.setLength(HRTableTools.getIDLength());
        metaInfo.setPrecision(HRTableTools.getIDPrecision());
        metaInfo.setAllowNull(Boolean.TRUE);
        return metaInfo;
    }

    private ColumnMetasInfo getPointColumnMetasInfo() {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName("FPointID");
        metaInfo.setDataType(HRTableTools.getIDDataType());
        metaInfo.setLength(HRTableTools.getIDLength());
        metaInfo.setPrecision(HRTableTools.getIDPrecision());
        metaInfo.setAllowNull(Boolean.TRUE);
        return metaInfo;
    }

    private ColumnMetasInfo getPersonMapColumnMetasInfo() {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName("FPersonMapID");
        metaInfo.setDataType(HRTableTools.getIDDataType());
        metaInfo.setLength(HRTableTools.getIDLength());
        metaInfo.setPrecision(HRTableTools.getIDPrecision());
        metaInfo.setAllowNull(Boolean.TRUE);
        return metaInfo;
    }

    @Override
    public void actionPointMap_actionPerformed(ActionEvent e) throws Exception {
        super.actionPointMap_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getPointGradeTableUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionPointTable_actionPerformed(ActionEvent e) throws Exception {
        super.actionPointTable_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getPointTableUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private boolean checkHasBeenUsed(String salSchemeID) throws Exception {
        String sql = "select top 1 * from T_HR_FixedCmpScheme where FSalariatScheme = '" + salSchemeID + "'";
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = executor.executeSQL();
        return rs.next();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        return filter;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean initDefaultFilter() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo(COL_STATE);
        sorterOrderItem1.setSortType(SortType.DESCEND);
        this.mainQuery.getSorter().add(sorterOrderItem1);
        SorterItemInfo sorterOrderItem2 = new SorterItemInfo("id");
        sorterOrderItem2.setSortType(SortType.ASCEND);
        this.mainQuery.getSorter().add(sorterOrderItem2);
        return false;
    }

    @Override
    public void actionItemMapping_actionPerformed(ActionEvent e) throws Exception {
        super.actionItemMapping_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"parentUIName", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"queryFullName", (Object)"com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery");
        String hroId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        ISQLExecutor iSQLExec = SQLExecutorFactory.getRemoteInstance((String)("SELECT FDynSolutionID FROM T_HR_CmpitemDynquery WHERE FType = 2 AND FHROrgUnitID='" + hroId + "'"));
        String dynQueryId = null;
        IRowSet rows = iSQLExec.executeSQL();
        while (rows.next()) {
            dynQueryId = rows.getString(1);
        }
        uiContext.put((Object)"DYNQUERY_HRO", (Object)hroId);
        if (dynQueryId != null) {
            uiContext.put((Object)"ID", (Object)dynQueryId);
        } else {
            uiContext.put((Object)"DYNQUERY_TYPE", (Object)2);
        }
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = null;
        curDialog = dynQueryId == null ? uiFactory.create(HRDynQueryEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW) : uiFactory.create(HRDynQueryEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        curDialog.show();
    }

    @Override
    public void actionCopyScheme_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            Object id = HRTableTools.getTableSelectCellValue(this.tblMain, "id");
            if (id != null) {
                ISalariatScheme iBiz = (ISalariatScheme)this.getBizInterface();
                iBiz.copySalScheme((IObjectPK)new ObjectUuidPK(id.toString()));
            }
            this.refresh(e);
        }
    }

    @Override
    public void actionInitFixedScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionInitFixedScheme_actionPerformed(e);
        this.checkSelected();
        String salSchmID = this.getSelectedKeyValue();
        ISalariatScheme iBiz = (ISalariatScheme)this.getBizInterface();
        if (iBiz.hasInitFixedScheme(salSchmID)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"599_SalariatSchemeListUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"SalSchmInfoID", (Object)salSchmID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FixSchemeInitUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionPointGradeTable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"salariatSchemeID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(SalariatPointSalariatGradeListUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    class LineSwitchListener
    implements KDTActiveCellListener {
        LineSwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent evt) {
            int selectRowIndex = evt.getRowIndex();
            if (selectRowIndex == -1) {
                return;
            }
            KDTSelectBlock selectBlock = SalariatSchemeListUI.this.tblMain.getSelectManager().get();
            if (selectBlock != null) {
                int rowIndex = selectBlock.getTop();
                IRow row = SalariatSchemeListUI.this.tblMain.getRow(rowIndex);
                String salSchemeID = (String)row.getCell("id").getValue();
                ICell cell = row.getCell(SalariatSchemeListUI.this.getStateFieldName());
                Object stateValue = cell.getValue();
                if (stateValue != null && stateValue instanceof BizEnumValueDTO) {
                    BizEnumValueDTO intSatet = (BizEnumValueDTO)stateValue;
                    if ("1".equals(intSatet.getValue())) {
                        SalariatSchemeListUI.this.btnEdit.setEnabled(true);
                        SalariatSchemeListUI.this.actionEdit.setEnabled(true);
                        SalariatSchemeListUI.this.btnEnabledScheme.setEnabled(false);
                        SalariatSchemeListUI.this.menuItemCancelCancel.setEnabled(false);
                        SalariatSchemeListUI.this.actionEnabledScheme.setEnabled(false);
                        SalariatSchemeListUI.this.btnDisableScheme.setEnabled(true);
                        SalariatSchemeListUI.this.actionDisableScheme.setEnabled(true);
                        SalariatSchemeListUI.this.menuItemCancel.setEnabled(true);
                        SalariatSchemeListUI.this.btnInitFixedScheme.setEnabled(true);
                        SalariatSchemeListUI.this.menuItemInitFixedScheme.setEnabled(true);
                        SalariatSchemeListUI.this.actionRemove.setEnabled(false);
                        if (SalariatSchemeListUI.this.isEnable) {
                            SalariatSchemeListUI.this.actionPointGradeTable.setEnabled(true);
                        }
                    } else {
                        block12: {
                            if (SalariatSchemeListUI.this.isEnable) {
                                SalariatSchemeListUI.this.actionPointGradeTable.setEnabled(false);
                            }
                            SalariatSchemeListUI.this.btnEdit.setEnabled(true);
                            SalariatSchemeListUI.this.actionEdit.setEnabled(true);
                            SalariatSchemeListUI.this.actionEnabledScheme.setEnabled(true);
                            SalariatSchemeListUI.this.menuItemCancelCancel.setEnabled(true);
                            SalariatSchemeListUI.this.btnEnabledScheme.setEnabled(true);
                            if ("3".equals(intSatet.getValue())) {
                                SalariatSchemeListUI.this.actionDisableScheme.setEnabled(false);
                                SalariatSchemeListUI.this.btnDisableScheme.setEnabled(false);
                                SalariatSchemeListUI.this.menuItemCancel.setEnabled(false);
                                try {
                                    if (SalariatSchemeListUI.this.checkHasBeenUsed(salSchemeID)) {
                                        SalariatSchemeListUI.this.actionRemove.setEnabled(false);
                                        break block12;
                                    }
                                    SalariatSchemeListUI.this.actionRemove.setEnabled(true);
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage());
                                }
                            } else {
                                SalariatSchemeListUI.this.actionDisableScheme.setEnabled(true);
                                SalariatSchemeListUI.this.btnDisableScheme.setEnabled(true);
                                SalariatSchemeListUI.this.menuItemCancel.setEnabled(true);
                                SalariatSchemeListUI.this.actionRemove.setEnabled(true);
                            }
                        }
                        SalariatSchemeListUI.this.btnInitFixedScheme.setEnabled(false);
                        SalariatSchemeListUI.this.menuItemInitFixedScheme.setEnabled(false);
                    }
                }
            }
        }
    }
}

