/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.EmailShowTypeEnum;
import com.kingdee.eas.hr.compensation.ISalaryEMailFormat;
import com.kingdee.eas.hr.compensation.SalaryEMailFormatFactory;
import com.kingdee.eas.hr.compensation.SalaryEMailFormatInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalaryEMailSendUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class SalaryEMailSendUI
extends AbstractSalaryEMailSendUI {
    private static final Logger logger = CoreUIObject.getLogger(SalaryEMailSendUI.class);
    private final ISalaryEMailFormat salaryEMailFormat = SalaryEMailFormatFactory.getRemoteInstance();
    private SalaryEMailFormatInfo salaryEMailFormatInfo = null;
    private final String res = "com.kingdee.eas.hr.compensation.SalaryMailResource.";
    private String tempQueryInfoURL = "com.kingdee.eas.hr.compensation.app.SalaryEmailFormatQuery";
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_DEL = "DELETE";
    public static final String STATUS_VIEW = "VIEW";
    private String[] curAttachIds = null;
    private File theFile = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadInitData();
        this.prmtSalaryEmailTemplate.setEditable(false);
        this.initAllEditor();
        this.salaryEMailFormatInfo = (SalaryEMailFormatInfo)this.prmtSalaryEmailTemplate.getData();
        if (this.salaryEMailFormatInfo != null && this.salaryEMailFormatInfo.getId() != null) {
            this.initAttach(this.salaryEMailFormatInfo.getId().toString());
        }
    }

    private void initAllEditor() throws Exception {
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnSaveSnap.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.prmtSalaryEmailTemplate.setQueryInfo(this.tempQueryInfoURL);
        this.prmtSalaryEmailTemplate.setEditFormat("$subject$");
        this.prmtSalaryEmailTemplate.setDisplayFormat("$subject$");
        FilterInfo filterInfoTemplate = new FilterInfo();
        filterInfoTemplate.getFilterItems().add(new FilterItemInfo("currentUserId", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo eviTemplate = new EntityViewInfo();
        eviTemplate.setFilter(filterInfoTemplate);
        this.prmtSalaryEmailTemplate.setEntityViewInfo(eviTemplate);
        this.setButtonDefaultStyl(this.btnAddNew);
        this.setButtonDefaultStyl(this.btnSaveSnap);
        this.setButtonDefaultStyl(this.btnDelete);
    }

    private void loadInitData() throws BOSException, EASBizException {
        this.salaryEMailFormatInfo = this.salaryEMailFormat.selectDefaultSalaryEmailFormat();
        if (this.salaryEMailFormatInfo == null || this.salaryEMailFormatInfo.isEmpty()) {
            this.clearAllData();
            this.setOprtState(STATUS_ADDNEW);
        } else {
            this.showData(this.salaryEMailFormatInfo);
            this.setOprtState(STATUS_EDIT);
        }
    }

    private void showData(SalaryEMailFormatInfo salaryEMailFormatInfo) {
        if (salaryEMailFormatInfo != null && !salaryEMailFormatInfo.isEmpty()) {
            if (salaryEMailFormatInfo.isIsDefault()) {
                this.prmtSalaryEmailTemplate.setData((Object)salaryEMailFormatInfo);
                this.prmtSalaryEmailTemplate.setEditFormat("$subject$");
                this.prmtSalaryEmailTemplate.setDisplayFormat("$subject$");
            }
            this.chkUseTemplate.setSelected(true);
            this.txtSubject.setText(salaryEMailFormatInfo.getSubject());
            this.txtStart.setText(salaryEMailFormatInfo.getStartText());
            this.txtEnd.setText(salaryEMailFormatInfo.getEndText());
            this.chkZeroNotDisp.setSelected(salaryEMailFormatInfo.isIsDisplayZeroItem());
            this.combShowType.setSelectedItem((Object)salaryEMailFormatInfo.getShowType());
            this.chkUseExcel.setSelected(salaryEMailFormatInfo.isIsUseExcelTemplate());
            this.chkSendForAttch.setSelected(salaryEMailFormatInfo.isIsSendAttachment());
        }
    }

    @Override
    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkPass()) {
            return;
        }
        this.saveEMailFormat();
        this.sendMail();
        this.actionExitCurrent_actionPerformed(null);
    }

    private void sendMail() {
        final List cmpItemLst = (List)this.getUIContext().get("cmpItem_list");
        final Map salaryMap = (Map)this.getUIContext().get("salary_data");
        CmpPeriodInfo cmpPeriod = (CmpPeriodInfo)this.getUIContext().get("salary_cmpPeriod");
        this.salaryEMailFormatInfo.setString("cmpPeriodInfoDate", cmpPeriod.getName());
        String schemeID = (String)this.getUIContext().get("salary_cmpScheme");
        Integer time = (Integer)this.getUIContext().get("salary_beginTime");
        HashSet personSet = new HashSet();
        final HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (this.isUseExcelTemplate() && this.curAttachIds != null && this.curAttachIds.length > 0) {
            Iterator iter = salaryMap.keySet().iterator();
            while (iter.hasNext()) {
                personSet.add(iter.next());
            }
            paramsMap.put("salary_cmpScheme", schemeID);
            paramsMap.put("salary_beginTime", time);
            paramsMap.put("salary_cmpPeriod", cmpPeriod);
            paramsMap.put("personlist", personSet);
            paramsMap.put("salary_AttachmentID", this.curAttachIds[0]);
        }
        final HashSet isErrorSet = new HashSet();
        GetDataDialog dlg = new GetDataDialog((Dialog)((UIModelDialog)SwingUtilities.getWindowAncestor((Component)((Object)this))));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                List retLst = null;
                try {
                    retLst = SalaryEMailSendUI.this.isUseExcelTemplate() ? SalaryEMailSendUI.this.salaryEMailFormat.sendSalaryMail(cmpItemLst, paramsMap, SalaryEMailSendUI.this.salaryEMailFormatInfo) : SalaryEMailSendUI.this.salaryEMailFormat.sendSalaryMail(cmpItemLst, salaryMap, SalaryEMailSendUI.this.salaryEMailFormatInfo);
                    SalaryEMailSendUI.this.showSendMainRetInfo(retLst);
                }
                catch (Exception e) {
                    isErrorSet.add("isError");
                    SalaryEMailSendUI.this.handUIExceptionAndAbort(e);
                }
                return null;
            }
        });
        dlg.show();
        if (isErrorSet.contains("isError")) {
            SysUtil.abort();
        }
    }

    private void showSendMainRetInfo(List lst) throws Exception {
        Set errorPerson = (Set)lst.get(0);
        if (errorPerson == null || errorPerson.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.SalaryMailResource.SENDALL_SUCCFUL"));
            return;
        }
        this.showErrorList(errorPerson);
    }

    private void showErrorList(Set errorPerson) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"personlist", (Object)errorPerson);
        uiContext.put((Object)"salary_data", this.getUIContext().get("salary_data"));
        uiContext.put((Object)"salary_cmpPeriod", this.getUIContext().get("salary_cmpPeriod"));
        uiContext.put((Object)"salary_cmpScheme", this.getUIContext().get("salary_cmpScheme"));
        uiContext.put((Object)"salary_beginTime", this.getUIContext().get("salary_beginTime"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.compensation.client.SalarySendMailErrorPersonUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.actionExitCurrent_actionPerformed(null);
    }

    private void saveEMailFormat() throws EASBizException, BOSException {
        if (this.salaryEMailFormatInfo == null) {
            this.salaryEMailFormatInfo = new SalaryEMailFormatInfo();
        }
        this.salaryEMailFormatInfo.setSubject(this.txtSubject.getText());
        this.salaryEMailFormatInfo.setStartText(this.convertToDB(this.txtStart.getText()));
        this.salaryEMailFormatInfo.setEndText(this.convertToDB(this.txtEnd.getText()));
        this.salaryEMailFormatInfo.setIsDisplayZeroItem(this.chkZeroNotDisp.isSelected());
        this.salaryEMailFormatInfo.setShowType((EmailShowTypeEnum)((Object)this.combShowType.getSelectedItem()));
        this.salaryEMailFormatInfo.setIsUseExcelTemplate(this.isUseExcelTemplate());
        this.salaryEMailFormatInfo.setIsSendAttachment(this.chkSendForAttch.isSelected());
    }

    private String convertToDB(String str) {
        str = str.replaceAll("\n", "<br>");
        return str;
    }

    private String convertToUI(String str) {
        str = str.replaceAll("<br>", "\n");
        return str;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        int opeResult = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.SalaryMailResource.IS_ADDNEW"));
        if (opeResult == 0) {
            this.salaryEMailFormatInfo = null;
            this.clearAllData();
            this.setOprtState(STATUS_ADDNEW);
        }
    }

    @Override
    public void actionDeleteTemplate_actionPerformed(ActionEvent e) throws Exception {
        int opeResult;
        super.actionDeleteTemplate_actionPerformed(e);
        if (this.txtSubject != null && this.getOprtState().equals(STATUS_EDIT) && (opeResult = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.SalaryMailResource.IS_DELETE"))) == 0) {
            this.salaryEMailFormat.deleteSalaryEmail(this.salaryEMailFormatInfo.getId().toString());
            this.salaryEMailFormatInfo = null;
            this.clearAllData();
            this.setOprtState(STATUS_ADDNEW);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.SalaryMailResource.DELETE_SUCCESS"));
        }
    }

    private SalaryEMailFormatInfo setSalaryEmailFormatInfo() {
        SalaryEMailFormatInfo sef = new SalaryEMailFormatInfo();
        sef.setStartText(this.txtStart.getText().toString());
        sef.setEndText(this.txtEnd.getText().toString());
        sef.setSubject(this.txtSubject.getText().toString());
        sef.setIsDisplayZeroItem(this.chkZeroNotDisp.isSelected());
        sef.setShowType((EmailShowTypeEnum)((Object)this.combShowType.getSelectedItem()));
        sef.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        sef.setCurrentUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        sef.setIsDefault(this.chkUseTemplate.isSelected());
        sef.setIsUseExcelTemplate(this.isUseExcelTemplate());
        sef.setIsSendAttachment(this.chkSendForAttch.isSelected());
        return sef;
    }

    @Override
    public void actionSaveTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.actionSaveTemplate_actionPerformed(e);
        this.verifyBeforeSave();
        SimpleAttachmentInfo saInfo = this.getAttachmentInfo();
        SalaryEMailFormatInfo salaryEmail = this.setSalaryEmailFormatInfo();
        if (this.getOprtState().equals(STATUS_ADDNEW)) {
            String fid = this.salaryEMailFormat.addNew(salaryEmail, saInfo, this.curAttachIds);
            salaryEmail.setId(BOSUuid.read((String)fid));
            this.setOprtState(STATUS_EDIT);
            this.setF7Value(salaryEmail);
        } else if (this.getOprtState().equals(STATUS_EDIT)) {
            int opeResult = -1;
            if (!this.salaryEMailFormatInfo.getSubject().equals(this.txtSubject.getText().toString())) {
                opeResult = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"601_SalaryEMailSendUI"));
            }
            if (opeResult == 0) {
                if (this.salaryEMailFormat.isSubjectExist(this.txtSubject.getText().toString())) {
                    HRUtils.msgBoxInfo("com.kingdee.eas.hr.compensation.SalaryMailResource.TITLE_IS_SAMENESS", true);
                }
                String fid = this.salaryEMailFormat.addNew(salaryEmail, saInfo, this.curAttachIds);
                salaryEmail.setId(BOSUuid.read((String)fid));
                this.setOprtState(STATUS_EDIT);
                this.setF7Value(salaryEmail);
            } else if (opeResult == 1) {
                if (this.salaryEMailFormat.isSubjectExist(this.txtSubject.getText().toString())) {
                    HRUtils.msgBoxInfo("com.kingdee.eas.hr.compensation.SalaryMailResource.TITLE_IS_SAMENESS", true);
                }
                this.salaryEMailFormat.updateSalaryEmail(this.salaryEMailFormatInfo.getId().toString(), salaryEmail, saInfo, this.curAttachIds);
                salaryEmail.setId(this.salaryEMailFormatInfo.getId());
                this.salaryEMailFormat.deleteSalaryEmail(this.salaryEMailFormatInfo.getId().toString());
                this.setF7Value(salaryEmail);
            } else if (opeResult == -1) {
                this.salaryEMailFormat.updateSalaryEmail(this.salaryEMailFormatInfo.getId().toString(), salaryEmail, saInfo, this.curAttachIds);
                salaryEmail.setId(this.salaryEMailFormatInfo.getId());
                this.setF7Value(salaryEmail);
            }
        }
    }

    private void setF7Value(SalaryEMailFormatInfo salaryEmail) throws EASBizException, BOSException {
        this.salaryEMailFormatInfo = this.salaryEMailFormat.selectDefaultSalaryEmailFormat();
        this.showData(this.salaryEMailFormatInfo);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.SalaryMailResource.SAVE_SUCCESS"));
    }

    private void verifyBeforeSave() throws EASBizException, BOSException {
        if (this.getOprtState().equals(STATUS_ADDNEW)) {
            this.salaryEMailFormatInfo = new SalaryEMailFormatInfo();
            if (this.salaryEMailFormat.isSubjectExist(this.txtSubject.getText().toString())) {
                HRUtils.msgBoxInfo("com.kingdee.eas.hr.compensation.SalaryMailResource.TITLE_IS_SAMENESS", true);
            }
        }
        if (this.txtSubject.getText().length() <= 0) {
            HRUtils.msgBoxInfo("com.kingdee.eas.hr.compensation.SalaryMailResource.MISS_TITLE_INPUT", true);
        }
        if (this.txtStart.getText() == null || "".equals(this.txtStart.getText()) || this.txtStart.getText().trim().indexOf("#NAME#") < 0) {
            HRUtils.msgBoxInfo("com.kingdee.eas.hr.compensation.SalaryMailResource.START_LAGUAGE", true);
        }
    }

    protected void initListener() {
        super.initListener();
        this.prmtSalaryEmailTemplate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    Object obj = SalaryEMailSendUI.this.prmtSalaryEmailTemplate.getData();
                    if (obj == null) {
                        SalaryEMailSendUI.this.clearAllData();
                        SalaryEMailSendUI.this.setOprtState(SalaryEMailSendUI.STATUS_ADDNEW);
                        return;
                    }
                    SalaryEMailSendUI.this.salaryEMailFormat.updateDefaultValue(SalaryEMailSendUI.this.prmtSalaryEmailTemplate.getText().toString());
                    SalaryEMailSendUI.this.setOprtState(SalaryEMailSendUI.STATUS_EDIT);
                    SalaryEMailSendUI.this.salaryEMailFormatInfo = (SalaryEMailFormatInfo)obj;
                    SalaryEMailSendUI.this.salaryEMailFormatInfo.setIsDefault(true);
                    SalaryEMailSendUI.this.loadDateToTemplate(SalaryEMailSendUI.this.salaryEMailFormatInfo);
                }
                catch (Exception e) {
                    SalaryEMailSendUI.this.handleException(e);
                }
            }
        });
    }

    private void loadDateToTemplate(SalaryEMailFormatInfo salaryEmailFormat) {
        this.txtFileName.setText("");
        this.curAttachIds = null;
        this.theFile = null;
        this.setOprtState(STATUS_EDIT);
        this.txtSubject.setText(salaryEmailFormat.getSubject());
        this.txtStart.setText(salaryEmailFormat.getStartText());
        this.txtEnd.setText(salaryEmailFormat.getEndText());
        this.chkZeroNotDisp.setSelected(salaryEmailFormat.isIsDisplayZeroItem());
        this.combShowType.setSelectedItem((Object)salaryEmailFormat.getShowType());
        this.chkUseTemplate.setSelected(true);
        this.chkUseExcel.setSelected(salaryEmailFormat.isIsUseExcelTemplate());
        this.chkSendForAttch.setSelected(salaryEmailFormat.isIsSendAttachment());
        if (salaryEmailFormat.getId() != null) {
            this.initAttach(salaryEmailFormat.getId().toString());
        }
    }

    private void clearAllData() {
        this.txtSubject.setText("");
        this.txtStart.setText("#NAME#\uff1a");
        this.txtEnd.setText("");
        this.chkZeroNotDisp.setSelected(false);
        this.prmtSalaryEmailTemplate.setData(null);
        this.chkUseTemplate.setSelected(false);
        this.chkUseExcel.setSelected(false);
        this.chkSendForAttch.setSelected(false);
        this.chkSendForAttch.setEnabled(false);
        this.txtFileName.setText("");
        this.curAttachIds = null;
        this.theFile = null;
    }

    @Override
    protected void chkUseTemplate_stateChanged(ChangeEvent e) throws Exception {
        super.chkUseTemplate_stateChanged(e);
        if (this.chkUseTemplate.isSelected()) {
            this.prmtSalaryEmailTemplate.setEnabled(true);
        } else {
            this.prmtSalaryEmailTemplate.setEnabled(false);
        }
    }

    private boolean checkPass() {
        if (this.txtStart.getText() == null || "".equals(this.txtStart.getText()) || this.txtStart.getText().trim().indexOf("#NAME#") < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.SalaryMailResource.KEY_NAME_NOTMODIFY"));
            return false;
        }
        if (this.isUseExcelTemplate() && (this.curAttachIds == null || this.curAttachIds.length <= 0)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.SalaryMailResource.UPLOAD_Attachment"));
            return false;
        }
        return true;
    }

    @Override
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
        if (this.curAttachIds != null && this.curAttachIds.length > 0) {
            AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
            acm.viewAttachment(this.curAttachIds[0]);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_NO_ATTACH"));
        }
    }

    @Override
    public void actionUpload_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpload_actionPerformed(e);
        AttachmentClientManager asm = AttachmentManagerFactory.getClientManager();
        this.theFile = asm.chooseFileByDialog((Component)((Object)this));
        if (this.theFile != null) {
            if (this.theFile.length() > 0xA00001L) {
                throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_ATTACH_SIZE_ERROR);
            }
            this.txtFileName.setText(this.theFile.getPath());
            this.curAttachIds = null;
        }
    }

    @Override
    protected void chkUseExcel_itemStateChanged(ItemEvent e) throws Exception {
        super.chkUseExcel_itemStateChanged(e);
        if (this.isUseExcelTemplate()) {
            this.chkZeroNotDisp.setEnabled(false);
            this.chkZeroNotDisp.setSelected(false);
            this.combShowType.setEnabled(false);
            this.chkSendForAttch.setEnabled(true);
        } else {
            this.chkZeroNotDisp.setEnabled(true);
            this.combShowType.setEnabled(true);
            this.chkSendForAttch.setSelected(false);
            this.chkSendForAttch.setEnabled(false);
        }
    }

    @Override
    protected void chkSendForAttch_itemStateChanged(ItemEvent e) throws Exception {
        if (this.isSendAttachment()) {
            this.label.setVisible(true);
        } else {
            this.label.setVisible(false);
        }
    }

    private void initAttach(String emailTempInfoID) {
        try {
            if (emailTempInfoID == null) {
                this.txtFileName.setText("");
                this.curAttachIds = null;
                this.theFile = null;
            } else {
                AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
                this.curAttachIds = acm.getAttachmentIDsByBoID(emailTempInfoID);
                if (this.curAttachIds.length > 0) {
                    ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
                    cais.needMainName();
                    cais.needExtName();
                    ComplexAttachmentInfo attachInfo = acm.getComplexAttachmentInfo(this.curAttachIds[0], cais);
                    this.txtFileName.setText(attachInfo.getMainName() + "." + attachInfo.getExtName());
                } else {
                    this.txtFileName.setText("");
                }
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private SimpleAttachmentInfo getAttachmentInfo() {
        SimpleAttachmentInfo saInfo = null;
        if (this.theFile != null) {
            saInfo = new SimpleAttachmentInfo();
            saInfo.setMainName(StringUtil4File.getMainFileName((String)this.theFile.getName()));
            saInfo.setExtName(StringUtil4File.getExtendedFileName((String)this.theFile.getName()));
            try {
                saInfo.setContent(FileGetter.getBytesFromFile((File)this.theFile));
            }
            catch (Exception exp) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream((OutputStream)bos);
                exp.printStackTrace(ps);
                ps.close();
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"184_ContractTempletEditUI"), (String)new String(bos.toByteArray()), (int)0);
                SysUtil.abort();
            }
        }
        return saInfo;
    }

    public boolean isUseExcelTemplate() {
        return this.chkUseExcel.isSelected();
    }

    public boolean isSendAttachment() {
        return this.chkSendForAttch.isSelected();
    }

    @Override
    public void actionViewTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewTemplate_actionPerformed(e);
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("salaryTemplate.xls");
        KDSBook book = POIXlsReader.parse((InputStream)inputStream);
        File tempFile = File.createTempFile("easHrTemp", ".xls");
        String fileName = tempFile.getAbsolutePath();
        ExportManager exportM = new ExportManager();
        exportM.exportToExcel(book, tempFile.getPath());
        KDTMenuManager.openFileInExcel((String)fileName);
        tempFile.deleteOnExit();
    }
}

