/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.compensation.AdjHistoryFacadeFactory;
import com.kingdee.eas.hr.compensation.IAdjHistoryFacade;
import com.kingdee.eas.hr.compensation.client.AbstractSelectAdjCmpSchUI;
import com.kingdee.eas.hr.compensation.client.EmpTransformListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;

public class SelectAdjCmpSchUI
extends AbstractSelectAdjCmpSchUI {
    static final String COLNAME_AFFAIRID = "id";
    static final String COLNAME_SELECT = "isSelect";
    static final String COLNAME_SCHEMEID = "schemeid";
    static final String COLNAME_EMPID = "personid";
    static final String COLNAME_EMP = "emp";
    static final String COLNAME_SCHEME = "cmpScheme";
    private KDTMergeManager mergMgr = null;
    private int indexOfSelectCol = 0;
    private int indexOfSchemeCol = 0;
    private String schemeName = "";

    public SelectAdjCmpSchUI() throws Exception {
        this.initCtl();
    }

    private void initCtl() {
        this.tblMain.checkParsed(true);
        KDCheckBox chkBox = new KDCheckBox();
        chkBox.setSelected(false);
        this.tblMain.getColumn(COLNAME_SELECT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkBox));
        this.mergMgr = this.tblMain.getMergeManager();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                SelectAdjCmpSchUI.this.selectOneScheme(e);
            }
        });
        this.indexOfSelectCol = this.tblMain.getColumnIndex(COLNAME_SELECT);
        this.indexOfSchemeCol = this.tblMain.getColumnIndex(COLNAME_SCHEME);
    }

    private void selectOneScheme(KDTMouseEvent e) {
        if (e.getClickCount() == 1 && e.getColIndex() == this.indexOfSelectCol && e.getRowIndex() >= 0) {
            int curRowInd = e.getRowIndex();
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                this.tblMain.getRow(i).getCell(this.indexOfSelectCol).setValue((Object)false);
            }
            this.tblMain.getRow(curRowInd).getCell(this.indexOfSelectCol).setValue((Object)true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadData();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void loadData() {
        Object obj = this.getUIContext().get("SELECTADJCMPSCHUIPARM");
        if (obj != null && obj instanceof List) {
            List data = (List)obj;
            this.tblMain.setRefresh(false);
            String tag = "";
            int start = 0;
            int end = -1;
            int size = data.size();
            for (int i = 0; i < size; ++i) {
                Object transfObj = data.get(i);
                if (transfObj == null || !(transfObj instanceof EmpTransformListUI.TransformData)) continue;
                IRow row = this.tblMain.addRow();
                EmpTransformListUI.TransformData transfData = (EmpTransformListUI.TransformData)transfObj;
                if (tag.length() == 0) {
                    tag = transfData.getCmpSchemeID();
                }
                row.getCell(COLNAME_AFFAIRID).setValue((Object)transfData.getAffairID());
                row.getCell(COLNAME_SCHEMEID).setValue((Object)transfData.getCmpSchemeID());
                row.getCell(COLNAME_SELECT).setValue((Object)false);
                row.getCell(COLNAME_EMPID).setValue((Object)transfData.getEmpID());
                row.getCell(COLNAME_SCHEME).setValue((Object)transfData.getCmpSchemeName());
                row.getCell(COLNAME_EMP).setValue((Object)transfData.getEmpName());
                ++end;
                if (!tag.equals(transfData.getCmpSchemeID())) {
                    this.mergMgr.mergeBlock(start, this.indexOfSelectCol, end - 1, this.indexOfSelectCol, 4);
                    this.mergMgr.mergeBlock(start, this.indexOfSchemeCol, end - 1, this.indexOfSchemeCol, 4);
                    tag = transfData.getCmpSchemeID();
                    start = end;
                }
                if (!tag.equals(transfData.getCmpSchemeID()) || end != size - 1) continue;
                this.mergMgr.mergeBlock(start, this.indexOfSelectCol, size - 1, this.indexOfSelectCol, 4);
                this.mergMgr.mergeBlock(start, this.indexOfSchemeCol, size - 1, this.indexOfSchemeCol, 4);
            }
            this.tblMain.setRefresh(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        if (!this.validCheck()) {
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.PROC_CONFIRM")))) {
            return;
        }
        List disposeIDList = this.getProcTransfIDList();
        IAdjHistoryFacade adjHisFacade = AdjHistoryFacadeFactory.getRemoteInstance();
        adjHisFacade.disposeAdjItem(disposeIDList);
        Map selectSch = this.getSchemeEmpData();
        Map ctx = this.getUIContext();
        ctx.put("ADJUSTSCHEMEEDITUIPARM", selectSch);
        ctx.put("SELECTEDSCHNAME", this.getSelectSchemeName());
        IUIWindow adjEditUI = UIFactory.createUIFactory().create("com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI", ctx, null, OprtState.ADDNEW);
        adjEditUI.show();
        this.disposeUIWindow();
    }

    private String getSelectSchemeName() {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean isSelected = (Boolean)row.getCell(COLNAME_SELECT).getValue();
            if (!isSelected.booleanValue()) continue;
            this.schemeName = (String)row.getCell(COLNAME_SCHEME).getValue();
            return this.schemeName;
        }
        return "";
    }

    private Map getSchemeEmpData() {
        HashMap rst = new HashMap();
        ArrayList<String> empList = new ArrayList<String>();
        String cmpSchemeID = null;
        StringBuffer buff = new StringBuffer();
        List indList = this.getSelectRowIDList();
        int size = indList.size();
        for (int i = 0; i < size; ++i) {
            int ind = (Integer)indList.get(i);
            IRow selectRow = this.tblMain.getRow(ind);
            cmpSchemeID = (String)selectRow.getCell(COLNAME_SCHEMEID).getValue();
            buff.append(selectRow.getCell(COLNAME_EMPID).getValue());
            buff.append(";");
            buff.append(selectRow.getCell(COLNAME_EMP).getValue());
            empList.add(buff.toString());
            buff.delete(0, buff.length());
        }
        if (cmpSchemeID != null && empList.size() > 0) {
            rst.put(cmpSchemeID, empList);
        }
        return rst;
    }

    private List getProcTransfIDList() {
        ArrayList<String> rst = new ArrayList<String>();
        List indList = this.getSelectRowIDList();
        int size = indList.size();
        for (int i = 0; i < size; ++i) {
            int ind = (Integer)indList.get(i);
            rst.add((String)this.tblMain.getRow(ind).getCell(COLNAME_AFFAIRID).getValue());
        }
        return rst;
    }

    private List getSelectRowIDList() {
        ArrayList<Integer> rst = new ArrayList<Integer>();
        String cmpSchemeID = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow selectRow;
            String selectSchID;
            IRow row = this.tblMain.getRow(i);
            Boolean isSelected = (Boolean)row.getCell(COLNAME_SELECT).getValue();
            if (!isSelected.booleanValue()) continue;
            cmpSchemeID = (String)row.getCell(COLNAME_SCHEMEID).getValue();
            for (int j = i; j < size && (selectSchID = (String)(selectRow = this.tblMain.getRow(j)).getCell(COLNAME_SCHEMEID).getValue()).equals(cmpSchemeID); ++j) {
                rst.add(j);
            }
            break;
        }
        return rst;
    }

    private boolean validCheck() {
        boolean rst = true;
        boolean selectOne = false;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            Boolean isSelected = (Boolean)this.tblMain.getRow(i).getCell(COLNAME_SELECT).getValue();
            if (isSelected.booleanValue() && selectOne) {
                selectOne = false;
                break;
            }
            if (!isSelected.booleanValue()) continue;
            selectOne = true;
        }
        if (!selectOne) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.SelectAdjSchResource", (String)"SELECT_ONE_CMPSCHEME"));
        }
        rst = selectOne;
        return rst;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        Object obj = this.getUIContext().get("PARENTUI");
        if (obj != null && obj instanceof EmpTransformListUI) {
            EmpTransformListUI parentUI = (EmpTransformListUI)((Object)obj);
            parentUI.REFRESH = false;
        }
        this.disposeUIWindow();
    }
}

