/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.AbstractVoucherTemptShrInfo;
import com.kingdee.eas.hr.compensation.BizDateEnum;
import com.kingdee.eas.hr.compensation.BookDateEnum;
import com.kingdee.eas.hr.compensation.CmpSchemeShrInfo;
import com.kingdee.eas.hr.compensation.VoucherTempShrFacadeFactory;
import com.kingdee.eas.hr.compensation.VoucherTemptShrCollection;
import com.kingdee.eas.hr.compensation.VoucherTemptShrFactory;
import com.kingdee.eas.hr.compensation.client.AbstractSelectCmpScheme;
import com.kingdee.eas.hr.compensation.exception.HRCompensationBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JInternalFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SelectCmpSchemeShr
extends AbstractSelectCmpScheme {
    Map<String, List<Map>> periodInfoMap = new HashMap<String, List<Map>>();
    private static final Logger logger = CoreUIObject.getLogger(SelectCmpSchemeShr.class);
    private static final String String = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.prmtCmpScheme.setEnabled(false);
        this.toolBar.setVisible(false);
        Map map = this.getUIContext();
        CmpSchemeShrInfo cmpshinfo = null;
        if (map.get("cmpshinfo") != null) {
            cmpshinfo = (CmpSchemeShrInfo)map.get("cmpshinfo");
        }
        if (cmpshinfo != null) {
            this.prmtCmpScheme.setValue((Object)cmpshinfo);
        }
        this.prmtCmpScheme.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent arg0) {
                SelectCmpSchemeShr.this.prmtcmpScheme_willshow();
            }
        });
        this.prmtCmpScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                SelectCmpSchemeShr.this.prmtCmpScheme_DataChange(arg0);
            }
        });
        if (cmpshinfo != null) {
            String schemeId = cmpshinfo.getId().toString();
            this.loadPeriodInfo(schemeId);
        }
        if (this.cmpPeriod.getSelectedItem() != null) {
            String selectItem = (String)this.cmpPeriod.getSelectedItem();
            this.loadTimeInfo(selectItem);
        }
        this.cmpPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (arg0.getStateChange() == 1) {
                    String selectItem = (String)arg0.getItem();
                    try {
                        SelectCmpSchemeShr.this.loadTimeInfo(selectItem);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.kdrFen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent stateEvent) {
                Map map = SelectCmpSchemeShr.this.getUIContext();
                CmpSchemeShrInfo cmpshinfo = (CmpSchemeShrInfo)map.get("cmpshinfo");
                SelectCmpSchemeShr.this.loadPeriodInfo(cmpshinfo.getId().toString());
            }
        });
    }

    protected void loadTimeInfo(String item) throws BOSException {
        this.kDTable1.removeRows();
        this.kDTable1.checkParsed();
        Map map = this.getUIContext();
        String tempId = (String)map.get("tempId");
        List<Map> timeInfo = this.periodInfoMap.get(item);
        if (timeInfo != null && timeInfo.size() > 0) {
            int i = 0;
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("company"));
            selectorItemCollection.add(new SelectorItemInfo("bizDateRange"));
            selectorItemCollection.add(new SelectorItemInfo("bookDateRange"));
            selectorItemCollection.add(new SelectorItemInfo("cmpScheme"));
            viewInfo.setSelector(selectorItemCollection);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)tempId, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            VoucherTemptShrCollection vouTemptList = new VoucherTemptShrCollection();
            vouTemptList = VoucherTemptShrFactory.getRemoteInstance().getVoucherTemptShrCollection(viewInfo);
            AbstractVoucherTemptShrInfo temptShrInfo = null;
            if (vouTemptList != null && vouTemptList.size() > 0) {
                temptShrInfo = vouTemptList.get(0);
            }
            BizDateEnum bizDateRange = temptShrInfo.getBizDateRange() == null ? BizDateEnum.SYS_DATE : temptShrInfo.getBizDateRange();
            BookDateEnum bookDateRange = temptShrInfo.getBookDateRange() == null ? BookDateEnum.SYS_DATE : temptShrInfo.getBookDateRange();
            String financialOrgId = temptShrInfo.getCompany().getId().toString();
            String cmpSchemeId = temptShrInfo.getCmpScheme().getId().toString();
            Map dateMap = new HashMap();
            int count = timeInfo.size();
            while (i < count) {
                IRow row = this.kDTable1.addRow();
                Map timeInfoMap = timeInfo.get(i);
                row.getCell("time").setValue(timeInfoMap.get("calTime"));
                if (timeInfoMap.get("bizDate") != null) {
                    row.getCell("bizDate").setValue((Object)timeInfoMap.get("bizDate").toString().substring(0, 10));
                }
                String voucherNumber = (String)timeInfoMap.get("voucherNumber");
                String bookDateStr = "";
                String businessDateStr = "";
                if (voucherNumber != null && !"".equals(voucherNumber)) {
                    row.getCell("voucherNum").setValue((Object)voucherNumber);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    Date utilBizDate = (Date)timeInfoMap.get("voucherBizDate");
                    Date utilBookDate = (Date)timeInfoMap.get("voucherBookDate");
                    bookDateStr = dateFormat.format(utilBookDate);
                    businessDateStr = dateFormat.format(utilBizDate);
                } else {
                    HashMap<String, String> otherParamMap = new HashMap<String, String>();
                    otherParamMap.put("financialOrgId", financialOrgId);
                    otherParamMap.put("cmpSchemeId", cmpSchemeId);
                    otherParamMap.put("calTime", "" + timeInfoMap.get("calTime"));
                    try {
                        dateMap = VoucherTempShrFacadeFactory.getRemoteInstance().getBusinessDateAndBookDate(bizDateRange.getValue(), bookDateRange.getValue(), item, otherParamMap);
                    }
                    catch (HRCompensationBizException e) {
                        MsgBox.showInfo((String)e.getMessage());
                        return;
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                    bookDateStr = (String)dateMap.get("bookDate");
                    businessDateStr = (String)dateMap.get("businessDate");
                }
                row.getCell("bookDate").setValue((Object)bookDateStr);
                row.getCell("businessDate").setValue((Object)businessDateStr);
                row.getCell("select").setValue((Object)false);
                ++i;
            }
            this.kDTable1.setRowCount(timeInfo.size() + 1);
        }
    }

    private void loadPeriodInfo(String schemeId) {
        try {
            Map map = this.getUIContext();
            String voucherType = (String)map.get("voucherType");
            String tempId = (String)map.get("tempId");
            boolean isfen = false;
            if (this.kdrFen.isSelected()) {
                isfen = true;
            }
            this.periodInfoMap = VoucherTempShrFacadeFactory.getRemoteInstance().getCmpSchemePeriod(schemeId, voucherType, tempId, isfen);
            this.cmpPeriod.removeAllItems();
            Set<String> set = this.periodInfoMap.keySet();
            if (set != null && set.size() > 0) {
                Iterator<String> it = set.iterator();
                while (it.hasNext()) {
                    this.cmpPeriod.addItem((Object)it.next().toString());
                }
            }
            int size = this.cmpPeriod.getItemCount();
            for (int i = 0; i < size; ++i) {
                this.cmpPeriod.setSelectedIndex(i);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void kdrAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdrAll.isSelected()) {
            this.kdrFen.setSelected(false);
        } else {
            this.kdrFen.setSelected(true);
        }
    }

    @Override
    protected void kdrFen_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdrFen.isSelected()) {
            this.kdrAll.setSelected(false);
        } else {
            this.kdrAll.setSelected(true);
        }
    }

    private void prmtCmpScheme_DataChange(DataChangeEvent arg0) {
        if (arg0.getNewValue() != null) {
            CmpSchemeShrInfo cmpscheme = (CmpSchemeShrInfo)arg0.getNewValue();
            this.loadSchemeInfo(cmpscheme);
        }
    }

    private void loadSchemeInfo(CmpSchemeShrInfo cmpscheme) {
        this.kDTable1.removeRows();
        this.kDTable1.checkParsed();
        if (cmpscheme != null) {
            int statue = cmpscheme.getAudit().getValue();
            String table = cmpscheme.getHorTableName();
            try {
                List list = VoucherTempShrFacadeFactory.getRemoteInstance().getCmpSchemeTime(cmpscheme);
                if (list != null && list.size() > 0) {
                    int count = list.size();
                    for (int i = 0; i < count; ++i) {
                        if (statue != 40 && i == count - 1) continue;
                        IRow row = this.kDTable1.addRow();
                        row.getCell("time").setValue(list.get(i));
                        row.getCell("select").setValue((Object)false);
                    }
                    this.kDTable1.setRowCount(list.size() + 1);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.HrCompenMultLangResource", (String)"label16", (Locale)SysContext.getSysContext().getLocale()));
                this.abort();
            }
        }
    }

    private void prmtcmpScheme_willshow() {
        try {
            Set set = this.getConter();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (set != null && set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)set, CompareType.INCLUDE));
            }
            filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1, CompareType.EQUALS));
            evi.setFilter(filter);
            this.prmtCmpScheme.setEntityViewInfo(evi);
            this.prmtCmpScheme.getQueryAgent().resetRuntimeEntityView();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set getConter() throws Exception {
        HashSet<String> set = new HashSet<String>();
        FullOrgUnitCollection OrgUnitconn = SelectCmpSchemeShr.getAuthorizedOrg(OrgViewType.ADMIN);
        if (OrgUnitconn != null) {
            for (int i = 0; i < OrgUnitconn.size(); ++i) {
                FullOrgUnitInfo finfo = OrgUnitconn.get(i);
                set.add(finfo.getId().toString());
            }
        }
        return set;
    }

    public static FullOrgUnitCollection getAuthorizedOrg(OrgViewType orgViewType) throws Exception {
        if (orgViewType == null || !(orgViewType instanceof OrgViewType)) {
            return null;
        }
        OrgType orgType = NewOrgViewHelper.convert((OrgViewType)orgViewType);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        FullOrgUnitCollection orgCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, null);
        return orgCol;
    }

    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
    }

    protected void menuItemEnterToNextRow_itemStateChanged(ItemEvent e) throws Exception {
        super.menuItemEnterToNextRow_itemStateChanged(e);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        String ids = "";
        CmpSchemeShrInfo cmpscheme = null;
        if (this.prmtCmpScheme.getValue() != null) {
            cmpscheme = (CmpSchemeShrInfo)this.prmtCmpScheme.getValue();
        }
        if (this.cmpPeriod.getSelectedItem() != null) {
            this.getUIContext().put("period", this.cmpPeriod.getSelectedItem());
        }
        int rowcount = this.kDTable1.getRowCount();
        ArrayList list = new ArrayList();
        ArrayList dateList = new ArrayList();
        if (rowcount > 0) {
            HashMap<String, String> dateMap = null;
            for (int i = 0; i < rowcount; ++i) {
                boolean boo;
                IRow row = this.kDTable1.getRow(i);
                if (row == null || !(boo = ((Boolean)row.getCell("select").getValue()).booleanValue())) continue;
                String time = (String)row.getCell("time").getValue();
                String bizDate = (String)row.getCell("bizDate").getValue();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("calTime", time);
                map.put("bizDate", bizDate);
                map.put("bookDate", (String)row.getCell("bookDate").getValue());
                map.put("businessDate", (String)row.getCell("businessDate").getValue());
                dateMap = new HashMap<String, String>();
                dateMap.put("bookDate", (String)row.getCell("bookDate").getValue());
                dateMap.put("businessDate", (String)row.getCell("businessDate").getValue());
                dateList.add(dateMap);
                list.add(map);
                if (!boo) continue;
                ids = ids + time + ";";
            }
        }
        boolean bool = false;
        if (this.kdrFen.isSelected()) {
            bool = true;
        }
        this.getUIContext().put("cmpscheme", cmpscheme);
        this.getUIContext().put("isfen", bool);
        this.getUIContext().put("rValue", ids);
        this.getUIContext().put("params", list);
        this.getUIContext().put("dateList", dateList);
        if (ids.equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.HrCompenMultLangResource", (String)"label17", (Locale)SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
        this.disposeUIWindow();
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        CmpSchemeShrInfo cmpscheme = null;
        if (this.prmtCmpScheme.getValue() != null) {
            cmpscheme = (CmpSchemeShrInfo)this.prmtCmpScheme.getValue();
        }
        boolean bool = false;
        if (this.kdrFen.isSelected()) {
            bool = true;
        }
        this.getUIContext().put("isfen", bool);
        this.getUIContext().put("cmpscheme", cmpscheme);
        this.getUIContext().put("rValue", "Exit");
        this.disposeUIWindow();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFrom_actionPerformed(e);
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMail_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionNumberSign_actionPerformed(ActionEvent e) throws Exception {
        super.actionNumberSign_actionPerformed(e);
    }

    protected IObjectValue createNewDetailData(KDTable arg0) {
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public boolean destroyWindow() {
        boolean b = this.checkBeforeWindowClosing();
        if (b) {
            this.disposeUIWindow();
        }
        return b;
    }

    protected void disposeUIWindow() {
        if (this.uiWindow != null) {
            this.removePropertyChangeListener((PropertyChangeListener)this.uiWindow);
        }
        if (this.uiWindow instanceof Dialog) {
            ((Dialog)this.uiWindow).dispose();
        } else if (this.uiWindow instanceof Window) {
            ((Window)this.uiWindow).dispose();
        } else if (this.uiWindow instanceof JInternalFrame) {
            ((JInternalFrame)this.uiWindow).dispose();
        }
    }
}

