/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.client.AbstractShRptCmpPersonContrastFilterUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class ShRptCmpPersonContrastFilterUI
extends AbstractShRptCmpPersonContrastFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ShRptCmpPersonContrastFilterUI.class);
    private String resourceURL = "com.kingdee.eas.hr.compensation.client.SHRcmpResource.";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
        if (this.cboYear1.getItemCount() == 0) {
            this.initComboBox();
            Calendar cal = Calendar.getInstance(SysContext.getSysContext().getLocale());
            int year = cal.get(1);
            this.cboYear1.setSelectedItem((Object)(year - 1));
            this.cboYear2.setSelectedItem((Object)year);
            int month = cal.get(2) + 1;
            if (month == 1) {
                this.cboMonth1.setSelectedItem((Object)month);
            } else {
                this.cboMonth1.setSelectedItem((Object)(month - 1));
            }
            this.cboMonth2.setSelectedItem((Object)month);
        }
    }

    private void initComboBox() {
        int i;
        this.cboYear1.removeAllItems();
        this.cboYear2.removeAllItems();
        this.cboMonth1.removeAllItems();
        this.cboMonth2.removeAllItems();
        for (i = 1990; i < 2021; ++i) {
            this.cboYear1.addItem((Object)i);
            this.cboYear2.addItem((Object)i);
        }
        for (i = 1; i <= 12; ++i) {
            this.cboMonth1.addItem((Object)i);
            this.cboMonth2.addItem((Object)i);
        }
    }

    public boolean verify() {
        if (this.prmtCmpPerson.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resourceURL + "NOT_SELECT_PERSON")));
            this.prmtCmpPerson.requestFocusInWindow();
            return false;
        }
        if (this.cboYear1.getSelectedIndex() > this.cboYear2.getSelectedIndex()) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resourceURL + "YEAR1_BIGER_YEAR2")));
            this.cboYear1.requestFocusInWindow();
            return false;
        }
        if (this.cboMonth1.getSelectedIndex() > this.cboMonth2.getSelectedIndex()) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resourceURL + "MONTH1_BIGER_MONTH2")));
            this.cboMonth1.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        if (this.prmtCmpPerson.getData() != null) {
            this.prmtCmpPerson.setData(null);
        }
    }

    public void setCustomerParams(CustomerParams param) {
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        this.initComboBox();
        if (param.getCustomerParam("PERSON_ID") != null) {
            try {
                PersonInfo pInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("PERSON_ID"))));
                this.prmtCmpPerson.setData((Object)pInfo);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        if (param.getInt("YEAR1") != 0) {
            this.cboYear1.setSelectedItem((Object)param.getInt("YEAR1"));
        }
        if (param.getInt("YEAR2") != 0) {
            this.cboYear2.setSelectedItem((Object)param.getInt("YEAR2"));
        }
        if (param.getInt("Month1") != 0) {
            this.cboMonth1.setSelectedItem((Object)param.getInt("Month1"));
        }
        if (param.getInt("Month2") != 0) {
            this.cboMonth2.setSelectedItem((Object)param.getInt("Month2"));
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        params.putInt("YEAR1", ((Integer)this.cboYear1.getSelectedItem()).intValue());
        params.putInt("YEAR2", ((Integer)this.cboYear2.getSelectedItem()).intValue());
        params.putInt("Month1", ((Integer)this.cboMonth1.getSelectedItem()).intValue());
        params.putInt("Month2", ((Integer)this.cboMonth2.getSelectedItem()).intValue());
        params.addCustomerParam("PERSON_ID", ((PersonInfo)this.prmtCmpPerson.getData()).getId().toString());
        params.addCustomerParam("PERSON_NAME", ((PersonInfo)this.prmtCmpPerson.getData()).getName());
        return params;
    }

    private void initF7() throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox();
        pmt.setModal(true);
        pmt.showOnlyPayPerson(true);
        pmt.setIsSingleSelect(true);
        pmt.showNoPositionPerson(true);
        this.prmtCmpPerson.setSelector((KDPromptSelector)pmt);
        this.prmtCmpPerson.setDisplayFormat("$name$");
    }
}

