/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.IShRptCmpPrizeStatFacade;
import com.kingdee.eas.hr.compensation.ShRptCmpPrizeStatFacadeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractShRptCmpPersonContrastReportUI;
import com.kingdee.eas.hr.compensation.client.ShRptCmpPersonContrastFilterUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ShRptCmpPersonContrastReportUI
extends AbstractShRptCmpPersonContrastReportUI {
    private static final Logger logger = CoreUIObject.getLogger(ShRptCmpPersonContrastReportUI.class);
    private CustomerParams params = null;
    private boolean isFirstDefaultQuery = true;
    private int lastIndex = 0;
    private int monthCount = 1;
    private String fixNameStr = null;
    private KDTMergeManager mm = null;
    private IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.org.app", "PositionSpecDS4Query");
    private CommonQueryDialog commonQueryDialog = null;
    private ShRptCmpPersonContrastFilterUI customerPanel = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.fixNameStr = this.labTitle.getText();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("zjndzz").getStyleAttributes().setNumberFormat("%R-{0.00}p");
        this.tblMain.getColumn("rjndzz").getStyleAttributes().setNumberFormat("%R-{0.00}p");
        this.mm = this.tblMain.getMergeManager();
        this.enableExportExcel(this.tblMain);
        HRUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        this.showFilterUI(false);
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    private static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    private void showFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = ShRptCmpPersonContrastReportUI.getQueryInfo(this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getQueryPanelInfo().get(0).getCustomerParams() != null && CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams()) != null) {
                this.params = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
                if (this.params.getCustomerParam("PERSON_ID") == null) {
                    this.showFilterDialog(false);
                    return;
                }
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("PERSON_ID")));
                if (pk == null || pk != null && !PersonFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                    this.showFilterDialog(false);
                    return;
                }
                this.loadTableData();
            } else {
                this.showFilterDialog(loaded);
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog(loaded);
        }
    }

    private void showFilterDialog(boolean loaded) throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(350);
            this.commonQueryDialog.setWidth(400);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.customerPanel = new ShRptCmpPersonContrastFilterUI();
            if (loaded) {
                this.customerPanel.setCustomerParams(this.params);
            }
            this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
            String commonQueryRes = "com.kingdee.eas.hr.time.TimeResource";
            this.commonQueryDialog.setTitle(HRResourceUtils.getMessage((String)commonQueryRes, (String)"54_CONDITION_QUERY", (String[])new String[]{this.getUITitle()}));
        }
        if (this.commonQueryDialog.show()) {
            this.params = this.customerPanel.getCustomerParams();
            this.loadTableData();
        } else {
            SysUtil.abort();
        }
    }

    private void loadTableData() throws Exception {
        this.tblMain.removeRows();
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                IShRptCmpPrizeStatFacade iShRpt = ShRptCmpPrizeStatFacadeFactory.getRemoteInstance();
                List list = iShRpt.getCmpPersonContrastData(ShRptCmpPersonContrastReportUI.this.params.getCustomerParamsHashMap());
                ShRptCmpPersonContrastReportUI.this.fillTable(list);
                return null;
            }
        });
        dlg.show();
    }

    private void addBlankRow() throws Exception {
        IRow row = null;
        int year1 = this.params.getInt("YEAR1");
        int year2 = this.params.getInt("YEAR2");
        int month1 = this.params.getInt("Month1");
        int month2 = this.params.getInt("Month2");
        for (int i = month1; i <= month2; ++i) {
            row = this.tblMain.addRow();
            row.getCell("year").setValue((Object)year1);
            row.getCell("month").setValue((Object)i);
            row.getCell("personCount").setValue((Object)"1");
            if (year1 == year2) continue;
            row = this.tblMain.addRow();
            row.getCell("year").setValue((Object)year2);
            row.getCell("month").setValue((Object)i);
            row.getCell("personCount").setValue((Object)"1");
        }
        row = this.tblMain.addRow();
        row.getCell("year").setValue((Object)year1);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"604_ShRptCmpPersonContrastReportUI"));
        row.getCell("personCount").setValue((Object)"1");
        row = this.tblMain.addRow();
        row.getCell("year").setValue((Object)year2);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"604_ShRptCmpPersonContrastReportUI"));
        row.getCell("personCount").setValue((Object)"1");
        row = this.tblMain.addRow();
        row.getCell("year").setValue((Object)year1);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"605_ShRptCmpPersonContrastReportUI"));
        row.getCell("personCount").setValue((Object)"1");
        row = this.tblMain.addRow();
        row.getCell("year").setValue((Object)year2);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"605_ShRptCmpPersonContrastReportUI"));
        row.getCell("personCount").setValue((Object)"1");
        row = this.tblMain.addRow();
        row.getCell("year").setValue((Object)year1);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"11_BIReportCmpFacadeControllerBean"));
        row.getCell("personCount").setValue((Object)"1");
        row = this.tblMain.addRow();
        row.getCell("year").setValue((Object)year2);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"11_BIReportCmpFacadeControllerBean"));
        row.getCell("personCount").setValue((Object)"1");
    }

    private void fillTable(List list) throws Exception {
        if (list == null) {
            return;
        }
        this.labName.setText(this.params.getCustomerParam("PERSON_NAME"));
        int year1 = this.params.getInt("YEAR1");
        int year2 = this.params.getInt("YEAR2");
        int month1 = this.params.getInt("Month1");
        int month2 = this.params.getInt("Month2");
        this.labTitle.setText(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"747_SalaryEMailFormatControllerBean", (String[])new String[]{String.valueOf(year1), String.valueOf(month1), String.valueOf(year2), String.valueOf(month2), this.fixNameStr}));
        this.addBlankRow();
        if (list.size() == 0) {
            return;
        }
        if (list.get(0) == null) {
            return;
        }
        IRowSet rows = (IRowSet)list.get(0);
        if (rows == null || rows.size() == 0) {
            return;
        }
        this.tblMain.removeRows();
        this.monthCount = month2 - month1 + 1;
        HashMap map = (HashMap)list.get(1);
        for (int i = month1; i <= month2; ++i) {
            if (map.get(year1 + "_" + i) != null) {
                this.addCommonColumn(rows, year1, i, map.get(year1 + "_" + i).toString());
            } else {
                this.addCommonColumn(rows, year2, i, null);
            }
            if (year1 == year2) continue;
            if (map.get(year2 + "_" + i) != null) {
                this.addCommonColumn(rows, year2, i, map.get(year2 + "_" + i).toString());
                continue;
            }
            this.addCommonColumn(rows, year2, i, null);
        }
        this.fillSumData2(year1);
        if (year1 != year2) {
            this.fillSumData2(year2);
        }
        this.fillSumData3(year1);
        if (year1 != year2) {
            this.fillSumData3(year2);
        }
        this.fillSumData4(year1);
        if (year1 != year2) {
            this.fillSumData4(year2);
        }
    }

    private void addCommonColumn(IRowSet rows, int year, int month, String pId) throws Exception {
        rows.beforeFirst();
        IRow row = null;
        BigDecimal sum = new BigDecimal(0);
        BigDecimal value = new BigDecimal(0);
        row = this.tblMain.addRow();
        this.lastIndex = row.getRowIndex();
        row.getCell("year").setValue((Object)year);
        row.getCell("month").setValue((Object)month);
        row.getCell("personCount").setValue((Object)"1");
        if (pId == null) {
            return;
        }
        while (rows.next()) {
            sum = new BigDecimal(0);
            if (!rows.getString("FPERIOD").trim().equals(pId)) continue;
            if (!rows.getString("JSGZ").equals("0")) {
                value = rows.getBigDecimal("JSGZ");
                row.getCell("jsgz").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("GNGZ").equals("0")) {
                value = rows.getBigDecimal("GNGZ");
                row.getCell("gongling").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL211").equals("0")) {
                value = rows.getBigDecimal("FFSAL211");
                row.getCell("wujia").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL242").equals("0")) {
                value = rows.getBigDecimal("FFSAL242");
                row.getCell("zybf").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL240").equals("0")) {
                value = rows.getBigDecimal("FFSAL240");
                row.getCell("jiabanfei").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FSAL002").equals("0")) {
                value = rows.getBigDecimal("FSAL002");
                row.getCell("jiangjin").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL284").equals("0")) {
                value = rows.getBigDecimal("FFSAL284");
                row.getCell("xiaoshifei").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL244").equals("0")) {
                value = rows.getBigDecimal("FFSAL244");
                row.getCell("kongqingtie").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL246").equals("0")) {
                value = rows.getBigDecimal("FFSAL246");
                row.getCell("diqingtie").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL238").equals("0")) {
                value = rows.getBigDecimal("FFSAL238");
                row.getCell("teshuqingtie").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL253").equals("0")) {
                value = rows.getBigDecimal("FFSAL253");
                row.getCell("yicixingjiangjin1").setValue((Object)value);
                sum = sum.add(value);
            }
            if (!rows.getString("FFSAL224").equals("0")) {
                value = rows.getBigDecimal("FFSAL224");
                row.getCell("shuangxin").setValue((Object)value);
                sum = sum.add(value);
            }
            if (sum.intValue() != 0) {
                row.getCell("zongji").setValue((Object)sum);
                row.getCell("renjun").setValue((Object)sum);
            }
            this.fillSumData(row);
            break;
        }
    }

    private void fillSumData(IRow row) throws Exception {
        int year2;
        int year1 = this.params.getInt("YEAR1");
        if (year1 != (year2 = this.params.getInt("YEAR2")) && (row.getRowIndex() + 1) % 2 == 0) {
            IRow preRow = this.tblMain.getRow(row.getRowIndex() - 1);
            BigDecimal preSum = (BigDecimal)preRow.getCell("zongji").getValue();
            BigDecimal sum = (BigDecimal)row.getCell("zongji").getValue();
            if (preSum != null && sum != null) {
                row.getCell("zjndzz").setValue((Object)sum.subtract(preSum).divide(preSum, 4, 4));
                row.getCell("rjndzz").setValue((Object)sum.subtract(preSum).divide(preSum, 4, 4));
            }
            int top = row.getRowIndex() - 1;
            int left = this.tblMain.getColumnIndex("zjndzz");
            int bottom = row.getRowIndex();
            int right = this.tblMain.getColumnIndex("rjndzz");
            this.mm.mergeBlock(top, left, bottom, left, 4);
            this.mm.mergeBlock(top, right, bottom, right, 4);
        }
    }

    private void fillSumData2(int year) throws Exception {
        BigDecimal sum = new BigDecimal(0);
        BigDecimal sum2 = new BigDecimal(0);
        IRow row = this.tblMain.addRow();
        row.getStyleAttributes().setBackground(new Color(15262923));
        row.getCell("year").setValue((Object)year);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"604_ShRptCmpPersonContrastReportUI"));
        row.getCell("personCount").setValue((Object)"1");
        sum = this.computeData(row, "jsgz");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jsgz").setValue((Object)this.computeData(row, "jsgz"));
        }
        sum = this.computeData(row, "gongling");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("gongling").setValue((Object)this.computeData(row, "gongling"));
        }
        sum = this.computeData(row, "wujia");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("wujia").setValue((Object)this.computeData(row, "wujia"));
        }
        sum = this.computeData(row, "zybf");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("zybf").setValue((Object)this.computeData(row, "zybf"));
        }
        sum = this.computeData(row, "jiabanfei");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jiabanfei").setValue((Object)this.computeData(row, "jiabanfei"));
        }
        sum = this.computeData(row, "jiangjin");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jiangjin").setValue((Object)this.computeData(row, "jiangjin"));
        }
        sum = this.computeData(row, "xiaoshifei");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("xiaoshifei").setValue((Object)this.computeData(row, "xiaoshifei"));
        }
        sum = this.computeData(row, "kongqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("kongqingtie").setValue((Object)this.computeData(row, "kongqingtie"));
        }
        sum = this.computeData(row, "diqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("diqingtie").setValue((Object)this.computeData(row, "diqingtie"));
        }
        sum = this.computeData(row, "teshuqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("teshuqingtie").setValue((Object)this.computeData(row, "teshuqingtie"));
        }
        sum = this.computeData(row, "yicixingjiangjin1");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("yicixingjiangjin1").setValue((Object)this.computeData(row, "yicixingjiangjin1"));
        }
        sum = this.computeData(row, "shuangxin");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("shuangxin").setValue((Object)this.computeData(row, "shuangxin"));
        }
        if (sum2.intValue() != 0) {
            row.getCell("zongji").setValue((Object)sum2);
            row.getCell("renjun").setValue((Object)sum2);
        }
        this.fillSumData(row);
    }

    private void fillSumData3(int year) throws Exception {
        BigDecimal sum = new BigDecimal(0);
        BigDecimal sum2 = new BigDecimal(0);
        IRow row = this.tblMain.addRow();
        row.getStyleAttributes().setBackground(new Color(15327928));
        row.getCell("year").setValue((Object)year);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"605_ShRptCmpPersonContrastReportUI"));
        row.getCell("personCount").setValue((Object)"1");
        sum = this.computeData(row, "jsgz");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jsgz").setValue((Object)this.computeData(row, "jsgz"));
        }
        sum = this.computeData(row, "gongling");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("gongling").setValue((Object)this.computeData(row, "gongling"));
        }
        sum = this.computeData(row, "wujia");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("wujia").setValue((Object)this.computeData(row, "wujia"));
        }
        sum = this.computeData(row, "zybf");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("zybf").setValue((Object)this.computeData(row, "zybf"));
        }
        sum = this.computeData(row, "jiabanfei");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jiabanfei").setValue((Object)this.computeData(row, "jiabanfei"));
        }
        sum = this.computeData(row, "jiangjin");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jiangjin").setValue((Object)this.computeData(row, "jiangjin"));
        }
        sum = this.computeData(row, "xiaoshifei");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("xiaoshifei").setValue((Object)this.computeData(row, "xiaoshifei"));
        }
        sum = this.computeData(row, "kongqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("kongqingtie").setValue((Object)this.computeData(row, "kongqingtie"));
        }
        sum = this.computeData(row, "diqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("diqingtie").setValue((Object)this.computeData(row, "diqingtie"));
        }
        sum = this.computeData(row, "teshuqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("teshuqingtie").setValue((Object)this.computeData(row, "teshuqingtie"));
        }
        sum = this.computeData(row, "yicixingjiangjin1");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("yicixingjiangjin1").setValue((Object)this.computeData(row, "yicixingjiangjin1"));
        }
        sum = this.computeData(row, "shuangxin");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("shuangxin").setValue((Object)this.computeData(row, "shuangxin"));
        }
        if (sum2.intValue() != 0) {
            row.getCell("zongji").setValue((Object)sum2);
            row.getCell("renjun").setValue((Object)sum2);
        }
        this.fillSumData(row);
    }

    private void fillSumData4(int year) throws Exception {
        BigDecimal sum = new BigDecimal(0);
        BigDecimal sum2 = new BigDecimal(0);
        IRow row = this.tblMain.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        row.getCell("year").setValue((Object)year);
        row.getCell("month").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"11_BIReportCmpFacadeControllerBean"));
        row.getCell("personCount").setValue((Object)"1");
        sum = this.computeData2(row, "jsgz");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jsgz").setValue((Object)this.computeData2(row, "jsgz"));
        }
        sum = this.computeData2(row, "gongling");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("gongling").setValue((Object)this.computeData2(row, "gongling"));
        }
        sum = this.computeData2(row, "wujia");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("wujia").setValue((Object)this.computeData2(row, "wujia"));
        }
        sum = this.computeData2(row, "zybf");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("zybf").setValue((Object)this.computeData2(row, "zybf"));
        }
        sum = this.computeData2(row, "jiabanfei");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jiabanfei").setValue((Object)this.computeData2(row, "jiabanfei"));
        }
        sum = this.computeData2(row, "jiangjin");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("jiangjin").setValue((Object)this.computeData2(row, "jiangjin"));
        }
        sum = this.computeData2(row, "xiaoshifei");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("xiaoshifei").setValue((Object)this.computeData2(row, "xiaoshifei"));
        }
        sum = this.computeData2(row, "kongqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("kongqingtie").setValue((Object)this.computeData2(row, "kongqingtie"));
        }
        sum = this.computeData2(row, "diqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("diqingtie").setValue((Object)this.computeData2(row, "diqingtie"));
        }
        sum = this.computeData2(row, "teshuqingtie");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("teshuqingtie").setValue((Object)this.computeData2(row, "teshuqingtie"));
        }
        sum = this.computeData2(row, "yicixingjiangjin1");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("yicixingjiangjin1").setValue((Object)this.computeData2(row, "yicixingjiangjin1"));
        }
        sum = this.computeData2(row, "shuangxin");
        sum2 = sum2.add(sum);
        if (sum.intValue() != 0) {
            row.getCell("shuangxin").setValue((Object)this.computeData2(row, "shuangxin"));
        }
        if (sum2.intValue() != 0) {
            row.getCell("zongji").setValue((Object)sum2);
            row.getCell("renjun").setValue((Object)sum2);
        }
        this.fillSumData(row);
    }

    private BigDecimal computeData(IRow row, String colName) throws Exception {
        int year2;
        BigDecimal sum = new BigDecimal(0);
        int year1 = this.params.getInt("YEAR1");
        if (year1 != (year2 = this.params.getInt("YEAR2"))) {
            if ((row.getRowIndex() + 1) % 2 == 0) {
                for (int i = 1; i <= this.lastIndex; i += 2) {
                    if (this.tblMain.getRow(i).getCell(colName).getValue() == null) continue;
                    sum = sum.add((BigDecimal)this.tblMain.getRow(i).getCell(colName).getValue());
                }
            } else {
                for (int i = 0; i <= this.lastIndex; i += 2) {
                    if (this.tblMain.getRow(i).getCell(colName).getValue() == null) continue;
                    sum = sum.add((BigDecimal)this.tblMain.getRow(i).getCell(colName).getValue());
                }
            }
        } else {
            for (int i = 0; i <= this.lastIndex; ++i) {
                if (this.tblMain.getRow(i).getCell(colName).getValue() == null) continue;
                sum = sum.add((BigDecimal)this.tblMain.getRow(i).getCell(colName).getValue());
            }
        }
        return sum.divide(new BigDecimal(this.monthCount), 2, 4);
    }

    private BigDecimal computeData2(IRow row, String colName) throws Exception {
        int year2;
        BigDecimal sum = new BigDecimal(0);
        int year1 = this.params.getInt("YEAR1");
        if (year1 != (year2 = this.params.getInt("YEAR2"))) {
            if ((row.getRowIndex() + 1) % 2 == 0) {
                for (int i = 1; i <= this.lastIndex; i += 2) {
                    if (this.tblMain.getRow(i).getCell(colName).getValue() == null) continue;
                    sum = sum.add((BigDecimal)this.tblMain.getRow(i).getCell(colName).getValue());
                }
            } else {
                for (int i = 0; i <= this.lastIndex; i += 2) {
                    if (this.tblMain.getRow(i).getCell(colName).getValue() == null) continue;
                    sum = sum.add((BigDecimal)this.tblMain.getRow(i).getCell(colName).getValue());
                }
            }
        } else {
            for (int i = 0; i <= this.lastIndex; ++i) {
                if (this.tblMain.getRow(i).getCell(colName).getValue() == null) continue;
                sum = sum.add((BigDecimal)this.tblMain.getRow(i).getCell(colName).getValue());
            }
        }
        return sum;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemExp.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadTableData();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.showFilterUI(true);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutput_actionPerformed(e);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }
}

