/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.formulateutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CompenItemFormuleException;
import com.kingdee.eas.hr.compensation.formulateutil.PreTranslateScript;
import com.kingdee.eas.hr.compensation.formulateutil.ScriptStmtTransform;
import com.kingdee.eas.hr.compensation.formulateutil.StmtTransFactory;
import java.util.ArrayList;
import java.util.List;

public class KScriptToKSQL {
    public String translateScript(Context ctx, String script, IObjectPK schPK) throws EASBizException, BOSException {
        if (schPK == null || script == null) {
            return "";
        }
        List stmtList = null;
        CodeStmt stmt = null;
        try {
            KScriptParser parser = new KScriptParser(script);
            parser.parse();
            stmtList = parser.stmtList;
        }
        catch (ParserException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC, e);
        }
        if (stmtList == null) {
            return "";
        }
        stmt = (CodeStmt)stmtList.get(0);
        if (stmt instanceof IfStmt) {
            stmt = this.preTranslateIfStmt((IfStmt)stmt);
        } else if (stmt instanceof ExprStmt) {
            stmt = this.preTranslateExprStmt((ExprStmt)stmt);
        }
        ScriptStmtTransform stmtTranalator = StmtTransFactory.createStmtTranslator(stmt);
        List updStmtList = stmtTranalator.scriptStmtToSQLStmt(ctx, stmt, schPK);
        StringBuffer buff = new StringBuffer();
        if (updStmtList != null) {
            int size = updStmtList.size();
            for (int i = 0; i < size; ++i) {
                try {
                    DrSQLFormater formater = new DrSQLFormater(buff);
                    formater.formatUpdateStmt((SqlUpdateStmt)updStmtList.get(i));
                    buff.append(";");
                    continue;
                }
                catch (FormaterException e1) {
                    throw new CompenItemFormuleException(CompenItemFormuleException.FORMAT_SQL_EXEC, e1);
                }
            }
        }
        return buff.toString();
    }

    private ExprStmt preTranslateExprStmt(ExprStmt stmt) {
        PreTranslateScript preTranslator = new PreTranslateScript();
        stmt.expr = preTranslator.successor().preTranslate(stmt.expr);
        return stmt;
    }

    private IfStmt preTranslateIfStmt(IfStmt stmt) {
        int i;
        int i2;
        int i3;
        PreTranslateScript preTranslator = new PreTranslateScript();
        CodeExpr testExpr = stmt.testExpr;
        stmt.testExpr = testExpr = preTranslator.successor().preTranslate(testExpr);
        List trueList = stmt.trueStmtList;
        ArrayList<ExprStmt> trueListNew = new ArrayList<ExprStmt>();
        int size = trueList.size();
        for (i3 = 0; i3 < size; ++i3) {
            ExprStmt trueStmt = (ExprStmt)trueList.get(i3);
            trueStmt.expr = preTranslator.successor().preTranslate(trueStmt.expr);
            trueListNew.add(trueStmt);
        }
        stmt.trueStmtList.clear();
        size = trueListNew.size();
        for (i3 = 0; i3 < size; ++i3) {
            stmt.trueStmtList.add(trueListNew.get(i3));
        }
        List elseIfList = stmt.elseIfList;
        ArrayList<ElseIfItem> elseIfListNew = new ArrayList<ElseIfItem>();
        ArrayList<ExprStmt> elseIfStmtList = null;
        int size2 = elseIfList.size();
        for (i2 = 0; i2 < size2; ++i2) {
            ElseIfItem item = (ElseIfItem)elseIfList.get(i2);
            item.testExpr = preTranslator.successor().preTranslate(item.testExpr);
            elseIfStmtList = new ArrayList<ExprStmt>();
            int jsize = item.stmtList.size();
            for (int j = 0; j < jsize; ++j) {
                ExprStmt exprStmt = (ExprStmt)item.stmtList.get(j);
                exprStmt.expr = preTranslator.successor().preTranslate(exprStmt.expr);
                elseIfStmtList.add(exprStmt);
            }
            item.stmtList = elseIfStmtList;
            elseIfListNew.add(item);
        }
        stmt.elseIfList.clear();
        size2 = elseIfListNew.size();
        for (i2 = 0; i2 < size2; ++i2) {
            stmt.elseIfList.add(elseIfListNew.get(i2));
        }
        List elseList = stmt.elseStmtList;
        ArrayList<ExprStmt> elseListNew = new ArrayList<ExprStmt>();
        int size3 = elseList.size();
        for (i = 0; i < size3; ++i) {
            ExprStmt exprStmt = (ExprStmt)elseList.get(i);
            exprStmt.expr = preTranslator.successor().preTranslate(exprStmt.expr);
            elseListNew.add(exprStmt);
        }
        stmt.elseStmtList.clear();
        size3 = elseListNew.size();
        for (i = 0; i < size3; ++i) {
            stmt.elseStmtList.add(elseListNew.get(i));
        }
        return stmt;
    }
}

