/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class BIXMLWriter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.util.BIXMLWriter");
    public static final String XML_ENCODING = "UTF-8";
    public static final String SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static String SCHEMA = "Schema";
    private static String PARAMETER = "Parameter";
    private static String DIMENSION = "Dimension";
    private static String HIERARCHY = "Hierarchy";
    private static String LEVEL = "Level";
    private static String PROPERTY = "Property";
    private static String CUBE = "Cube";
    private static String DIMENSIONUSAGE = "DimensionUsage";
    private static String MEASURE = "Measure";
    private static String NAME = "name";
    private static String TYPE = "type";
    private static String CAPTION = "caption";
    private static String TABLE = "table";
    private static String PRIMARYKEY = "primaryKey";
    private static String COLUMN = "column";
    private static String CHILDCOLUMN = "childColumn";
    private static String PARENTCOLUMN = "parentColumn";
    private static String FOREIGNKEY = "foreignKey";
    private static String AGGREGATOR = "aggregator";
    private static String FORMATSTRING = "formatString";
    private Document doc = null;
    private Element root = null;

    public BIXMLWriter() {
        this.init();
    }

    protected void init() {
        this.root = new Element(SCHEMA);
        this.doc = new Document(this.root);
    }

    public void write(File file) throws BOSException {
        try {
            if (file == null) {
                logger.debug((Object)"--xml file is null.");
                return;
            }
            if (this.doc == null) {
                logger.debug((Object)"--Do not have the document.");
                return;
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            XMLOutputter outter = new XMLOutputter();
            outter.setFormat(Format.getPrettyFormat());
            outter.output(this.doc, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (IOException err) {
            logger.debug((Object)err.getMessage(), err.getCause());
            throw new BOSException(err.getMessage(), err.getCause());
        }
    }

    public Document read(String fileName) {
        if (this.doc != null) {
            return this.doc;
        }
        try {
            SAXBuilder builder = new SAXBuilder(SAX_PARSER_NAME, false);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            InputSource source = new InputSource(new FileInputStream(fileName));
            try {
                try {
                    Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.doc = builder.build(source);
            }
            catch (JDOMException je) {
                throw je;
            }
            finally {
                try {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                catch (SecurityException se) {
                    logger.debug((Object)se.getMessage(), se.getCause());
                }
            }
        }
        catch (JDOMException err) {
            throw new AssertionError((Object)("Error on analysis XML file, info: " + err.getMessage()));
        }
        catch (IOException err) {
            throw new AssertionError((Object)"Failed loading file");
        }
        return this.doc;
    }

    private InputStream loadSchema(String xmlFile, Class loaderClass) {
        String clPath = loaderClass.getName();
        String shortName = clPath.substring(clPath.lastIndexOf(46) + 1);
        String interfaceName = 'I' + shortName.substring(0, shortName.length() - "ControllerBean".length());
        String interfacePath = clPath.substring(0, clPath.length() - shortName.length() - "app.".length()) + interfaceName;
        InputStream is = null;
        try {
            is = Class.forName(interfacePath).getResourceAsStream("config/" + xmlFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element createParameterNode(String name, String type) {
        Element element = null;
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)type)) {
            return element;
        }
        element = new Element(PARAMETER);
        element.setAttribute(NAME, name);
        element.setAttribute(TYPE, type);
        this.root.addContent((Content)element);
        return element;
    }

    public Element createDimensionNode(String name, String caption, String table, String primaryKey) {
        Element element = null;
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)table) || StringUtils.isEmpty((String)primaryKey)) {
            return element;
        }
        element = new Element(DIMENSION);
        element.setAttribute(NAME, name);
        element.setAttribute(CAPTION, caption);
        element.setAttribute(TABLE, table);
        element.setAttribute(PRIMARYKEY, primaryKey);
        this.root.addContent((Content)element);
        return element;
    }

    public Element createCubeNode(String name, String caption, String table) {
        Element element = null;
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)caption) || StringUtils.isEmpty((String)table)) {
            return element;
        }
        element = new Element(CUBE);
        element.setAttribute(NAME, name);
        element.setAttribute(CAPTION, caption);
        element.setAttribute(TABLE, table);
        this.root.addContent((Content)element);
        return element;
    }

    public Element createHierarchyNode(Element dimension) {
        Element element = new Element(HIERARCHY);
        if (dimension != null) {
            dimension.addContent((Content)element);
        }
        return element;
    }

    public Element createPaternityLevelNode(String name, String column, String childColumn, String parentColumn, Element hierarchy) {
        Element element = null;
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)column)) {
            return element;
        }
        element = new Element(LEVEL);
        element.setAttribute(NAME, name);
        element.setAttribute(COLUMN, column);
        if (StringUtils.isEmpty((String)childColumn) || StringUtils.isEmpty((String)parentColumn)) {
            if (hierarchy != null) {
                hierarchy.addContent((Content)element);
            }
            return element;
        }
        element.setAttribute(CHILDCOLUMN, childColumn);
        element.setAttribute(PARENTCOLUMN, parentColumn);
        if (hierarchy != null) {
            hierarchy.addContent((Content)element);
        }
        return element;
    }

    public Element createCommonLevelNode(String name, String column, Element hierarchy) {
        return this.createPaternityLevelNode(name, column, null, null, hierarchy);
    }

    public Element createPropertyNode(String name, String column, Element level) {
        Element element = null;
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)column)) {
            return element;
        }
        element = new Element(PROPERTY);
        element.setAttribute(NAME, name);
        element.setAttribute(COLUMN, column);
        if (level != null) {
            level.addContent((Content)element);
        }
        return element;
    }

    public Element createDimensionUsageNode(String name, String foreignKey, Element cube) {
        Element element = null;
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)foreignKey)) {
            return element;
        }
        element = new Element(DIMENSIONUSAGE);
        element.setAttribute(NAME, name);
        element.setAttribute(FOREIGNKEY, foreignKey);
        if (cube != null) {
            cube.addContent((Content)element);
        }
        return element;
    }

    public Element createMeasureNode(String name, String caption, String column, String aggregator, String formatString, Element cube) {
        Element element = null;
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)caption) || StringUtils.isEmpty((String)column) || StringUtils.isEmpty((String)aggregator) || StringUtils.isEmpty((String)formatString)) {
            return element;
        }
        element = new Element(MEASURE);
        element.setAttribute(NAME, name);
        element.setAttribute(CAPTION, caption);
        element.setAttribute(COLUMN, column);
        element.setAttribute(AGGREGATOR, aggregator);
        element.setAttribute(FORMATSTRING, formatString);
        if (cube != null) {
            cube.addContent((Content)element);
        }
        return element;
    }
}

