/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.hr.compensation.pojo.dto.AbstractTemptTableDTO;
import com.kingdee.eas.hr.compensation.pojo.dto.InSqlDTO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class HRCmpSqlUtil {
    public static void releaseTemptTable(Context ctx, AbstractTemptTableDTO temptTableDTO) {
        if (temptTableDTO != null && temptTableDTO.getTmpTableName() != null) {
            HRCmpSqlUtil.releaseTemptTable(ctx, temptTableDTO.getTmpTableName());
        }
    }

    public static void releaseTemptTable(Context ctx, String temptTableName) {
        if (temptTableName != null && !"".equals(temptTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(temptTableName);
        }
    }

    public static InSqlDTO createInSql(Context ctx, Collection<String> idColl, String tableName, String fieldName) throws BOSException {
        StringBuffer inSqlBuffer = new StringBuffer();
        if (idColl == null || idColl.size() == 0) {
            inSqlBuffer.append(" ('') ");
            return new InSqlDTO(inSqlBuffer.toString());
        }
        int size = idColl.size();
        if (size <= 500) {
            inSqlBuffer.append(" (");
            boolean isFirst = true;
            for (String id : idColl) {
                if (isFirst) {
                    inSqlBuffer.append("'").append(id).append("'");
                    isFirst = false;
                    continue;
                }
                inSqlBuffer.append(",'").append(id).append("'");
            }
            inSqlBuffer.append(") ");
            return new InSqlDTO(inSqlBuffer.toString());
        }
        String tempTable = HRCmpSqlUtil.getTemptTableName(ctx);
        String creatTable = "select " + fieldName + " tempColumn into " + tempTable + " from " + tableName + " where 1<>1";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        for (String id : idColl) {
            params = new Object[]{id};
            paramList.add(params);
        }
        DbUtil.execute((Context)ctx, (String)creatTable);
        String insertSql = "insert into " + tempTable + "(tempColumn) values(?)";
        HRCmpSqlUtil.executeBatchAndReturn(ctx, insertSql, paramList);
        String inSql = " ( select tmpxq1.tempColumn from " + tempTable + " as tmpxq1 ) ";
        return new InSqlDTO(tempTable, inSql);
    }

    public static String getTemptTableName(Context ctx) {
        String createTempTableName = "TempTableCmpName";
        try {
            createTempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return createTempTableName;
    }

    public static Connection getConnection(Context ctx) throws BOSException {
        if (ctx == null) {
            String mutiMsg = EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.EasHrMultilanResourse", (String)"label12", (Locale)ctx.getLocale());
            throw new BOSException(mutiMsg);
        }
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static int[] executeBatchAndReturn(Context ctx, String sql, List<Object[]> paramsList) throws BOSException {
        PreparedStatement ps;
        Connection conn;
        block12: {
            int[] nArray;
            conn = null;
            ps = null;
            try {
                conn = HRCmpSqlUtil.getConnection(ctx);
                ps = conn.prepareStatement(sql);
                conn.setAutoCommit(false);
                Object[] params = null;
                int k = 1;
                boolean flag = false;
                int[] result = new int[]{};
                int batchSize = 8000;
                for (int i = 0; i < paramsList.size(); ++i) {
                    params = paramsList.get(i);
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j] != null) {
                            ps.setObject(j + 1, params[j]);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.addBatch();
                    if (i == k * batchSize) {
                        flag = true;
                    }
                    if (i <= k * batchSize || !flag) continue;
                    int[] temp = ps.executeBatch();
                    conn.commit();
                    int[] tempresult = new int[result.length + temp.length];
                    if (result.length > 0) {
                        System.arraycopy(temp, 0, tempresult, result.length, temp.length);
                    }
                    System.arraycopy(temp, 0, tempresult, tempresult.length - temp.length, temp.length);
                    result = tempresult;
                    ++k;
                    flag = false;
                    ps.clearBatch();
                }
                if (flag) break block12;
                int[] temp = ps.executeBatch();
                conn.commit();
                int[] tempresult = new int[result.length + temp.length];
                if (result.length > 0) {
                    System.arraycopy(temp, 0, tempresult, result.length, temp.length);
                }
                System.arraycopy(temp, 0, tempresult, tempresult.length - temp.length, temp.length);
                nArray = result = tempresult;
            }
            catch (SQLException exc) {
                try {
                    Object sb = null;
                    Object params = null;
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
                    }
                    throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return nArray;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return new int[0];
    }
}

