/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.compensation.DeptSchemeCollection;
import com.kingdee.eas.hr.compensation.DeptSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.util.DeptInnerSchemePersonHisUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class UpdateDeptInnerSchemePersonHis {
    private static final Logger logger = CoreUIObject.getLogger(UpdateDeptInnerSchemePersonHis.class);

    public boolean oldDeptSchemeUpdateForAll(Context ctx) throws BOSException {
        DeptSchemeCollection deptSchemeColl = DeptSchemeFactory.getLocalInstance(ctx).getDeptSchemeCollection();
        try {
            int size = deptSchemeColl.size();
            for (int i = 0; i < size; ++i) {
                DeptSchemeInfo deptSchemeInfo = deptSchemeColl.get(i);
                this.updateOldDeptSchToHisByCmpSch(ctx, deptSchemeInfo.getId().toString());
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    private void updateOldDeptSchToHisByCmpSch(Context ctx, String depSchmId) throws BOSException, SQLException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select ").append(" T_HR_DeptScheme.fid,").append(" T_HR_DeptSchemeEntry.fid as DeptEntryId,").append(" T_HR_DeptSchemeEntry.FDeptInnerSchemeID as innerSchemeId").append("  from T_HR_DeptScheme  ").append(" inner join T_HR_DeptSchemeEntry on T_HR_DeptSchemeEntry.FDeptSchemeID=T_HR_DeptScheme.fid ").append(" where T_HR_DeptSchemeEntry.FDeptInnerSchemeID is not null  and T_HR_DeptScheme.fid='" + depSchmId + "'");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        String strEntryID = "";
        String strInnerId = "";
        while (irs.next()) {
            strEntryID = irs.getString("DeptEntryId");
            strInnerId = irs.getString("innerSchemeId");
            if (DeptInnerSchemePersonHisUtils.isExitHis(ctx, strEntryID)) continue;
            this.addOldInnerSchPersonToHist(ctx, strEntryID, strInnerId);
        }
    }

    private void addOldInnerSchPersonToHist(Context ctx, String strEntryID, String deptInnerSchemeId) throws BOSException {
        if (deptInnerSchemeId == null) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("DeptInnerScheme.id", (Object)deptInnerSchemeId));
        entityViewInfo.setFilter(filter);
        String metadataStr = "com.kingdee.eas.hr.compensation.app.DepInnerSchemePersonDataForUpdateQuery";
        String personDataSql = DeptInnerSchemePersonHisUtils.getPerson(ctx, entityViewInfo, metadataStr);
        String insertSql = "insert into T_HR_DeptInnerSchemePersonInfo(fid,FDeptInnerSchemeID,FPersonID,FPositionID,fAdminOrgUnitID,FJobGradeID,FDiplomaID)select newbosid('CEF435BB'),'" + strEntryID + "',\"Person.id\", \"PrimaryPosition.id\",\"AdminOrgUnit.id\",\"JOBGRADE.ID\", \"Diploma.id\"    from (" + personDataSql + ")";
        DbUtil.execute((Context)ctx, (String)insertSql);
    }
}

