/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.openapi.app.core.cache.IORMRPCSessionCache;
import com.kingdee.bos.openapi.app.core.cache.impl.ORMRPCSessionCache;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.util.OpenApiConfig;
import com.kingdee.bos.openapi.util.OpenApiUtils;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.concurrent.Callable;

public class SessionUtil {
    private static final String LICENSE_SERVER_LOCATION = "license";
    private static Cache<String, Cache<String, String>> cache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(20L).build();

    public static Context getContext() {
        return ORMRPCSessionCache.getContext();
    }

    public static Context login(String user, String password, String dataCenter, String language, String solution, String userAuthPattern, String clientIp, String appid, String isolation) throws BOSException {
        Context ctx = SessionUtil.getORMRPCBosObject()._login(user, password, dataCenter, language, solution, userAuthPattern, clientIp, appid, isolation);
        ORMRPCSessionCache.setContext(ctx);
        return ctx;
    }

    public static String getTokenId(String user, String password, String dataCenter, String language, String solution, String userAuthPattern, String clientIp, String appid, String isolation) throws BOSException {
        return SessionUtil.getORMRPCBosObject()._getTokenId(user, password, dataCenter, language, solution, userAuthPattern, clientIp, appid, isolation);
    }

    public static Context getContextBySession(String sessionId) throws BOSException {
        Context ctx = SessionUtil.getORMRPCBosObject()._getContextBySession(sessionId);
        ORMRPCSessionCache.setContext(ctx);
        return ctx;
    }

    public static Context getContextByToken(String tokenId) throws BOSException {
        tokenId = tokenId.replaceAll(" ", "+");
        Context ctx = SessionUtil.getORMRPCBosObject()._getContextByToken(tokenId);
        ORMRPCSessionCache.setContext(ctx);
        return ctx;
    }

    private static String getORMRPCServerURL() throws BOSException {
        ORMServiceLocation loc = new ORMServiceLocation(LICENSE_SERVER_LOCATION);
        try {
            return loc.getServiceURL();
        }
        catch (Exception err) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!", (Throwable)err);
        }
    }

    private static IORMRPCSessionCache getORMRPCBosObject() throws BOSException {
        String url = SessionUtil.getORMRPCServerURL();
        ORMRPCSessionCache bosObject = null;
        bosObject = url == null || url.trim().equals("") || url.equalsIgnoreCase("tcp://127.0.0.1") ? new ORMRPCSessionCache() : RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.openapi.app.core.cache.impl.ORMRPCSessionCache", IORMRPCSessionCache.class);
        return bosObject;
    }

    public static String getTokenByLtpa(String appid, String dcName, String signiture, String username, String language, String solution, long ts, String clientIp, String isolation) throws Exception, BOSException {
        String secret = SessionUtil.getSecret(dcName, appid);
        StringBuffer bf = new StringBuffer(appid);
        bf.append(secret);
        bf.append(dcName);
        bf.append(username);
        bf.append(language);
        bf.append(ts);
        String realSigniture = OpenApiUtils.sha1(bf.toString());
        if (signiture.equals(realSigniture)) {
            LtpaToken ltpaToken = LtpaTokenManager.generate((String)username, (String)LtpaTokenManager.getDefaultLtpaConfig());
            String password = SessionUtil.encodePassword(username, ltpaToken.getTokenStr());
            String token = SessionUtil.getTokenId(username, password, dcName, language, solution, "BaseTrdLtpaToken", clientIp, appid, isolation);
            return token;
        }
        throw new Exception("\u767b\u9646\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
    }

    public static String getSecret(String ais, String appid) throws Exception {
        String final_appid;
        String final_ais;
        if (StringUtils.isEmpty((String)ais) || StringUtils.isEmpty((String)appid)) {
            return null;
        }
        Cache aisCache = (Cache)cache.get((Object)ais, (Callable)new Callable<Cache<String, String>>(){

            @Override
            public Cache<String, String> call() throws Exception {
                return CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).build();
            }
        });
        String secret = (String)aisCache.get((Object)appid, (Callable)new Callable<String>(final_ais = ais, final_appid = appid){
            final /* synthetic */ String val$final_ais;
            final /* synthetic */ String val$final_appid;
            {
                this.val$final_ais = string;
                this.val$final_appid = string2;
            }

            @Override
            public String call() throws Exception {
                Context ctx = new Context(null, "eas", this.val$final_ais, null);
                String sql = "select top 1 fsecret from T_API_OpenApiDockingApp where fnumber = ?";
                Object[] params = new Object[]{this.val$final_appid};
                String secret = null;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                secret = rs.next() ? rs.getString(1) : "";
                return secret;
            }
        });
        if (StringUtils.isEmpty((String)secret)) {
            System.out.println("secret is null. appid : " + appid + " ais : " + ais);
        }
        return secret;
    }

    public static String encodePassword(String userName, String password) {
        String encodedPassword = "";
        if (password == null) {
            password = "";
        }
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            e.printStackTrace();
        }
        if (encodedPassword == null) {
            encodedPassword = "";
        }
        return encodedPassword;
    }

    public static String getAppidByToken(String token) throws BOSException {
        return new ORMRPCSessionCache().getAppidByToken(token);
    }

    public static void clearCache(Context ctx) {
        cache.invalidate((Object)ctx.getAIS());
    }

    public static void clearAllCache() {
        cache.cleanUp();
    }

    public static ResultInfo limit(String key, double limiterQPS) throws BOSException {
        String enableLimiter = OpenApiConfig.getProperty("enableLimiter", "false").trim();
        if ("true".equals(enableLimiter)) {
            ResultInfo rs = SessionUtil.getORMRPCBosObject().limit(key, limiterQPS);
            return rs;
        }
        return ResultInfo.STATUS_SUCCESS;
    }
}

