/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.login;

import com.kingdee.bos.openapi.third.ctx.IloginContext;
import com.kingdee.bos.openapi.third.ctx.LTPALogin;
import com.kingdee.bos.openapi.third.invoker.AbstractHttpLoginContext;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class KGSContext
extends AbstractHttpLoginContext {
    protected final KGSHeader loginKgsHeader;
    protected final KGSHeader apiKgsHeader;

    private KGSContext(Builder builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.loginKgsHeader = builder.loginKgsHeader;
        this.apiKgsHeader = builder.apiKgsHeader;
        this.loginContext = builder.loginContext;
        if (builder.isHttps) {
            this.setHttps();
        }
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
    }

    @Override
    public String getUrl() {
        if (this.loginContext instanceof LTPALogin) {
            return "/easopenapilogin/ltpa";
        }
        return "/easopenapilogin/login";
    }

    @Override
    public String getInvokeUrl() {
        return "/easopenapi/api";
    }

    protected Map<String, String> initKGSParams(KGSHeader kgsHeader) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        map.put("X-Api-ClientID", kgsHeader.clienID);
        map.put("X-Api-Auth-Version", kgsHeader.authVersion);
        map.put("X-Api-TimeStamp", String.valueOf(kgsHeader.ts));
        map.put("X-Api-Nonce", kgsHeader.nonce);
        return map;
    }

    @Override
    public Map<String, String> getRequestHeaders() throws Exception {
        Map<String, String> headers = this.initKGSParams(this.loginKgsHeader);
        StringBuffer paramStr = new StringBuffer();
        Map<String, String> map = this.getloginMap();
        for (String key : map.keySet()) {
            paramStr.append(key).append("=").append(map.get(key)).append("&");
        }
        paramStr.deleteCharAt(paramStr.length() - 1);
        String signature = OpenApiTools.generateKGSSignature("GET", this.getUrl(), paramStr.toString(), this.loginKgsHeader.nonce, this.loginKgsHeader.ts, this.loginKgsHeader.secret);
        headers.put("X-Api-Signature", signature);
        return headers;
    }

    @Override
    public Map<String, String> getRequestHeaders4Invoke() throws Exception {
        Map<String, String> headers = this.initKGSParams(this.apiKgsHeader);
        String paramStr = "token=" + URLEncoder.encode(URLEncoder.encode(this.getToken(), "utf-8"), "utf-8");
        String signature = OpenApiTools.generateKGSSignature("POST", this.getInvokeUrl(), paramStr, this.apiKgsHeader.nonce, this.apiKgsHeader.ts, this.apiKgsHeader.secret);
        headers.put("X-Api-Signature", signature);
        return headers;
    }

    public static class KGSHeader {
        private String clienID;
        private String secret;
        private String authVersion = "2.0";
        private long ts;
        private String nonce;

        public KGSHeader(String clienID, String secret, long ts, String nonce) {
            this.clienID = clienID;
            this.secret = secret;
            this.ts = ts;
            this.nonce = nonce;
        }

        public KGSHeader authVersion(String authVersion) {
            this.authVersion = authVersion;
            return this;
        }
    }

    public static class Builder {
        private final KGSHeader loginKgsHeader;
        private final KGSHeader apiKgsHeader;
        private final String ip;
        private final int port;
        private final IloginContext loginContext;
        private boolean isHttps;
        private int connectTimeout = 120000;
        private int readTimeout = 120000;

        public Builder(String ip, int port, KGSHeader loginKgsHeader, KGSHeader apiKgsHeader, IloginContext loginContext) {
            this.loginKgsHeader = loginKgsHeader;
            this.apiKgsHeader = apiKgsHeader;
            this.loginContext = loginContext;
            this.ip = ip;
            this.port = port;
        }

        public Builder https(boolean isHttps) {
            this.isHttps = isHttps;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public KGSContext build() {
            if (OpenApiTools.isEmpty(this.ip)) {
                throw new IllegalArgumentException("Invalid parameters ip");
            }
            if (this.loginContext == null) {
                throw new IllegalArgumentException("Invalid parameters loginContext");
            }
            if (this.loginKgsHeader == null) {
                throw new IllegalArgumentException("Invalid parameters loginKgsHeader");
            }
            if (OpenApiTools.isEmpty(this.loginKgsHeader.clienID)) {
                throw new IllegalArgumentException("Invalid parameters loginKgsHeader.clienID");
            }
            if (OpenApiTools.isEmpty(this.loginKgsHeader.secret)) {
                throw new IllegalArgumentException("Invalid parameters loginKgsHeader.secret");
            }
            if (OpenApiTools.isEmpty(this.loginKgsHeader.nonce)) {
                throw new IllegalArgumentException("Invalid parameters loginKgsHeader.nonce");
            }
            if (this.apiKgsHeader == null) {
                throw new IllegalArgumentException("Invalid parameters apiKgsHeader");
            }
            if (OpenApiTools.isEmpty(this.apiKgsHeader.clienID)) {
                throw new IllegalArgumentException("Invalid parameters apiKgsHeader.clienID");
            }
            if (OpenApiTools.isEmpty(this.apiKgsHeader.secret)) {
                throw new IllegalArgumentException("Invalid parameters apiKgsHeader.secret");
            }
            if (OpenApiTools.isEmpty(this.apiKgsHeader.nonce)) {
                throw new IllegalArgumentException("Invalid parameters apiKgsHeader.nonce");
            }
            return new KGSContext(this);
        }
    }
}

