/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util.json.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.configure.VOUtil;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.openapi.util.ClassUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.BillEntryCustomCollection;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.SortedStringObjectMap;
import com.kingdee.util.ThreadLocalCache;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BosObjectTypeAdapter
implements JsonSerializer<IObjectValue>,
JsonDeserializer<IObjectValue> {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.json.adapter.BosObjectTypeAdapter");
    public static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";
    public Map entityMap = new HashMap();
    private Map<String, List> objectMap = new HashMap<String, List>();
    private static Map<String, Class> typeMap = new HashMap<String, Class>();
    private static String L1_displayName = LocaleUtils.locale_l1.getDisplayName();
    private static String L2_displayName = LocaleUtils.locale_l2.getDisplayName();
    private static String L3_displayName = LocaleUtils.locale_l3.getDisplayName();
    private static ThreadLocal<SimpleDateFormat> sdfLocal = new ThreadLocal();

    public IObjectValue deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        Iterator iterator = jsonObject.entrySet().iterator();
        long s0 = System.currentTimeMillis();
        try {
            String clazzName = type.toString().substring(type.toString().indexOf(" ") + 1);
            Class clazz = this.getClass(clazzName);
            if (clazz == null) {
                throw new Exception("clazzName is invail.clazzName: " + clazzName);
            }
            IObjectValue objectInfo = (IObjectValue)clazz.newInstance();
            if (objectInfo.getBOSType() == null) {
                String bosType = jsonObject.get("bosType").getAsString();
                ((ICommonBOSType)objectInfo).setBOSType(BOSObjectType.create((String)bosType));
            }
            EntityObjectInfo entityInfo = this.getEntityInfo(objectInfo.getBOSType());
            while (iterator.hasNext()) {
                Object result;
                Method method;
                JsonObject customJsonObject;
                String num;
                Map.Entry entry = (Map.Entry)iterator.next();
                if ("hascodingrule".equalsIgnoreCase((String)entry.getKey())) continue;
                JsonElement element = jsonObject.get((String)entry.getKey());
                if (element.toString().equals("") || element.toString().equals("\"\"") || element.toString().equals("\"null\"") || element.toString().equals("\"undefined\"")) {
                    objectInfo.put(((String)entry.getKey()).toString(), null);
                    continue;
                }
                if (entry.getKey() != null && ((String)entry.getKey()).equals("extendedProps")) {
                    JsonElement extendPropValue = jsonObject.get((String)entry.getKey());
                    Map map = (Map)context.deserialize(extendPropValue, SortedStringObjectMap.class);
                    for (String key : map.keySet()) {
                        objectInfo.setExtendedProperty(key, (String)map.get(key));
                    }
                    continue;
                }
                Class dataType = null;
                PropertyInfo simpleProperty = entityInfo.getPropertyByNameRuntime((String)entry.getKey());
                if (simpleProperty != null) {
                    dataType = this.getMetaDataType(entityInfo, simpleProperty);
                }
                if (dataType == null) {
                    JsonElement extendPropValue = jsonObject.get((String)entry.getKey());
                    Object realValue = null;
                    String methodName = "get" + this.getTokenName((String)entry.getKey());
                    Method method2 = null;
                    boolean flag = true;
                    try {
                        method2 = ClassUtil.getMethodIgnoreCaseWithoutParams(clazz, methodName);
                        Class<?> argClazz = method2.getReturnType();
                        realValue = JSONUtils.convertJsonToObject((Context)Kson.getBOSContext(), (String)extendPropValue.toString(), argClazz);
                        flag = false;
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (flag) {
                        String strRealValue;
                        JsonPrimitive jsonPrimitive;
                        realValue = extendPropValue.isJsonPrimitive() ? ((jsonPrimitive = (JsonPrimitive)extendPropValue).isNumber() ? extendPropValue.getAsBigDecimal() : (jsonPrimitive.isBoolean() ? Boolean.valueOf(extendPropValue.getAsBoolean()) : ((strRealValue = extendPropValue.getAsString()).startsWith("{") && strRealValue.endsWith("}") ? Kson.getGson().fromJson(strRealValue, HashMap.class) : (strRealValue.equalsIgnoreCase("true") ? Boolean.TRUE : (strRealValue.equalsIgnoreCase("false") ? Boolean.FALSE : strRealValue))))) : (extendPropValue.isJsonObject() ? context.deserialize(extendPropValue, HashMap.class) : extendPropValue.toString());
                    }
                    objectInfo.put((String)entry.getKey(), realValue);
                    continue;
                }
                if (element.isJsonNull()) {
                    if (dataType.isPrimitive()) continue;
                    objectInfo.put((String)entry.getKey(), null);
                    continue;
                }
                if (this.asSubClass(dataType, String.class)) {
                    boolean isMultiLang = false;
                    if (simpleProperty != null) {
                        OwnPropertyInfo ownP = (OwnPropertyInfo)simpleProperty;
                        isMultiLang = ownP.isMultilingual();
                    }
                    if (isMultiLang) {
                        JsonObject jsonValue = null;
                        if (element.isJsonObject()) {
                            jsonValue = element.getAsJsonObject();
                            for (Map.Entry entity : jsonValue.entrySet()) {
                                String key = (String)entity.getKey();
                                Object value = entity.getValue();
                                value = !(value instanceof JsonNull) ? ((JsonPrimitive)value).getAsString().trim() : null;
                                Locale locale = LocaleUtils.getLocale((String)key);
                                if (Kson.getBOSContext().getLocale().equals(locale)) {
                                    objectInfo.put((String)entry.getKey(), value);
                                }
                                objectInfo.put((String)entry.getKey(), value, locale);
                            }
                            continue;
                        }
                        String strMultiLangValue = element.getAsString().trim();
                        if (this.isMultiLangValueFormat(strMultiLangValue)) {
                            HashMap multiLangPartValue = JSONUtils.convertJsonToObject((Context)Kson.getBOSContext(), (String)strMultiLangValue);
                            for (String key : multiLangPartValue.keySet()) {
                                Object value = multiLangPartValue.get(key);
                                if (value != null) {
                                    objectInfo.put((String)entry.getKey(), value, LocaleUtils.getLocale((String)key));
                                    continue;
                                }
                                objectInfo.put((String)entry.getKey(), null, LocaleUtils.getLocale((String)key));
                            }
                            continue;
                        }
                        objectInfo.put((String)entry.getKey(), (Object)strMultiLangValue, null);
                        continue;
                    }
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsString().trim());
                    continue;
                }
                if (this.asSubClass(dataType, Boolean.class)) {
                    try {
                        if (element instanceof JsonPrimitive && ((JsonPrimitive)element).isBoolean()) {
                            objectInfo.put((String)entry.getKey(), (Object)element.getAsBoolean());
                            continue;
                        }
                        if (element.getAsInt() != 0) {
                            objectInfo.put((String)entry.getKey(), (Object)true);
                            continue;
                        }
                        objectInfo.put((String)entry.getKey(), (Object)false);
                    }
                    catch (NumberFormatException exception) {
                        objectInfo.put((String)entry.getKey(), (Object)element.getAsBoolean());
                    }
                    continue;
                }
                if (this.asSubClass(dataType, Integer.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put((String)entry.getKey(), (Object)new Integer(num));
                    continue;
                }
                if (this.asSubClass(dataType, Long.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put((String)entry.getKey(), (Object)new Long(num));
                    continue;
                }
                if (this.asSubClass(dataType, Float.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)Float.valueOf(element.getAsFloat()));
                    continue;
                }
                if (this.asSubClass(dataType, Double.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsDouble());
                    continue;
                }
                if (this.asSubClass(dataType, BigDecimal.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsBigDecimal());
                    continue;
                }
                if (this.asSubClass(dataType, Date.class)) {
                    String dateValue = element.getAsString();
                    if (dateValue.indexOf("T") >= 0) {
                        dateValue = dateValue.replace("T", " ");
                        dateValue = dateValue.substring(0, dateValue.lastIndexOf("."));
                    }
                    if (dateValue.indexOf(" ") < 0) {
                        dateValue = dateValue + " 00:00:00";
                    }
                    objectInfo.put((String)entry.getKey(), (Object)BosObjectTypeAdapter.getSdf(DATEFORMAT).parse(dateValue));
                    continue;
                }
                if (this.asSubClass(dataType, Timestamp.class)) {
                    Date date = BosObjectTypeAdapter.getSdf(DATEFORMAT).parse(element.getAsString());
                    objectInfo.put((String)entry.getKey(), (Object)date.getTime());
                    continue;
                }
                if (this.asSubClass(dataType, BOSUuid.class)) {
                    if (element.getAsString() == null || element.getAsString().equals("")) continue;
                    objectInfo.put((String)entry.getKey(), (Object)BOSUuid.read((String)element.getAsString()));
                    continue;
                }
                if (this.asSubClass(dataType, BillEntryCustomCollection.class)) {
                    JsonArray jsonArray = element.getAsJsonArray();
                    if (jsonArray == null) continue;
                    BillEntryCustomCollection objectCollection = new BillEntryCustomCollection();
                    String fullName = ((LinkPropertyInfo)simpleProperty).getRelationship().getSupplierObject().getFullName();
                    BOSObjectType bosType = BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)MetaDataPK.create((String)fullName)).getType();
                    objectInfo.put((String)entry.getKey(), (Object)objectCollection);
                    for (int nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                        JsonObject temp = (JsonObject)jsonArray.get(nIndex);
                        temp.addProperty("bosType", bosType.toString());
                        objectCollection.addObject(this.deserialize((JsonElement)temp, this.getEntryValueType((IObjectCollection)objectCollection), context));
                    }
                    continue;
                }
                if (this.asSubClass(dataType, IObjectCollection.class)) {
                    IObjectCollection objectCollection = (IObjectCollection)objectInfo.get((String)entry.getKey());
                    if (objectCollection == null || !element.isJsonArray()) continue;
                    JsonArray jsonArray = element.getAsJsonArray();
                    for (int nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                        objectCollection.addObject(this.deserialize(jsonArray.get(nIndex), this.getEntryValueType(objectCollection), context));
                    }
                    continue;
                }
                if (this.asSubClass(dataType, DataBaseCustomInfo.class)) {
                    customJsonObject = element.getAsJsonObject();
                    if (customJsonObject == null || customJsonObject.get("id").getAsString() == null || customJsonObject.get("id").getAsString().length() <= 0) continue;
                    DataBaseCustomInfo dataBaseCustomInfo = new DataBaseCustomInfo();
                    dataBaseCustomInfo.setId(BOSUuid.read((String)customJsonObject.get("id").getAsString()));
                    objectInfo.put((String)entry.getKey(), (Object)dataBaseCustomInfo);
                    continue;
                }
                if (this.asSubClass(dataType, CoreBillBaseCustomInfo.class)) {
                    customJsonObject = element.getAsJsonObject();
                    if (customJsonObject == null || customJsonObject.get("id") == null || customJsonObject.get("id").getAsString() == null || customJsonObject.get("id").getAsString().length() <= 0) continue;
                    CoreBillBaseCustomInfo coreBillBaseCustomInfo = new CoreBillBaseCustomInfo();
                    coreBillBaseCustomInfo.setId(BOSUuid.read((String)customJsonObject.get("id").getAsString()));
                    objectInfo.put((String)entry.getKey(), (Object)coreBillBaseCustomInfo);
                    continue;
                }
                if (this.asSubClass(dataType, IObjectValue.class)) {
                    String filter;
                    JsonObject tmp = null;
                    if (element.isJsonObject()) {
                        tmp = element.getAsJsonObject();
                    } else {
                        String ele = element.getAsString();
                        try {
                            BOSUuid.read((String)ele);
                            tmp = new JsonObject();
                            tmp.addProperty("id", ele);
                        }
                        catch (Exception e) {
                            logger.error((Object)"\u975e\u5bf9\u8c61\u7c7b\u578b\u65f6\u4ec5\u652f\u6301\u4f20bosuuid\uff0c\u6e90\u6570\u636e\u9519\u8bef", (Throwable)e);
                        }
                    }
                    IObjectValue obv = this.deserialize(element, dataType, context);
                    if ((obv.get("id") == null || "".equals(obv.get("id"))) && (filter = (String)obv.get("filter")) != null && !"".equals(filter)) {
                        Map objectCache = ThreadLocalCache.getRegion((String)"openapi.objectCache");
                        String id = (String)objectCache.get(obv.getBOSType().toString() + filter);
                        if (id != null) {
                            obv.setString("id", id);
                        } else {
                            try {
                                ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)obv.getBOSType(), ICoreBase.class);
                                CoreBaseInfo obvResult = coreBase.getValue("select id " + filter);
                                if (obvResult != null) {
                                    obv.setString("id", obvResult.get("id").toString());
                                    objectCache.put(obv.getBOSType().toString() + filter, obvResult.get("id").toString());
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException("obtain id by filter error " + element, e);
                            }
                        }
                    }
                    objectInfo.put((String)entry.getKey(), (Object)obv);
                    continue;
                }
                if (this.asSubClass(dataType, IntEnum.class)) {
                    method = dataType.getMethod("getEnum", Integer.TYPE);
                    result = null;
                    String num2 = null;
                    if (element.isJsonObject()) {
                        num2 = element.getAsJsonObject().get("value").toString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, Integer.parseInt(num2));
                    } else {
                        num2 = element.getAsString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, Integer.parseInt(num2));
                    }
                    objectInfo.put((String)entry.getKey(), (Object)((IntEnum)result).getValue());
                    continue;
                }
                if (this.asSubClass(dataType, StringEnum.class)) {
                    method = dataType.getMethod("getEnum", String.class);
                    result = null;
                    String str = null;
                    if (element.isJsonObject()) {
                        str = element.getAsJsonObject().get("value").getAsString();
                        if (str.indexOf(".") >= 0) {
                            str = str.substring(0, str.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, str);
                    } else {
                        str = element.getAsString();
                        if (str.indexOf(".") >= 0) {
                            str = str.substring(0, str.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, str);
                    }
                    if (result == null) continue;
                    objectInfo.put((String)entry.getKey(), (Object)((StringEnum)result).getValue());
                    continue;
                }
                if (this.asSubClass(dataType, DynamicEnum.class)) {
                    if (!(simpleProperty instanceof OwnPropertyInfo)) continue;
                    DynamicEnum result2 = null;
                    result2 = element.isJsonObject() ? DynamicEnum.getEnum((String)((OwnPropertyInfo)simpleProperty).getMetaDataRef(), (Object)element.getAsJsonObject().get("value").getAsString()) : DynamicEnum.getEnum((String)((OwnPropertyInfo)simpleProperty).getMetaDataRef(), (Object)element.getAsString());
                    objectInfo.put((String)entry.getKey(), (Object)result2.getValue());
                    continue;
                }
                if (this.asSubClass(dataType, FloatEnum.class)) {
                    method = dataType.getMethod("getEnum", Float.TYPE);
                    result = null;
                    result = element.isJsonObject() ? method.invoke((Object)dataType, Float.valueOf(element.getAsJsonObject().get("value").getAsFloat())) : method.invoke((Object)dataType, Float.valueOf(element.getAsFloat()));
                    objectInfo.put((String)entry.getKey(), result);
                    continue;
                }
                if (!this.asSubClass(dataType, DoubleEnum.class)) continue;
                method = dataType.getMethod("getEnum", Double.TYPE);
                result = null;
                result = element.isJsonObject() ? method.invoke((Object)dataType, element.getAsJsonObject().get("value").getAsDouble()) : method.invoke((Object)dataType, element.getAsDouble());
                objectInfo.put((String)entry.getKey(), result);
            }
            this.log("deserialize " + type.toString() + " : ", System.currentTimeMillis(), s0);
            return objectInfo;
        }
        catch (Exception ex) {
            throw new JsonParseException((Throwable)ex);
        }
    }

    private boolean asSubClass(Class source, Class desc) {
        return desc.isAssignableFrom(source);
    }

    public boolean isMultiLangEntityProperty(BOSObjectType bosObjectType, String property) {
        try {
            SimpleEntity entity;
            long s1 = System.currentTimeMillis();
            if (this.entityMap.containsKey(bosObjectType + "isMultilingual")) {
                entity = (SimpleEntity)this.entityMap.get(bosObjectType + "isMultilingual");
            } else {
                EntitySelect select = new EntitySelect(bosObjectType);
                select.propertySelect().selectOwnProperty(new String[]{"*"}, new String[]{"isMultilingual"});
                entity = MetaDataAccessFactory.getRemoteInstance().select(select);
                this.entityMap.put(bosObjectType + "isMultilingual", entity);
            }
            SimpleProperty propertyObject = entity.property(property);
            long e1 = System.currentTimeMillis();
            this.log("isMultiLangEntityProperty: property " + property, e1, s1);
            return propertyObject != null && propertyObject.getBoolean("isMultilingual");
        }
        catch (BOSException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isMultiLangValueFormat(String text) {
        if (text == null) {
            return false;
        }
        return text.startsWith("{") && text.endsWith("}");
    }

    private Type getEntryValueType(IObjectCollection collection) {
        long s11 = System.currentTimeMillis();
        Class returnType = null;
        String collectionClassName = collection.getClass().getName();
        String entryInfoClassName = collectionClassName.substring(0, collectionClassName.indexOf("Collection"));
        entryInfoClassName = entryInfoClassName + "Info";
        returnType = this.getClass(entryInfoClassName);
        long e11 = System.currentTimeMillis();
        this.log("getEntryValueType: " + ((Object)returnType).toString(), e11, s11);
        return returnType;
    }

    private Object getObjectValue(Object object, Class objectClass, String property) {
        if (object == null) {
            return null;
        }
        try {
            long s1 = System.currentTimeMillis();
            String strMethod = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            String strMethodByBoolean = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method method : objectClass.getMethods()) {
                if (method.getParameterTypes().length > 0 || !method.getName().equalsIgnoreCase(strMethod) && !method.getName().equalsIgnoreCase(strMethodByBoolean)) continue;
                Object ret = method.invoke(object, new Object[0]);
                long e1 = System.currentTimeMillis();
                this.log("getObjectValue: " + property, e1, s1);
                return ret;
            }
            Object ret = this.getObjectValue(object, objectClass.getSuperclass(), property);
            long e1 = System.currentTimeMillis();
            this.log("getObjectValue: " + property, e1, s1);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JsonObject serialize(IObjectValue objectValue, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = null;
        if (objectValue == null) {
            return null;
        }
        try {
            jsonObject = this.convertInfoToJson(context, objectValue, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.objectMap.clear();
        return jsonObject;
    }

    private JsonObject convertInfoToJson(JsonSerializationContext context, IObjectValue objectValue, int level) {
        if (objectValue == null) {
            return null;
        }
        long s0 = System.currentTimeMillis();
        Class<?> objectClazz = objectValue.getClass();
        if (++level > 7) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        BOSObjectType bosType = objectValue.getBOSType();
        jsonObject.addProperty("bosType", objectValue.getBOSType().toString());
        SortedStringObjectMap ssom = (SortedStringObjectMap)objectValue.getExtendedProperties();
        if (ssom.size() > 0) {
            jsonObject.add("extendedProps", context.serialize((Object)ssom, SortedStringObjectMap.class));
        }
        this.log("extendedProps\uff1a" + objectClazz, System.currentTimeMillis(), s0);
        try {
            Enumeration propertyKeys = objectValue.keys();
            this.log("\u5b9e\u4f53 " + objectClazz + " \u5c5e\u6027\u6570\uff1a " + objectValue.size());
            long e0 = System.currentTimeMillis();
            this.log("Json\u8f6c\u6362\u51c6\u5907\uff1a", e0, s0);
            EntityObjectInfo entityInfo = this.getEntityInfo(bosType);
            while (propertyKeys.hasMoreElements()) {
                String propertyKey = (String)propertyKeys.nextElement();
                if (propertyKey != null && (propertyKey.endsWith("_l1") || propertyKey.endsWith("_l2") || propertyKey.endsWith("_l3"))) continue;
                long s1 = System.currentTimeMillis();
                PropertyInfo simpleProperty = entityInfo.getPropertyByNameRuntime(propertyKey);
                this.log("\u83b7\u5f97\u5c5e\u6027\uff1a", System.currentTimeMillis(), s1);
                long s2 = System.currentTimeMillis();
                String key = null;
                if (simpleProperty != null) {
                    key = simpleProperty.getName();
                } else {
                    key = this.getRealByEntity(objectClazz, propertyKey);
                    if (key == null) {
                        key = propertyKey;
                    }
                }
                String realKey = key;
                Object value = objectValue.get(key);
                if (!objectValue.containsKey(key)) continue;
                if (value == null) {
                    OwnPropertyInfo ownP;
                    boolean isMultiLang;
                    jsonObject.add(realKey, null);
                    if (!(simpleProperty instanceof OwnPropertyInfo) || !(isMultiLang = (ownP = (OwnPropertyInfo)simpleProperty).isMultilingual())) continue;
                }
                Class dataType = null;
                dataType = simpleProperty != null ? this.getMetaDataType(entityInfo, simpleProperty) : value.getClass();
                if (dataType == null) continue;
                long e2 = System.currentTimeMillis();
                this.log("\u83b7\u5f97\u8fd4\u56de\u503c\uff1a", e2, s2);
                if (this.asSubClass(dataType, String.class)) {
                    long s3 = System.currentTimeMillis();
                    this.log("\u591a\u8bed\u8a00 " + key + " t1 ", s3, e2);
                    boolean isMultiLang = false;
                    if (simpleProperty != null) {
                        OwnPropertyInfo ownP = (OwnPropertyInfo)simpleProperty;
                        isMultiLang = ownP.isMultilingual();
                    }
                    if (isMultiLang) {
                        long s31 = System.currentTimeMillis();
                        JsonObject jsonValue = new JsonObject();
                        Object v_l1 = objectValue.get(key, LocaleUtils.locale_l1);
                        if (v_l1 != null) {
                            jsonValue.add(L1_displayName, (JsonElement)new JsonPrimitive((String)v_l1));
                        } else {
                            jsonValue.add(L1_displayName, null);
                        }
                        Object v_l2 = objectValue.get(key, LocaleUtils.locale_l2);
                        if (v_l2 != null) {
                            jsonValue.add(L2_displayName, (JsonElement)new JsonPrimitive((String)v_l2));
                        } else {
                            jsonValue.add(L2_displayName, null);
                        }
                        Object v_l3 = objectValue.get(key, LocaleUtils.locale_l3);
                        if (v_l3 != null) {
                            jsonValue.add(L3_displayName, (JsonElement)new JsonPrimitive((String)v_l3));
                        } else {
                            jsonValue.add(L3_displayName, null);
                        }
                        this.log("\u591a\u8bed\u8a00 " + key + " t9 ", System.currentTimeMillis(), s31);
                        jsonObject.add(realKey, (JsonElement)jsonValue);
                    } else {
                        jsonObject.add(realKey, (JsonElement)new JsonPrimitive(value.toString()));
                    }
                    this.log("\u5904\u7406\u5b57\u7b26\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s3);
                    continue;
                }
                if (this.asSubClass(dataType, Number.class)) {
                    long s4 = System.currentTimeMillis();
                    jsonObject.add(realKey, (JsonElement)new JsonPrimitive((Number)value));
                    this.log("\u5904\u7406\u6570\u503c\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s4);
                    continue;
                }
                if (this.asSubClass(dataType, IObjectValue.class)) {
                    ArrayList<Object> objList;
                    long s5 = System.currentTimeMillis();
                    IObjectValue ov = (IObjectValue)value;
                    JsonObject joObj = null;
                    String id = ov.getString("id") + String.valueOf(ov.hashCode());
                    if (this.objectMap.get(id) != null && ov == (objList = this.objectMap.get(id)).get(0)) {
                        joObj = (JsonObject)objList.get(1);
                    }
                    if (joObj == null) {
                        joObj = this.convertInfoToJson(context, (IObjectValue)value, level);
                        objList = new ArrayList<Object>(2);
                        objList.add(value);
                        objList.add(joObj);
                        this.objectMap.put(id, objList);
                    }
                    jsonObject.add(realKey, joObj);
                    this.log("\u5904\u7406\u503c\u5bf9\u8c61\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s5);
                    continue;
                }
                if (this.asSubClass(dataType, Boolean.class)) {
                    long s6 = System.currentTimeMillis();
                    if (value != null) {
                        jsonObject.add(realKey, (JsonElement)new JsonPrimitive((Boolean)value));
                    } else {
                        jsonObject.add(realKey, null);
                    }
                    this.log("\u5904\u7406\u5e03\u5c14\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s6);
                    continue;
                }
                if (this.asSubClass(dataType, IObjectCollection.class)) {
                    long s7 = System.currentTimeMillis();
                    JsonArray jsonValueArray = new JsonArray();
                    IObjectCollection objectCollection = (IObjectCollection)value;
                    for (int nIndex = 0; nIndex < objectCollection.size(); ++nIndex) {
                        IObjectValue entryObject = objectCollection.getObject(nIndex);
                        jsonValueArray.add((JsonElement)this.convertInfoToJson(context, entryObject, level));
                    }
                    jsonObject.add(realKey, (JsonElement)jsonValueArray);
                    this.log("\u5904\u7406\u5bf9\u8c61\u96c6\u5408\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s7);
                    continue;
                }
                if (this.asSubClass(dataType, Enum.class)) {
                    String strAlias;
                    long s8 = System.currentTimeMillis();
                    JsonObject jsonValue = new JsonObject();
                    Enum result = (Enum)this.getObjectValue(objectValue, objectValue.getClass(), key);
                    if (result == null && (result = (Enum)VOUtil.getProperty((IObjectValue)objectValue, (String)key, (BOSObjectType)objectValue.getBOSType(), null)) == null) continue;
                    if (this.asSubClass(dataType, IntEnum.class)) {
                        strAlias = null;
                        strAlias = Kson.getBOSContext().getLocale().equals(LocaleUtils.locale_l1) ? ((IntEnum)result).getName() : ((IntEnum)result).getAlias(Kson.getBOSContext().getOriginLocale());
                        jsonValue.add("isenum", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                        jsonValue.add("alias", (JsonElement)new JsonPrimitive(strAlias));
                        jsonValue.add("value", (JsonElement)new JsonPrimitive((Number)((IntEnum)result).getValue()));
                    } else if (this.asSubClass(dataType, FloatEnum.class)) {
                        strAlias = null;
                        strAlias = Kson.getBOSContext().getLocale().equals(LocaleUtils.locale_l1) ? ((FloatEnum)result).getName() : ((FloatEnum)result).getAlias(Kson.getBOSContext().getOriginLocale());
                        jsonValue.add("isenum", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                        jsonValue.add("alias", (JsonElement)new JsonPrimitive(strAlias));
                        jsonValue.add("value", (JsonElement)new JsonPrimitive((Number)Float.valueOf(((FloatEnum)result).getValue())));
                    } else if (this.asSubClass(dataType, DoubleEnum.class)) {
                        strAlias = null;
                        strAlias = Kson.getBOSContext().getLocale().equals(LocaleUtils.locale_l1) ? ((DoubleEnum)result).getName() : ((DoubleEnum)result).getAlias(Kson.getBOSContext().getOriginLocale());
                        jsonValue.add("isenum", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                        jsonValue.add("alias", (JsonElement)new JsonPrimitive(strAlias));
                        jsonValue.add("value", (JsonElement)new JsonPrimitive((Number)((DoubleEnum)result).getValue()));
                    } else if (this.asSubClass(dataType, StringEnum.class)) {
                        strAlias = null;
                        strAlias = Kson.getBOSContext().getLocale().equals(LocaleUtils.locale_l1) ? ((StringEnum)result).getName() : ((StringEnum)result).getAlias(Kson.getBOSContext().getOriginLocale());
                        jsonValue.add("isenum", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                        jsonValue.add("alias", (JsonElement)new JsonPrimitive(strAlias));
                        jsonValue.add("value", (JsonElement)new JsonPrimitive(((StringEnum)result).getValue()));
                    } else if (this.asSubClass(dataType, DynamicEnum.class)) {
                        strAlias = null;
                        strAlias = Kson.getBOSContext().getLocale().equals(LocaleUtils.locale_l1) ? ((DynamicEnum)result).getName() : ((DynamicEnum)result).getAlias(Kson.getBOSContext().getOriginLocale());
                        jsonValue.add("isenum", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                        jsonValue.add("alias", (JsonElement)new JsonPrimitive(strAlias));
                        jsonValue.add("value", (JsonElement)new JsonPrimitive(((DynamicEnum)result).getValue()));
                    }
                    jsonObject.add(realKey, (JsonElement)jsonValue);
                    this.log("\u5904\u7406\u679a\u4e3e\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s8);
                    continue;
                }
                if (this.asSubClass(dataType, BOSUuid.class)) {
                    long s9 = System.currentTimeMillis();
                    jsonObject.add(realKey, (JsonElement)new JsonPrimitive(value.toString()));
                    this.log("\u5904\u7406UUID\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s9);
                    continue;
                }
                if (this.asSubClass(dataType, Timestamp.class)) {
                    long s10 = System.currentTimeMillis();
                    if (value instanceof String) {
                        jsonObject.add(realKey, (JsonElement)new JsonPrimitive(value.toString()));
                        continue;
                    }
                    jsonObject.add(realKey, (JsonElement)new JsonPrimitive(BosObjectTypeAdapter.getSdf(DATEFORMAT).format((Date)value)));
                    this.log("\u5904\u7406\u65f6\u95f4\u6233\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s10);
                    continue;
                }
                if (this.asSubClass(dataType, Date.class)) {
                    long s11 = System.currentTimeMillis();
                    if (value instanceof String) {
                        jsonObject.add(realKey, (JsonElement)new JsonPrimitive(value.toString()));
                    } else {
                        jsonObject.add(realKey, (JsonElement)new JsonPrimitive(BosObjectTypeAdapter.getSdf(DATEFORMAT).format((Date)value)));
                    }
                    this.log("\u5904\u7406\u65f6\u95f4\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s11);
                    continue;
                }
                long s12 = System.currentTimeMillis();
                jsonObject.add(realKey, context.serialize(value));
                this.log("\u5904\u7406\u5176\u4ed6\u7c7b\u578b\uff1a[" + realKey + "]", System.currentTimeMillis(), s12);
            }
        }
        catch (Exception exception) {
            throw new JsonParseException((Throwable)exception);
        }
        this.log("convertInfoToJson: " + objectValue.getClass().toString(), System.currentTimeMillis(), s0);
        return jsonObject;
    }

    private String getRealByEntity(Class clazz, String property) {
        if (clazz == null || property == null || property.equals("")) {
            return null;
        }
        long s1 = System.currentTimeMillis();
        Method[] methods = clazz.getDeclaredMethods();
        String strOldKey = "get" + property;
        String strOldKeyByBoolean = "is" + property;
        for (Method method : methods) {
            if (method.getName().equalsIgnoreCase(strOldKey)) {
                String fieldName = method.getName().substring(3);
                return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
            }
            if (!method.getName().equalsIgnoreCase(strOldKeyByBoolean)) continue;
            String fieldName = method.getName().substring(2);
            return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        }
        String sRet = this.getRealByEntity(clazz.getSuperclass(), property);
        long e1 = System.currentTimeMillis();
        this.log("getRealByEntity: " + property, e1, s1);
        return sRet;
    }

    private EntityObjectInfo getEntityInfo(BOSObjectType bosType) {
        long s1 = System.currentTimeMillis();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        this.log("getEntityInfo: " + bosType + " t1: ", System.currentTimeMillis(), s1);
        return entityInfo;
    }

    private Class getMetaDataType(EntityObjectInfo parentEntityInfo, PropertyInfo propertyInfo) {
        long s1 = System.currentTimeMillis();
        Class type = null;
        if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownP = (OwnPropertyInfo)propertyInfo;
            DataType dataType = ownP.getDataType();
            type = dataType.equals((Object)DataType.STRING) ? String.class : (dataType.equals((Object)DataType.INTEGER) ? Integer.class : (dataType.equals((Object)DataType.FLOAT) ? Float.class : (dataType.equals((Object)DataType.DOUBLE) ? Double.class : (dataType.equals((Object)DataType.BOOLEAN) ? Boolean.class : (dataType.equals((Object)DataType.ENUM) ? (ownP.getEnumType(MDHostType.RUNTIME) == null || ownP.getEnumType(MDHostType.RUNTIME).isDynamic() ? DynamicEnum.class : this.getClass(ownP.getEnumType(MDHostType.RUNTIME).getFullName())) : this.getClass(dataType.getJavaTypeName()))))));
        } else if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkP = (LinkPropertyInfo)propertyInfo;
            RelationshipInfo ri = linkP.getRelationship();
            String strDataType = null;
            EntityObjectInfo childInfo = ri.getChildObject(parentEntityInfo);
            CardinalityType cardType = ri.getChildCardinality(parentEntityInfo);
            strDataType = CardinalityType.isUnbounded((CardinalityType)cardType) ? childInfo.getObjectCollectionClass() : childInfo.getObjectValueClass();
            type = this.getClass(strDataType);
        }
        this.log("getMetaDataType: " + propertyInfo + " t: ", System.currentTimeMillis(), s1);
        return type;
    }

    private Class getClass(String className) {
        Class<?> type = typeMap.get(className);
        if (type == null) {
            try {
                type = Class.forName(className);
                typeMap.put(className, type);
            }
            catch (ClassNotFoundException exception) {
                logger.error((Object)exception);
            }
        }
        return type;
    }

    public void log(String msg, long end, long start) {
        if (end - start > 1L) {
            logger.debug((Object)(msg + " t:" + (end - start)));
        }
    }

    public void log(String msg) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)msg);
        }
    }

    public static SimpleDateFormat getSdf(String formatPattern) {
        SimpleDateFormat sdf = sdfLocal.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat(formatPattern);
            sdfLocal.set(sdf);
        }
        return sdf;
    }

    private String getTokenName(String propertyName) {
        String rtn = "";
        rtn = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return rtn;
    }
}

