/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.DataSource;
import com.kingdee.shr.base.bizmanage.ISHRPersonBizManage;
import com.kingdee.shr.base.bizmanage.ItemState;
import com.kingdee.shr.base.bizmanage.PersonBURelationCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.bizmanage.constant.BizManageMsgConstants;
import com.kingdee.shr.base.bizmanage.util.BatchPromptsInfo;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageHelpUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SHRPersonBizManageImpl
implements ISHRPersonBizManage {
    @Override
    public IObjectPK addNewPersonBizManage(Context ctx, PersonBURelationInfo info) throws BOSException, EASBizException {
        if (!SHRPersonBizManageImpl.checkPersonBURelationExist(ctx, info.getEmpOrgRelation().getId().toString(), info.getPerson().getId().toString(), info.getBizManageType().getId().toString(), info.getHrOrgUnit().getId().toString(), "0,1")) {
            info.setState(BizManageState.New);
            info.setItemState(ItemState.unsubmit);
            boolean isDefault = SHRBizManageHelpUtil.isPerosnBuRelationDefault(ctx, info.getBizManageType().getId().toString(), info.getEmpOrgRelation().getId().toString(), info.getHrOrgUnit().getId().toString());
            info.setUseDefault(isDefault);
            if (info.getDataSource() == null) {
                info.setDataSource(DataSource.ChangeOperation);
            }
            return PersonBURelationFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        return null;
    }

    @Override
    public IObjectPK[] batchAddNewPersonBizManage(Context ctx, List<PersonBURelationInfo> list) throws BOSException, EASBizException {
        CoreBaseCollection coll = new CoreBaseCollection();
        for (PersonBURelationInfo info : list) {
            if (SHRPersonBizManageImpl.checkPersonBURelationExist(ctx, info.getEmpOrgRelation().getId().toString(), info.getPerson().getId().toString(), info.getBizManageType().getId().toString(), info.getHrOrgUnit().getId().toString(), "0,1")) continue;
            info.setState(BizManageState.New);
            info.setItemState(ItemState.unsubmit);
            boolean isDefault = SHRBizManageHelpUtil.isPerosnBuRelationDefault(ctx, info.getBizManageType().getId().toString(), info.getEmpOrgRelation().getId().toString(), info.getHrOrgUnit().getId().toString());
            info.setUseDefault(isDefault);
            if (info.getDataSource() == null) {
                info.setDataSource(DataSource.ChangeOperation);
            }
            coll.add((CoreBaseInfo)info);
        }
        return PersonBURelationFactory.getLocalInstance(ctx).addnewBatchData(coll);
    }

    public static boolean checkPersonBURelationExist(Context ctx, String empOrgRelationID, String personID, String bizManageTypeID, String hrOrgUnitID, String state) throws BOSException, EASBizException {
        boolean result = false;
        String sql = "SELECT FID FROM T_HR_PersonBURelation WHERE FEmpOrgRelationID = '" + empOrgRelationID + "' AND FPERSONID = '" + personID + "' AND FBizManageTypeID = '" + bizManageTypeID + "' AND FHrOrgUnitID = '" + hrOrgUnitID + "' AND FState IN (" + state + ")";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (executeQuery.size() > 0) {
            result = true;
        }
        return result;
    }

    @Override
    public Map batchSubmitPersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        for (int i = 0; i < list.size(); ++i) {
            String id = list.get(i);
            PersonBURelationInfo info = new PersonBURelationInfo();
            PersonBURelationCollection coll = PersonBURelationFactory.getLocalInstance(ctx).getPersonBURelationCollection("select *,empOrgRelation.*,empPostExpHis.* where id = '" + id + "'");
            info = coll.get(0);
            boolean isDefault = false;
            if (info.getEmpOrgRelation() != null) {
                isDefault = SHRBizManageHelpUtil.isPerosnBuRelationDefault(ctx, info.getBizManageType().getId().toString(), info.getEmpOrgRelation().getId().toString(), info.getHrOrgUnit().getId().toString());
            } else if (info.getEmpPostExpHis() != null && info.getEmpPostExpHis().getAdminOrg() != null) {
                String adminOrgUnitID = info.getEmpPostExpHis().getAdminOrg().getId().toString();
                if (info.getHrOrgUnit().getId().toString().equals(SHRBizManageHelpUtil.getEnableAdminBuRelation(ctx, adminOrgUnitID, info.getBizManageType().getId().toString()))) {
                    isDefault = true;
                }
            }
            info.setUseDefault(isDefault);
            PersonBURelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        }
        this.batchUpdateItemState(ctx, list, 1);
        return null;
    }

    @Override
    public Map batchDeletePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        if (list.isEmpty()) {
            return null;
        }
        String deleteSql = "delete from T_HR_PersonBURelation where fid in " + SHRBizManageCommonTool.list2SQLinclude(list);
        DbUtil.execute((Context)ctx, (String)deleteSql);
        String deleteHISSql = "delete from T_HR_PersonBURelationHIS where FHistoryRelateID in " + SHRBizManageCommonTool.list2SQLinclude(list);
        DbUtil.execute((Context)ctx, (String)deleteHISSql);
        return null;
    }

    @Override
    public Map batchDisablePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        if (list.isEmpty()) {
            return null;
        }
        String disableSql = "update T_HR_PersonBURelation set FState = 2,FendDate = curDate() where fid in " + SHRBizManageCommonTool.list2SQLinclude(list) + " and FendDate is null";
        DbUtil.execute((Context)ctx, (String)disableSql);
        return null;
    }

    @Override
    public Map batchEnablePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        String enableSql;
        if (list.isEmpty()) {
            return null;
        }
        String idString = SHRBizManageCommonTool.list2SQLinclude(list);
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT  enableBURela.fid FROM T_HR_PersonBURelation mainBuRela ").append("  inner join T_HR_EMPORGRELATION posRela on mainBuRela.FEMPORGRELATIONID=posRela.fid ").append("  inner join (SELECT X.FID,X.FPERSONID,Y.FPOSITIONID,X.FBIZMANAGETYPEID,X.FSTATE FROM T_HR_PersonBURelation X,T_HR_EMPORGRELATION Y WHERE X.FEMPORGRELATIONID = Y.FID ) enableBURela ").append("    on mainBuRela.FPERSONID=enableBURela.FPERSONID and posRela.FPOSITIONID=enableBURela.FPOSITIONID and posRela.FPERSONID=enableBURela.FPERSONID and mainBuRela.FBIZMANAGETYPEID=enableBURela.FBIZMANAGETYPEID").append("  where mainBuRela.FBIZMANAGETYPEID=enableBURela.FBIZMANAGETYPEID and mainBuRela.fid in ").append(idString).append(" \tand enableBURela.FSTATE=").append(1).append(" \tand enableBURela.fid<>mainBuRela.fid");
        IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            ArrayList<String> disableIdList = new ArrayList<String>();
            while (ir.next()) {
                disableIdList.add(ir.getString("fid"));
                this.batchDisablePersonBizManage(ctx, disableIdList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        StringBuffer getDefaultSql = new StringBuffer();
        getDefaultSql.append("select buRela.fid from T_HR_PersonBURelation buRela").append(" inner join T_HR_EMPORGRELATION rela on rela.fid=buRela.FEmpOrgRelationID").append(" inner join T_HR_AdminOrgBURelation orgBURela on orgBURela.FAdminOrgID=rela.FAdminOrgID").append(" where orgBURela.FState = 1 and buRela.FBIZMANAGETYPEID=orgBURela.FBIZMANAGETYPEID and orgBURela.FManageHrOrgID=buRela.FHrOrgUnitID and buRela.fid in ").append(idString);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getDefaultSql.toString());
        ArrayList<String> isDefaultList = new ArrayList<String>();
        try {
            while (rs.next()) {
                isDefaultList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        list.removeAll(isDefaultList);
        if (!isDefaultList.isEmpty()) {
            enableSql = "update T_HR_PersonBURelation set fitemstate=2,FState = 1,FUseDefault = 1,FEndDate = null where fid in " + SHRBizManageCommonTool.list2SQLinclude(isDefaultList);
            DbUtil.execute((Context)ctx, (String)enableSql);
        }
        if (!list.isEmpty()) {
            enableSql = "update T_HR_PersonBURelation set fitemstate=2,FState = 1,FUseDefault = 0,FEndDate = null where fid in " + SHRBizManageCommonTool.list2SQLinclude(list);
            DbUtil.execute((Context)ctx, (String)enableSql);
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append("T_HR_PersonBURelation").append(" set FbeginDate = curdate() where fid in ").append(idString).append(" and FbeginDate is null");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        return null;
    }

    public boolean isUseDefault(Context ctx, PersonBURelationInfo personBURelationInfo) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrgInfo = personBURelationInfo.getEmpOrgRelation().getAdminOrg();
        String adminOrgUnitId = adminOrgInfo == null ? null : adminOrgInfo.getId().toString();
        String bizManageTypeId = personBURelationInfo.getBizManageType().getId().toString();
        HROrgUnitInfo currentHrOrg = personBURelationInfo.getHrOrgUnit();
        HROrgUnitInfo orgManageHrOrg = SHRBizManageCommonTool.getCurrentManageOrg(ctx, adminOrgUnitId, bizManageTypeId);
        String currentHrOrgId = currentHrOrg.getId().toString();
        String orgManageHrOrgId = orgManageHrOrg == null ? null : orgManageHrOrg.getId().toString();
        boolean useDefault = false;
        if (currentHrOrgId.equals(orgManageHrOrgId)) {
            useDefault = true;
        }
        return useDefault;
    }

    @Override
    public Map batchReceivePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        for (int i = 0; i < list.size(); ++i) {
            String id = list.get(i);
            PersonBURelationInfo info = new PersonBURelationInfo();
            PersonBURelationCollection coll = PersonBURelationFactory.getLocalInstance(ctx).getPersonBURelationCollection("select * where id = '" + id + "'");
            info = coll.get(0);
            boolean isDefault = SHRBizManageHelpUtil.isPerosnBuRelationDefault(ctx, info.getBizManageType().getId().toString(), info.getEmpOrgRelation().getId().toString(), info.getHrOrgUnit().getId().toString());
            info.setUseDefault(isDefault);
            PersonBURelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        }
        this.batchUpdateItemState(ctx, list, 2);
        this.afterReceivePersonBizManage(ctx, list);
        return null;
    }

    protected void afterReceivePersonBizManage(Context ctx, List<String> list) throws EASBizException, BOSException {
        this.batchEnablePersonBizManage(ctx, list);
    }

    @Override
    public Map batchRefusePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        this.batchUpdateItemState(ctx, list, 3);
        return null;
    }

    @Override
    public Map batchReversePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        this.batchUpdateItemState(ctx, list, 0);
        return null;
    }

    public Map batchRecallPersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        this.batchUpdateItemState(ctx, list, 0);
        return null;
    }

    private void batchUpdateItemState(Context ctx, List<String> list, int itemStateValue) throws BOSException {
        if (list.isEmpty()) {
            return;
        }
        if (list.size() <= 200) {
            this.batchUpdateItemStateBySingleStmt(ctx, list, itemStateValue);
        } else {
            this.batchUpdateItemStateByMultiStmt(ctx, list, itemStateValue);
        }
    }

    private void batchUpdateItemStateBySingleStmt(Context ctx, List<String> list, int itemStateValue) throws BOSException {
        String updateSql = "update T_HR_PersonBURelation set FItemState = " + itemStateValue + ",FDataSource = 0 where fid in " + SHRBizManageCommonTool.list2SQLinclude(list);
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void batchUpdateItemStateByMultiStmt(Context ctx, List<String> list, int itemStateValue) throws BOSException {
        String updateSql = "update T_HR_PersonBURelation set FItemState = " + itemStateValue + ",FDataSource = 0 where fid = ?";
        Object[] tempObjectArray = new Object[1];
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        for (String item : list) {
            tempObjectArray[0] = item;
            param.add(tempObjectArray);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, param);
    }

    public Map deletePersonBizManageByPersonId(Context ctx, List<String> personIdList, String bizManageTypeId, boolean isEmpInitDelete) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("delete from ").append("T_HR_PersonChangeMsg").append(" where fPersonID in ").append(SHRBizManageCommonTool.list2SQLinclude(personIdList));
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        deleteSql = new StringBuffer();
        deleteSql.append("delete from ").append("T_HR_PersonBURelaConfirm").append(" where fPersonID in ").append(SHRBizManageCommonTool.list2SQLinclude(personIdList)).append(" and FBizManageTypeID='").append(bizManageTypeId).append("'");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        deleteSql = new StringBuffer();
        deleteSql.append("delete from ").append("T_HR_PersonBURelation").append(" where fPersonID in ").append(SHRBizManageCommonTool.list2SQLinclude(personIdList)).append(" and FBizManageTypeID='").append(bizManageTypeId).append("'");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        deleteSql = new StringBuffer();
        deleteSql.append("delete from ").append("T_HR_PersonBURelationHIS").append(" where fPersonID in ").append(SHRBizManageCommonTool.list2SQLinclude(personIdList)).append(" and FBizManageTypeID='").append(bizManageTypeId).append("'");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        return resultMap;
    }

    @Override
    public List<BatchPromptsInfo> checkBeforeDeletePersonBizManageByPersonId(Context ctx, List<String> personIdList, String bizManageTypeId, boolean isEmpInitDelete) throws BOSException, EASBizException {
        return new ArrayList<BatchPromptsInfo>();
    }

    @Override
    public Map<String, String> recoverPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        ArrayList<String> nowEmpRelaIdList = new ArrayList<String>();
        String sql = "select fid from T_HR_EmpOrgRelation where fid in " + SHRBizManageCommonTool.list2SQLinclude(empRelaIdList) + " and FFlowOutAffairID is null";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                nowEmpRelaIdList.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (nowEmpRelaIdList.size() > 0) {
            String disableSql = "update T_HR_PersonBURelation set FState = 2,FendDate = curDate() where FEMPORGRELATIONID in " + SHRBizManageCommonTool.list2SQLinclude(nowEmpRelaIdList) + " and FendDate is null AND FBIZMANAGETYPEID = '" + bizManageTypeId + "'";
            DbUtil.execute((Context)ctx, (String)disableSql);
        }
        return new HashMap<String, String>();
    }

    @Override
    public List<BatchPromptsInfo> checkBeforeRecoverPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        return new ArrayList<BatchPromptsInfo>();
    }

    @Override
    public Map<String, String> enablePrePersonBizManageByBURelaDataId(Context ctx, List<String> personBURelaIdList, List<String> preBuRelationIdList, String bizManageTypeId) throws BOSException, EASBizException {
        Map result = this.batchEnablePersonBizManage(ctx, preBuRelationIdList);
        return result;
    }

    @Override
    public Map<String, String> enrollErrorModifyPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_PersonBURelation where FEmpOrgRelationID in (").append(" select fid from T_HR_EmpOrgRelation where fid in ").append(SHRBizManageCommonTool.list2SQLinclude(empRelaIdList)).append(" and FFlowOutAffairID is null").append(")").append(" and FBizManageTypeID='").append(bizManageTypeId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> personBURelaDelIdList = new ArrayList<String>();
        ArrayList<String> preBuRelationIdList = new ArrayList<String>();
        preBuRelationIdList.addAll(personBURelaIdList);
        try {
            while (rs.next()) {
                String empBURelaId = rs.getString("fid");
                if (StringUtils.isEmpty((String)empBURelaId)) continue;
                personBURelaDelIdList.add(empBURelaId);
                preBuRelationIdList.remove(empBURelaId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.batchDeletePersonBizManage(ctx, personBURelaDelIdList);
        return new HashMap<String, String>();
    }

    @Override
    public List<BatchPromptsInfo> checkBeforeEnrollErrorModifyPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        return new ArrayList<BatchPromptsInfo>();
    }

    @Override
    public Map batchAddAndEnablePersonInitBizManage(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        String tmpConfirmTblName = (String)param.get(BizManageMsgConstants.PARAM_PERSON_INIT_CONFIRM_MSGTBL_NAME);
        String bizManageTypeId = (String)param.get(BizManageMsgConstants.BIZ_MANAGE_TYPE_ID);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_hr_personburelation(FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FState, FItemState,FUseDefault, ").append(" FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FID, FComfirmMsgId,FEFFDT, FIsEmpInit,FDataSource)").append(" select buConfirm.fpersonID,buConfirm.FNewEmpOrgRelationID,buConfirm.FNewEmpPostExpHisID,buConfirm.FBizManageTypeID,buConfirm.FNewHrOrgUnitID, CURDATE(),1,2,1,").append(" buConfirm.FCreatorID, buConfirm.FCreateTime, buConfirm.FLastUpdateUserID, buConfirm.FLastUpdateTime,buConfirm.FControlUnitID,newbosid('9F35F085'),buConfirm.fid,buConfirm.FChangeDate,buConfirm.FIsEmpInit,1").append(" FROM T_HR_PersonBURelaConfirm buConfirm where FBizManageTypeID='").append(bizManageTypeId).append("'").append(" and buConfirm.fid in (select fid from ").append(tmpConfirmTblName).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_PersonBURelaConfirm set FDealState=1 where FBizManageTypeID='").append(bizManageTypeId).append("' and fid in (select fid from ").append(tmpConfirmTblName).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return new HashMap();
    }

    @Override
    public Map batchDisablePersonBizManageInfoList(Context ctx, List<PersonBURelationInfo> list) throws BOSException, EASBizException {
        if (list.isEmpty()) {
            return null;
        }
        CoreBaseCollection coll = new CoreBaseCollection();
        PersonBURelationInfo buRelaInfo = null;
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            buRelaInfo = list.get(i);
            buRelaInfo.setState(BizManageState.Disable);
            if (buRelaInfo.getEndDate() == null) {
                buRelaInfo.setEndDate(curDate);
            }
            coll.add((CoreBaseInfo)buRelaInfo);
        }
        PersonBURelationFactory.getLocalInstance(ctx).updateBatchData(coll);
        return new HashMap();
    }
}

