/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationCollection;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationFactory;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationInfo;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.OrgManageInitRptCollection;
import com.kingdee.shr.base.bizmanage.OrgManageInitRptFactory;
import com.kingdee.shr.base.bizmanage.OrgManageInitRptInfo;
import com.kingdee.shr.base.bizmanage.app.AbstractSHROrgManageInitFacadeControllerBean;
import com.kingdee.shr.base.bizmanage.constant.ManageInitContants;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SHROrgManageInitFacadeControllerBean
extends AbstractSHROrgManageInitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.bizmanage.app.SHROrgManageInitFacadeControllerBean");

    @Override
    protected void _startAdminOrgMangeInit(Context ctx) throws BOSException, EASBizException {
        try {
            if (!SHRBizManageCommonTool.isCompleteGenerateAdminOrgManageReport(ctx)) {
                this._generateAdminOrgManageReport(ctx);
            }
            if (!SHRBizManageCommonTool.isCompleteGenerateAdminOrgManageReport(ctx)) {
                this._setCompleteInitFlag(ctx);
            } else {
                this.doInitAdminOrgManageTable(ctx);
                this._clearAdminOrgManageReport(ctx);
                this._setCompleteInitFlag(ctx);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected void _setCompleteInitFlag(Context ctx) throws BOSException, EASBizException {
        if (SHRBizManageCommonTool.isCompleteManageInit(ctx)) {
            return;
        }
        SHRBizManageCommonTool.setCompleteManageInit(ctx);
    }

    @Override
    protected void _generateAdminOrgManageReport(Context ctx) throws BOSException, EASBizException {
        String[] bizManageType = this.getEnableBizManageTypeIdArray(ctx);
        ArrayList orgList = this.getAdminOrgBaseData(ctx);
        this.generateAdminOrgManageReport(ctx, orgList, bizManageType);
    }

    @Override
    protected void _clearAdminOrgManageReport(Context ctx) throws BOSException, EASBizException {
        this.truncateReportTable(ctx);
    }

    private void truncateReportTable(Context ctx) throws BOSException {
        SHRBizManageCommonTool.truncateTable(ctx, ManageInitContants.REPORT_TABLE);
    }

    private void doInitAdminOrgManageTable(Context ctx) throws BOSException, EASBizException {
        OrgManageInitRptCollection coll = this.getReportData(ctx);
        CoreBaseCollection coreColl = this.transOrgManageColl2AdminOrgMangeColl(ctx, coll);
        this.saveAdminOrgMangeColl(ctx, coreColl);
    }

    private OrgManageInitRptCollection getReportData(Context ctx) throws BOSException {
        OrgManageInitRptCollection coll = OrgManageInitRptFactory.getLocalInstance(ctx).getOrgManageInitRptCollection(" where source is null");
        return coll;
    }

    private CoreBaseCollection transOrgManageColl2AdminOrgMangeColl(Context ctx, OrgManageInitRptCollection coll) {
        CoreBaseCollection coreColl = new CoreBaseCollection();
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        Date now = new Date();
        for (int i = 0; i < coll.size(); ++i) {
            OrgManageInitRptInfo item = coll.get(i);
            AdminOrgBURelationInfo info = new AdminOrgBURelationInfo();
            info.setAdminOrg(item.getAdminOrg());
            info.setBizManageType(item.getBizManageType());
            info.setManageHrOrg(item.getManageHrOrg());
            info.setBeginDate(DateTimeUtils.truncateDate((Date)new Date()));
            info.setIsDefaultManage(item.isIsDefaultManage());
            info.setState(BizManageState.Enable);
            info.setCreator(currentUser);
            info.setLastUpdateUser(currentUser);
            info.setLastUpdateTime(new Timestamp(now.getTime()));
            info.setCreateTime(new Timestamp(now.getTime()));
            coreColl.add((CoreBaseInfo)info);
        }
        return coreColl;
    }

    private void saveAdminOrgMangeColl(Context ctx, CoreBaseCollection coreColl) throws EASBizException, BOSException {
        AdminOrgBURelationFactory.getLocalInstance(ctx).saveBatchData(coreColl);
    }

    private String[] getEnableBizManageTypeIdArray(Context ctx) throws BOSException {
        String[] s = SHRBizManageCommonTool.getEnableBizManageTypeIdArray(ctx);
        return s;
    }

    private ArrayList getAdminOrgBaseData(Context ctx) throws BOSException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT A.FID,A.FNUMBER,A.FISHRORGUNIT,A.FLEVEL,A.FPARENTID,A.FCOMPANYID,A.FisStartSHR").append(" ,(CASE WHEN B.FISHRORGUNIT = 1 AND C.FIsSealUp = 0 THEN A.FID ELSE NULL END) FMANAGEHRORGID ").append(" FROM T_ORG_ADMIN A").append(" LEFT JOIN T_ORG_BASEUNIT B  ON A.FID = B.FID ").append(" LEFT JOIN T_ORG_HRO C ON A.FID = C.FID ").append(" WHERE  A.FISSEALUP = 0 AND A.FISSTARTSHR = 1").append(" ORDER BY A.FLEVEL,A.FNUMBER ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)query.toString());
        ArrayList<String[]> resultArray = new ArrayList<String[]>();
        try {
            while (result.next()) {
                String[] s = new String[]{result.getString("FID"), result.getString("FNUMBER"), result.getString("FISHRORGUNIT"), result.getString("FLEVEL"), result.getString("FPARENTID"), result.getString("FCOMPANYID"), result.getString("FisStartSHR"), result.getString("FMANAGEHRORGID")};
                resultArray.add(s);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("getAdminOrgBaseData failed.");
        }
        return resultArray;
    }

    private void generateAdminOrgManageReport(Context ctx, ArrayList<String[]> orgArray, String[] bizManageType) throws BOSException, EASBizException {
        ArrayList<String> batchSQL = this.generateAdminOrgManageReportBatchSQL(ctx, orgArray, bizManageType);
        ArrayList<String> existingEnableOrgManageRelation = this.getExistingEnableOrgManageRelation(ctx);
        this.enableOrgManageRelationFilter(batchSQL, existingEnableOrgManageRelation);
        AdminOrgBURelationCollection adminOrgBURelationColl = this.getExistingNewOrgManageRelationColl(ctx);
        CoreBaseCollection insertColl = this.newOrgManageRelationFilter(batchSQL, adminOrgBURelationColl);
        SHRBizManageCommonTool.batchInsertReportDataSQL(ctx, batchSQL);
        this.batchInsertReportDataColl(ctx, insertColl);
    }

    private void batchInsertReportDataColl(Context ctx, CoreBaseCollection insertColl) throws EASBizException, BOSException {
        OrgManageInitRptFactory.getLocalInstance(ctx).saveBatchData(insertColl);
    }

    private ArrayList<String> generateAdminOrgManageReportBatchSQL(Context ctx, ArrayList<String[]> orgArray, String[] bizManageType) throws EASBizException, BOSException {
        int currentlevel = 1;
        HashMap parentsNodes = new HashMap();
        HashMap<String, String[]> currentNodes = new HashMap<String, String[]>();
        HashMap<String, String> parentManageMap = new HashMap<String, String>();
        String[] Node2 = new String[3];
        ArrayList<String> batchSQL = new ArrayList<String>();
        int isDefaultManage = 1;
        for (int i = 0; i < orgArray.size(); ++i) {
            String[] item = orgArray.get(i);
            String id = item[0];
            int level = Integer.parseInt(item[3]);
            String parentId = item[4];
            String isStartSHR = item[6];
            String managehrorgId = item[7];
            if (level > currentlevel) {
                parentsNodes.putAll(currentNodes);
                currentNodes.clear();
                currentlevel = level;
            }
            if (StringUtils.isEmpty((String)managehrorgId)) {
                if (level == 1) {
                    managehrorgId = id;
                } else {
                    String tempParentId = parentId;
                    AdminOrgUnitInfo temp = null;
                    while (!parentsNodes.containsKey(tempParentId)) {
                        temp = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(tempParentId));
                        tempParentId = temp.getParent().getId().toString();
                    }
                    while (parentsNodes.containsKey(tempParentId) && parentsNodes.get(parentId) != null && ((String[])parentsNodes.get(parentId))[2] == "0") {
                        tempParentId = ((String[])parentsNodes.get(tempParentId))[1];
                    }
                    managehrorgId = (String)parentManageMap.get(tempParentId);
                }
            }
            parentManageMap.put(id, managehrorgId);
            Node2[0] = managehrorgId;
            Node2[1] = parentId;
            Node2[2] = isStartSHR;
            currentNodes.put(id, Node2);
            String companyId = "";
            if (!StringUtils.isEmpty((String)item[5])) {
                companyId = item[5];
            }
            int isSameCompany = companyId.equals(managehrorgId) ? 1 : 0;
            Object[] insertSql = this.generateOrgManageInitSqlByBizType(ctx, id, managehrorgId, isDefaultManage, isSameCompany, bizManageType);
            batchSQL.addAll(Arrays.asList((Object[])insertSql));
        }
        return batchSQL;
    }

    private void enableOrgManageRelationFilter(ArrayList<String> batchSQL, ArrayList<String> existingEnableOrgManageRelation) {
        if (existingEnableOrgManageRelation.isEmpty()) {
            return;
        }
        for (int i = 0; i < batchSQL.size(); ++i) {
            String itemSQL = batchSQL.get(i);
            String fbizmanagetypeid = itemSQL.substring(SHRBizManageCommonTool.getCharacterPosition(itemSQL, "','", 1) + 3, SHRBizManageCommonTool.getCharacterPosition(itemSQL, "','", 2));
            String fadminorgid = itemSQL.substring(SHRBizManageCommonTool.getCharacterPosition(itemSQL, ",'", 1) + 2, SHRBizManageCommonTool.getCharacterPosition(itemSQL, "','", 1));
            if (!existingEnableOrgManageRelation.contains(fadminorgid + "_" + fbizmanagetypeid)) continue;
            batchSQL.remove(i--);
        }
    }

    private CoreBaseCollection newOrgManageRelationFilter(ArrayList<String> batchSQL, AdminOrgBURelationCollection coll) {
        int i;
        CoreBaseCollection insertColl = new CoreBaseCollection();
        if (coll.size() < 1) {
            return insertColl;
        }
        ArrayList tempList = new ArrayList();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        for (i = 0; i < coll.size(); ++i) {
            String adminOrgId = coll.get(i).getAdminOrg().getId().toString();
            String bizManageTypeId = coll.get(i).getBizManageType().getId().toString();
            if (StringUtils.isEmpty((String)adminOrgId) || StringUtils.isEmpty((String)bizManageTypeId)) continue;
            tempMap.put(adminOrgId + "_" + bizManageTypeId, i);
        }
        for (i = 0; i < batchSQL.size(); ++i) {
            String itemSQL = batchSQL.get(i);
            String fbizmanagetypeid = itemSQL.substring(SHRBizManageCommonTool.getCharacterPosition(itemSQL, "','", 1) + 3, SHRBizManageCommonTool.getCharacterPosition(itemSQL, "','", 2));
            String fadminorgid = itemSQL.substring(SHRBizManageCommonTool.getCharacterPosition(itemSQL, ",'", 1) + 2, SHRBizManageCommonTool.getCharacterPosition(itemSQL, "','", 1));
            String tempKey = fbizmanagetypeid + "_" + fadminorgid;
            if (!tempMap.containsKey(tempKey)) continue;
            tempList.add(tempMap.get(tempKey));
            batchSQL.remove(i--);
        }
        if (tempList.isEmpty()) {
            return insertColl;
        }
        for (int j = 0; j < tempList.size(); ++j) {
            OrgManageInitRptInfo info = new OrgManageInitRptInfo();
            AdminOrgBURelationInfo relationInfo = coll.get(tempList.get(j));
            info.setAdminOrg(relationInfo.getAdminOrg());
            info.setBizManageType(relationInfo.getBizManageType());
            info.setManageHrOrg(relationInfo.getManageHrOrg());
            info.setIsDefaultManage(relationInfo.isIsDefaultManage());
            info.setSource(relationInfo.getId().toString());
            String manageHrOrgId = relationInfo.getManageHrOrg().getId().toString();
            String companyId = "";
            if (relationInfo.getAdminOrg().getCompany() != null) {
                companyId = relationInfo.getAdminOrg().getCompany().getId().toString();
            }
            boolean isSameCompany = companyId.equals(manageHrOrgId);
            info.setIsSameCompany(isSameCompany);
            insertColl.add((CoreBaseInfo)info);
        }
        return insertColl;
    }

    private String[] generateOrgManageInitSqlByBizType(Context ctx, String id, String managehrorgId, int isDefaultManage, int isSameCompany, String[] bizManageType) {
        String[] s = SHRBizManageCommonTool.getFullOrgManageReportSql(ctx, id, managehrorgId, isDefaultManage, isSameCompany, bizManageType);
        return s;
    }

    private Map<String, Object> getExistingOrgManageRelation(Context ctx) throws BOSException {
        ArrayList existingNewOrgManageRelation = this.getExistingNewOrgManageRelation(ctx);
        ArrayList<String> existingEnableOrgManageRelation = this.getExistingEnableOrgManageRelation(ctx);
        Map<String, String> mergeMap = this.mergeRelation(existingNewOrgManageRelation, existingEnableOrgManageRelation);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("existingNewOrgManageRelation", existingNewOrgManageRelation);
        resMap.put("mergeMap", mergeMap);
        return resMap;
    }

    private AdminOrgBURelationCollection getExistingNewOrgManageRelationColl(Context ctx) throws BOSException {
        AdminOrgBURelationCollection coll = AdminOrgBURelationFactory.getLocalInstance(ctx).getAdminOrgBURelationCollection(" WHERE STATE = 0 AND bizManageType.stateForOrg = 1 ");
        return coll;
    }

    private ArrayList getExistingNewOrgManageRelation(Context ctx) throws BOSException {
        String query = "SELECT FID,FADMINORGID,FBIZMANAGETYPEID FROM T_HR_ADMINORGBURELATION WHERE FState = 0 AND FBizManageTypeID IN (SELECT FID FROM T_HR_BizManageType WHERE FStateForOrg = 1)";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)query);
        ArrayList<String[]> array = new ArrayList<String[]>();
        if (result.size() > 1) {
            try {
                while (result.next()) {
                    String[] param = new String[]{result.getString("FID"), result.getString("FADMINORGID"), result.getString("FBIZMANAGETYPEID")};
                    array.add(param);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException("getExistingNewOrgManageRelation failed.");
            }
        }
        return array;
    }

    private ArrayList<String> getExistingEnableOrgManageRelation(Context ctx) throws BOSException {
        String query = "SELECT FADMINORGID,FBIZMANAGETYPEID FROM T_HR_ADMINORGBURELATION WHERE FState = 1 AND FBizManageTypeID IN (SELECT FID FROM T_HR_BizManageType WHERE FStateForOrg = 1) ";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)query);
        ArrayList<String> keyList = new ArrayList<String>();
        if (result.size() > 1) {
            try {
                while (result.next()) {
                    String fadminorgid = result.getString("FADMINORGID");
                    String fbizmanagetypeid = result.getString("FBIZMANAGETYPEID");
                    if (StringUtils.isEmpty((String)fadminorgid) || StringUtils.isEmpty((String)fbizmanagetypeid)) continue;
                    keyList.add(fadminorgid + "_" + fbizmanagetypeid);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException("getExistingEnableOrgManageRelation failed.");
            }
        }
        return keyList;
    }

    private void enableNewOrgManageRelation(Context ctx, ArrayList<String[]> existingNewOrgManageRelation) throws BOSException {
        if (existingNewOrgManageRelation.size() < 1) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < existingNewOrgManageRelation.size(); ++i) {
            Object[] o = new Object[]{existingNewOrgManageRelation.get(i)[0]};
            paramsList.add(o);
        }
        String updateSql = "UPDATE T_HR_ADMINORGBURELATION SET FSTATE = 1 WHERE FID = ? ";
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
    }

    private Map<String, String> mergeRelation(ArrayList<String[]> existingNewOrgManageRelation, ArrayList<String[]> existingEnableOrgManageRelation) {
        String key;
        HashMap<String, String> mergeMap = new HashMap<String, String>();
        for (int i = 0; i < existingNewOrgManageRelation.size(); ++i) {
            key = existingNewOrgManageRelation.get(i)[1] + "_" + existingNewOrgManageRelation.get(i)[2];
            mergeMap.put(key, null);
        }
        for (int j = 0; j < existingEnableOrgManageRelation.size(); ++j) {
            key = existingEnableOrgManageRelation.get(j)[0] + "_" + existingEnableOrgManageRelation.get(j)[1];
            mergeMap.put(key, null);
        }
        return mergeMap;
    }
}

