/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.certificationservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.shr.baseconfig.QueryConfigFieldFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsFactory;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.util.UuidException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateSqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(TemplateSqlUtils.class);
    public static final String scheme = "009SSC";

    public static String generateSQLFromString(Context ctx, String config, String schemeNum) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONArray selector = JSONArray.fromObject((Object)config);
        params.put("selectorFields", selector);
        return TemplateSqlUtils.generateSQL(ctx, params, schemeNum);
    }

    public static String generateSQL(Context ctx, Map<String, Object> params, String schemeNum) throws EASBizException, BOSException {
        String querySql = "";
        SqlParam sqlParam = new SqlParam();
        JSONArray selector = (JSONArray)params.get("selectorFields");
        sqlParam.setSelectMapping(TemplateSqlUtils.assembleSelector(selector));
        if (StringUtils.isEmpty((CharSequence)schemeNum)) {
            schemeNum = scheme;
        }
        sqlParam.setScheme(schemeNum);
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(false);
        querySql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        return querySql;
    }

    protected static Map<String, String> assembleSelector(String selector) {
        String[] columnModel = selector.split(",");
        String columnName2 = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String columnName2 : columnModel) {
            map.put(columnName2, columnName2);
        }
        return map;
    }

    protected static Map<String, String> assembleSelector(JSONArray selector) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (selector == null || selector.size() <= 0) {
            return map;
        }
        int length = selector.size();
        for (int i = 0; i < length; ++i) {
            JSONObject config = selector.getJSONObject(i);
            map.put(config.getString("metafield"), config.getString("metafield"));
        }
        return map;
    }

    public static void fillFieldValue(Context ctx, String queryConfigFieldId, Object value, String billId) throws EASBizException, BOSException, UuidException {
        QueryConfigFieldInfo queryConfigFieldInfo = QueryConfigFieldFactory.getLocalInstance((Context)ctx).getQueryConfigFieldInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)queryConfigFieldId)));
        StructureConfigColumnsInfo columnInfo = StructureConfigColumnsFactory.getLocalInstance((Context)ctx).getStructureConfigColumnsInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)queryConfigFieldInfo.getFactField().getId().toString())));
        if ("string".equals(columnInfo.getDataType())) {
            String fieldName = columnInfo.getNumber();
            StructureConfigInfo configInfo = StructureConfigFactory.getLocalInstance((Context)ctx).getStructureConfigInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)columnInfo.getStructureConfig().getId().toString())));
            String entityName = configInfo.getEntityName();
            ICoreBase entityBizInterface = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
            CoreBaseCollection entityBizCollection = entityBizInterface.getCollection("where id = '" + billId + "'");
            if (entityBizCollection.size() <= 1) {
                logger.error("TemplateSqlUtils fillFieldValue : the count of row = 0 or >1 queryConfigFieldId:" + queryConfigFieldId + ";value:" + value + ";billId:" + billId);
            } else {
                entityBizCollection.get(0).put(fieldName, (Object)((String)value));
            }
        }
    }
}

