/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.DealSpecialItem;
import com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.SpecialItemInfo;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.SscTypeEnum;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.SubBillSource;
import com.kingdee.shr.compensation.util.adj.RecEmpAdjSalaryUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DealSignatureFee
implements DealSpecialItem {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.impl.DealSignatureFee");
    private static final String DEFAULT_SCHEME_ID = "8r0AAAAVg9VRn/us";
    private static final String DEFAULT_ITEM_FIELDSN = "S20";
    private IRowSet rowSet;
    private Map<String, Object[]> initBillApplyer;
    private List<Object[]> updateESAStateParams = new ArrayList<Object[]>();

    @Override
    public void dealSpecialItem(Context ctx, SpecialItemInfo info) throws BOSException, SQLException, EASBizException {
        this.initParam(info);
        if (null == this.rowSet.getString("FItemVal") || null == this.rowSet.getString("FSegment")) {
            return;
        }
        int segment = Integer.valueOf(this.rowSet.getString("FSegment"));
        Date effectDate = this.rowSet.getDate("FEffect");
        Calendar c = Calendar.getInstance();
        c.setTime(effectDate);
        c.add(2, segment);
        info.setEffectDate(c.getTime());
        logger.error((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.impl.DealSignatureFee->segment:" + segment + ", effectDate:" + effectDate + ", info.eff:" + info.getEffectDate()));
        this.assembleSubBillInfo(ctx, info);
        this.saveSpecialItem(ctx, info);
        RecEmpAdjSalaryUtil.updateEmpSalaryState((Context)ctx, this.updateESAStateParams);
    }

    public void initParam(SpecialItemInfo info) {
        this.rowSet = info.getRowSet();
        this.initBillApplyer = info.getInitBillApplyer();
    }

    public void assembleSubBillInfo(Context ctx, SpecialItemInfo info) throws BOSException, SQLException {
        this.assembleSubBillInfo(info, DEFAULT_SCHEME_ID);
        BatchSubmitShemeBillInfo submitShemeBillInfo = info.getBillInfo();
        this.setProposerAdminOrg(ctx, submitShemeBillInfo);
        this.assembleSubBillEntry(info);
    }

    public void assembleSubBillInfo(SpecialItemInfo info, String subSchemeId) throws BOSException, SQLException {
        BatchSubmitShemeBillInfo submitShemeBillInfo = new BatchSubmitShemeBillInfo();
        String hrOrgUnitId = this.rowSet.getString("fhrorgunitid");
        HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
        hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgUnitId));
        submitShemeBillInfo.setHrOrgUnit(hrOrgUnitInfo);
        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
        String adminOrgUnitId = this.rowSet.getString("FAdminOrgID");
        adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitId));
        submitShemeBillInfo.setAdminOrg(adminOrgUnitInfo);
        String esaId = this.rowSet.getString("ESAID");
        Object[] applierInfo = this.initBillApplyer.get(esaId);
        if (applierInfo != null && applierInfo.length >= 2) {
            submitShemeBillInfo.setApplyDate((java.util.Date)applierInfo[1]);
            PersonInfo applier = (PersonInfo)applierInfo[0];
            submitShemeBillInfo.setProposer(applier);
        }
        CalSubmitSchemeInfo subSchemeInfo = new CalSubmitSchemeInfo();
        subSchemeInfo.setId(BOSUuid.read((String)subSchemeId));
        submitShemeBillInfo.setSubmitScheme(subSchemeInfo);
        submitShemeBillInfo.setBillSource(SubBillSource.Inner_Data);
        submitShemeBillInfo.setIsSsc(SscTypeEnum.NORMAL);
        info.setBillInfo(submitShemeBillInfo);
    }

    protected void assembleSubBillEntry(SpecialItemInfo info) throws BOSException, SQLException {
        BatchSubmitShemeBillInfo submitShemeBillInfo = info.getBillInfo();
        BatchSubmitShemeBillEntryCollection entry = submitShemeBillInfo.getEntry();
        BatchSubmitShemeBillEntryInfo entryInfo = new BatchSubmitShemeBillEntryInfo();
        String personId = this.rowSet.getString("FPERSONID");
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        entryInfo.setPerson(person);
        String adjeorId = this.rowSet.getString("EORID");
        CmpEmpORelationInfo cmpEmpORelationInfo = new CmpEmpORelationInfo();
        cmpEmpORelationInfo.setId(BOSUuid.read((String)adjeorId));
        entryInfo.setCmpEmpORelation(cmpEmpORelationInfo);
        String positionId = this.rowSet.getString("fpositionid");
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.setId(BOSUuid.read((String)positionId));
        entryInfo.setPosition(positionInfo);
        entryInfo.setHrOrgUnit(submitShemeBillInfo.getHrOrgUnit());
        entryInfo.setAdminOrgUnit(submitShemeBillInfo.getAdminOrg());
        entryInfo.setEffectDate(info.getEffectDate());
        entryInfo.put("effectday", (Object)info.getEffectDate());
        Date leffDt = this.rowSet.getDate("FLeffdt");
        if (null != leffDt) {
            entryInfo.setLeffectDate((java.util.Date)leffDt);
        }
        CurrencyInfo currencyInfo = new CurrencyInfo();
        String currencyId = this.rowSet.getString("FCurrencyId");
        if (!StringUtils.isEmpty((String)currencyId)) {
            currencyInfo.setId(BOSUuid.read((String)currencyId));
            entryInfo.setCurrency(currencyInfo);
        }
        String itemValue = this.rowSet.getString("FItemVal");
        entryInfo.put(DEFAULT_ITEM_FIELDSN, (Object)itemValue);
        String[] descriptions = new String[]{StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l1)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l1), StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l2)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l2), StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l3)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l3)};
        String[] results = this.assembleDescription(this.rowSet, descriptions);
        entryInfo.setDescription(results[0], LocaleUtils.locale_l1);
        entryInfo.setDescription(results[1], LocaleUtils.locale_l2);
        entryInfo.setDescription(results[2], LocaleUtils.locale_l3);
        entry.add(entryInfo);
    }

    protected String[] assembleDescription(IRowSet rowSet, String[] descriptions) throws SQLException {
        String[] results = descriptions;
        int MAX_LENGTH = 170;
        String des1 = rowSet.getString("FDescription_l1");
        String des2 = rowSet.getString("FDescription_l2");
        String des3 = rowSet.getString("FDescription_l3");
        String temp = null;
        if (!StringUtils.isEmpty((String)des1) && !descriptions[0].contains(des1) && (temp = des1 + ";" + descriptions[0]).length() < MAX_LENGTH) {
            results[0] = temp;
        }
        if (!StringUtils.isEmpty((String)des2) && !descriptions[1].contains(des2) && (temp = des2 + ";" + descriptions[1]).length() < MAX_LENGTH) {
            results[1] = temp;
        }
        if (!StringUtils.isEmpty((String)des3) && !descriptions[2].contains(des3) && (temp = des3 + ";" + descriptions[2]).length() < MAX_LENGTH) {
            results[2] = temp;
        }
        return results;
    }

    @Override
    public void saveSpecialItem(Context ctx, SpecialItemInfo info) throws BOSException, EASBizException, SQLException {
        BatchSubmitShemeBillInfo submitShemeBillInfo = info.getBillInfo();
        this.beforeSaveSpecialItem(ctx, info);
        String number = RecEmpAdjSalaryUtil.createBillNumber((Context)ctx, (String)submitShemeBillInfo.getHrOrgUnit().toString(), (HRBillBaseInfo)submitShemeBillInfo);
        submitShemeBillInfo.setNumber(number);
        logger.error((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.impl.DealSignatureFee->saveSignatureFee: " + submitShemeBillInfo));
        IObjectPK billId = null;
        billId = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)submitShemeBillInfo);
        BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).setPassState(BOSUuid.read((String)billId.toString()));
        this.afterSaveSpecialItem(ctx, info);
        Object[] param = new Object[]{billId.toString(), this.rowSet.getString("ESAID")};
        this.updateESAStateParams.add(param);
    }

    @Override
    public void beforeSaveSpecialItem(Context ctx, SpecialItemInfo info) throws BOSException, SQLException {
    }

    @Override
    public void afterSaveSpecialItem(Context ctx, SpecialItemInfo info) throws BOSException, SQLException {
    }

    protected void setProposerAdminOrg(Context ctx, BatchSubmitShemeBillInfo submitShemeBillInfo) {
        if (submitShemeBillInfo.getProposer() == null) {
            return;
        }
        String personId = submitShemeBillInfo.getProposer().getId().toString();
        String oql = "select adminOrg.id, adminOrg.name where person.id = '" + personId + "' and assignType = 1 order by endDateTime desc";
        try {
            EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(oql);
            if (collection.isEmpty()) {
                return;
            }
            java.util.Date now = new java.util.Date();
            EmpPosOrgRelationInfo cmpEmpORelationInfo = null;
            for (int i = 0; i < collection.size(); ++i) {
                EmpPosOrgRelationInfo info = collection.get(i);
                if (null == info.getEndDateTime() || info.getEndDateTime().compareTo(now) <= 0) continue;
                cmpEmpORelationInfo = info;
                break;
            }
            if (null == cmpEmpORelationInfo) {
                cmpEmpORelationInfo = collection.get(0);
            }
            AdminOrgUnitInfo proposerAdminOrg = new AdminOrgUnitInfo();
            proposerAdminOrg.setId(BOSUuid.read((String)cmpEmpORelationInfo.getAdminOrg().getId().toString()));
            submitShemeBillInfo.setProposerAdminOrg(proposerAdminOrg);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

